/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.internal.values.RefValue;
import java.util.Map;
import java.util.Objects;

public final class XmlQName
implements RefValue,
BXmlQName {
    private String localName;
    private String uri;
    private String prefix;

    @Deprecated
    public XmlQName(String localName, String uri, String prefix) {
        this.localName = localName;
        this.uri = uri;
        this.prefix = prefix;
    }

    @Deprecated
    public XmlQName(String qNameStr) {
        int parenEndIndex = qNameStr.indexOf(125);
        if (qNameStr.startsWith("{") && parenEndIndex > 0) {
            this.localName = qNameStr.substring(parenEndIndex + 1);
            this.uri = qNameStr.substring(1, parenEndIndex);
        } else {
            this.localName = qNameStr;
            this.uri = null;
        }
    }

    @Deprecated
    public XmlQName(BString localName, BString uri, BString prefix) {
        this.localName = localName.getValue();
        if (uri != null) {
            this.uri = uri.getValue();
        }
        if (prefix != null) {
            this.prefix = prefix.getValue();
        }
    }

    @Deprecated
    public XmlQName(BString qNameStrVal) {
        this(qNameStrVal.getValue());
    }

    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public String stringValue(BLink parent) {
        return this.uri == null || this.uri.isEmpty() ? this.localName : "{" + this.uri + "}" + this.localName;
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + this.toString() + "`";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return "xml`" + this.toString() + "`";
    }

    @Override
    public Type getType() {
        return PredefinedTypes.TYPE_XML_ATTRIBUTES;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XmlQName)) {
            return false;
        }
        return obj.toString().equals(this.localName);
    }

    public int hashCode() {
        return Objects.hash(this.localName, this.uri);
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XmlQName(this.localName, this.uri, this.prefix);
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XmlQName copy = (XmlQName)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

