/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.observability.BallerinaObserver;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.tracer.BSpan;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.config.ConfigRegistry;

public class ObserveUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();
    private static final boolean enabled;
    private static final boolean metricsEnabled;
    private static final boolean tracingEnabled;

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void startResourceObservation(Environment env, BString serviceName, BString resourceName, BString pkg, BString position) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame(env, observerContext);
        }
        String service = serviceName.getValue() == null ? "Unknown Service" : serviceName.getValue();
        observerContext.setServiceName(service);
        observerContext.setResourceName(resourceName.getValue());
        observerContext.setServer();
        observerContext.addTag("src.module", pkg.getValue());
        observerContext.addTag("src.position", position.getValue());
        observerContext.addTag("src.entry_point.resource", "true");
        observerContext.addTag("service", observerContext.getServiceName());
        observerContext.addTag("resource", observerContext.getResourceName());
        observerContext.addTag("connector_name", observerContext.getObjectName());
        observerContext.setStarted();
        ObserverContext copyOfObserverContext = observerContext;
        observers.forEach(observer -> observer.startServerObservation(copyOfObserverContext));
        env.setStrandLocal("service_name", service);
    }

    public static void stopObservation(Environment env) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            return;
        }
        Integer statusCode = (Integer)observerContext.getProperty("http.status_code");
        if (statusCode != null && statusCode >= 100) {
            observerContext.addTag("http.status_code_group", statusCode / 100 + "xx");
        }
        if (observerContext.isServer()) {
            observers.forEach(observer -> observer.stopServerObservation(observerContext));
        } else {
            observers.forEach(observer -> observer.stopClientObservation(observerContext));
        }
        ObserveUtils.setObserverContextToCurrentFrame(env, observerContext.getParent());
        observerContext.setFinished();
    }

    public static void reportError(Environment env, ErrorValue errorValue) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            return;
        }
        observers.forEach(observer -> {
            observerContext.addTag("error", "true");
            observerContext.addProperty("bstruct_error", errorValue);
        });
    }

    public static void startCallableObservation(Environment env, boolean isRemote, boolean isMainEntryPoint, boolean isWorker, BObject typeDef, BString functionName, BString pkg, BString position) {
        if (!enabled) {
            return;
        }
        ObserverContext observerCtx = ObserveUtils.getObserverContextOfCurrentFrame(env);
        ObserverContext newObContext = new ObserverContext();
        newObContext.setParent(observerCtx);
        newObContext.setServiceName(observerCtx == null ? "Unknown Service" : observerCtx.getServiceName());
        newObContext.setResourceName(observerCtx == null ? "Unknown Resource" : observerCtx.getResourceName());
        if (typeDef == null) {
            newObContext.setObjectName("");
        } else {
            ObjectType type = typeDef.getType();
            Module module = type.getPackage();
            newObContext.setObjectName(module.getOrg() + "/" + module.getName() + "/" + type.getName());
        }
        newObContext.setFunctionName(functionName.getValue());
        newObContext.addTag("src.module", pkg.getValue());
        newObContext.addTag("src.position", position.getValue());
        if (isRemote) {
            newObContext.addTag("src.remote", "true");
            newObContext.addTag("action", newObContext.getFunctionName());
            newObContext.addTag("connector_name", newObContext.getObjectName());
        }
        if (isMainEntryPoint) {
            newObContext.addTag("src.entry_point.main", "true");
        }
        if (isWorker) {
            newObContext.addTag("src.worker", "true");
        }
        if (!isRemote && !isWorker) {
            newObContext.addTag("function", newObContext.getFunctionName());
            if (!StringUtils.isEmpty(newObContext.getObjectName())) {
                newObContext.addTag("object_name", newObContext.getObjectName());
            }
        }
        if (!"Unknown Service".equals(newObContext.getServiceName())) {
            newObContext.addTag("service", newObContext.getServiceName());
            newObContext.addTag("resource", newObContext.getResourceName());
        }
        newObContext.setStarted();
        ObserveUtils.setObserverContextToCurrentFrame(env, newObContext);
        observers.forEach(observer -> observer.startClientObservation(newObContext));
    }

    public static Map<String, String> getContextProperties(ObserverContext observerContext) {
        BSpan bSpan = (BSpan)observerContext.getProperty("_span_");
        if (bSpan != null) {
            return bSpan.getTraceContext();
        }
        return Collections.emptyMap();
    }

    public static void logMessageToActiveSpan(String logLevel, Supplier<String> logMessage, boolean isError) {
        if (!tracingEnabled) {
            return;
        }
        Environment balEnv = new Environment(Scheduler.getStrand());
        ObserverContext observerContext = (ObserverContext)balEnv.getStrandLocal("__observer_context__");
        if (observerContext == null) {
            return;
        }
        BSpan span = (BSpan)observerContext.getProperty("_span_");
        if (span == null) {
            return;
        }
        HashMap<String, Object> logs = new HashMap<String, Object>(1);
        logs.put(logLevel, logMessage.get());
        if (!isError) {
            span.log(logs);
        } else {
            span.logError(logs);
        }
    }

    public static boolean isObservabilityEnabled() {
        return enabled;
    }

    public static boolean isMetricsEnabled() {
        return metricsEnabled;
    }

    public static boolean isTracingEnabled() {
        return tracingEnabled;
    }

    public static ObserverContext getObserverContextOfCurrentFrame(Environment env) {
        if (!enabled) {
            return null;
        }
        return (ObserverContext)env.getStrandLocal("__observer_context__");
    }

    public static void setObserverContextToCurrentFrame(Environment env, ObserverContext observerContext) {
        if (!enabled) {
            return;
        }
        env.setStrandLocal("__observer_context__", observerContext);
    }

    static {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        tracingEnabled = configRegistry.getAsBoolean("b7a.observability.tracing.enabled");
        metricsEnabled = configRegistry.getAsBoolean("b7a.observability.metrics.enabled");
        enabled = metricsEnabled || tracingEnabled;
    }
}

