/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability;

import io.ballerina.runtime.observability.metrics.Tag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ObserverContext {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Tag> tags = new HashMap<String, Tag>();
    private String serviceName;
    private String resourceName;
    private String objectName;
    private String functionName;
    private boolean server;
    private boolean started;
    private boolean finished;
    private ObserverContext parent;
    private boolean isSystemSpan;

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Deprecated
    public void addMainTag(String key, String value) {
        this.addTag(key, value);
    }

    public void addTag(String key, String value) {
        String sanitizedValue = value != null ? value : "";
        Tag tag = Tag.of(key, sanitizedValue);
        this.tags.put(key, tag);
    }

    public Tag getTag(String key) {
        return this.tags.get(key);
    }

    public Set<Tag> getAllTags() {
        return new HashSet<Tag>(this.tags.values());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = Objects.requireNonNull(serviceName);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = Objects.requireNonNull(resourceName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = Objects.requireNonNull(objectName);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = Objects.requireNonNull(functionName);
    }

    public boolean isServer() {
        return this.server;
    }

    void setServer() {
        this.server = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    void setStarted() {
        this.started = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    public ObserverContext getParent() {
        return this.parent;
    }

    public void setParent(ObserverContext parent) {
        this.parent = parent;
    }

    public boolean isSystemSpan() {
        return this.isSystemSpan;
    }

    public void setSystemSpan(boolean userSpan) {
        this.isSystemSpan = userSpan;
    }
}

