/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.metrics;

import io.ballerina.runtime.observability.metrics.Counter;
import io.ballerina.runtime.observability.metrics.Gauge;
import io.ballerina.runtime.observability.metrics.Metric;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.PolledGauge;
import io.ballerina.runtime.observability.metrics.StatisticConfig;
import io.ballerina.runtime.observability.metrics.spi.MetricProvider;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

public class MetricRegistry {
    private final MetricProvider metricProvider;
    private final ConcurrentMap<MetricId, Metric> metrics;

    public MetricRegistry(MetricProvider metricProvider) {
        this.metricProvider = metricProvider;
        this.metrics = new ConcurrentHashMap<MetricId, Metric>();
    }

    public Counter counter(MetricId id) {
        return this.getOrCreate(id, Counter.class, () -> this.metricProvider.newCounter(id));
    }

    public Counter register(Counter counter) {
        return this.register(counter, Counter.class);
    }

    public void unregister(Counter counter) {
        this.unregister(counter, Counter.class);
    }

    public Gauge gauge(MetricId id, StatisticConfig ... statisticConfigs) {
        return this.getOrCreate(id, Gauge.class, () -> this.metricProvider.newGauge(id, statisticConfigs));
    }

    public Gauge register(Gauge gauge) {
        return this.register(gauge, Gauge.class);
    }

    public void unregister(Gauge gauge) {
        this.unregister(gauge, Gauge.class);
    }

    public <T> PolledGauge polledGauge(MetricId id, T obj, ToDoubleFunction<T> valueFunction) {
        return this.getOrCreate(id, PolledGauge.class, () -> this.metricProvider.newPolledGauge(id, obj, valueFunction));
    }

    public PolledGauge register(PolledGauge gauge) {
        return this.register(gauge, PolledGauge.class);
    }

    public void unregister(PolledGauge gauge) {
        this.unregister(gauge, PolledGauge.class);
    }

    private <M extends Metric> M getOrCreate(MetricId id, Class<M> metricClass, Supplier<M> metricSupplier) {
        M metric = this.readMetric(id, metricClass);
        if (metric == null) {
            Metric newMetric = (Metric)metricSupplier.get();
            return (M)this.writeMetricIfNotExists(newMetric, metricClass);
        }
        return metric;
    }

    private <M extends Metric> M readMetric(MetricId metricId, Class<M> metricClass) {
        Metric existingMetrics = this.lookup(metricId);
        if (existingMetrics != null) {
            if (metricClass.isInstance(existingMetrics)) {
                return (M)existingMetrics;
            }
            throw new IllegalArgumentException(metricId + " is already used for a different type of metric: " + metricClass.getSimpleName());
        }
        return null;
    }

    private <M extends Metric> M writeMetricIfNotExists(M metric, Class<M> metricClass) {
        Metric existing = this.metrics.putIfAbsent(metric.getId(), metric);
        if (existing != null) {
            if (metricClass.isInstance(existing)) {
                return (M)existing;
            }
            throw new IllegalArgumentException(metric.getId() + " is already used for a different type of metric: " + metricClass.getSimpleName());
        }
        return metric;
    }

    private <M extends Metric> M register(M registerMetric, Class<M> metricClass) {
        M metric = this.readMetric(registerMetric.getId(), metricClass);
        if (metric == null) {
            return this.writeMetricIfNotExists(registerMetric, metricClass);
        }
        return metric;
    }

    private <M extends Metric> void unregister(Metric registerMetric, Class<M> metricClass) {
        M metric = this.readMetric(registerMetric.getId(), metricClass);
        if (metric != null) {
            this.metrics.remove(registerMetric.getId());
        }
    }

    public void remove(String name) {
        List<MetricId> ids = this.metrics.keySet().stream().filter(id -> id.getName().equals(name)).collect(Collectors.toList());
        ids.forEach(this.metrics::remove);
    }

    public MetricProvider getMetricProvider() {
        return this.metricProvider;
    }

    public Metric[] getAllMetrics() {
        return this.metrics.values().toArray(new Metric[this.metrics.values().size()]);
    }

    public Metric lookup(MetricId metricId) {
        return (Metric)this.metrics.get(metricId);
    }
}

