/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.toml.internal.parser.AbstractLexer;
import io.ballerina.toml.internal.parser.ParserMode;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;
import java.util.List;

public class TomlLexer
extends AbstractLexer {
    public TomlLexer(CharReader charReader) {
        super(charReader, ParserMode.DEFAULT);
    }

    @Override
    public STToken nextToken() {
        STToken token;
        switch (this.mode) {
            case STRING: {
                token = this.readStringToken();
                break;
            }
            case MULTILINE_STRING: {
                token = this.readMultilineStringToken();
                break;
            }
            case LITERAL_STRING: {
                token = this.readLiteralStringToken();
                break;
            }
            case NEW_LINE: {
                token = this.readNewlineToken();
                if (token != null) break;
                token = this.nextToken();
                break;
            }
            default: {
                this.processLeadingTrivia();
                token = this.readToken();
            }
        }
        return this.cloneWithDiagnostics(token);
    }

    private STToken readToken() {
        STToken token;
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char c = this.reader.peek();
        this.reader.advance();
        switch (c) {
            case '\n': 
            case '\r': {
                token = this.getNewlineToken();
                break;
            }
            case '[': {
                token = this.getSyntaxToken(SyntaxKind.OPEN_BRACKET_TOKEN);
                break;
            }
            case ']': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_BRACKET_TOKEN);
                break;
            }
            case '\'': {
                if (this.reader.peek(1) == '\'') {
                    this.reader.advance(2);
                    token = this.getDoubleQuoteToken(SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN);
                } else {
                    token = this.getDoubleQuoteToken(SyntaxKind.SINGLE_QUOTE_TOKEN);
                }
                this.startMode(ParserMode.LITERAL_STRING);
                break;
            }
            case '=': {
                token = this.getSyntaxToken(SyntaxKind.EQUAL_TOKEN);
                break;
            }
            case ',': {
                token = this.getSyntaxToken(SyntaxKind.COMMA_TOKEN);
                break;
            }
            case '.': {
                token = this.getSyntaxToken(SyntaxKind.DOT_TOKEN);
                break;
            }
            case '+': {
                token = this.getSyntaxToken(SyntaxKind.PLUS_TOKEN);
                break;
            }
            case '-': {
                token = this.getSyntaxToken(SyntaxKind.MINUS_TOKEN);
                break;
            }
            case '\"': {
                if (this.reader.peek(1) == '\"') {
                    this.reader.advance(2);
                    token = this.getDoubleQuoteToken(SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN);
                    this.startMode(ParserMode.MULTILINE_STRING);
                    break;
                }
                token = this.getDoubleQuoteToken(SyntaxKind.DOUBLE_QUOTE_TOKEN);
                this.startMode(ParserMode.STRING);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                token = this.processNumericLiteral(c);
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                token = this.processKey();
                break;
            }
            default: {
                this.processInvalidToken();
                token = this.nextToken();
            }
        }
        return token;
    }

    private STToken readNewlineToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char c = this.reader.peek();
        this.endMode();
        if (c == '\n' || c == '\r') {
            this.reader.advance();
            return this.getNewlineToken();
        }
        return null;
    }

    private STToken readStringToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        if (nextChar == '\"') {
            this.endMode();
            this.reader.advance();
            return this.getSyntaxToken(SyntaxKind.DOUBLE_QUOTE_TOKEN);
        }
        block10: while (!this.reader.isEOF()) {
            nextChar = this.reader.peek();
            switch (nextChar) {
                case '\"': {
                    break block10;
                }
                case '\n': 
                case '\r': {
                    this.endMode();
                    return this.getUnquotedKey();
                }
                case '\\': {
                    switch (this.reader.peek(1)) {
                        case 'n': 
                        case 'r': {
                            this.endMode();
                            continue block10;
                        }
                        case '\"': 
                        case '\\': 
                        case 't': {
                            this.reader.advance(2);
                            continue block10;
                        }
                        case 'U': 
                        case 'u': {
                            this.processStringNumericEscape();
                            continue block10;
                        }
                    }
                    String escapeSequence = String.valueOf(this.reader.peek(2));
                    this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, escapeSequence);
                    this.reader.advance();
                    continue block10;
                }
                default: {
                    this.reader.advance();
                    continue block10;
                }
            }
        }
        return this.getUnquotedKey();
    }

    private STToken readLiteralStringToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        if (nextChar == '\'') {
            this.endMode();
            this.reader.advance();
            return this.getSyntaxToken(SyntaxKind.SINGLE_QUOTE_TOKEN);
        }
        block3: while (!this.reader.isEOF()) {
            nextChar = this.reader.peek();
            switch (nextChar) {
                case '\n': 
                case '\r': 
                case '\'': {
                    break block3;
                }
                default: {
                    this.reader.advance();
                    continue block3;
                }
            }
        }
        return this.getUnquotedKey();
    }

    private STToken readMultilineStringToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        char secondNextChar = this.reader.peek(1);
        char thirdNextChar = this.reader.peek(2);
        if (nextChar == '\"' && secondNextChar == '\"' && thirdNextChar == '\"') {
            this.endMode();
            this.reader.advance(3);
            return this.getSyntaxToken(SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN);
        }
        block5: while (!(this.reader.isEOF() || (nextChar = this.reader.peek()) == '\"' && this.reader.peek(1) == '\"' && this.reader.peek(2) == '\"')) {
            if (nextChar != '\\') {
                this.reader.advance();
                continue;
            }
            switch (this.reader.peek(1)) {
                case '\n': 
                case '\r': {
                    this.reader.advance();
                    continue block5;
                }
                case '\"': 
                case '\\': 
                case 'n': 
                case 'r': 
                case 't': {
                    this.reader.advance(2);
                    continue block5;
                }
                case 'U': 
                case 'u': {
                    this.processStringNumericEscape();
                    continue block5;
                }
            }
            String escapeSequence = String.valueOf(this.reader.peek(2));
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, escapeSequence);
            this.reader.advance();
        }
        return this.getUnquotedKey();
    }

    private STToken getNewlineToken() {
        STNode leadingTrivia = STNodeFactory.createEmptyNodeList();
        STNode trailingTrivia = STNodeFactory.createEmptyNodeList();
        return STNodeFactory.createToken(SyntaxKind.NEWLINE, leadingTrivia, trailingTrivia);
    }

    private STToken getSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getUnquotedKey() {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createIdentifierToken(lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getLiteral(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getDoubleQuoteToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STNodeFactory.createEmptyNodeList();
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private void processLeadingTrivia() {
        this.processSyntaxTrivia(this.leadingTriviaList, true);
    }

    private STNode processTrailingTrivia() {
        ArrayList<STNode> triviaList = new ArrayList<STNode>(10);
        this.processSyntaxTrivia(triviaList, false);
        return STNodeFactory.createNodeList(triviaList);
    }

    private void processSyntaxTrivia(List<STNode> triviaList, boolean isLeading) {
        block5: while (!this.reader.isEOF()) {
            this.reader.mark();
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    triviaList.add(this.processWhitespaces());
                    continue block5;
                }
                case '\n': 
                case '\r': {
                    if (!isLeading) {
                        this.startMode(ParserMode.NEW_LINE);
                    }
                    triviaList.add(this.processEndOfLine());
                    return;
                }
                case '#': {
                    triviaList.add(this.processComment());
                    continue block5;
                }
            }
            return;
        }
    }

    private STNode processWhitespaces() {
        block4: while (!this.reader.isEOF()) {
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    this.reader.advance();
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
    }

    private STNode processEndOfLine() {
        char c = this.reader.peek();
        switch (c) {
            case '\n': {
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, "\n");
            }
            case '\r': {
                if (this.reader.peek(1) == '\n') {
                    this.reader.advance();
                }
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, "\r\n");
            }
        }
        throw new IllegalStateException();
    }

    private STNode processComment() {
        this.reader.advance();
        int nextToken = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextToken) {
                case 10: 
                case 13: {
                    break block3;
                }
                default: {
                    this.reader.advance();
                    nextToken = this.peek();
                    continue block3;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.COMMENT_MINUTIAE, this.getLexeme());
    }

    private STToken processNumericLiteral(int startChar) {
        int nextChar = this.peek();
        if (nextChar == 43 || nextChar == 45) {
            this.reader.advance();
            nextChar = this.peek();
        }
        int len = 1;
        SyntaxKind type = SyntaxKind.DECIMAL_INT_TOKEN;
        boolean isString = false;
        while (!this.reader.isEOF()) {
            if (TomlLexer.isDigit(nextChar) || nextChar == 46 || nextChar == 95) {
                if (nextChar == 46) {
                    type = SyntaxKind.DECIMAL_FLOAT_TOKEN;
                }
                this.reader.advance();
                ++len;
                nextChar = this.peek();
                continue;
            }
            if (!Character.isLetter(nextChar)) break;
            isString = true;
            break;
        }
        if (isString) {
            type = SyntaxKind.IDENTIFIER_LITERAL;
        }
        if (startChar == 48 && len > 1) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_LEADING_ZEROS_IN_NUMERIC_LITERALS, new Object[0]);
        }
        return this.getLiteral(type);
    }

    private STToken processKey() {
        String tokenText;
        while (this.isIdentifierFollowingChar(this.peek())) {
            this.reader.advance();
        }
        switch (tokenText = this.getLexeme()) {
            case "true": {
                return this.getSyntaxToken(SyntaxKind.TRUE_KEYWORD);
            }
            case "false": {
                return this.getSyntaxToken(SyntaxKind.FALSE_KEYWORD);
            }
            case "inf": {
                return this.getSyntaxToken(SyntaxKind.INF_TOKEN);
            }
            case "nan": {
                return this.getSyntaxToken(SyntaxKind.NAN_TOKEN);
            }
        }
        return this.getUnquotedKey();
    }

    private void processInvalidToken() {
        while (!this.isEndOfInvalidToken()) {
            this.reader.advance();
        }
        String tokenText = this.getLexeme();
        STToken invalidToken = STNodeFactory.createInvalidToken(tokenText);
        STNode invalidNodeMinutiae = STNodeFactory.createInvalidNodeMinutiae(invalidToken);
        this.leadingTriviaList.add(invalidNodeMinutiae);
    }

    private boolean isEndOfInvalidToken() {
        if (this.reader.isEOF()) {
            return true;
        }
        int currentChar = this.peek();
        switch (currentChar) {
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 40: 
            case 41: 
            case 59: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private boolean isIdentifierInitialChar(int c) {
        if (65 <= c && c <= 90) {
            return true;
        }
        if (97 <= c && c <= 122) {
            return true;
        }
        return c == 95 || c == 45;
    }

    private boolean isIdentifierFollowingChar(int c) {
        return this.isIdentifierInitialChar(c) || TomlLexer.isDigit(c);
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isHexDigit(int c) {
        if (97 <= c && c <= 102) {
            return true;
        }
        if (65 <= c && c <= 70) {
            return true;
        }
        return TomlLexer.isDigit(c);
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    private void processStringNumericEscape() {
        this.reader.advance(2);
        if (!TomlLexer.isHexDigit(this.peek())) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
            return;
        }
        this.reader.advance();
        while (TomlLexer.isHexDigit(this.peek())) {
            this.reader.advance();
        }
        this.reader.advance();
    }
}

