/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.internal.syntax.ExternalTreeNodeList;
import io.ballerina.toml.internal.syntax.NodeListUtils;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Arrays;
import java.util.Collection;

public final class STNodeList
extends STNode {
    STNodeList(STNode ... nodes) {
        super(SyntaxKind.LIST);
        this.addChildren(nodes);
    }

    STNodeList(Collection<STNode> nodes) {
        this(nodes.toArray(new STNode[0]));
    }

    public STNode get(int index) {
        NodeListUtils.rangeCheck(index, this.bucketCount);
        return this.childBuckets[index];
    }

    public STNodeList add(STNode node) {
        int newLength = this.bucketCount + 1;
        STNode[] newNodesArray = Arrays.copyOf(this.childBuckets, newLength);
        newNodesArray[this.bucketCount] = node;
        return new STNodeList(newNodesArray);
    }

    public STNodeList add(int index, STNode node) {
        NodeListUtils.rangeCheckForAdd(index, this.bucketCount);
        STNode[] newNodesArray = Arrays.copyOf(this.childBuckets, this.bucketCount + 1);
        System.arraycopy(newNodesArray, index, newNodesArray, index + 1, this.bucketCount - index);
        newNodesArray[index] = node;
        return new STNodeList(newNodesArray);
    }

    public STNodeList addAll(int index, Collection<STNode> c) {
        NodeListUtils.rangeCheckForAdd(index, this.bucketCount);
        int newLength = this.bucketCount + c.size();
        STNode[] newNodesArray = Arrays.copyOf(this.childBuckets, newLength);
        System.arraycopy(this.childBuckets, index, newNodesArray, index + c.size(), this.bucketCount - index);
        for (STNode stNode : c) {
            newNodesArray[index++] = stNode;
        }
        return new STNodeList(newNodesArray);
    }

    public STNodeList addAll(Collection<STNode> c) {
        int newLength = this.bucketCount + c.size();
        STNode[] newNodesArray = Arrays.copyOf(this.childBuckets, newLength);
        int index = this.bucketCount;
        for (STNode stNode : c) {
            newNodesArray[index++] = stNode;
        }
        return new STNodeList(newNodesArray);
    }

    public STNodeList set(int index, STNode node) {
        NodeListUtils.rangeCheck(index, this.bucketCount);
        STNode[] newNodesArray = Arrays.copyOf(this.childBuckets, this.bucketCount);
        newNodesArray[index] = node;
        return new STNodeList(newNodesArray);
    }

    public STNodeList remove(int index) {
        NodeListUtils.rangeCheck(index, this.bucketCount);
        boolean lastElement = index + 1 == this.bucketCount;
        STNode[] newNodesArray = Arrays.copyOf(this.childBuckets, this.bucketCount - 1);
        if (lastElement) {
            return new STNodeList(newNodesArray);
        }
        System.arraycopy(this.childBuckets, index + 1, newNodesArray, index, this.bucketCount - index - 1);
        return new STNodeList(newNodesArray);
    }

    public STNodeList remove(STNode node) {
        if (node == null) {
            return this.removeFirstNullValue();
        }
        for (int bucket = 0; bucket < this.bucketCount; ++bucket) {
            if (!node.equals(this.childBuckets[bucket])) continue;
            return this.remove(bucket);
        }
        return this;
    }

    public STNodeList removeAll(Collection<STNode> c) {
        int index = 0;
        STNode[] newNodesArray = Arrays.copyOf(this.childBuckets, this.bucketCount);
        for (int bucket = 0; bucket < this.bucketCount; ++bucket) {
            STNode currentNode = this.childBuckets[bucket];
            if (c.contains(currentNode)) continue;
            newNodesArray[index++] = currentNode;
        }
        return new STNodeList(Arrays.copyOf(newNodesArray, index));
    }

    public int size() {
        return this.bucketCount;
    }

    public boolean isEmpty() {
        return this.bucketCount == 0;
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NonTerminalNode createFacade(int position, NonTerminalNode parent) {
        return new ExternalTreeNodeList(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }

    private STNodeList removeFirstNullValue() {
        for (int bucket = 0; bucket < this.bucketCount; ++bucket) {
            if (this.childBuckets[bucket] != null) continue;
            return this.remove(bucket);
        }
        return this;
    }
}

