/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TomlTableArrayNode
extends TopLevelNode {
    private final List<TomlTableNode> children;

    public TomlTableArrayNode(TomlKeyNode key, TomlNodeLocation location) {
        super(key, TomlType.TABLE_ARRAY, location);
        this.children = new ArrayList<TomlTableNode>();
    }

    public TomlTableArrayNode(TomlKeyNode key, TomlNodeLocation location, List<TomlTableNode> children) {
        super(key, TomlType.TABLE_ARRAY, location);
        this.children = children;
    }

    public List<TomlTableNode> children() {
        return this.children;
    }

    public void addChild(TomlTableNode topLevelNode) {
        this.children.add(topLevelNode);
    }

    @Override
    public Set<Diagnostic> diagnostics() {
        Set tomlDiagnostics = this.diagnostics;
        for (TomlTableNode childTable : this.children) {
            tomlDiagnostics.addAll(childTable.diagnostics());
        }
        return tomlDiagnostics;
    }

    public String toString() {
        return "TomlTableArray{identifier=" + this.key().name() + "}";
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }
}

