/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TomlTableNode
extends TopLevelNode {
    private final Map<String, TopLevelNode> entries;
    private final boolean generated;

    public TomlTableNode(TomlKeyNode key, TomlNodeLocation location) {
        super(key, TomlType.TABLE, location);
        this.entries = new LinkedHashMap<String, TopLevelNode>();
        this.generated = false;
    }

    public TomlTableNode(TomlKeyNode key, boolean generated, TomlNodeLocation location) {
        super(key, TomlType.TABLE, location);
        this.entries = new LinkedHashMap<String, TopLevelNode>();
        this.generated = generated;
    }

    public TomlTableNode(TomlKeyNode key, boolean generated, TomlNodeLocation location, Map<String, TopLevelNode> entries) {
        super(key, TomlType.TABLE, location);
        this.entries = entries;
        this.generated = generated;
    }

    public Map<String, TopLevelNode> entries() {
        return this.entries;
    }

    public boolean generated() {
        return this.generated;
    }

    @Override
    public Set<Diagnostic> diagnostics() {
        Set tomlDiagnostics = this.diagnostics;
        for (Map.Entry<String, TopLevelNode> child : this.entries.entrySet()) {
            tomlDiagnostics.addAll(child.getValue().diagnostics());
        }
        return tomlDiagnostics;
    }

    public void replaceGeneratedTable(TomlTableNode tomlTableNode) {
        TomlTableNode childTable;
        TopLevelNode childNode = this.entries.get(tomlTableNode.key().name());
        if (childNode instanceof TomlTableNode && (childTable = (TomlTableNode)childNode).generated()) {
            tomlTableNode.entries().putAll(childTable.entries());
            this.entries.put(tomlTableNode.key().name(), tomlTableNode);
        }
    }

    public String toString() {
        return "TomlTable{identifier=" + this.key().name() + ", generated=" + this.generated + "}";
    }

    public void addSyntaxDiagnostics(Set<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            this.addDiagnostic(diagnostic);
        }
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }
}

