/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.BoolLiteralNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierLiteralNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NumericLiteralNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public abstract class NodeFactory
extends AbstractNodeFactory {
    private NodeFactory() {
    }

    public static DocumentNode createDocumentNode(NodeList<DocumentMemberDeclarationNode> members, Token eofToken) {
        Objects.requireNonNull(members, "members must not be null");
        Objects.requireNonNull(eofToken, "eofToken must not be null");
        STNode stDocumentNode = STNodeFactory.createDocumentNode(members.underlyingListNode().internalNode(), eofToken.internalNode());
        return (DocumentNode)stDocumentNode.createUnlinkedFacade();
    }

    public static TableNode createTableNode(Token openBracket, SeparatedNodeList<ValueNode> identifier, Token closeBracket, NodeList<KeyValueNode> fields) {
        Objects.requireNonNull(openBracket, "openBracket must not be null");
        Objects.requireNonNull(identifier, "identifier must not be null");
        Objects.requireNonNull(closeBracket, "closeBracket must not be null");
        Objects.requireNonNull(fields, "fields must not be null");
        STNode stTableNode = STNodeFactory.createTableNode(openBracket.internalNode(), identifier.underlyingListNode().internalNode(), closeBracket.internalNode(), fields.underlyingListNode().internalNode());
        return (TableNode)stTableNode.createUnlinkedFacade();
    }

    public static TableArrayNode createTableArrayNode(Token firstOpenBracket, Token secondOpenBracket, SeparatedNodeList<ValueNode> identifier, Token firstCloseBracket, Token secondCloseBracket, NodeList<KeyValueNode> fields) {
        Objects.requireNonNull(firstOpenBracket, "firstOpenBracket must not be null");
        Objects.requireNonNull(secondOpenBracket, "secondOpenBracket must not be null");
        Objects.requireNonNull(identifier, "identifier must not be null");
        Objects.requireNonNull(firstCloseBracket, "firstCloseBracket must not be null");
        Objects.requireNonNull(secondCloseBracket, "secondCloseBracket must not be null");
        Objects.requireNonNull(fields, "fields must not be null");
        STNode stTableArrayNode = STNodeFactory.createTableArrayNode(firstOpenBracket.internalNode(), secondOpenBracket.internalNode(), identifier.underlyingListNode().internalNode(), firstCloseBracket.internalNode(), secondCloseBracket.internalNode(), fields.underlyingListNode().internalNode());
        return (TableArrayNode)stTableArrayNode.createUnlinkedFacade();
    }

    public static KeyValueNode createKeyValueNode(SeparatedNodeList<ValueNode> identifier, Token assign, ValueNode value) {
        Objects.requireNonNull(identifier, "identifier must not be null");
        Objects.requireNonNull(assign, "assign must not be null");
        Objects.requireNonNull(value, "value must not be null");
        STNode stKeyValueNode = STNodeFactory.createKeyValueNode(identifier.underlyingListNode().internalNode(), assign.internalNode(), value.internalNode());
        return (KeyValueNode)stKeyValueNode.createUnlinkedFacade();
    }

    public static ArrayNode createArrayNode(Token openBracket, SeparatedNodeList<ValueNode> values, Token closeBracket) {
        Objects.requireNonNull(openBracket, "openBracket must not be null");
        Objects.requireNonNull(values, "values must not be null");
        Objects.requireNonNull(closeBracket, "closeBracket must not be null");
        STNode stArrayNode = STNodeFactory.createArrayNode(openBracket.internalNode(), values.underlyingListNode().internalNode(), closeBracket.internalNode());
        return (ArrayNode)stArrayNode.createUnlinkedFacade();
    }

    public static StringLiteralNode createStringLiteralNode(Token startDoubleQuote, Token content, Token endDoubleQuote) {
        Objects.requireNonNull(startDoubleQuote, "startDoubleQuote must not be null");
        Objects.requireNonNull(content, "content must not be null");
        Objects.requireNonNull(endDoubleQuote, "endDoubleQuote must not be null");
        STNode stStringLiteralNode = STNodeFactory.createStringLiteralNode(startDoubleQuote.internalNode(), content.internalNode(), endDoubleQuote.internalNode());
        return (StringLiteralNode)stStringLiteralNode.createUnlinkedFacade();
    }

    public static NumericLiteralNode createNumericLiteralNode(SyntaxKind kind, Token sign, Token value) {
        Objects.requireNonNull(value, "value must not be null");
        STNode stNumericLiteralNode = STNodeFactory.createNumericLiteralNode(kind, NodeFactory.getOptionalSTNode(sign), value.internalNode());
        return (NumericLiteralNode)stNumericLiteralNode.createUnlinkedFacade();
    }

    public static BoolLiteralNode createBoolLiteralNode(Token value) {
        Objects.requireNonNull(value, "value must not be null");
        STNode stBoolLiteralNode = STNodeFactory.createBoolLiteralNode(value.internalNode());
        return (BoolLiteralNode)stBoolLiteralNode.createUnlinkedFacade();
    }

    public static IdentifierLiteralNode createIdentifierLiteralNode(IdentifierToken value) {
        Objects.requireNonNull(value, "value must not be null");
        STNode stIdentifierLiteralNode = STNodeFactory.createIdentifierLiteralNode(value.internalNode());
        return (IdentifierLiteralNode)stIdentifierLiteralNode.createUnlinkedFacade();
    }
}

