/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.BoolLiteralNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierLiteralNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.NumericLiteralNode;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;

public abstract class NodeVisitor {
    public void visit(DocumentNode documentNode) {
        this.visitSyntaxNode(documentNode);
    }

    public void visit(TableNode tableNode) {
        this.visitSyntaxNode(tableNode);
    }

    public void visit(TableArrayNode tableArrayNode) {
        this.visitSyntaxNode(tableArrayNode);
    }

    public void visit(KeyValueNode keyValueNode) {
        this.visitSyntaxNode(keyValueNode);
    }

    public void visit(ArrayNode arrayNode) {
        this.visitSyntaxNode(arrayNode);
    }

    public void visit(StringLiteralNode stringLiteralNode) {
        this.visitSyntaxNode(stringLiteralNode);
    }

    public void visit(NumericLiteralNode numericLiteralNode) {
        this.visitSyntaxNode(numericLiteralNode);
    }

    public void visit(BoolLiteralNode boolLiteralNode) {
        this.visitSyntaxNode(boolLiteralNode);
    }

    public void visit(IdentifierLiteralNode identifierLiteralNode) {
        this.visitSyntaxNode(identifierLiteralNode);
    }

    public void visit(Token token) {
    }

    protected void visitSyntaxNode(Node node) {
        if (node instanceof Token) {
            node.accept(this);
            return;
        }
        NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
        for (Node child : nonTerminalNode.children()) {
            child.accept(this);
        }
    }
}

