/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.syntax.SyntaxUtils;
import io.ballerina.toml.internal.syntax.TreeModifiers;
import io.ballerina.toml.syntax.tree.ChildNodeEntry;
import io.ballerina.toml.syntax.tree.ChildNodeList;
import io.ballerina.toml.syntax.tree.MinutiaeList;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class NonTerminalNode
extends Node {
    protected final Node[] childBuckets;
    private ChildNodeList childNodeList;

    public NonTerminalNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
        this.childBuckets = new Node[internalNode.bucketCount()];
    }

    public ChildNodeList children() {
        if (this.childNodeList != null) {
            return this.childNodeList;
        }
        this.childNodeList = new ChildNodeList(this);
        return this.childNodeList;
    }

    public Collection<ChildNodeEntry> childEntries() {
        String[] childNames = this.childNames();
        return Collections.unmodifiableCollection(IntStream.range(0, this.bucketCount()).filter(bucket -> this.childInBucket(bucket) != null).mapToObj(bucket -> new ChildNodeEntry(childNames[bucket], (Node)this.childInBucket(bucket))).collect(Collectors.toList()));
    }

    @Override
    public MinutiaeList leadingMinutiae() {
        throw new UnsupportedOperationException("This method is not yet implemented. Please check again later.");
    }

    @Override
    public MinutiaeList trailingMinutiae() {
        throw new UnsupportedOperationException("This method is not yet implemented. Please check again later.");
    }

    public Token findToken(int position) {
        if (!this.textRangeWithMinutiae().contains(position)) {
            throw new IllegalArgumentException();
        }
        Node foundNode = this;
        while (!SyntaxUtils.isToken(foundNode)) {
            foundNode = foundNode.findChildNode(position);
        }
        return (Token)foundNode;
    }

    public <T extends NonTerminalNode> T replace(Node target, Node replacement) {
        return (T)TreeModifiers.replace(this, target, replacement);
    }

    @Override
    public Iterable<Diagnostic> diagnostics() {
        if (!this.internalNode.hasDiagnostics()) {
            return Collections::emptyIterator;
        }
        return () -> this.collectDiagnostics().iterator();
    }

    protected abstract String[] childNames();

    protected int bucketCount() {
        return this.internalNode.bucketCount();
    }

    protected <T extends Node> T childInBucket(int bucket) {
        Node child = this.childBuckets[bucket];
        if (child != null) {
            return (T)child;
        }
        STNode internalChild = this.internalNode.childInBucket(bucket);
        if (SyntaxUtils.isSTNodePresent(internalChild)) {
            this.childBuckets[bucket] = child = internalChild.createFacade(this.getChildPosition(bucket), this);
        }
        return (T)child;
    }

    protected <T extends Node> Optional<T> optionalChildInBucket(int bucket) {
        return Optional.ofNullable(this.childInBucket(bucket));
    }

    protected int getChildPosition(int bucket) {
        int childPos = this.position;
        for (int i = 0; i < bucket; ++i) {
            STNode childNode = this.internalNode.childInBucket(i);
            if (childNode == null) continue;
            childPos += childNode.widthWithMinutiae();
        }
        return childPos;
    }

    protected boolean checkForReferenceEquality(Node ... children) {
        for (int bucket = 0; bucket < children.length; ++bucket) {
            if (this.checkForReferenceEquality(bucket, children[bucket])) continue;
            return false;
        }
        return true;
    }

    protected boolean checkForReferenceEquality(int index, Node child) {
        return this.childBuckets[index] == child;
    }

    private Node findChildNode(int position) {
        int offset = this.textRangeWithMinutiae().startOffset();
        for (int bucket = 0; bucket < this.internalNode.bucketCount(); ++bucket) {
            STNode internalChildNode = this.internalNode.childInBucket(bucket);
            if (!SyntaxUtils.isSTNodePresent(internalChildNode)) continue;
            if (position < offset + internalChildNode.widthWithMinutiae()) {
                return this.childInBucket(bucket);
            }
            offset += internalChildNode.widthWithMinutiae();
        }
        throw new IllegalStateException();
    }

    private List<Diagnostic> collectDiagnostics() {
        ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
        this.collectDiagnostics(this, diagnosticList);
        return diagnosticList;
    }

    private void collectDiagnostics(NonTerminalNode node, List<Diagnostic> diagnosticList) {
        for (Node child : node.children()) {
            child.diagnostics().forEach(diagnosticList::add);
        }
        this.internalNode.diagnostics().stream().map(this::createSyntaxDiagnostic).forEach(diagnosticList::add);
    }
}

