/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.ArraySchema;
import io.ballerina.toml.validator.schema.BooleanSchema;
import io.ballerina.toml.validator.schema.JsonSchemaException;
import io.ballerina.toml.validator.schema.NumericSchema;
import io.ballerina.toml.validator.schema.ObjectSchema;
import io.ballerina.toml.validator.schema.StringSchema;
import io.ballerina.toml.validator.schema.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SchemaDeserializer
implements JsonDeserializer<AbstractSchema> {
    public static final String TYPE = "type";
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";
    public static final String INTEGER = "integer";
    public static final String NUMBER = "number";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String DESCRIPTION = "description";
    public static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    public static final String PROPERTIES = "properties";
    public static final String ITEMS = "items";
    public static final String PATTERN = "pattern";
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";

    @Override
    public AbstractSchema deserialize(JsonElement jsonElement, java.lang.reflect.Type refType, JsonDeserializationContext jsonDeserializationContext) {
        String type;
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        switch (type = jsonObj.get(TYPE).getAsString()) {
            case "object": {
                return this.getObjectSchema(jsonDeserializationContext, jsonObj);
            }
            case "array": {
                return this.getArraySchema(jsonDeserializationContext, jsonObj);
            }
            case "integer": {
                return this.getNumericSchema(jsonObj, Type.INTEGER);
            }
            case "number": {
                return this.getNumericSchema(jsonObj, Type.NUMBER);
            }
            case "string": {
                return this.getStringSchema(jsonObj);
            }
            case "boolean": {
                return new BooleanSchema(Type.BOOLEAN);
            }
        }
        throw new JsonSchemaException(type + " is not supported type in json schema");
    }

    private ObjectSchema getObjectSchema(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObj) {
        JsonElement descriptionProperty = jsonObj.get(DESCRIPTION);
        String description = descriptionProperty != null ? descriptionProperty.getAsString() : null;
        boolean additionalProperties = this.parseOptionalBooleanFromJson(jsonObj, ADDITIONAL_PROPERTIES);
        JsonObject properties = jsonObj.get(PROPERTIES).getAsJsonObject();
        Set<Map.Entry<String, JsonElement>> entries = properties.entrySet();
        HashMap<String, AbstractSchema> propertiesList = new HashMap<String, AbstractSchema>();
        for (Map.Entry<String, JsonElement> entry : entries) {
            String key = entry.getKey();
            AbstractSchema abstractSchema = (AbstractSchema)jsonDeserializationContext.deserialize(entry.getValue(), (java.lang.reflect.Type)((Object)AbstractSchema.class));
            propertiesList.put(key, abstractSchema);
        }
        return new ObjectSchema(Type.OBJECT, description, additionalProperties, propertiesList);
    }

    private AbstractSchema getArraySchema(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObj) {
        JsonObject items = jsonObj.get(ITEMS).getAsJsonObject();
        AbstractSchema abstractSchema = (AbstractSchema)jsonDeserializationContext.deserialize(items, (java.lang.reflect.Type)((Object)AbstractSchema.class));
        return new ArraySchema(Type.ARRAY, abstractSchema);
    }

    private StringSchema getStringSchema(JsonObject jsonObj) {
        String pattern = this.parseOptionalStringFromJson(jsonObj, PATTERN);
        return new StringSchema(Type.STRING, pattern);
    }

    private NumericSchema getNumericSchema(JsonObject jsonObj, Type type) {
        Double minimum = this.parseOptionalDoubleFromJson(jsonObj, MINIMUM);
        Double maximum = this.parseOptionalDoubleFromJson(jsonObj, MAXIMUM);
        return new NumericSchema(type, minimum, maximum);
    }

    private Double parseOptionalDoubleFromJson(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return jsonElement.getAsDouble();
        }
        throw new JsonSchemaException(key + " should always be a number");
    }

    private boolean parseOptionalBooleanFromJson(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return false;
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isBoolean()) {
            return jsonElement.getAsBoolean();
        }
        throw new JsonSchemaException(key + " should always be a boolean");
    }

    private String parseOptionalStringFromJson(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return jsonElement.getAsString();
        }
        throw new JsonSchemaException(key + " should always be a string");
    }
}

