/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.text;

public class TextLine {
    private final int lineNo;
    private final String text;
    private final int startOffset;
    private final int endOffset;
    private final int lengthOfNewLineChars;

    TextLine(int lineNo, String text, int startOffset, int endOffset, int lengthOfNewLineChars) {
        this.text = text;
        this.lineNo = lineNo;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.lengthOfNewLineChars = lengthOfNewLineChars;
    }

    public int lineNo() {
        return this.lineNo;
    }

    public String text() {
        return this.text;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public int endOffsetWithNewLines() {
        return this.endOffset + this.lengthOfNewLineChars;
    }

    public int length() {
        return this.endOffset - this.startOffset;
    }

    public int lengthWithNewLineChars() {
        return this.endOffset - this.startOffset + this.lengthOfNewLineChars;
    }
}

