/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.module;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import org.ballerinalang.cli.module.util.ErrorUtil;

public class TokenUpdater {
    private static PrintStream errStream = System.err;
    private static PrintStream outStream = System.out;

    private TokenUpdater() {
    }

    public static void execute(String settingsTomlFilePath) {
        HttpServer server;
        try {
            server = HttpServer.create(new InetSocketAddress(9295), 0);
        }
        catch (IOException e) {
            throw ErrorUtil.createCommandException("error occurred while creating the server: " + e.getMessage() + "Access token is missing in " + settingsTomlFilePath + "\nAuto update failed. Please visit https://central.ballerina.io, get token and add it to the" + settingsTomlFilePath + " file.");
        }
        server.createContext("/update-settings", new TokenUpdateHandler());
        server.setExecutor(null);
        server.start();
    }

    static class TokenUpdateHandler
    implements HttpHandler {
        TokenUpdateHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) {
            String token = TokenUpdateHandler.getToken(httpExchange.getRequestURI().getPath());
            String currentUsersHomeDir = System.getProperty("user.home");
            String settingsTomlPath = String.valueOf(Paths.get(currentUsersHomeDir, ".ballerina", "Settings.toml"));
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(settingsTomlPath);
                String str = "[central]\naccesstoken=\"" + token + "\"";
                outputStream.write(str.getBytes(StandardCharsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                throw ErrorUtil.createCommandException("Settings.toml file could not be found: " + settingsTomlPath);
            }
            catch (IOException e) {
                throw ErrorUtil.createCommandException("error occurred while writing to the Settings.toml file: " + e.getMessage());
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    errStream.println("error occurred while closing the output stream: " + e.getMessage());
                }
            }
            outStream.println("token updated");
            OutputStream os = null;
            try {
                String response = "<svg xmlns=\"http://www.w3.org/2000/svg\"/>";
                httpExchange.getResponseHeaders().put("Content-Type", Collections.singletonList("image/svg+xml"));
                httpExchange.sendResponseHeaders(200, response.getBytes(StandardCharsets.UTF_8).length);
                os = httpExchange.getResponseBody();
                os.write(response.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw ErrorUtil.createCommandException("error occurred while generating the response: " + e.getMessage());
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    errStream.println("error occurred while closing the output stream: " + e.getMessage());
                }
            }
        }

        private static String getToken(String uri) {
            String[] uriParts = uri.split("/");
            return uriParts[uriParts.length - 1];
        }
    }
}

