/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.types;

import java.util.Arrays;
import org.ballerinalang.core.model.types.BType;
import org.ballerinalang.core.model.values.BFunctionPointer;
import org.ballerinalang.core.model.values.BValue;

public class BFunctionType
extends BType {
    public BType[] paramTypes;
    public BType restType;
    public BType[] retParamTypes;
    private boolean hasReturnsKeyword;
    private String[] parametersFieldsNames = new String[0];
    private String[] returnsParametersFieldsNames = new String[0];

    public BFunctionType() {
        super("function ()", null, BFunctionPointer.class);
        this.paramTypes = new BType[0];
        this.retParamTypes = new BType[0];
    }

    public BFunctionType(BType[] paramTypes, BType restType, BType[] retParamType) {
        super("function ()", null, BFunctionPointer.class);
        this.paramTypes = paramTypes;
        this.restType = restType;
        this.retParamTypes = retParamType;
    }

    public BType[] getParameterType() {
        return this.paramTypes;
    }

    public BType[] getReturnParameterType() {
        return this.retParamTypes;
    }

    @Override
    public <V extends BValue> V getZeroValue() {
        return null;
    }

    @Override
    public <V extends BValue> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 35;
    }

    public static String getTypeName(BType[] parameterType, BType[] returnParameterType) {
        return "function (" + (parameterType != null ? BFunctionType.getBTypeListAsString(parameterType) : "") + ")" + (String)(returnParameterType != null ? " returns (" + BFunctionType.getBTypeListAsString(returnParameterType) + ")" : "");
    }

    private static String getBTypeListAsString(BType[] typeNames) {
        StringBuffer br = new StringBuffer();
        int i = 0;
        for (BType type : typeNames) {
            br.append(type.getName());
            if (++i >= typeNames.length) continue;
            br.append(",");
        }
        return br.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BFunctionType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BFunctionType that = (BFunctionType)o;
        if (!Arrays.equals(this.paramTypes, that.paramTypes)) {
            return false;
        }
        return Arrays.equals(this.retParamTypes, that.retParamTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.paramTypes);
        result = 31 * result + Arrays.hashCode(this.retParamTypes);
        return result;
    }

    @Override
    public String toString() {
        return BFunctionType.getTypeName(this.paramTypes, this.retParamTypes);
    }

    public boolean hasReturnsKeyword() {
        return this.hasReturnsKeyword;
    }

    public void setHasReturnsKeyword(boolean hasReturnsKeyword) {
        this.hasReturnsKeyword = hasReturnsKeyword;
    }

    public String[] getParametersFieldsNames() {
        return this.parametersFieldsNames;
    }

    public void setParametersFieldsNames(String[] parametersFieldsNames) {
        this.parametersFieldsNames = parametersFieldsNames;
    }

    public String[] getReturnsParametersFieldsNames() {
        return this.returnsParametersFieldsNames;
    }

    public void setReturnsParametersFieldsNames(String[] returnsParametersFieldsNames) {
        this.returnsParametersFieldsNames = returnsParametersFieldsNames;
    }
}

