/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.core.model.types.BArrayType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.values.BBoolean;
import org.ballerinalang.core.model.values.BFloat;
import org.ballerinalang.core.model.values.BInteger;
import org.ballerinalang.core.model.values.BMap;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BString;
import org.ballerinalang.core.model.values.BValueArray;
import org.ballerinalang.core.util.exceptions.BallerinaException;

public class JsonParser {
    private static ThreadLocal<StateMachine> tlStateMachine = new ThreadLocal<StateMachine>(){

        @Override
        public StateMachine initialValue() {
            return new StateMachine();
        }
    };

    public static BRefType<?> parse(InputStream in) throws BallerinaException {
        return JsonParser.parse(in, Charset.defaultCharset().name());
    }

    public static BRefType<?> parse(InputStream in, String charsetName) throws BallerinaException {
        try {
            return JsonParser.parse(new InputStreamReader((InputStream)new BufferedInputStream(in), charsetName));
        }
        catch (IOException e) {
            throw new BallerinaException("Error in parsing JSON data: " + e.getMessage(), e);
        }
    }

    public static BRefType<?> parse(String jsonStr) throws BallerinaException {
        return JsonParser.parse(new StringReader(jsonStr));
    }

    public static BRefType<?> parse(Reader reader) throws BallerinaException {
        StateMachine sm = tlStateMachine.get();
        try {
            BRefType<?> bRefType = sm.execute(reader);
            return bRefType;
        }
        finally {
            sm.reset();
        }
    }

    private static class StateMachine {
        private static final char CR = '\r';
        private static final char NEWLINE = '\n';
        private static final char HZ_TAB = '\t';
        private static final char SPACE = ' ';
        private static final char BACKSPACE = '\b';
        private static final char FORMFEED = '\f';
        private static final char QUOTES = '\"';
        private static final char SINGLE_QUOTES = '\'';
        private static final char REV_SOL = '\\';
        private static final char SOL = '/';
        private static final char EOF = '\uffff';
        private static final String NULL = "null";
        private static final String TRUE = "true";
        private static final String FALSE = "false";
        private static final State DOC_START_STATE = new DocumentStartState();
        private static final State DOC_END_STATE = new DocumentEndState();
        private static final State FIRST_FIELD_READY_STATE = new FirstFieldReadyState();
        private static final State NON_FIRST_FIELD_READY_STATE = new NonFirstFieldReadyState();
        private static final State FIELD_NAME_STATE = new FieldNameState();
        private static final State END_FIELD_NAME_STATE = new EndFieldNameState();
        private static final State FIELD_VALUE_READY_STATE = new FieldValueReadyState();
        private static final State STRING_FIELD_VALUE_STATE = new StringFieldValueState();
        private static final State NON_STRING_FIELD_VALUE_STATE = new NonStringFieldValueState();
        private static final State NON_STRING_VALUE_STATE = new NonStringValueState();
        private static final State STRING_VALUE_STATE = new StringValueState();
        private static final State FIELD_END_STATE = new FieldEndState();
        private static final State STRING_AE_ESC_CHAR_PROCESSING_STATE = new StringAEEscapedCharacterProcessingState();
        private static final State STRING_AE_PROCESSING_STATE = new StringAEProcessingState();
        private static final State FIELD_NAME_UNICODE_HEX_PROCESSING_STATE = new FieldNameUnicodeHexProcessingState();
        private static final State FIRST_ARRAY_ELEMENT_READY_STATE = new FirstArrayElementReadyState();
        private static final State NON_FIRST_ARRAY_ELEMENT_READY_STATE = new NonFirstArrayElementReadyState();
        private static final State STRING_ARRAY_ELEMENT_STATE = new StringArrayElementState();
        private static final State NON_STRING_ARRAY_ELEMENT_STATE = new NonStringArrayElementState();
        private static final State ARRAY_ELEMENT_END_STATE = new ArrayElementEndState();
        private static final State STRING_FIELD_ESC_CHAR_PROCESSING_STATE = new StringFieldEscapedCharacterProcessingState();
        private static final State STRING_VAL_ESC_CHAR_PROCESSING_STATE = new StringValueEscapedCharacterProcessingState();
        private static final State FIELD_NAME_ESC_CHAR_PROCESSING_STATE = new FieldNameEscapedCharacterProcessingState();
        private static final State STRING_FIELD_UNICODE_HEX_PROCESSING_STATE = new StringFieldUnicodeHexProcessingState();
        private static final State STRING_VALUE_UNICODE_HEX_PROCESSING_STATE = new StringValueUnicodeHexProcessingState();
        private BRefType<?> currentJsonNode;
        private Deque<BRefType<?>> nodesStack;
        private Deque<String> fieldNames;
        private StringBuilder hexBuilder = new StringBuilder(4);
        private char[] charBuff = new char[1024];
        private int charBuffIndex;
        private int index;
        private int line;
        private int column;
        private char currentQuoteChar;

        StateMachine() {
            this.reset();
        }

        public void reset() {
            this.index = 0;
            this.currentJsonNode = null;
            this.line = 1;
            this.column = 0;
            this.nodesStack = new ArrayDeque();
            this.fieldNames = new ArrayDeque<String>();
        }

        private static boolean isWhitespace(char ch) {
            return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
        }

        private static void throwExpected(String ... chars) throws JsonParserException {
            throw new JsonParserException("expected " + String.join((CharSequence)" or ", chars));
        }

        private void processLocation(char ch) {
            if (ch == '\n') {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
        }

        public BRefType<?> execute(Reader reader) throws BallerinaException {
            State currentState = DOC_START_STATE;
            try {
                int count;
                char[] buff = new char[1024];
                while ((count = reader.read(buff)) > 0) {
                    this.index = 0;
                    while (this.index < count) {
                        currentState = currentState.transition(this, buff, this.index, count);
                    }
                }
                if ((currentState = currentState.transition(this, new char[]{'\uffff'}, 0, 1)) != DOC_END_STATE) {
                    throw new BallerinaException("invalid JSON document");
                }
                return this.currentJsonNode;
            }
            catch (IOException e) {
                throw new BallerinaException("Error reading JSON: " + e.getMessage());
            }
            catch (JsonParserException e) {
                throw new BallerinaException(e.getMessage() + " at line: " + this.line + " column: " + this.column);
            }
        }

        private void append(char ch) {
            try {
                this.charBuff[this.charBuffIndex] = ch;
                ++this.charBuffIndex;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.growCharBuff();
                this.charBuff[this.charBuffIndex++] = ch;
            }
        }

        private void growCharBuff() {
            char[] newBuff = new char[this.charBuff.length * 2];
            System.arraycopy(this.charBuff, 0, newBuff, 0, this.charBuff.length);
            this.charBuff = newBuff;
        }

        private State finalizeObject() {
            if (!this.nodesStack.isEmpty()) {
                BRefType<?> parentNode = this.nodesStack.pop();
                if (parentNode.getType().getTag() == 7) {
                    ((BMap)parentNode).put(this.fieldNames.pop(), this.currentJsonNode);
                    this.currentJsonNode = parentNode;
                    return FIELD_END_STATE;
                }
                ((BValueArray)parentNode).append(this.currentJsonNode);
                this.currentJsonNode = parentNode;
                return ARRAY_ELEMENT_END_STATE;
            }
            return DOC_END_STATE;
        }

        private State initNewObject() {
            if (this.currentJsonNode != null) {
                this.nodesStack.push(this.currentJsonNode);
            }
            this.currentJsonNode = new BMap(BTypes.typeJSON);
            return FIRST_FIELD_READY_STATE;
        }

        private State initNewArray() {
            if (this.currentJsonNode != null) {
                this.nodesStack.push(this.currentJsonNode);
            }
            this.currentJsonNode = new BValueArray(new BArrayType(BTypes.typeJSON));
            return FIRST_ARRAY_ELEMENT_READY_STATE;
        }

        private String value() {
            String result = new String(this.charBuff, 0, this.charBuffIndex);
            this.charBuffIndex = 0;
            return result;
        }

        private void processFieldName() {
            this.fieldNames.push(this.value());
        }

        private void processNonStringValue(ValueType type) throws JsonParserException {
            String str = this.value();
            if (str.indexOf(46) >= 0) {
                try {
                    double doubleValue = Double.parseDouble(str);
                    switch (type) {
                        case ARRAY_ELEMENT: {
                            ((BValueArray)this.currentJsonNode).append(new BFloat(doubleValue));
                            break;
                        }
                        case FIELD: {
                            ((BMap)this.currentJsonNode).put(this.fieldNames.pop(), new BFloat(doubleValue));
                            break;
                        }
                        case VALUE: {
                            this.currentJsonNode = new BFloat(doubleValue);
                            break;
                        }
                    }
                }
                catch (NumberFormatException ignore) {
                    throw new JsonParserException("unrecognized token '" + str + "'");
                }
            }
            char ch = str.charAt(0);
            if (ch == 't' && TRUE.equals(str)) {
                switch (type) {
                    case ARRAY_ELEMENT: {
                        ((BValueArray)this.currentJsonNode).append(new BBoolean(true));
                        break;
                    }
                    case FIELD: {
                        ((BMap)this.currentJsonNode).put(this.fieldNames.pop(), new BBoolean(true));
                        break;
                    }
                    case VALUE: {
                        this.currentJsonNode = new BBoolean(true);
                        break;
                    }
                }
            } else if (ch == 'f' && FALSE.equals(str)) {
                switch (type) {
                    case ARRAY_ELEMENT: {
                        ((BValueArray)this.currentJsonNode).append(new BBoolean(false));
                        break;
                    }
                    case FIELD: {
                        ((BMap)this.currentJsonNode).put(this.fieldNames.pop(), new BBoolean(false));
                        break;
                    }
                    case VALUE: {
                        this.currentJsonNode = new BBoolean(false);
                        break;
                    }
                }
            } else if (ch == 'n' && NULL.equals(str)) {
                switch (type) {
                    case ARRAY_ELEMENT: {
                        ((BValueArray)this.currentJsonNode).append(null);
                        break;
                    }
                    case FIELD: {
                        ((BMap)this.currentJsonNode).put(this.fieldNames.pop(), null);
                        break;
                    }
                    case VALUE: {
                        this.currentJsonNode = null;
                        break;
                    }
                }
            } else {
                try {
                    long longValue = Long.parseLong(str);
                    switch (type) {
                        case ARRAY_ELEMENT: {
                            ((BValueArray)this.currentJsonNode).append(new BInteger(longValue));
                            break;
                        }
                        case FIELD: {
                            ((BMap)this.currentJsonNode).put(this.fieldNames.pop(), new BInteger(longValue));
                            break;
                        }
                        case VALUE: {
                            this.currentJsonNode = new BInteger(longValue);
                            break;
                        }
                    }
                }
                catch (NumberFormatException ignore) {
                    throw new JsonParserException("unrecognized token '" + str + "'");
                }
            }
        }

        private static abstract class EscapedCharacterProcessingState
        implements State {
            private EscapedCharacterProcessingState() {
            }

            protected abstract State getSourceState();

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                if (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    switch (ch) {
                        case '\"': {
                            sm.append('\"');
                            state = this.getSourceState();
                            break;
                        }
                        case '\\': {
                            sm.append('\\');
                            state = this.getSourceState();
                            break;
                        }
                        case '/': {
                            sm.append('/');
                            state = this.getSourceState();
                            break;
                        }
                        case 'b': {
                            sm.append('\b');
                            state = this.getSourceState();
                            break;
                        }
                        case 'f': {
                            sm.append('\f');
                            state = this.getSourceState();
                            break;
                        }
                        case 'n': {
                            sm.append('\n');
                            state = this.getSourceState();
                            break;
                        }
                        case 'r': {
                            sm.append('\r');
                            state = this.getSourceState();
                            break;
                        }
                        case 't': {
                            sm.append('\t');
                            state = this.getSourceState();
                            break;
                        }
                        case 'u': {
                            if (this.getSourceState() == STRING_FIELD_VALUE_STATE) {
                                state = STRING_FIELD_UNICODE_HEX_PROCESSING_STATE;
                                break;
                            }
                            if (this.getSourceState() == STRING_VALUE_STATE) {
                                state = STRING_VALUE_UNICODE_HEX_PROCESSING_STATE;
                                break;
                            }
                            if (this.getSourceState() == FIELD_NAME_STATE) {
                                state = FIELD_NAME_UNICODE_HEX_PROCESSING_STATE;
                                break;
                            }
                            if (this.getSourceState() == STRING_ARRAY_ELEMENT_STATE) {
                                state = STRING_AE_PROCESSING_STATE;
                                break;
                            }
                            throw new JsonParserException("unknown source '" + this.getSourceState() + "' in escape char processing state");
                        }
                        default: {
                            StateMachine.throwExpected("escaped characters");
                        }
                    }
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FieldNameEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private FieldNameEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return FIELD_NAME_STATE;
            }
        }

        private static class StringValueEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private StringValueEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_VALUE_STATE;
            }
        }

        private static class StringAEEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private StringAEEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_ARRAY_ELEMENT_STATE;
            }
        }

        private static class StringFieldEscapedCharacterProcessingState
        extends EscapedCharacterProcessingState {
            private StringFieldEscapedCharacterProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_FIELD_VALUE_STATE;
            }
        }

        private static abstract class UnicodeHexProcessingState
        implements State {
            private UnicodeHexProcessingState() {
            }

            protected abstract State getSourceState();

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') {
                        sm.hexBuilder.append(ch);
                        if (sm.hexBuilder.length() >= 4) {
                            sm.append(this.extractUnicodeChar(sm));
                            this.reset(sm);
                            state = this.getSourceState();
                            break;
                        }
                    } else {
                        this.reset(sm);
                        StateMachine.throwExpected("hexadecimal value of an unicode character");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }

            private void reset(StateMachine sm) {
                sm.hexBuilder.setLength(0);
            }

            private char extractUnicodeChar(StateMachine sm) {
                return StringEscapeUtils.unescapeJava("\\u" + sm.hexBuilder.toString()).charAt(0);
            }
        }

        private static class FieldNameUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private FieldNameUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return FIELD_NAME_STATE;
            }
        }

        private static class StringValueUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private StringValueUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_VALUE_STATE;
            }
        }

        private static class StringAEProcessingState
        extends UnicodeHexProcessingState {
            private StringAEProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_ARRAY_ELEMENT_STATE;
            }
        }

        private static class StringFieldUnicodeHexProcessingState
        extends UnicodeHexProcessingState {
            private StringFieldUnicodeHexProcessingState() {
            }

            @Override
            protected State getSourceState() {
                return STRING_FIELD_VALUE_STATE;
            }
        }

        private static class ArrayElementEndState
        implements State {
            private ArrayElementEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == ',') {
                            state = NON_FIRST_ARRAY_ELEMENT_READY_STATE;
                            break;
                        }
                        if (ch == ']') {
                            state = sm.finalizeObject();
                            break;
                        }
                        StateMachine.throwExpected(",", "]");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FieldEndState
        implements State {
            private FieldEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == ',') {
                            state = NON_FIRST_FIELD_READY_STATE;
                            break;
                        }
                        if (ch == '}') {
                            state = sm.finalizeObject();
                            break;
                        }
                        StateMachine.throwExpected(",", "}");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonStringValueState
        implements State {
            private NonStringValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (StateMachine.isWhitespace(ch) || ch == '\uffff') {
                        sm.currentJsonNode = null;
                        sm.processNonStringValue(ValueType.VALUE);
                        state = DOC_END_STATE;
                        break;
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static enum ValueType {
            FIELD,
            VALUE,
            ARRAY_ELEMENT;

        }

        private static class StringValueState
        implements State {
            private StringValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        sm.currentJsonNode = new BString(sm.value());
                        state = DOC_END_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = STRING_VAL_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonStringArrayElementState
        implements State {
            private NonStringArrayElementState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '{') {
                        state = sm.initNewObject();
                        break;
                    }
                    if (ch == '[') {
                        state = sm.initNewArray();
                        break;
                    }
                    if (ch == ']') {
                        sm.processNonStringValue(ValueType.ARRAY_ELEMENT);
                        state = sm.finalizeObject();
                        break;
                    }
                    if (ch == ',') {
                        sm.processNonStringValue(ValueType.ARRAY_ELEMENT);
                        state = NON_FIRST_ARRAY_ELEMENT_READY_STATE;
                        break;
                    }
                    if (StateMachine.isWhitespace(ch)) {
                        sm.processNonStringValue(ValueType.ARRAY_ELEMENT);
                        state = ARRAY_ELEMENT_END_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonStringFieldValueState
        implements State {
            private NonStringFieldValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '{') {
                        state = sm.initNewObject();
                        break;
                    }
                    if (ch == '[') {
                        state = sm.initNewArray();
                        break;
                    }
                    if (ch == '}' || ch == ']') {
                        sm.processNonStringValue(ValueType.FIELD);
                        state = sm.finalizeObject();
                        break;
                    }
                    if (ch == ',') {
                        sm.processNonStringValue(ValueType.FIELD);
                        state = NON_FIRST_FIELD_READY_STATE;
                        break;
                    }
                    if (StateMachine.isWhitespace(ch)) {
                        sm.processNonStringValue(ValueType.FIELD);
                        state = FIELD_END_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class StringArrayElementState
        implements State {
            private StringArrayElementState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        ((BValueArray)sm.currentJsonNode).append(new BString(sm.value()));
                        state = ARRAY_ELEMENT_END_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = STRING_AE_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class StringFieldValueState
        implements State {
            private StringFieldValueState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        ((BMap)sm.currentJsonNode).put(sm.fieldNames.pop(), new BString(sm.value()));
                        state = FIELD_END_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = STRING_FIELD_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FieldValueReadyState
        implements State {
            private FieldValueReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"' || ch == '\'') {
                            state = STRING_FIELD_VALUE_STATE;
                            sm.currentQuoteChar = ch;
                            break;
                        }
                        if (ch == '{') {
                            state = sm.initNewObject();
                            break;
                        }
                        if (ch == '[') {
                            state = sm.initNewArray();
                            break;
                        }
                        state = NON_STRING_FIELD_VALUE_STATE;
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_FIELD_VALUE_STATE ? i : i + 1;
                return state;
            }
        }

        private static class EndFieldNameState
        implements State {
            private EndFieldNameState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == ':') {
                            state = FIELD_VALUE_READY_STATE;
                            break;
                        }
                        StateMachine.throwExpected(":");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FieldNameState
        implements State {
            private FieldNameState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == sm.currentQuoteChar) {
                        sm.processFieldName();
                        state = END_FIELD_NAME_STATE;
                        break;
                    }
                    if (ch == '\\') {
                        state = FIELD_NAME_ESC_CHAR_PROCESSING_STATE;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new JsonParserException("unexpected end of JSON document");
                    }
                    sm.append(ch);
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class NonFirstArrayElementReadyState
        implements State {
            private NonFirstArrayElementReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"' || ch == '\'') {
                            state = STRING_ARRAY_ELEMENT_STATE;
                            sm.currentQuoteChar = ch;
                            break;
                        }
                        if (ch == '{') {
                            state = sm.initNewObject();
                            break;
                        }
                        if (ch == '[') {
                            state = sm.initNewArray();
                            break;
                        }
                        state = NON_STRING_ARRAY_ELEMENT_STATE;
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_ARRAY_ELEMENT_STATE ? i : i + 1;
                return state;
            }
        }

        private static class NonFirstFieldReadyState
        implements State {
            private NonFirstFieldReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\"' || ch == '\'') {
                        sm.currentQuoteChar = ch;
                        state = FIELD_NAME_STATE;
                        break;
                    }
                    if (!StateMachine.isWhitespace(ch)) {
                        StateMachine.throwExpected("\"");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class FirstArrayElementReadyState
        implements State {
            private FirstArrayElementReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"' || ch == '\'') {
                            state = STRING_ARRAY_ELEMENT_STATE;
                            sm.currentQuoteChar = ch;
                            break;
                        }
                        if (ch == '{') {
                            state = sm.initNewObject();
                            break;
                        }
                        if (ch == '[') {
                            state = sm.initNewArray();
                            break;
                        }
                        if (ch == ']') {
                            state = sm.finalizeObject();
                            break;
                        }
                        state = NON_STRING_ARRAY_ELEMENT_STATE;
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_ARRAY_ELEMENT_STATE ? i : i + 1;
                return state;
            }
        }

        private static class FirstFieldReadyState
        implements State {
            private FirstFieldReadyState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '\"' || ch == '\'') {
                        state = FIELD_NAME_STATE;
                        sm.currentQuoteChar = ch;
                        break;
                    }
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '}') {
                            state = sm.finalizeObject();
                            break;
                        }
                        StateMachine.throwExpected("\"", "}");
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class DocumentEndState
        implements State {
            private DocumentEndState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                DocumentEndState state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (!StateMachine.isWhitespace(ch) && ch != '\uffff') {
                        throw new JsonParserException("JSON document has already ended");
                    }
                    state = this;
                    ++i;
                }
                sm.index = i + 1;
                return state;
            }
        }

        private static class DocumentStartState
        implements State {
            private DocumentStartState() {
            }

            @Override
            public State transition(StateMachine sm, char[] buff, int i, int count) throws JsonParserException {
                State state = null;
                while (i < count) {
                    char ch = buff[i];
                    sm.processLocation(ch);
                    if (ch == '{') {
                        state = sm.initNewObject();
                        break;
                    }
                    if (ch == '[') {
                        state = sm.initNewArray();
                        break;
                    }
                    if (!StateMachine.isWhitespace(ch)) {
                        if (ch == '\"' || ch == '\'') {
                            sm.currentQuoteChar = ch;
                            state = STRING_VALUE_STATE;
                            break;
                        }
                        if (ch == '\uffff') {
                            throw new JsonParserException("empty JSON document");
                        }
                        state = NON_STRING_VALUE_STATE;
                        break;
                    }
                    state = this;
                    ++i;
                }
                sm.index = state == NON_STRING_VALUE_STATE ? i : i + 1;
                return state;
            }
        }

        private static interface State {
            public State transition(StateMachine var1, char[] var2, int var3, int var4) throws JsonParserException;
        }
    }

    private static class JsonParserException
    extends Exception {
        private static final long serialVersionUID = 6359022327525293320L;

        public JsonParserException(String msg) {
            super(msg);
        }
    }
}

