/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util;

import java.math.BigDecimal;
import org.ballerinalang.core.model.types.BArrayType;
import org.ballerinalang.core.model.values.BBoolean;
import org.ballerinalang.core.model.values.BByte;
import org.ballerinalang.core.model.values.BDecimal;
import org.ballerinalang.core.model.values.BFloat;
import org.ballerinalang.core.model.values.BInteger;
import org.ballerinalang.core.model.values.BNewArray;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BString;
import org.ballerinalang.core.model.values.BValueArray;

public class ListUtils {
    public static BRefType<?> execListGetOperation(BNewArray array, long index) {
        if (array.getType().getTag() != 19) {
            BValueArray bRefValueArray = (BValueArray)array;
            return bRefValueArray.getRefValue(index);
        }
        switch (((BArrayType)array.getType()).getElementType().getTag()) {
            case 6: {
                BValueArray bBooleanArray = (BValueArray)array;
                int i = bBooleanArray.getBoolean(index);
                return i == 0 ? new BBoolean(false) : new BBoolean(true);
            }
            case 2: {
                BValueArray bByteArray = (BValueArray)array;
                return new BByte(bByteArray.getByte(index));
            }
            case 3: {
                BValueArray bFloatArray = (BValueArray)array;
                return new BFloat(bFloatArray.getFloat(index));
            }
            case 4: {
                BValueArray bDecimalArray = (BValueArray)array;
                return new BDecimal(new BigDecimal(bDecimalArray.getRefValue(index).stringValue()));
            }
            case 1: {
                BValueArray bIntArray = (BValueArray)array;
                return new BInteger(bIntArray.getInt(index));
            }
            case 5: {
                BValueArray bStringArray = (BValueArray)array;
                return new BString(bStringArray.getString(index));
            }
        }
        BValueArray bRefValueArray = (BValueArray)array;
        return bRefValueArray.getRefValue(index);
    }

    public static void execListAddOperation(BNewArray array, long index, BRefType refType) {
        if (array.getType().getTag() != 19) {
            BValueArray bRefValueArray = (BValueArray)array;
            bRefValueArray.add(index, refType);
            return;
        }
        BValueArray bValueArray = (BValueArray)array;
        switch (((BArrayType)array.getType()).getElementType().getTag()) {
            case 6: {
                bValueArray.add(index, ((BBoolean)refType).value() != false ? 1 : 0);
                return;
            }
            case 2: {
                bValueArray.add(index, (Byte)refType.value());
                return;
            }
            case 3: {
                bValueArray.add(index, (Double)refType.value());
                return;
            }
            case 1: {
                bValueArray.add(index, (Long)refType.value());
                return;
            }
            case 5: {
                bValueArray.add(index, (String)refType.value());
                return;
            }
        }
        bValueArray.add(index, refType);
    }
}

