/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer;

import java.util.Set;
import org.ballerinalang.core.model.values.BInteger;
import org.ballerinalang.core.model.values.BMap;
import org.ballerinalang.core.model.values.BString;
import org.ballerinalang.core.model.values.BValue;
import org.ballerinalang.core.model.values.BValueArray;

class BTreeHelper {
    private BTreeHelper() {
    }

    static BMap<String, BValue> wrapWithTypeMetadata(String type, BValue payload) {
        BMap<String, BValue> map = new BMap<String, BValue>();
        map.put("type#", BTreeHelper.createBString(type));
        map.put("value#", payload);
        return map;
    }

    static BString createBString(String s) {
        if (s == null) {
            return null;
        }
        return new BString(s);
    }

    static void trimTree(BValue jsonObj, Set<Long> repeatedReferenceSet) {
        if (jsonObj == null) {
            return;
        }
        if (jsonObj instanceof BMap) {
            BMap map = (BMap)jsonObj;
            BInteger objId = (BInteger)map.get("#id#");
            if (objId != null && !repeatedReferenceSet.contains(objId.intValue())) {
                map.remove("#id#");
            }
            BTreeHelper.trimTree(map.get("value#"), repeatedReferenceSet);
        }
        if (jsonObj instanceof BValueArray) {
            BValueArray array = (BValueArray)jsonObj;
            int i = 0;
            while ((long)i < array.size()) {
                BTreeHelper.trimTree(array.getRefValue(i), repeatedReferenceSet);
                ++i;
            }
        }
    }
}

