/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer.providers.bvalue;

import java.util.ArrayList;
import org.ballerinalang.core.model.types.BArrayType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.util.serializer.BPacket;
import org.ballerinalang.core.model.util.serializer.BValueDeserializer;
import org.ballerinalang.core.model.util.serializer.BValueSerializer;
import org.ballerinalang.core.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.core.model.values.BInteger;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BValueArray;

public class ArrayListBValueProvider
implements SerializationBValueProvider<ArrayList> {
    @Override
    public String typeName() {
        return this.getType().getName();
    }

    @Override
    public Class<?> getType() {
        return ArrayList.class;
    }

    @Override
    public BPacket toBValue(ArrayList list, BValueSerializer serializer) {
        BValueArray array = new BValueArray(new BArrayType(BTypes.typeAny));
        for (Object item : list) {
            array.append((BRefType)serializer.toBValue(item, null));
        }
        return BPacket.from(this.typeName(), array).put("len#", new BInteger(list.size()));
    }

    @Override
    public ArrayList toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BInteger length = (BInteger)packet.get("len#");
        BValueArray array = (BValueArray)packet.getValue();
        ArrayList<Object> arrayList = new ArrayList<Object>((int)length.intValue());
        int i = 0;
        while ((long)i < array.size()) {
            arrayList.add(bValueDeserializer.deserialize(array.getRefValue(i), null));
            ++i;
        }
        while ((long)i < length.intValue()) {
            arrayList.add(i, null);
            ++i;
        }
        return arrayList;
    }
}

