/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer.providers.bvalue;

import org.ballerinalang.core.model.types.BArrayType;
import org.ballerinalang.core.model.types.BType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.util.serializer.BPacket;
import org.ballerinalang.core.model.util.serializer.BValueDeserializer;
import org.ballerinalang.core.model.util.serializer.BValueSerializer;
import org.ballerinalang.core.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BValue;
import org.ballerinalang.core.model.values.BValueArray;

public class BValueArrayBValueProvider
implements SerializationBValueProvider<BValueArray> {
    public static final String TYPE = "TYPE";

    @Override
    public String typeName() {
        return this.getType().getSimpleName();
    }

    @Override
    public Class<?> getType() {
        return BValueArray.class;
    }

    @Override
    public BPacket toBValue(BValueArray array, BValueSerializer serializer) {
        long size = array.size();
        BValueArray target = new BValueArray(new BArrayType(BTypes.typeAny));
        BValue elemType = serializer.toBValue(array.getType(), null);
        if (array.getType().getTag() == 19) {
            BType elementType = ((BArrayType)array.getType()).getElementType();
            if (elementType == BTypes.typeInt) {
                int i = 0;
                while ((long)i < size) {
                    BValue value = serializer.toBValue(array.getInt(i), Integer.class);
                    target.add((long)i, (BRefType)value);
                    ++i;
                }
            } else if (elementType == BTypes.typeBoolean) {
                int i = 0;
                while ((long)i < size) {
                    BValue value = serializer.toBValue(array.getBoolean(i), Boolean.class);
                    target.add((long)i, (BRefType)value);
                    ++i;
                }
            } else if (elementType == BTypes.typeByte) {
                int i = 0;
                while ((long)i < size) {
                    BValue value = serializer.toBValue(array.getByte(i), Byte.class);
                    target.add((long)i, (BRefType)value);
                    ++i;
                }
            } else if (elementType == BTypes.typeFloat) {
                int i = 0;
                while ((long)i < size) {
                    BValue value = serializer.toBValue(array.getFloat(i), Double.class);
                    target.add((long)i, (BRefType)value);
                    ++i;
                }
            } else if (elementType == BTypes.typeString) {
                int i = 0;
                while ((long)i < size) {
                    BValue value = serializer.toBValue(array.getString(i), String.class);
                    target.add((long)i, (BRefType)value);
                    ++i;
                }
            } else {
                this.serializeRefObjArray(array, serializer, size, target);
            }
        } else if (array.getType().getTag() == 30) {
            this.serializeRefObjArray(array, serializer, size, target);
        }
        return BPacket.from(this.typeName(), target).put(TYPE, elemType);
    }

    private void serializeRefObjArray(BValueArray array, BValueSerializer serializer, long size, BValueArray target) {
        int i = 0;
        while ((long)i < size) {
            BValue value = serializer.toBValue(array.getRefValue(i), null);
            target.add((long)i, (BRefType)value);
            ++i;
        }
    }

    @Override
    public BValueArray toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BValueArray array = (BValueArray)packet.getValue();
        BType type = (BType)bValueDeserializer.deserialize(packet.get(TYPE), BType.class);
        int size = (int)array.size();
        BValueArray target = null;
        if (type.getTag() == 19) {
            int i;
            Object[] arr;
            if ((type = ((BArrayType)type).getElementType()).getTag() == 1) {
                arr = new long[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = (Long)bValueDeserializer.deserialize(array.getBValue(i), Long.class);
                }
                target = new BValueArray((long[])arr);
            } else if (type.getTag() == 6) {
                arr = new int[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = ((Integer)bValueDeserializer.deserialize(array.getBValue(i), Integer.class)).intValue();
                }
                target = new BValueArray((int[])arr);
            } else if (type.getTag() == 2) {
                arr = new byte[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = ((Byte)bValueDeserializer.deserialize(array.getBValue(i), BType.class)).byteValue();
                }
                target = new BValueArray((byte[])arr);
            } else if (type.getTag() == 3) {
                arr = new double[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = (long)((Double)bValueDeserializer.deserialize(array.getBValue(i), Double.class)).doubleValue();
                }
                target = new BValueArray((double[])arr);
            } else if (type.getTag() == 5) {
                arr = new String[size];
                for (i = 0; i < size; ++i) {
                    arr[i] = (long)((String)bValueDeserializer.deserialize(array.getBValue(i), String.class));
                }
                target = new BValueArray((String[])arr);
            }
        }
        if (target == null) {
            target = type.getTag() == 30 ? new BValueArray(type) : new BValueArray(new BArrayType(type));
            int i = 0;
            while ((long)i < array.size()) {
                target.add((long)i, (BRefType)bValueDeserializer.deserialize(array.getRefValue(i), null));
                ++i;
            }
        }
        return target;
    }
}

