/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.values;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.util.XMLNodeType;
import org.ballerinalang.core.model.values.BBoolean;
import org.ballerinalang.core.model.values.BIterator;
import org.ballerinalang.core.model.values.BMap;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BString;
import org.ballerinalang.core.model.values.BValue;
import org.ballerinalang.core.model.values.BValueArray;
import org.ballerinalang.core.model.values.BXML;
import org.ballerinalang.core.model.values.BXMLCodePointIterator;
import org.ballerinalang.core.model.values.BXMLItem;
import org.ballerinalang.core.util.BLangConstants;
import org.ballerinalang.core.util.exceptions.BallerinaException;

public final class BXMLSequence
extends BXML<BValueArray> {
    private BValueArray sequence;

    public BXMLSequence() {
        this.sequence = new BValueArray();
    }

    public BXMLSequence(BValueArray sequence) {
        this.sequence = sequence;
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.SEQUENCE;
    }

    @Override
    public BBoolean isEmpty() {
        return new BBoolean(this.sequence.size() == 0L);
    }

    @Override
    public BBoolean isSingleton() {
        return new BBoolean(this.sequence.size() == 1L);
    }

    @Override
    public BString getItemType() {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.getRefValue(0L)).getItemType();
        }
        return new BString(XMLNodeType.SEQUENCE.value());
    }

    @Override
    public BString getElementName() {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.getRefValue(0L)).getElementName();
        }
        return (BString)BTypes.typeString.getZeroValue();
    }

    @Override
    public BString getTextValue() {
        StringBuilder seqTextBuilder = new StringBuilder();
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem item = (BXMLItem)this.sequence.getRefValue(i);
            String strVal = item.getTextValue().stringValue();
            if (strVal != null) {
                seqTextBuilder.append(strVal);
            }
            ++i;
        }
        return new BString(seqTextBuilder.toString());
    }

    @Override
    public String getAttribute(String localName, String namespace) {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.getRefValue(0L)).getAttribute(localName, namespace);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.getRefValue(0L)).getAttribute(localName, namespace, prefix);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public void setAttribute(String localName, String namespace, String prefix, String value) {
        if (this.sequence.size() == 1L) {
            ((BXMLItem)this.sequence.getRefValue(0L)).setAttribute(localName, namespace, prefix, value);
        }
    }

    @Override
    public BMap<?, ?> getAttributesMap() {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.getRefValue(0L)).getAttributesMap();
        }
        return null;
    }

    @Override
    public void setAttributes(BMap<String, ?> attributes) {
        if (this.sequence.size() == 1L) {
            ((BXMLItem)this.sequence.getRefValue(0L)).setAttributes(attributes);
        }
    }

    @Override
    public BXML<?> elements() {
        BValueArray elementsSeq = new BValueArray(BTypes.typeXML);
        int j = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem item = (BXMLItem)this.sequence.getRefValue(i);
            if (item.getNodeType() == XMLNodeType.ELEMENT) {
                elementsSeq.add((long)j++, item);
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> elements(String qname) {
        BValueArray elementsSeq = new BValueArray(BTypes.typeXML);
        String qnameStr = this.getQname(qname).toString();
        int j = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem item = (BXMLItem)this.sequence.getRefValue(i);
            if (item.getNodeType() == XMLNodeType.ELEMENT && item.getElementName().stringValue().equals(qnameStr)) {
                elementsSeq.add((long)j++, item);
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> children() {
        BValueArray elementsSeq = new BValueArray(BTypes.typeXML);
        int index = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.getRefValue(i);
            if (element.getNodeType() == XMLNodeType.ELEMENT) {
                Iterator childrenItr = ((OMElement)element.value()).getChildren();
                while (childrenItr.hasNext()) {
                    elementsSeq.add((long)index++, new BXMLItem((OMNode)childrenItr.next()));
                }
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> children(String qname) {
        BValueArray elementsSeq = new BValueArray();
        QName name = this.getQname(qname);
        int index = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.getRefValue(i);
            if (element.getNodeType() == XMLNodeType.ELEMENT) {
                Iterator childrenItr = ((OMElement)element.value()).getChildrenWithName(name);
                while (childrenItr.hasNext()) {
                    OMNode child = (OMNode)childrenItr.next();
                    elementsSeq.add((long)index++, new BXMLItem(child));
                }
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public void setChildren(BXML<?> seq) {
        if (this.sequence.size() != 1L) {
            throw new BallerinaException("not an " + XMLNodeType.ELEMENT);
        }
        ((BXMLItem)this.sequence.getRefValue(0L)).setChildren(seq);
    }

    @Override
    public void addChildren(BXML<?> seq) {
        if (this.sequence.size() != 1L) {
            throw new BallerinaException("not an " + XMLNodeType.ELEMENT);
        }
        ((BXMLItem)this.sequence.getRefValue(0L)).addChildren(seq);
    }

    @Override
    public BXML<?> strip() {
        BValueArray elementsSeq = new BValueArray();
        int j = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.getRefValue(i);
            if (!(element.value() == null || element.getNodeType() == XMLNodeType.TEXT && ((OMText)element.value()).getText().trim().isEmpty())) {
                elementsSeq.add((long)j++, element);
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> slice(long startIndex, long endIndex) {
        if (startIndex > this.sequence.size() || endIndex > this.sequence.size() || startIndex < -1L || endIndex < -1L) {
            throw new BallerinaException("index out of range: [" + startIndex + "," + endIndex + "]");
        }
        if (startIndex == -1L) {
            startIndex = 0L;
        }
        if (endIndex == -1L) {
            endIndex = this.sequence.size();
        }
        if (startIndex == endIndex) {
            return new BXMLSequence();
        }
        if (startIndex > endIndex) {
            throw new BallerinaException("invalid indices: " + startIndex + " < " + endIndex);
        }
        int j = 0;
        BValueArray elementsSeq = new BValueArray();
        for (long i = startIndex; i < endIndex; ++i) {
            elementsSeq.add((long)j++, this.sequence.getRefValue(i));
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> descendants(String qname) {
        ArrayList descendants = new ArrayList();
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.getRefValue(i);
            if (element.getNodeType() == XMLNodeType.ELEMENT) {
                this.addDescendants(descendants, (OMElement)element.value(), this.getQname(qname).toString());
            }
            ++i;
        }
        return new BXMLSequence(new BValueArray(descendants.toArray(new BXML[descendants.size()]), BTypes.typeXML));
    }

    @Override
    public void serialize(OutputStream outputStream) {
        int i = 0;
        while ((long)i < this.sequence.size()) {
            ((BXML)this.sequence.getRefValue(i)).serialize(outputStream);
            ++i;
        }
    }

    @Override
    public BValueArray value() {
        return this.sequence;
    }

    @Override
    public String stringValue() {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while ((long)i < this.sequence.size()) {
                sb.append(this.sequence.getRefValue(i).stringValue());
                ++i;
            }
            return sb.toString();
        }
        catch (Throwable t) {
            BXMLSequence.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public BXMLSequence copy(Map<BValue, BValue> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return (BXMLSequence)refs.get(this);
        }
        BRefType[] copiedVals = new BRefType[(int)this.sequence.size()];
        refs.put(this, new BXMLSequence(new BValueArray(copiedVals, BTypes.typeXML)));
        int i = 0;
        while ((long)i < this.sequence.size()) {
            copiedVals[i] = ((BXML)this.sequence.getRefValue(i)).copy((Map)refs);
            ++i;
        }
        return (BXMLSequence)refs.get(this);
    }

    @Override
    public BXML<?> getItem(long index) {
        return (BXML)this.sequence.getRefValue(index);
    }

    @Override
    public long size() {
        int size = 0;
        for (int i = 0; i < this.sequence.size; ++i) {
            BRefType<?> refValue = this.sequence.getRefValue(i);
            if (refValue.getType().getTag() == 8) {
                BXML xmlItem = (BXML)refValue;
                size = (int)((long)size + xmlItem.size());
                continue;
            }
            ++size;
        }
        return size;
    }

    @Override
    public void build() {
        int i = 0;
        while ((long)i < this.sequence.size()) {
            ((BXML)this.sequence.getRefValue(i)).build();
            ++i;
        }
    }

    @Override
    public void removeAttribute(String qname) {
        if (this.sequence.size() != 1L) {
            throw new BallerinaException("not an " + XMLNodeType.ELEMENT);
        }
        ((BXMLItem)this.sequence.getRefValue(0L)).removeAttribute(qname);
    }

    @Override
    public BIterator newIterator() {
        return new BXMLSequenceIterator(this);
    }

    @Override
    public void removeChildren(String qname) {
        if (this.sequence.size() != 1L) {
            throw new BallerinaException("not an " + XMLNodeType.ELEMENT);
        }
        ((BXMLItem)this.sequence.getRefValue(0L)).removeChildren(qname);
    }

    static enum IterMode {
        SEQUENCE,
        CODE_POINT;

    }

    static class BXMLSequenceIterator
    implements BIterator {
        BXMLSequence value;
        int cursor = 0;
        IterMode iterMode = IterMode.SEQUENCE;
        BXMLCodePointIterator codePointIterator;

        BXMLSequenceIterator(BXMLSequence bxmlSequence) {
            this.value = bxmlSequence;
        }

        @Override
        public BValue getNext() {
            BRefType<?> curVal;
            if (this.iterMode == IterMode.CODE_POINT) {
                if (this.codePointIterator.hasNext()) {
                    return this.codePointIterator.getNext();
                }
                this.iterMode = IterMode.SEQUENCE;
                this.codePointIterator = null;
            }
            if ((curVal = this.value.sequence.getRefValue(this.cursor++)).getType().getTag() == 8 && ((BXMLItem)curVal).getNodeType() == XMLNodeType.TEXT) {
                this.iterMode = IterMode.CODE_POINT;
                this.codePointIterator = BXMLCodePointIterator.from(curVal.stringValue());
                return this.codePointIterator.getNext();
            }
            return curVal;
        }

        @Override
        public boolean hasNext() {
            boolean hasMoreXmlItems;
            boolean bl = hasMoreXmlItems = (long)this.cursor < this.value.sequence.size();
            return this.iterMode == IterMode.SEQUENCE ? hasMoreXmlItems : this.codePointIterator.hasNext() || hasMoreXmlItems;
        }
    }
}

