/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import bsh.EvalError;
import bsh.Interpreter;
import java.lang.reflect.Method;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.Maps;
import org.testng.internal.IBsh;
import org.testng.internal.Utils;

public class Bsh
implements IBsh {
    private static Interpreter s_interpreter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean includeMethodFromExpression(String string, ITestNGMethod iTestNGMethod) {
        boolean bl = false;
        Interpreter interpreter = Bsh.getInterpreter();
        try {
            Map<String, String> map = Maps.newHashMap();
            for (String string2 : iTestNGMethod.getGroups()) {
                map.put(string2, string2);
            }
            this.setContext(interpreter, iTestNGMethod.getConstructorOrMethod().getMethod(), map, iTestNGMethod);
            Object object = interpreter.eval(string);
            if (object == null) {
                String string3 = String.format("The beanshell expression [%s] evaluated to null.", string);
                throw new TestNGException(string3);
            }
            bl = (Boolean)object;
        }
        catch (EvalError evalError) {
            Utils.log("bsh.Interpreter", 2, "Cannot evaluate expression:" + string + ":" + evalError.getMessage());
        }
        finally {
            this.resetContext(interpreter);
        }
        return bl;
    }

    private static Interpreter getInterpreter() {
        if (null == s_interpreter) {
            s_interpreter = new Interpreter();
        }
        return s_interpreter;
    }

    private void setContext(Interpreter interpreter, Method method, Map<String, String> map, ITestNGMethod iTestNGMethod) {
        try {
            interpreter.set("method", method);
            interpreter.set("groups", map);
            interpreter.set("testngMethod", iTestNGMethod);
        }
        catch (EvalError evalError) {
            throw new TestNGException("Cannot set BSH interpreter", evalError);
        }
    }

    private void resetContext(Interpreter interpreter) {
        try {
            interpreter.unset("method");
            interpreter.unset("groups");
            interpreter.unset("testngMethod");
        }
        catch (EvalError evalError) {
            Utils.log("bsh.Interpreter", 2, "Cannot reset interpreter:" + evalError.getMessage());
        }
    }
}

