/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class DependencyTree {
    private static final CompilerContext.Key<DependencyTree> DEPENDENCY_TREE_KEY = new CompilerContext.Key();
    private PrintStream outStream = System.out;

    private DependencyTree(CompilerContext context) {
        context.put(DEPENDENCY_TREE_KEY, this);
    }

    public static DependencyTree getInstance(CompilerContext context) {
        DependencyTree binaryFileWriter = context.get(DEPENDENCY_TREE_KEY);
        if (binaryFileWriter == null) {
            binaryFileWriter = new DependencyTree(context);
        }
        return binaryFileWriter;
    }

    private static String renderDependencyTree(BPackageSymbol packageSymbol, int depth) {
        List<StringBuilder> lines = DependencyTree.renderDependencyTreeLines(packageSymbol, depth);
        StringBuilder sb = new StringBuilder(lines.size() * 20);
        for (StringBuilder line : lines) {
            sb.append((CharSequence)line);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static List<StringBuilder> renderDependencyTreeLines(BPackageSymbol packageNode, int depth) {
        LinkedList<StringBuilder> result = new LinkedList<StringBuilder>();
        if (depth > 0) {
            result.add(new StringBuilder().append(packageNode.pkgID.toString()));
        }
        Iterator<BPackageSymbol> iterator = packageNode.imports.iterator();
        while (iterator.hasNext()) {
            List<StringBuilder> subtree = DependencyTree.renderDependencyTreeLines(iterator.next(), 1);
            if (iterator.hasNext()) {
                DependencyTree.addSubtree(result, subtree);
                continue;
            }
            DependencyTree.addLastSubtree(result, subtree);
        }
        return result;
    }

    private static void addSubtree(List<StringBuilder> result, List<StringBuilder> subtree) {
        Iterator<StringBuilder> iterator = subtree.iterator();
        result.add(iterator.next().insert(0, "\u251c\u2500\u2500 "));
        while (iterator.hasNext()) {
            result.add(iterator.next().insert(0, "\u2502   "));
        }
    }

    private static void addLastSubtree(List<StringBuilder> result, List<StringBuilder> subtree) {
        Iterator<StringBuilder> iterator = subtree.iterator();
        result.add(iterator.next().insert(0, "\u2514\u2500\u2500 "));
        while (iterator.hasNext()) {
            result.add(iterator.next().insert(0, "    "));
        }
    }

    void listDependencyPackages(BLangPackage packageNode) {
        String pkgIdAsStr = packageNode.symbol.pkgID.toString();
        if (packageNode.symbol.pkgID.isUnnamed) {
            pkgIdAsStr = packageNode.symbol.pkgID.sourceFileName.value;
        }
        this.outStream.println(pkgIdAsStr);
        this.outStream.println(DependencyTree.renderDependencyTree(packageNode.symbol, 0));
    }
}

