/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.internal.IdentifierUtils;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;

public class JvmDesugarPhase {
    public static void addDefaultableBooleanVarsToSignature(BIRNode.BIRFunction func, BType booleanType) {
        BInvokableType type = func.type = new BInvokableType(func.type.paramTypes, func.type.restType, func.type.retType, func.type.tsymbol);
        func.type.paramTypes = JvmDesugarPhase.updateParamTypesWithDefaultableBooleanVar(func.type.paramTypes, type.restType, booleanType);
        int index = 0;
        ArrayList<BIRNode.BIRVariableDcl> updatedVars = new ArrayList<BIRNode.BIRVariableDcl>();
        List<BIRNode.BIRVariableDcl> localVars = func.localVars;
        int nameIndex = 0;
        for (BIRNode.BIRVariableDcl localVar : localVars) {
            updatedVars.add(index, localVar);
            ++index;
            if (!(localVar instanceof BIRNode.BIRFunctionParameter)) continue;
            String argName = "%syn" + nameIndex;
            ++nameIndex;
            BIRNode.BIRFunctionParameter booleanVar = new BIRNode.BIRFunctionParameter(null, booleanType, new Name(argName), VarScope.FUNCTION, VarKind.ARG, "", false);
            updatedVars.add(index, booleanVar);
            ++index;
        }
        func.localVars = updatedVars;
    }

    public static void enrichWithDefaultableParamInits(BIRNode.BIRFunction currentFunc, InitMethodGen initMethodGen) {
        ArrayList<BIRNode.BIRFunctionParameter> functionParams = new ArrayList<BIRNode.BIRFunctionParameter>();
        List<BIRNode.BIRVariableDcl> localVars = currentFunc.localVars;
        for (int k = 1; k < localVars.size(); ++k) {
            BIRNode.BIRVariableDcl localVar = localVars.get(k);
            if (!(localVar instanceof BIRNode.BIRFunctionParameter)) continue;
            functionParams.add((BIRNode.BIRFunctionParameter)localVar);
        }
        initMethodGen.resetIds();
        ArrayList<BIRNode.BIRBasicBlock> basicBlocks = new ArrayList<BIRNode.BIRBasicBlock>();
        BIRNode.BIRBasicBlock nextBB = JvmDesugarPhase.insertAndGetNextBasicBlock(basicBlocks, "desugaredBB", initMethodGen);
        Location pos = currentFunc.pos;
        for (int paramCounter = 0; paramCounter < functionParams.size(); paramCounter += 2) {
            BIRNode.BIRFunctionParameter funcParam = (BIRNode.BIRFunctionParameter)functionParams.get(paramCounter);
            if (funcParam == null || !funcParam.hasDefaultExpr) continue;
            int boolParam = paramCounter + 1;
            BIRNode.BIRFunctionParameter funcBooleanParam = JvmDesugarPhase.getFunctionParam((BIRNode.BIRFunctionParameter)functionParams.get(boolParam));
            BIROperand boolRef = new BIROperand(funcBooleanParam);
            BIRNonTerminator.UnaryOP notOp = new BIRNonTerminator.UnaryOP(pos, InstructionKind.NOT, boolRef, boolRef);
            nextBB.instructions.add(notOp);
            List<BIRNode.BIRBasicBlock> bbArray = currentFunc.parameters.get(funcParam);
            BIRNode.BIRBasicBlock trueBB = bbArray.get(0);
            basicBlocks.addAll(bbArray);
            BIRNode.BIRBasicBlock falseBB = JvmDesugarPhase.insertAndGetNextBasicBlock(basicBlocks, "desugaredBB", initMethodGen);
            nextBB.terminator = new BIRTerminator.Branch(pos, boolRef, trueBB, falseBB);
            BIRNode.BIRBasicBlock lastBB = bbArray.get(bbArray.size() - 1);
            lastBB.terminator = new BIRTerminator.GOTO(pos, falseBB);
            nextBB = falseBB;
        }
        if (basicBlocks.size() == 1) {
            return;
        }
        if (currentFunc.basicBlocks.size() == 0) {
            currentFunc.basicBlocks = basicBlocks;
            return;
        }
        BIRNode.BIRBasicBlock firstBB = currentFunc.basicBlocks.get(0);
        nextBB.terminator = new BIRTerminator.GOTO(pos, firstBB);
        basicBlocks.addAll(currentFunc.basicBlocks);
        currentFunc.basicBlocks = basicBlocks;
    }

    public static BIRNode.BIRBasicBlock insertAndGetNextBasicBlock(List<BIRNode.BIRBasicBlock> basicBlocks, String prefix, InitMethodGen initMethodGen) {
        BIRNode.BIRBasicBlock nextbb = new BIRNode.BIRBasicBlock(JvmDesugarPhase.getNextDesugarBBId(prefix, initMethodGen));
        basicBlocks.add(nextbb);
        return nextbb;
    }

    public static Name getNextDesugarBBId(String prefix, InitMethodGen initMethodGen) {
        int nextId = initMethodGen.incrementAndGetNextId();
        return new Name(prefix + nextId);
    }

    private static List<BType> updateParamTypesWithDefaultableBooleanVar(List<BType> funcParams, BType restType, BType booleanType) {
        int size;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        int index = 0;
        int n = size = funcParams == null ? 0 : funcParams.size();
        for (int counter = 0; counter < size; ++counter) {
            paramTypes.add(index, funcParams.get(counter));
            paramTypes.add(index + 1, booleanType);
            index += 2;
        }
        if (restType != null) {
            paramTypes.add(index, restType);
            paramTypes.add(index + 1, booleanType);
        }
        return paramTypes;
    }

    static void rewriteRecordInits(List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition typeDef : typeDefs) {
            BType recordType = typeDef.type;
            if (recordType.tag != 12) continue;
            List<BIRNode.BIRFunction> attachFuncs = typeDef.attachedFuncs;
            for (BIRNode.BIRFunction func : attachFuncs) {
                JvmDesugarPhase.rewriteRecordInitFunction(func, (BRecordType)recordType);
            }
        }
    }

    private static void rewriteRecordInitFunction(BIRNode.BIRFunction func, BRecordType recordType) {
        BIRNode.BIRVariableDcl receiver = func.receiver;
        func.name = new Name(JvmCodeGenUtil.toNameString(recordType) + func.name.value);
        receiver.kind = VarKind.ARG;
        String paramName = "$_" + receiver.name.value;
        receiver.name = new Name(paramName);
        BIRNode.BIRFunctionParameter selfParam = new BIRNode.BIRFunctionParameter(null, receiver.type, receiver.name, receiver.scope, VarKind.ARG, paramName, false);
        List<BType> updatedParamTypes = Lists.of(receiver.type);
        updatedParamTypes.addAll(func.type.paramTypes);
        func.type = new BInvokableType(updatedParamTypes, func.type.restType, func.type.retType, null);
        List<BIRNode.BIRVariableDcl> localVars = func.localVars;
        ArrayList<BIRNode.BIRVariableDcl> updatedLocalVars = new ArrayList<BIRNode.BIRVariableDcl>();
        updatedLocalVars.add(localVars.get(0));
        updatedLocalVars.add(selfParam);
        for (int index = 1; index < localVars.size(); ++index) {
            updatedLocalVars.add(localVars.get(index));
        }
        func.localVars = updatedLocalVars;
    }

    private static BIRNode.BIRFunctionParameter getFunctionParam(BIRNode.BIRFunctionParameter localVar) {
        if (localVar == null) {
            throw new BLangCompilerException("Invalid function parameter");
        }
        return localVar;
    }

    private JvmDesugarPhase() {
    }

    static void encodeModuleIdentifiers(BIRNode.BIRPackage module, Names names) {
        JvmDesugarPhase.encodePackageIdentifiers(module, names);
        JvmDesugarPhase.encodeGlobalVariableIdentifiers(module.globalVars, names);
        JvmDesugarPhase.encodeFunctionIdentifiers(module.functions, names);
        JvmDesugarPhase.encodeTypeDefIdentifiers(module.typeDefs, names);
    }

    private static void encodePackageIdentifiers(BIRNode.BIRPackage module, Names names) {
        module.org = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(module.org.value));
        module.name = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(module.name.value));
    }

    private static void encodeTypeDefIdentifiers(List<BIRNode.BIRTypeDefinition> typeDefs, Names names) {
        for (BIRNode.BIRTypeDefinition typeDefinition : typeDefs) {
            typeDefinition.type.tsymbol.name = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(typeDefinition.type.tsymbol.name.value));
            typeDefinition.name = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(typeDefinition.name.value));
            JvmDesugarPhase.encodeFunctionIdentifiers(typeDefinition.attachedFuncs, names);
            BType bType = typeDefinition.type;
            if (bType.tag == 33) {
                BObjectType objectType = (BObjectType)bType;
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bType.tsymbol;
                if (objectTypeSymbol.attachedFuncs != null) {
                    JvmDesugarPhase.encodeAttachedFunctionIdentifiers(objectTypeSymbol.attachedFuncs, names);
                }
                for (BField field : objectType.fields.values()) {
                    field.name = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(field.name.value));
                }
            }
            if (bType.tag != 12) continue;
            BRecordType recordType = (BRecordType)bType;
            for (BField field : recordType.fields.values()) {
                field.name = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(field.name.value));
            }
        }
    }

    private static void encodeFunctionIdentifiers(List<BIRNode.BIRFunction> functions, Names names) {
        for (BIRNode.BIRFunction function : functions) {
            function.name = names.fromString(IdentifierUtils.encodeFunctionIdentifier(function.name.value));
            for (BIRNode.BIRVariableDcl localVar : function.localVars) {
                if (localVar.metaVarName == null) continue;
                localVar.metaVarName = IdentifierUtils.encodeNonFunctionIdentifier(localVar.metaVarName);
            }
            for (BIRNode.BIRParameter parameter : function.requiredParams) {
                if (parameter.name == null) continue;
                parameter.name = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(parameter.name.value));
            }
            JvmDesugarPhase.encodeWorkerName(function, names);
        }
    }

    private static void encodeWorkerName(BIRNode.BIRFunction function, Names names) {
        if (function.workerName != null) {
            function.workerName = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(function.workerName.value));
        }
    }

    private static void encodeAttachedFunctionIdentifiers(List<BAttachedFunction> functions, Names names) {
        for (BAttachedFunction function : functions) {
            function.funcName = names.fromString(IdentifierUtils.encodeFunctionIdentifier(function.funcName.value));
        }
    }

    private static void encodeGlobalVariableIdentifiers(List<BIRNode.BIRGlobalVariableDcl> globalVars, Names names) {
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            if (globalVar == null) continue;
            globalVar.name = names.fromString(IdentifierUtils.encodeNonFunctionIdentifier(globalVar.name.value));
        }
    }
}

