/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.internal.IdentifierUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.FieldNameHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.NameHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.OldStyleExternalFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.LambdaGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;
import org.wso2.ballerinalang.compiler.util.Names;

class JvmValueGen {
    static final FieldNameHashComparator FIELD_NAME_HASH_COMPARATOR = new FieldNameHashComparator();
    static final NameHashComparator NAME_HASH_COMPARATOR = new NameHashComparator();
    static final String ENCODED_RECORD_INIT = IdentifierUtils.encodeFunctionIdentifier(Names.INIT_FUNCTION_SUFFIX.value);
    private final BIRNode.BIRPackage module;
    private final JvmPackageGen jvmPackageGen;
    private final MethodGen methodGen;
    private final LambdaGen lambdaGen;
    private final BType booleanType;

    JvmValueGen(BIRNode.BIRPackage module, JvmPackageGen jvmPackageGen, MethodGen methodGen, LambdaGen lambdaGen) {
        this.module = module;
        this.jvmPackageGen = jvmPackageGen;
        this.methodGen = methodGen;
        this.lambdaGen = lambdaGen;
        this.booleanType = jvmPackageGen.symbolTable.booleanType;
    }

    private static BIRNode.BIRFunction getFunction(BIRNode.BIRFunction func) {
        if (func == null) {
            throw new BLangCompilerException("Invalid function");
        }
        return func;
    }

    static void injectDefaultParamInitsToAttachedFuncs(BIRNode.BIRPackage module, InitMethodGen initMethodGen, JvmPackageGen jvmPackageGen) {
        List<BIRNode.BIRTypeDefinition> typeDefs = module.typeDefs;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BType bType = optionalTypeDef.type;
            if (!(bType instanceof BServiceType) && (bType.tag != 33 || !Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) && bType.tag != 12) continue;
            JvmValueGen.desugarObjectMethods(module, bType, optionalTypeDef.attachedFuncs, initMethodGen, jvmPackageGen);
        }
    }

    private static void desugarObjectMethods(BIRNode.BIRPackage module, BType bType, List<BIRNode.BIRFunction> attachedFuncs, InitMethodGen initMethodGen, JvmPackageGen jvmPackageGen) {
        if (attachedFuncs == null) {
            return;
        }
        for (BIRNode.BIRFunction birFunc : attachedFuncs) {
            if (birFunc == null) continue;
            if (JvmCodeGenUtil.isExternFunc(birFunc)) {
                BIRFunctionWrapper extFuncWrapper = ExternalMethodGen.lookupBIRFunctionWrapper(module, birFunc, bType, jvmPackageGen);
                if (extFuncWrapper instanceof OldStyleExternalFunctionWrapper) {
                    ExternalMethodGen.desugarOldExternFuncs((OldStyleExternalFunctionWrapper)extFuncWrapper, birFunc, initMethodGen);
                } else if (extFuncWrapper instanceof JMethodFunctionWrapper) {
                    InteropMethodGen.desugarInteropFuncs((JMethodFunctionWrapper)extFuncWrapper, birFunc, initMethodGen);
                    JvmDesugarPhase.enrichWithDefaultableParamInits(birFunc, initMethodGen);
                } else if (!(extFuncWrapper instanceof JFieldFunctionWrapper)) {
                    JvmDesugarPhase.enrichWithDefaultableParamInits(birFunc, initMethodGen);
                }
            } else {
                JvmDesugarPhase.addDefaultableBooleanVarsToSignature(birFunc, jvmPackageGen.symbolTable.booleanType);
            }
            JvmDesugarPhase.enrichWithDefaultableParamInits(birFunc, initMethodGen);
        }
    }

    static List<Label> createDecodedLabelsForSwitch(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, Label defaultCaseLabel) {
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
        int i = 0;
        ArrayList<Label> labels = new ArrayList<Label>();
        int[] hashCodes = new int[nodes.size()];
        for (NamedNode namedNode : nodes) {
            if (namedNode == null) continue;
            labels.add(i, new Label());
            String name = IdentifierUtils.decodeIdentifier(namedNode.getName().value);
            hashCodes[i] = name.hashCode();
            ++i;
        }
        mv.visitLookupSwitchInsn(defaultCaseLabel, hashCodes, labels.toArray(new Label[0]));
        return labels;
    }

    static void createDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/util/exceptions/BLangRuntimeException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn("No such field or method: ");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", String.format("(L%s;)L%s;", "java/lang/String", "java/lang/StringBuilder"), false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", String.format("()L%s;", "java/lang/String"), false);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/util/exceptions/BLangRuntimeException", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
        mv.visitInsn(191);
    }

    static String getTypeDescClassName(Object module, String typeName) {
        String packageName = JvmValueGen.calculateJavaPkgName(module);
        return packageName + "$typedesc$" + typeName;
    }

    static String getTypeValueClassName(Object module, String typeName) {
        String packageName = JvmValueGen.calculateJavaPkgName(module);
        return packageName + "$value$" + typeName;
    }

    private static String calculateJavaPkgName(Object module) {
        String packageName;
        if (module instanceof BIRNode.BIRPackage) {
            BIRNode.BIRPackage birPackage = (BIRNode.BIRPackage)module;
            packageName = JvmCodeGenUtil.getPackageName(birPackage);
        } else if (module instanceof PackageID) {
            PackageID packageID = (PackageID)module;
            packageName = JvmCodeGenUtil.getPackageName(packageID);
        } else {
            throw new ClassCastException("module should be PackageID or BIRPackage but is : " + (Serializable)(module == null ? "null" : module.getClass()));
        }
        return packageName;
    }

    static List<Label> createDecodedLabelsForEqualCheck(MethodVisitor mv, int nameRegIndex, List<? extends NamedNode> nodes, List<Label> labels, Label defaultCaseLabel) {
        ArrayList<Label> targetLabels = new ArrayList<Label>();
        int i = 0;
        for (NamedNode namedNode : nodes) {
            if (namedNode == null) continue;
            mv.visitLabel(labels.get(i));
            mv.visitVarInsn(25, nameRegIndex);
            mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(namedNode.getName().value));
            mv.visitMethodInsn(182, "java/lang/String", "equals", String.format("(L%s;)Z", "java/lang/Object"), false);
            Label targetLabel = new Label();
            mv.visitJumpInsn(154, targetLabel);
            mv.visitJumpInsn(167, defaultCaseLabel);
            targetLabels.add(i, targetLabel);
            ++i;
        }
        return targetLabels;
    }

    private void createLambdas(ClassWriter cw, AsyncDataCollector asyncDataCollector) {
        for (Map.Entry<String, BIRInstruction> entry : asyncDataCollector.getLambdas().entrySet()) {
            this.lambdaGen.generateLambdaMethod(entry.getValue(), cw, entry.getKey());
        }
    }

    private void createObjectFields(ClassWriter cw, Map<String, BField> fields) {
        for (BField field : fields.values()) {
            if (field == null) continue;
            FieldVisitor fvb = cw.visitField(0, field.name.value, JvmTypeGen.getTypeDesc(field.type), null, null);
            fvb.visitEnd();
            String lockClass = "Lio/ballerina/runtime/internal/BLock;";
            FieldVisitor fv = cw.visitField(17, JvmPackageGen.computeLockNameFromString(field.name.value), lockClass, null, null);
            fv.visitEnd();
        }
    }

    private void createObjectMethods(ClassWriter cw, List<BIRNode.BIRFunction> attachedFuncs, String moduleClassName, BObjectType currentObjectType, AsyncDataCollector asyncDataCollector) {
        for (BIRNode.BIRFunction func : attachedFuncs) {
            if (func == null) continue;
            this.methodGen.generateMethod(func, cw, this.module, currentObjectType, moduleClassName, asyncDataCollector);
        }
    }

    private void createObjectInit(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", String.format("(L%s;)V", "io/ballerina/runtime/internal/types/BObjectType"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/AbstractObjectValue", "<init>", String.format("(L%s;)V", "io/ballerina/runtime/internal/types/BObjectType"), false);
        String lockClass = "Lio/ballerina/runtime/internal/BLock;";
        for (BField field : fields.values()) {
            if (field == null) continue;
            Label fLabel = new Label();
            mv.visitLabel(fLabel);
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/BLock");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/BLock", "<init>", "()V", false);
            mv.visitFieldInsn(181, className, JvmPackageGen.computeLockNameFromString(field.name.value), lockClass);
        }
        mv.visitInsn(177);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
    }

    private void createCallMethod(ClassWriter cw, List<BIRNode.BIRFunction> functions, String objClassName) {
        MethodVisitor mv = cw.visitMethod(1, "call", String.format("(L%s;L%s;[L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        int funcNameRegIndex = 2;
        Label defaultCaseLabel = new Label();
        functions.sort(NAME_HASH_COMPARATOR);
        List<Label> labels = JvmTypeGen.createLabelsForSwitch(mv, funcNameRegIndex, functions, defaultCaseLabel);
        List<Label> targetLabels = JvmTypeGen.createLabelsForEqualCheck(mv, funcNameRegIndex, functions, labels, defaultCaseLabel);
        int i = 0;
        for (BIRNode.BIRFunction optionalFunc : functions) {
            BIRNode.BIRFunction func = JvmValueGen.getFunction(optionalFunc);
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            List<BType> paramTypes = func.type.paramTypes;
            BType retType = func.type.retType;
            String methodSig = JvmCodeGenUtil.getMethodDesc(paramTypes, retType);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            int j = 0;
            for (BType paramType : paramTypes) {
                mv.visitVarInsn(25, 3);
                mv.visitLdcInsn(j);
                mv.visitInsn(136);
                mv.visitInsn(50);
                JvmCastGen.addUnboxInsn(mv, paramType);
                ++j;
            }
            mv.visitMethodInsn(182, objClassName, func.name.value, methodSig, false);
            if (retType == null || retType.tag == 10 || retType.tag == 49) {
                mv.visitInsn(1);
            } else {
                JvmCastGen.addBoxInsn(mv, retType);
                if (SymbolFlags.isFlagOn(func.flags, 131072L)) {
                    mv.visitMethodInsn(184, "io/ballerina/runtime/internal/ErrorUtils", "handleResourceError", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), false);
                }
            }
            mv.visitInsn(176);
            ++i;
        }
        JvmValueGen.createDefaultCase(mv, defaultCaseLabel, funcNameRegIndex);
        mv.visitMaxs(functions.size() + 10, functions.size() + 10);
        mv.visitEnd();
    }

    private void createObjectGetMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        String signature = String.format("(L%s;)L%s;", "io/ballerina/runtime/api/values/BString", "java/lang/Object");
        MethodVisitor mv = cw.visitMethod(1, "get", signature, null, null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
        fieldNameRegIndex = 2;
        mv.visitVarInsn(58, fieldNameRegIndex);
        Label defaultCaseLabel = new Label();
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Label> labels = JvmValueGen.createDecodedLabelsForSwitch(mv, fieldNameRegIndex, sortedFields, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createDecodedLabelsForEqualCheck(mv, fieldNameRegIndex, sortedFields, labels, defaultCaseLabel);
        int i = 0;
        for (BField optionalField : sortedFields) {
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, optionalField.name.value, JvmTypeGen.getTypeDesc(optionalField.type));
            JvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitInsn(176);
            ++i;
        }
        JvmValueGen.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createObjectSetMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        this.createObjectSetMethod(cw, fields, className, "set", "checkFieldUpdate");
    }

    private void createObjectSetOnInitializationMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        this.createObjectSetMethod(cw, fields, className, "setOnInitialization", "checkFieldUpdateOnInitialization");
    }

    private void createObjectSetMethod(ClassWriter cw, Map<String, BField> fields, String className, String setFuncName, String checkFieldUpdateFuncName) {
        MethodVisitor mv = cw.visitMethod(1, setFuncName, String.format("(L%s;L%s;)V", "io/ballerina/runtime/api/values/BString", "java/lang/Object"), null, null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        int valueRegIndex = 2;
        Label defaultCaseLabel = new Label();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
        mv.visitInsn(89);
        fieldNameRegIndex = 3;
        mv.visitVarInsn(58, fieldNameRegIndex);
        mv.visitVarInsn(25, valueRegIndex);
        mv.visitMethodInsn(182, className, checkFieldUpdateFuncName, String.format("(L%s;L%s;)V", "java/lang/String", "java/lang/Object"), false);
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Label> labels = JvmValueGen.createDecodedLabelsForSwitch(mv, fieldNameRegIndex, sortedFields, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createDecodedLabelsForEqualCheck(mv, fieldNameRegIndex, sortedFields, labels, defaultCaseLabel);
        int i = 0;
        for (BField optionalField : sortedFields) {
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, valueRegIndex);
            JvmCastGen.addUnboxInsn(mv, optionalField.type);
            String filedName = optionalField.name.value;
            mv.visitFieldInsn(181, className, filedName, JvmTypeGen.getTypeDesc(optionalField.type));
            mv.visitInsn(177);
            ++i;
        }
        JvmValueGen.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private byte[] createRecordTypeDescClass(BRecordType recordType, String className, BIRNode.BIRTypeDefinition typeDef) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        if (typeDef.pos != null) {
            cw.visitSource(typeDef.pos.lineRange().filePath(), null);
        } else {
            cw.visitSource(className, null);
        }
        cw.visit(52, 33, className, null, "io/ballerina/runtime/internal/values/TypedescValueImpl", new String[]{"io/ballerina/runtime/internal/values/TypedescValue"});
        this.createTypeDescConstructor(cw);
        this.createInstantiateMethod(cw, recordType, typeDef);
        cw.visitEnd();
        return this.jvmPackageGen.getBytes(cw, typeDef);
    }

    private void createInstantiateMethod(ClassWriter cw, BRecordType recordType, BIRNode.BIRTypeDefinition typeDef) {
        String valueClassName;
        Object initFuncName;
        MethodVisitor mv = cw.visitMethod(1, "instantiate", String.format("(L%s;[L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/api/values/BInitialValueEntry", "java/lang/Object"), null, null);
        mv.visitCode();
        String className = JvmValueGen.getTypeValueClassName(recordType.tsymbol.pkgID, JvmCodeGenUtil.toNameString(recordType));
        mv.visitTypeInsn(187, className);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "io/ballerina/runtime/internal/values/TypedescValue"), false);
        BAttachedFunction initializer = ((BRecordTypeSymbol)recordType.tsymbol).initializerFunc;
        StringBuilder closureParamSignature = this.calcClosureMapSignature(initializer.type.paramTypes.size());
        mv.visitVarInsn(25, 1);
        mv.visitInsn(95);
        for (BType typeRef : typeDef.referencedTypes) {
            if (typeRef.tag != 12) continue;
            String refTypeClassName = JvmValueGen.getTypeValueClassName(typeRef.tsymbol.pkgID, JvmCodeGenUtil.toNameString(typeRef));
            mv.visitInsn(92);
            mv.visitMethodInsn(184, refTypeClassName, "$init", String.format("(L%s;L%s;)V", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/values/MapValue"), false);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/TypedescValueImpl", "closures", String.format("[L%s;", "io/ballerina/runtime/internal/values/MapValue"));
        for (int i = 0; i < initializer.type.paramTypes.size(); ++i) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            mv.visitInsn(50);
            mv.visitInsn(95);
            mv.visitInsn(4);
            mv.visitInsn(95);
        }
        mv.visitInsn(87);
        List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
        if (attachedFuncs.size() != 0) {
            initFuncName = attachedFuncs.get((int)0).name.value;
            valueClassName = className;
        } else {
            valueClassName = JvmValueGen.getTypeValueClassName(recordType.tsymbol.pkgID, JvmCodeGenUtil.toNameString(recordType));
            initFuncName = recordType.name + ENCODED_RECORD_INIT;
        }
        mv.visitMethodInsn(184, valueClassName, (String)initFuncName, String.format("(L%s;L%s;%s)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/values/MapValue", closureParamSignature, "java/lang/Object"), false);
        mv.visitInsn(87);
        mv.visitInsn(89);
        mv.visitTypeInsn(192, valueClassName);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, String.format("[L%s;", "io/ballerina/runtime/api/values/BMapInitialValueEntry"));
        mv.visitMethodInsn(182, valueClassName, "populateInitialValues", String.format("([L%s;)V", "io/ballerina/runtime/api/values/BMapInitialValueEntry"), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private StringBuilder calcClosureMapSignature(int size) {
        StringBuilder closureParamSignature = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            closureParamSignature.append('L');
            closureParamSignature.append("io/ballerina/runtime/internal/values/MapValue");
            closureParamSignature.append(";Z");
        }
        return closureParamSignature;
    }

    private byte[] createRecordValueClass(BRecordType recordType, String className, BIRNode.BIRTypeDefinition typeDef) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        if (typeDef.pos != null) {
            cw.visitSource(typeDef.pos.lineRange().filePath(), null);
        } else {
            cw.visitSource(className, null);
        }
        AsyncDataCollector asyncDataCollector = new AsyncDataCollector(className);
        cw.visit(52, 33, className, String.format("<K:L%s;V:L%s;>L%s<TK;TV;>;L%s<TK;TV;>;", "java/lang/Object", "java/lang/Object", "io/ballerina/runtime/internal/values/MapValueImpl", "io/ballerina/runtime/internal/values/MapValue"), "io/ballerina/runtime/internal/values/MapValueImpl", new String[]{"io/ballerina/runtime/internal/values/MapValue"});
        List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
        if (attachedFuncs != null) {
            this.createRecordMethods(cw, attachedFuncs, className, asyncDataCollector);
        }
        LinkedHashMap fields = recordType.fields;
        this.createRecordFields(cw, fields);
        this.createRecordGetMethod(cw, fields, className);
        this.createRecordSetMethod(cw, fields, className);
        this.createRecordEntrySetMethod(cw, fields, className);
        this.createRecordContainsKeyMethod(cw, fields, className);
        this.createRecordGetValuesMethod(cw, fields, className);
        this.createGetSizeMethod(cw, fields, className);
        this.createRecordClearMethod(cw);
        this.createRecordRemoveMethod(cw, fields, className);
        this.createRecordGetKeysMethod(cw, fields, className);
        this.createRecordPopulateInitialValuesMethod(cw);
        this.createRecordConstructor(cw, "io/ballerina/runtime/internal/values/TypedescValue");
        this.createRecordConstructor(cw, "io/ballerina/runtime/api/types/Type");
        this.createRecordInitWrapper(cw, className, typeDef);
        this.createLambdas(cw, asyncDataCollector);
        JvmCodeGenUtil.visitStrandMetadataField((ClassWriter)cw, asyncDataCollector);
        this.generateStaticInitializer(cw, className, this.module, asyncDataCollector);
        cw.visitEnd();
        return this.jvmPackageGen.getBytes(cw, typeDef);
    }

    private void createRecordMethods(ClassWriter cw, List<BIRNode.BIRFunction> attachedFuncs, String moduleClassName, AsyncDataCollector asyncDataCollector) {
        for (BIRNode.BIRFunction func : attachedFuncs) {
            if (func == null) continue;
            this.methodGen.generateMethod(func, cw, this.module, null, moduleClassName, asyncDataCollector);
        }
    }

    private void createTypeDescConstructor(ClassWriter cw) {
        String descriptor = String.format("(L%s;[L%s;)V", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/internal/values/MapValue");
        MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/TypedescValueImpl", "<init>", descriptor, false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordConstructor(ClassWriter cw, String argumentClass) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", String.format("(L%s;)V", argumentClass), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "<init>", String.format("(L%s;)V", argumentClass), false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateStaticInitializer(ClassWriter cw, String moduleClass, BIRNode.BIRPackage module, AsyncDataCollector asyncDataCollector) {
        if (asyncDataCollector.getStrandMetadata().isEmpty()) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        JvmCodeGenUtil.generateStrandMetadata(mv, moduleClass, module, asyncDataCollector);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordInitWrapper(ClassWriter cw, String className, BIRNode.BIRTypeDefinition typeDef) {
        String valueClassName;
        Object initFuncName;
        MethodVisitor mv = cw.visitMethod(9, "$init", String.format("(L%s;L%s;)V", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/values/MapValue"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        for (BType typeRef : typeDef.referencedTypes) {
            if (typeRef.tag != 12) continue;
            String refTypeClassName = JvmValueGen.getTypeValueClassName(typeRef.tsymbol.pkgID, JvmCodeGenUtil.toNameString(typeRef));
            mv.visitInsn(92);
            mv.visitMethodInsn(184, refTypeClassName, "$init", String.format("(L%s;L%s;)V", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/values/MapValue"), false);
        }
        List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
        if (!attachedFuncs.isEmpty()) {
            initFuncName = attachedFuncs.get((int)0).name.value;
            valueClassName = className;
        } else {
            BRecordType recordType = (BRecordType)typeDef.type;
            valueClassName = JvmValueGen.getTypeValueClassName(recordType.tsymbol.pkgID, JvmCodeGenUtil.toNameString(recordType));
            initFuncName = recordType.name + ENCODED_RECORD_INIT;
        }
        mv.visitMethodInsn(184, valueClassName, (String)initFuncName, String.format("(L%s;L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/values/MapValue", "java/lang/Object"), false);
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordFields(ClassWriter cw, Map<String, BField> fields) {
        for (BField field : fields.values()) {
            if (field == null) continue;
            String fieldName = field.name.value;
            FieldVisitor fv = cw.visitField(0, fieldName, JvmTypeGen.getTypeDesc(field.type), null, null);
            fv.visitEnd();
            if (!this.isOptionalRecordField(field)) continue;
            fv = cw.visitField(0, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType), null, null);
            fv.visitEnd();
        }
    }

    private String getFieldIsPresentFlagName(String fieldName) {
        return String.format("%s$isPresent", fieldName);
    }

    private boolean isOptionalRecordField(BField field) {
        return (field.symbol.flags & 0x1000L) == 4096L;
    }

    private void createRecordGetMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "get", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), String.format("(L%s;)TV;", "java/lang/Object"), null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        int strKeyVarIndex = 2;
        Label defaultCaseLabel = new Label();
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
        mv.visitVarInsn(58, strKeyVarIndex);
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Label> labels = JvmValueGen.createDecodedLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createDecodedLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
        int i = 0;
        for (BField optionalField : sortedFields) {
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            Label ifPresentLabel = new Label();
            String fieldName = optionalField.name.value;
            if (this.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(154, ifPresentLabel);
                mv.visitInsn(1);
                mv.visitInsn(176);
            }
            mv.visitLabel(ifPresentLabel);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            JvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitInsn(176);
            ++i;
        }
        this.createRecordGetDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordSetMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(4, "putValue", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), "(TK;TV;)TV;", null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        int valueRegIndex = 2;
        int strKeyVarIndex = 3;
        Label defaultCaseLabel = new Label();
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
        mv.visitVarInsn(58, strKeyVarIndex);
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Label> labels = JvmValueGen.createDecodedLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createDecodedLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
        int i = 0;
        for (BField optionalField : sortedFields) {
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            String fieldName = optionalField.name.value;
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            JvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, valueRegIndex);
            JvmCastGen.addUnboxInsn(mv, optionalField.type);
            mv.visitFieldInsn(181, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            if (this.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitInsn(4);
                mv.visitFieldInsn(181, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
            }
            mv.visitInsn(176);
            ++i;
        }
        this.createRecordPutDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex, valueRegIndex);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordPutDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex, int valueRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitVarInsn(25, valueRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "putValue", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), false);
        mv.visitInsn(176);
    }

    private void createRecordGetDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "get", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), false);
        mv.visitInsn(176);
    }

    private void createRecordEntrySetMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "entrySet", String.format("()L%s;", "java/util/Set"), String.format("()L%s<L%s<TK;TV;>;>;", "java/util/Set", "java/util/Map$Entry"), null);
        mv.visitCode();
        int entrySetVarIndex = 1;
        mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
        mv.visitVarInsn(58, entrySetVarIndex);
        for (BField optionalField : fields.values()) {
            Label ifNotPresent = new Label();
            String fieldName = optionalField.name.value;
            if (this.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(IdentifierUtils.decodeIdentifier(fieldName)), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(153, ifNotPresent);
            }
            mv.visitVarInsn(25, entrySetVarIndex);
            mv.visitTypeInsn(187, "java/util/AbstractMap$SimpleEntry");
            mv.visitInsn(89);
            mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(fieldName));
            mv.visitMethodInsn(184, "io/ballerina/runtime/api/utils/StringUtils", "fromString", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/api/values/BString"), false);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            JvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitMethodInsn(183, "java/util/AbstractMap$SimpleEntry", "<init>", String.format("(L%s;L%s;)V", "java/lang/Object", "java/lang/Object"), false);
            mv.visitMethodInsn(185, "java/util/Set", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            mv.visitInsn(87);
            mv.visitLabel(ifNotPresent);
        }
        mv.visitVarInsn(25, entrySetVarIndex);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "entrySet", String.format("()L%s;", "java/util/Set"), false);
        mv.visitMethodInsn(185, "java/util/Set", "addAll", String.format("(L%s;)Z", "java/util/Collection"), true);
        mv.visitInsn(87);
        mv.visitVarInsn(25, entrySetVarIndex);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordContainsKeyMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "containsKey", String.format("(L%s;)Z", "java/lang/Object"), null, null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        int strKeyVarIndex = 2;
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
        mv.visitVarInsn(58, strKeyVarIndex);
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        Label defaultCaseLabel = new Label();
        List<Label> labels = JvmValueGen.createDecodedLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createDecodedLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
        int i = 0;
        for (BField optionalField : sortedFields) {
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            String fieldName = optionalField.name.value;
            if (this.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
            } else {
                mv.visitLdcInsn(true);
            }
            mv.visitInsn(172);
            ++i;
        }
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "containsKey", String.format("(L%s;)Z", "java/lang/Object"), false);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordGetValuesMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "values", String.format("()L%s;", "java/util/Collection"), String.format("()L%s<TV;>;", "java/util/Collection"), null);
        mv.visitCode();
        int valuesVarIndex = 1;
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        mv.visitVarInsn(58, valuesVarIndex);
        for (BField optionalField : fields.values()) {
            Label ifNotPresent = new Label();
            String fieldName = optionalField.name.value;
            if (this.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(153, ifNotPresent);
            }
            mv.visitVarInsn(25, valuesVarIndex);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            JvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitMethodInsn(185, "java/util/List", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            mv.visitInsn(87);
            mv.visitLabel(ifNotPresent);
        }
        mv.visitVarInsn(25, valuesVarIndex);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "values", String.format("()L%s;", "java/util/Collection"), false);
        mv.visitMethodInsn(185, "java/util/List", "addAll", String.format("(L%s;)Z", "java/util/Collection"), true);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createGetSizeMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "size", "()I", null, null);
        mv.visitCode();
        int sizeVarIndex = 1;
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "size", "()I", false);
        mv.visitVarInsn(54, sizeVarIndex);
        int requiredFieldsCount = 0;
        for (BField optionalField : fields.values()) {
            String fieldName = optionalField.name.value;
            if (this.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                Label l3 = new Label();
                mv.visitJumpInsn(153, l3);
                mv.visitIincInsn(sizeVarIndex, 1);
                mv.visitLabel(l3);
                continue;
            }
            ++requiredFieldsCount;
        }
        mv.visitIincInsn(sizeVarIndex, requiredFieldsCount);
        mv.visitVarInsn(21, sizeVarIndex);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordClearMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "clear", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V", false);
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordRemoveMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "remove", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), String.format("(L%s;)TV;", "java/lang/Object"), null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        int strKeyVarIndex = 2;
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "getValue", String.format("()L%s;", "java/lang/String"), true);
        mv.visitVarInsn(58, strKeyVarIndex);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "validateFreezeStatus", "()V", false);
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        Label defaultCaseLabel = new Label();
        List<Label> labels = JvmValueGen.createDecodedLabelsForSwitch(mv, strKeyVarIndex, sortedFields, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createDecodedLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, labels, defaultCaseLabel);
        int i = 0;
        for (BField optionalField : sortedFields) {
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            if (this.isOptionalRecordField(optionalField)) {
                String fieldName = optionalField.name.value;
                mv.visitVarInsn(25, 0);
                mv.visitInsn(3);
                mv.visitFieldInsn(181, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
                JvmCastGen.addBoxInsn(mv, optionalField.type);
                if (this.checkIfValueIsJReferenceType(optionalField.type)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitInsn(1);
                    mv.visitFieldInsn(181, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
                }
                mv.visitInsn(176);
            } else {
                mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
                mv.visitInsn(89);
                mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V", false);
                mv.visitInsn(191);
            }
            ++i;
        }
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "remove", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private boolean checkIfValueIsJReferenceType(BType bType) {
        switch (bType.getKind()) {
            case INT: 
            case BOOLEAN: 
            case FLOAT: 
            case BYTE: {
                return false;
            }
        }
        return true;
    }

    private void createRecordGetKeysMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "getKeys", String.format("()[L%s;", "java/lang/Object"), "()[TK;", null);
        mv.visitCode();
        int keysVarIndex = 1;
        mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
        mv.visitVarInsn(58, keysVarIndex);
        for (BField optionalField : fields.values()) {
            Label ifNotPresent = new Label();
            String fieldName = IdentifierUtils.decodeIdentifier(optionalField.name.value);
            if (this.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, this.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(153, ifNotPresent);
            }
            mv.visitVarInsn(25, keysVarIndex);
            mv.visitLdcInsn(fieldName);
            mv.visitMethodInsn(184, "io/ballerina/runtime/api/utils/StringUtils", "fromString", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/api/values/BString"), false);
            mv.visitMethodInsn(185, "java/util/Set", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            mv.visitInsn(87);
            mv.visitLabel(ifNotPresent);
        }
        mv.visitVarInsn(25, keysVarIndex);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "keySet", String.format("()L%s;", "java/util/Set"), false);
        mv.visitMethodInsn(185, "java/util/Set", "addAll", String.format("(L%s;)Z", "java/util/Collection"), true);
        mv.visitInsn(87);
        mv.visitVarInsn(25, keysVarIndex);
        mv.visitInsn(89);
        mv.visitMethodInsn(185, "java/util/Set", "size", "()I", true);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/values/BString");
        mv.visitMethodInsn(185, "java/util/Set", "toArray", String.format("([L%s;)[L%s;", "java/lang/Object", "java/lang/Object"), true);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordPopulateInitialValuesMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(4, "populateInitialValues", String.format("([L%s;)V", "io/ballerina/runtime/api/values/BMapInitialValueEntry"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "populateInitialValues", String.format("([L%s;)V", "io/ballerina/runtime/api/values/BMapInitialValueEntry"), false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void generateValueClasses(Map<String, byte[]> jarEntries) {
        this.module.typeDefs.parallelStream().forEach(optionalTypeDef -> {
            BType bType = optionalTypeDef.type;
            if (bType.tag == 33 && Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) {
                BObjectType objectType = (BObjectType)bType;
                String className = JvmValueGen.getTypeValueClassName(this.module, optionalTypeDef.name.value);
                byte[] bytes = this.createObjectValueClass(objectType, className, (BIRNode.BIRTypeDefinition)optionalTypeDef);
                jarEntries.put(className + ".class", bytes);
            } else if (bType.tag == 12) {
                BRecordType recordType = (BRecordType)bType;
                String className = JvmValueGen.getTypeValueClassName(this.module, optionalTypeDef.name.value);
                byte[] bytes = this.createRecordValueClass(recordType, className, (BIRNode.BIRTypeDefinition)optionalTypeDef);
                jarEntries.put(className + ".class", bytes);
                String typedescClass = JvmValueGen.getTypeDescClassName(this.module, optionalTypeDef.name.value);
                bytes = this.createRecordTypeDescClass(recordType, typedescClass, (BIRNode.BIRTypeDefinition)optionalTypeDef);
                jarEntries.put(typedescClass + ".class", bytes);
            }
        });
    }

    private byte[] createObjectValueClass(BObjectType objectType, String className, BIRNode.BIRTypeDefinition typeDef) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visitSource(typeDef.pos.lineRange().filePath(), null);
        AsyncDataCollector asyncDataCollector = new AsyncDataCollector(className);
        cw.visit(52, 33, className, null, "io/ballerina/runtime/internal/values/AbstractObjectValue", new String[]{"io/ballerina/runtime/api/values/BObject"});
        LinkedHashMap fields = objectType.fields;
        this.createObjectFields(cw, fields);
        List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
        if (attachedFuncs != null) {
            this.createObjectMethods(cw, attachedFuncs, className, objectType, asyncDataCollector);
        }
        this.createObjectInit(cw, fields, className);
        this.createCallMethod(cw, attachedFuncs, className);
        this.createObjectGetMethod(cw, fields, className);
        this.createObjectSetMethod(cw, fields, className);
        this.createObjectSetOnInitializationMethod(cw, fields, className);
        this.createLambdas(cw, asyncDataCollector);
        JvmCodeGenUtil.visitStrandMetadataField((ClassWriter)cw, asyncDataCollector);
        this.generateStaticInitializer(cw, className, this.module, asyncDataCollector);
        cw.visitEnd();
        return this.jvmPackageGen.getBytes(cw, typeDef);
    }
}

