/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.CatchIns;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JCast;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JErrorEntry;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JIConstructorCall;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JIMethodCall;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JavaField;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class InteropMethodGen {
    static void genJFieldForInteropField(JFieldFunctionWrapper jFieldFuncWrapper, ClassWriter classWriter, BIRNode.BIRPackage birModule, JvmPackageGen jvmPackageGen, String moduleClassName, AsyncDataCollector asyncDataCollector) {
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        indexMap.addIfNotExists("$_strand_$", jvmPackageGen.symbolTable.stringType);
        BIRNode.BIRFunction birFunc = jFieldFuncWrapper.func;
        BType retType = birFunc.type.retType;
        if (Symbols.isFlagOn(retType.flags, 0x4000000L)) {
            retType = JvmCodeGenUtil.TYPE_BUILDER.build(birFunc.type.retType);
        }
        String desc = JvmCodeGenUtil.getMethodDesc(birFunc.type.paramTypes, retType);
        int access = birFunc.receiver != null ? 1 : 9;
        MethodVisitor mv = classWriter.visitMethod(access, birFunc.name.value, desc, null, null);
        JvmInstructionGen instGen = new JvmInstructionGen(mv, indexMap, birModule, jvmPackageGen);
        JvmErrorGen errorGen = new JvmErrorGen(mv, indexMap, instGen);
        LabelGenerator labelGen = new LabelGenerator();
        JvmTerminatorGen termGen = new JvmTerminatorGen(mv, indexMap, labelGen, errorGen, birModule, instGen, jvmPackageGen);
        mv.visitCode();
        Label paramLoadLabel = labelGen.getLabel("param_load");
        mv.visitLabel(paramLoadLabel);
        mv.visitLineNumber(birFunc.pos.lineRange().startLine().line(), paramLoadLabel);
        ArrayList<BIRNode.BIRFunctionParameter> birFuncParams = new ArrayList<BIRNode.BIRFunctionParameter>();
        for (BIRNode.BIRVariableDcl bIRVariableDcl : birFunc.localVars) {
            if (!(bIRVariableDcl instanceof BIRNode.BIRFunctionParameter)) continue;
            BIRNode.BIRFunctionParameter functionParameter = (BIRNode.BIRFunctionParameter)bIRVariableDcl;
            birFuncParams.add(functionParameter);
            indexMap.addIfNotExists(functionParameter.name.value, functionParameter.type);
        }
        int birFuncParamIndex = 0;
        for (BIRNode.BIRFunctionParameter birFuncParam : birFuncParams) {
            if (birFuncParamIndex % 2 != 0 || !birFuncParam.hasDefaultExpr) {
                ++birFuncParamIndex;
                continue;
            }
            BIRNode.BIRFunctionParameter isDefaultValueExist = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex + 1);
            mv.visitVarInsn(21, indexMap.addIfNotExists(isDefaultValueExist.name.value, isDefaultValueExist.type));
            Label paramNextLabel = labelGen.getLabel(birFuncParam.name.value + "next");
            mv.visitJumpInsn(154, paramNextLabel);
            List<BIRNode.BIRBasicBlock> basicBlocks = birFunc.parameters.get(birFuncParam);
            InteropMethodGen.generateBasicBlocks(mv, basicBlocks, labelGen, errorGen, instGen, termGen, birFunc, moduleClassName, asyncDataCollector);
            mv.visitLabel(paramNextLabel);
            ++birFuncParamIndex;
        }
        JavaField javaField = jFieldFuncWrapper.jField;
        JType jFieldType = JInterop.getJType(javaField.getFieldType());
        if (!javaField.isStatic()) {
            BIRNode.BIRVariableDcl var = (BIRNode.BIRVariableDcl)birFuncParams.get(0);
            int receiverLocalVarIndex = indexMap.addIfNotExists(var.name.value, var.type);
            mv.visitVarInsn(25, receiverLocalVarIndex);
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            mv.visitTypeInsn(192, javaField.getDeclaringClassName());
            Label ifNonNullLabel = labelGen.getLabel("receiver_null_check");
            mv.visitLabel(ifNonNullLabel);
            mv.visitInsn(89);
            Label elseBlockLabel = labelGen.getLabel("receiver_null_check_else");
            mv.visitJumpInsn(199, elseBlockLabel);
            Label thenBlockLabel = labelGen.getLabel("receiver_null_check_then");
            mv.visitLabel(thenBlockLabel);
            mv.visitFieldInsn(178, "io/ballerina/runtime/internal/util/exceptions/BallerinaErrorReasons", "JAVA_NULL_REFERENCE_ERROR", "Ljava/lang/String;");
            mv.visitFieldInsn(178, "io/ballerina/runtime/internal/util/exceptions/RuntimeErrors", "JAVA_NULL_REFERENCE", "Lio/ballerina/runtime/internal/util/exceptions/RuntimeErrors;");
            mv.visitInsn(3);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/exceptions/BLangExceptionHelper", "getRuntimeException", "(Ljava/lang/String;Lio/ballerina/runtime/internal/util/exceptions/RuntimeErrors;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/ErrorValue;", false);
            mv.visitInsn(191);
            mv.visitLabel(elseBlockLabel);
        }
        int n = birFuncParamIndex = javaField.isStatic() ? 0 : 2;
        if (birFuncParamIndex < birFuncParams.size()) {
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            int paramLocalVarIndex = indexMap.addIfNotExists(birFuncParam.name.value, birFuncParam.type);
            InteropMethodGen.loadMethodParamToStackInInteropFunction(mv, birFuncParam, jFieldType, paramLocalVarIndex, instGen);
        }
        if (javaField.isStatic()) {
            if (javaField.method == JFieldMethod.ACCESS) {
                mv.visitFieldInsn(178, javaField.getDeclaringClassName(), javaField.getName(), javaField.getSignature());
            } else {
                mv.visitFieldInsn(179, javaField.getDeclaringClassName(), javaField.getName(), javaField.getSignature());
            }
        } else if (javaField.method == JFieldMethod.ACCESS) {
            mv.visitFieldInsn(180, javaField.getDeclaringClassName(), javaField.getName(), javaField.getSignature());
        } else {
            mv.visitFieldInsn(181, javaField.getDeclaringClassName(), javaField.getName(), javaField.getSignature());
        }
        BIRNode.BIRVariableDcl retVarDcl = new BIRNode.BIRVariableDcl(retType, new Name("$_ret_var_$"), null, VarKind.LOCAL);
        int returnVarRefIndex = indexMap.addIfNotExists(retVarDcl.name.value, retType);
        if (retType.tag == 10) {
            mv.visitInsn(1);
        } else if (retType.tag == 36) {
            int returnJObjectVarRefIndex = indexMap.addIfNotExists("$_ret_jobject_var_$", jvmPackageGen.symbolTable.anyType);
            mv.visitVarInsn(58, returnJObjectVarRefIndex);
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/HandleValue");
            mv.visitInsn(89);
            mv.visitVarInsn(25, returnJObjectVarRefIndex);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/HandleValue", "<init>", "(Ljava/lang/Object;)V", false);
        } else if (javaField.getFieldType().isPrimitive()) {
            InteropMethodGen.performWideningPrimitiveConversion(mv, retType, jFieldType);
        } else {
            JvmCastGen.addUnboxInsn(mv, retType);
        }
        instGen.generateVarStore(mv, retVarDcl, returnVarRefIndex);
        Label retLabel = labelGen.getLabel("return_lable");
        mv.visitLabel(retLabel);
        mv.visitLineNumber(birFunc.pos.lineRange().startLine().line(), retLabel);
        termGen.genReturnTerm(returnVarRefIndex, birFunc);
        mv.visitMaxs(200, 400);
        mv.visitEnd();
    }

    private static void generateBasicBlocks(MethodVisitor mv, List<BIRNode.BIRBasicBlock> basicBlocks, LabelGenerator labelGen, JvmErrorGen errorGen, JvmInstructionGen instGen, JvmTerminatorGen termGen, BIRNode.BIRFunction func, String moduleClassName, AsyncDataCollector asyncDataCollector) {
        String funcName = func.name.value;
        BirScope lastScope = null;
        HashSet<BirScope> visitedScopesSet = new HashSet<BirScope>();
        for (BIRNode.BIRBasicBlock basicBlock : basicBlocks) {
            Label bbLabel = labelGen.getLabel(funcName + basicBlock.id.value);
            mv.visitLabel(bbLabel);
            lastScope = JvmCodeGenUtil.getLastScopeFromBBInsGen(mv, labelGen, instGen, -1, asyncDataCollector, funcName, basicBlock, visitedScopesSet, lastScope);
            Label bbEndLabel = labelGen.getLabel(funcName + basicBlock.id.value + "beforeTerm");
            mv.visitLabel(bbEndLabel);
            BIRTerminator terminator = basicBlock.terminator;
            if (!(terminator instanceof BIRTerminator.Return)) {
                JvmCodeGenUtil.generateDiagnosticPos(terminator.pos, mv);
                termGen.genTerminator(terminator, moduleClassName, func, funcName, -1, -1, null, asyncDataCollector);
            }
            errorGen.generateTryCatch(func, funcName, basicBlock, termGen, labelGen);
            BIRNode.BIRBasicBlock thenBB = terminator.thenBB;
            if (thenBB == null) continue;
            JvmCodeGenUtil.genYieldCheck(mv, termGen.getLabelGenerator(), thenBB, funcName, -1);
        }
    }

    public static void desugarInteropFuncs(JMethodFunctionWrapper extFuncWrapper, BIRNode.BIRFunction birFunc, InitMethodGen initMethodGen) {
        BIRTerminator jCall;
        BType retType = birFunc.type.retType;
        if (Symbols.isFlagOn(retType.flags, 0x4000000L)) {
            retType = JvmCodeGenUtil.TYPE_BUILDER.build(birFunc.type.retType);
        }
        JMethod jMethod = extFuncWrapper.jMethod;
        Class<?>[] jMethodParamTypes = jMethod.getParamTypes();
        JType jMethodRetType = JInterop.getJType(jMethod.getReturnType());
        if (jMethodRetType == JType.jVoid && jMethod.isBalEnvAcceptingMethod()) {
            jMethodRetType = JType.getPrimitiveJTypeForBType(birFunc.returnVariable.type);
        }
        initMethodGen.resetIds();
        String bbPrefix = "wrapperGen";
        BIRNode.BIRBasicBlock beginBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, bbPrefix, initMethodGen);
        BIRNode.BIRBasicBlock retBB = new BIRNode.BIRBasicBlock(JvmDesugarPhase.getNextDesugarBBId(bbPrefix, initMethodGen));
        ArrayList<BIROperand> args = new ArrayList<BIROperand>();
        ArrayList<BIRNode.BIRFunctionParameter> birFuncParams = new ArrayList<BIRNode.BIRFunctionParameter>(birFunc.parameters.keySet());
        int birFuncParamIndex = 0;
        if (jMethod.kind == JMethodKind.METHOD && !jMethod.isStatic()) {
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            BIROperand argRef = new BIROperand(birFuncParam);
            args.add(argRef);
            birFuncParamIndex = 1;
        }
        JType varArgType = null;
        int jMethodParamIndex = 0;
        if (jMethod.getReceiverType() != null) {
            ++jMethodParamIndex;
            args.add(new BIROperand(birFunc.receiver));
        }
        if (jMethod.isBalEnvAcceptingMethod()) {
            ++jMethodParamIndex;
        }
        int paramCount = birFuncParams.size();
        while (birFuncParamIndex < paramCount) {
            BIRNode.BIRFunctionParameter birFuncParam = (BIRNode.BIRFunctionParameter)birFuncParams.get(birFuncParamIndex);
            boolean isVarArg = birFuncParamIndex == paramCount - 1 && birFunc.restParam != null;
            BType bPType = birFuncParam.type;
            JType jPType = JInterop.getJType(jMethodParamTypes[jMethodParamIndex]);
            BIROperand argRef = new BIROperand(birFuncParam);
            if (!isVarArg && !InteropMethodGen.isMatchingBAndJType(bPType, jPType)) {
                String varName = "$_param_jobject_var" + birFuncParamIndex + "_$";
                BIRNode.BIRVariableDcl paramVarDcl = new BIRNode.BIRVariableDcl(jPType, new Name(varName), null, VarKind.LOCAL);
                birFunc.localVars.add(paramVarDcl);
                BIROperand paramVarRef = new BIROperand(paramVarDcl);
                JCast jToBCast = new JCast(birFunc.pos);
                jToBCast.lhsOp = paramVarRef;
                jToBCast.rhsOp = argRef;
                jToBCast.targetType = jPType;
                argRef = paramVarRef;
                beginBB.instructions.add(jToBCast);
            }
            if (isVarArg) {
                varArgType = jPType;
            }
            args.add(argRef);
            ++birFuncParamIndex;
            ++jMethodParamIndex;
        }
        int invocationType = 184;
        if (jMethod.kind == JMethodKind.METHOD && !jMethod.isStatic()) {
            invocationType = jMethod.isDeclaringClassInterface() ? 185 : 182;
        } else if (jMethod.kind != JMethodKind.METHOD || !jMethod.isStatic()) {
            invocationType = 183;
        }
        BIROperand jRetVarRef = null;
        BIRNode.BIRBasicBlock thenBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, bbPrefix, initMethodGen);
        thenBB.terminator = new BIRTerminator.GOTO(birFunc.pos, retBB);
        if (retType.tag != 10) {
            BIROperand retRef = new BIROperand(birFunc.localVars.get(0));
            if (JType.jVoid != jMethodRetType) {
                BIROperand castVarRef;
                BIRNode.BIRVariableDcl retJObjectVarDcl = new BIRNode.BIRVariableDcl(jMethodRetType, new Name("$_ret_jobject_var_$"), null, VarKind.LOCAL);
                birFunc.localVars.add(retJObjectVarDcl);
                jRetVarRef = castVarRef = new BIROperand(retJObjectVarDcl);
                JCast jToBCast = new JCast(birFunc.pos);
                jToBCast.lhsOp = retRef;
                jToBCast.rhsOp = castVarRef;
                jToBCast.targetType = retType;
                thenBB.instructions.add(jToBCast);
            }
            BIRNode.BIRBasicBlock catchBB = new BIRNode.BIRBasicBlock(JvmDesugarPhase.getNextDesugarBBId(bbPrefix, initMethodGen));
            JErrorEntry ee = new JErrorEntry(beginBB, thenBB, retRef, catchBB);
            for (Class<?> exception : extFuncWrapper.jMethod.getExceptionTypes()) {
                BIRTerminator.Return exceptionRet = new BIRTerminator.Return(birFunc.pos);
                CatchIns catchIns = new CatchIns();
                catchIns.errorClass = exception.getName().replace(".", "/");
                catchIns.term = exceptionRet;
                ee.catchIns.add(catchIns);
            }
            birFunc.errorTable.add(ee);
        }
        if (jMethod.kind == JMethodKind.CONSTRUCTOR) {
            jCall = new JIConstructorCall(birFunc.pos);
            jCall.args = args;
            jCall.varArgExist = birFunc.restParam != null;
            jCall.varArgType = varArgType;
            jCall.lhsOp = jRetVarRef;
            jCall.jClassName = jMethod.getClassName().replace(".", "/");
            jCall.name = jMethod.getName();
            jCall.jMethodVMSig = jMethod.getSignature();
            jCall.thenBB = thenBB;
            beginBB.terminator = jCall;
        } else {
            jCall = new JIMethodCall(birFunc.pos);
            ((JIMethodCall)jCall).args = args;
            ((JIMethodCall)jCall).varArgExist = birFunc.restParam != null;
            ((JIMethodCall)jCall).varArgType = varArgType;
            ((JIMethodCall)jCall).lhsOp = jRetVarRef;
            ((JIMethodCall)jCall).jClassName = jMethod.getClassName().replace(".", "/");
            ((JIMethodCall)jCall).name = jMethod.getName();
            ((JIMethodCall)jCall).jMethodVMSig = jMethod.getSignature();
            ((JIMethodCall)jCall).invocationType = invocationType;
            ((JIMethodCall)jCall).thenBB = thenBB;
            beginBB.terminator = jCall;
        }
        birFunc.basicBlocks.add(retBB);
        retBB.terminator = new BIRTerminator.Return(birFunc.pos);
    }

    private static boolean isMatchingBAndJType(BType sourceTypes, JType targetType) {
        return TypeTags.isIntegerTypeTag(sourceTypes.tag) && targetType.jTag == 5 || sourceTypes.tag == 3 && targetType.jTag == 7 || sourceTypes.tag == 6 && targetType.jTag == 8;
    }

    private static void performWideningPrimitiveConversion(MethodVisitor mv, BType bType, JType jType) {
        if (!(TypeTags.isIntegerTypeTag(bType.tag) && jType.jTag == 5 || bType.tag == 3 && jType.jTag == 7)) {
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                mv.visitInsn(133);
            } else if (bType.tag == 3) {
                if (jType.jTag == 5) {
                    mv.visitInsn(138);
                } else if (jType.jTag == 6) {
                    mv.visitInsn(141);
                } else {
                    mv.visitInsn(135);
                }
            }
        }
    }

    private static void loadMethodParamToStackInInteropFunction(MethodVisitor mv, BIRNode.BIRFunctionParameter birFuncParam, JType jMethodParamType, int localVarIndex, JvmInstructionGen jvmInstructionGen) {
        BType bFuncParamType = birFuncParam.type;
        jvmInstructionGen.generateVarLoad(mv, birFuncParam, localVarIndex);
        JvmCastGen.generateBToJCheckCast(mv, bFuncParamType, jMethodParamType);
    }

    public static String getJTypeSignature(JType jType) {
        if (jType.jTag == 10) {
            return "L" + ((JType.JRefType)jType).typeValue + ";";
        }
        if (jType.jTag == 9) {
            JType eType = ((JType.JArrayType)jType).elementType;
            return "[" + InteropMethodGen.getJTypeSignature(eType);
        }
        switch (jType.jTag) {
            case 1: {
                return "B";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "S";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "J";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "Z";
            }
        }
        throw new BLangCompilerException(String.format("invalid element type: %s", jType));
    }

    public static String getSignatureForJType(JType jType) {
        if (jType.jTag == 10) {
            return ((JType.JRefType)jType).typeValue;
        }
        if (jType.jTag == 9) {
            JType eType = ((JType.JArrayType)jType).elementType;
            Object sig = "[";
            while (eType.jTag == 9) {
                eType = ((JType.JArrayType)eType).elementType;
                sig = (String)sig + "[";
            }
            switch (eType.jTag) {
                case 10: {
                    return (String)sig + "L" + InteropMethodGen.getSignatureForJType(eType) + ";";
                }
                case 1: {
                    return (String)sig + "B";
                }
                case 2: {
                    return (String)sig + "C";
                }
                case 3: {
                    return (String)sig + "S";
                }
                case 4: {
                    return (String)sig + "I";
                }
                case 5: {
                    return (String)sig + "J";
                }
                case 6: {
                    return (String)sig + "F";
                }
                case 7: {
                    return (String)sig + "D";
                }
                case 8: {
                    return (String)sig + "Z";
                }
            }
            throw new BLangCompilerException(String.format("invalid element type: %s", eType));
        }
        throw new BLangCompilerException(String.format("invalid element type: %s", jType));
    }

    public static void genVarArg(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, BType bType, JType jvmType, int varArgIndex, SymbolTable symbolTable) {
        if (jvmType.jTag != 9 || bType.tag != 19) {
            throw new BLangCompilerException(String.format("invalid type for var-arg: %s", jvmType));
        }
        JType jElementType = ((JType.JArrayType)jvmType).elementType;
        BType bElementType = ((BArrayType)bType).eType;
        int varArgsLenVarIndex = indexMap.addIfNotExists("$varArgsLen", symbolTable.intType);
        int indexVarIndex = indexMap.addIfNotExists("$index", symbolTable.intType);
        int valueArrayIndex = indexMap.addIfNotExists("$valueArray", symbolTable.anyType);
        mv.visitVarInsn(25, varArgIndex);
        mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "size", "()I", true);
        mv.visitInsn(89);
        mv.visitVarInsn(54, varArgsLenVarIndex);
        InteropMethodGen.genArrayNew(mv, jElementType);
        mv.visitVarInsn(58, valueArrayIndex);
        mv.visitInsn(3);
        mv.visitVarInsn(54, indexVarIndex);
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitLabel(l1);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitVarInsn(21, varArgsLenVarIndex);
        mv.visitJumpInsn(162, l2);
        mv.visitVarInsn(25, valueArrayIndex);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitVarInsn(25, varArgIndex);
        mv.visitVarInsn(21, indexVarIndex);
        mv.visitInsn(133);
        if (TypeTags.isIntegerTypeTag(bElementType.tag)) {
            mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getInt", "(J)J", true);
        } else if (TypeTags.isStringTypeTag(bElementType.tag)) {
            mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBString", String.format("(J)L%s;", "io/ballerina/runtime/api/values/BString"), true);
        } else {
            switch (bElementType.tag) {
                case 6: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBoolean", "(J)Z", true);
                    break;
                }
                case 2: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getByte", "(J)B", true);
                    break;
                }
                case 3: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getFloat", "(J)D", true);
                    break;
                }
                case 36: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
                    mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/HandleValue");
                    break;
                }
                default: {
                    mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
                }
            }
        }
        JvmCastGen.generateBToJCheckCast(mv, bElementType, jElementType);
        InteropMethodGen.genArrayStore(mv, jElementType);
        mv.visitIincInsn(indexVarIndex, 1);
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, valueArrayIndex);
    }

    private static void genArrayStore(MethodVisitor mv, JType jType) {
        int code;
        switch (jType.jTag) {
            case 4: {
                code = 79;
                break;
            }
            case 5: {
                code = 80;
                break;
            }
            case 7: {
                code = 82;
                break;
            }
            case 1: 
            case 8: {
                code = 84;
                break;
            }
            case 3: {
                code = 86;
                break;
            }
            case 2: {
                code = 85;
                break;
            }
            case 6: {
                code = 81;
                break;
            }
            default: {
                code = 83;
            }
        }
        mv.visitInsn(code);
    }

    private static void genArrayNew(MethodVisitor mv, JType elementType) {
        switch (elementType.jTag) {
            case 4: {
                mv.visitIntInsn(188, 10);
                break;
            }
            case 5: {
                mv.visitIntInsn(188, 11);
                break;
            }
            case 7: {
                mv.visitIntInsn(188, 7);
                break;
            }
            case 1: 
            case 8: {
                mv.visitIntInsn(188, 4);
                break;
            }
            case 3: {
                mv.visitIntInsn(188, 9);
                break;
            }
            case 2: {
                mv.visitIntInsn(188, 5);
                break;
            }
            case 6: {
                mv.visitIntInsn(188, 6);
                break;
            }
            case 9: 
            case 10: {
                mv.visitTypeInsn(189, InteropMethodGen.getSignatureForJType(elementType));
                break;
            }
            default: {
                throw new BLangCompilerException(String.format("invalid type for var-arg: %s", elementType));
            }
        }
    }

    static BIRFunctionWrapper createJInteropFunctionWrapper(InteropValidator interopValidator, InteropValidationRequest jInteropValidationReq, BIRNode.BIRFunction birFunc, String orgName, String moduleName, String version, String birModuleClassName, SymbolTable symbolTable) {
        if (interopValidator.isEntryModuleValidation()) {
            JvmDesugarPhase.addDefaultableBooleanVarsToSignature(birFunc, symbolTable.booleanType);
        }
        BIRFunctionWrapper birFuncWrapper = JvmPackageGen.getFunctionWrapper(birFunc, orgName, moduleName, version, birModuleClassName);
        if (jInteropValidationReq instanceof InteropValidationRequest.MethodValidationRequest) {
            InteropValidationRequest.MethodValidationRequest methodValidationRequest = (InteropValidationRequest.MethodValidationRequest)jInteropValidationReq;
            methodValidationRequest.restParamExist = birFunc.restParam != null;
            return InteropMethodGen.createJMethodWrapper(interopValidator, methodValidationRequest, birFuncWrapper);
        }
        InteropValidationRequest.FieldValidationRequest fieldValidationRequest = (InteropValidationRequest.FieldValidationRequest)jInteropValidationReq;
        return InteropMethodGen.createJFieldWrapper(interopValidator, fieldValidationRequest, birFuncWrapper);
    }

    private static JMethodFunctionWrapper createJMethodWrapper(InteropValidator interopValidator, InteropValidationRequest jMethodValidationReq, BIRFunctionWrapper birFuncWrapper) {
        JMethod jMethod = interopValidator.validateAndGetJMethod((InteropValidationRequest.MethodValidationRequest)jMethodValidationReq);
        return new JMethodFunctionWrapper(birFuncWrapper, jMethod);
    }

    private static JFieldFunctionWrapper createJFieldWrapper(InteropValidator interopValidator, InteropValidationRequest jFieldValidationReq, BIRFunctionWrapper birFuncWrapper) {
        JavaField jField = interopValidator.validateAndGetJField((InteropValidationRequest.FieldValidationRequest)jFieldValidationReq);
        return new JFieldFunctionWrapper(birFuncWrapper, jField);
    }

    private InteropMethodGen() {
    }
}

