/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.lang.reflect.Field;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodResolver;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JavaField;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;

public class InteropValidator {
    private ClassLoader classLoader;
    private SymbolTable symbolTable;
    private boolean isEntryModuleValidation;

    public InteropValidator(ClassLoader classLoader, SymbolTable symbolTable) {
        this.classLoader = classLoader;
        this.symbolTable = symbolTable;
    }

    JMethod validateAndGetJMethod(InteropValidationRequest.MethodValidationRequest methodValidationRequest) {
        JMethodRequest jMethodRequest = JMethodRequest.build(methodValidationRequest, this.classLoader, this.isEntryModuleValidation);
        JMethodResolver methodResolver = new JMethodResolver(this.classLoader, this.symbolTable);
        return methodResolver.resolve(jMethodRequest);
    }

    JavaField validateAndGetJField(InteropValidationRequest.FieldValidationRequest fieldValidationRequest) {
        JavaField javaField;
        JFieldMethod method = fieldValidationRequest.fieldMethod;
        String className = fieldValidationRequest.klass;
        Class<?> clazz = JInterop.loadClass(className, this.classLoader);
        String fieldName = fieldValidationRequest.name;
        try {
            Field field = clazz.getField(fieldName);
            javaField = new JavaField(method, field);
        }
        catch (NoSuchFieldException e) {
            throw new JInteropException(DiagnosticErrorCode.FIELD_NOT_FOUND, "No such field '" + fieldName + "' found in class '" + className + "'");
        }
        return javaField;
    }

    boolean isEntryModuleValidation() {
        return this.isEntryModuleValidation;
    }

    public void setEntryModuleValidation(boolean entryModuleValidation) {
        this.isEntryModuleValidation = entryModuleValidation;
    }
}

