/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import io.ballerina.runtime.internal.IdentifierUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JavaClass;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Name;

public class InitMethodGen {
    private final SymbolTable symbolTable;
    private final BUnionType errorOrNilType;
    private int nextId = -1;
    private int nextVarId = -1;

    public InitMethodGen(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.errorOrNilType = BUnionType.create(null, symbolTable.errorType, symbolTable.nilType);
    }

    public void generateLambdaForPackageInits(ClassWriter cw, BIRNode.BIRPackage pkg, String initClass, List<PackageID> depMods) {
        if (!MethodGenUtils.hasInitFunction(pkg)) {
            return;
        }
        this.generateLambdaForModuleFunction(cw, "$moduleInit", initClass);
        this.generateLambdaForModuleFunction(cw, "$moduleStart", initClass);
        MethodVisitor mv = this.visitFunction(cw, MethodGenUtils.calculateLambdaStopFuncName(MethodGenUtils.packageToModuleId(pkg)));
        this.invokeStopFunction(initClass, mv);
        for (PackageID id : depMods) {
            String jvmClass = JvmCodeGenUtil.getPackageName(id) + "$_init";
            this.generateLambdaForDepModStopFunc(cw, id, jvmClass);
        }
    }

    private void generateLambdaForModuleFunction(ClassWriter cw, String funcName, String initClass) {
        MethodVisitor mv = this.visitFunction(cw, String.format("$lambda$%s$", funcName));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        mv.visitMethodInsn(184, initClass, funcName, String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/Object"), false);
        JvmCastGen.addBoxInsn(mv, this.errorOrNilType);
        MethodGenUtils.visitReturn(mv);
    }

    private void generateLambdaForDepModStopFunc(ClassWriter cw, PackageID pkgID, String initClass) {
        String lambdaName = MethodGenUtils.calculateLambdaStopFuncName(pkgID);
        MethodVisitor mv = this.visitFunction(cw, lambdaName);
        this.invokeStopFunction(initClass, mv);
    }

    private MethodVisitor visitFunction(ClassWriter cw, String funcName) {
        MethodVisitor mv = cw.visitMethod(9, funcName, String.format("([L%s;)L%s;", "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        return mv;
    }

    private void invokeStopFunction(String initClass, MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        String stopFuncName = MethodGenUtils.encodeModuleSpecialFuncName(".<stop>");
        mv.visitMethodInsn(184, initClass, stopFuncName, String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/Object"), false);
        MethodGenUtils.visitReturn(mv);
    }

    public void generateModuleInitializer(ClassWriter cw, BIRNode.BIRPackage module, String typeOwnerClass) {
        MethodVisitor mv = cw.visitMethod(9, "$currentModuleInit", String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/Object"), null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, typeOwnerClass, "$createTypes", "()V", false);
        mv.visitTypeInsn(187, typeOwnerClass);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, typeOwnerClass, "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(module.org.value));
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(module.name.value));
        mv.visitLdcInsn(module.version.value);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, String.format("%s", "io/ballerina/runtime/internal/values/ValueCreator"), "addValueCreator", String.format("(L%s;L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String", "io/ballerina/runtime/internal/values/ValueCreator"), false);
        mv.visitInsn(1);
        MethodGenUtils.visitReturn(mv);
    }

    public void addInitAndTypeInitInstructions(BIRNode.BIRPackage pkg, BIRNode.BIRFunction func) {
        ArrayList<BIRNode.BIRBasicBlock> basicBlocks = new ArrayList<BIRNode.BIRBasicBlock>();
        this.nextId = -1;
        BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(this.getNextBBId());
        basicBlocks.add(nextBB);
        PackageID modID = MethodGenUtils.packageToModuleId(pkg);
        BIRNode.BIRBasicBlock typeOwnerCreateBB = new BIRNode.BIRBasicBlock(this.getNextBBId());
        basicBlocks.add(typeOwnerCreateBB);
        nextBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modID, new Name("$currentModuleInit"), new ArrayList<BIROperand>(), null, typeOwnerCreateBB, Collections.emptyList(), Collections.emptySet());
        if (func.basicBlocks.size() == 0) {
            typeOwnerCreateBB.terminator = new BIRTerminator.Return(func.pos);
            func.basicBlocks = basicBlocks;
            return;
        }
        typeOwnerCreateBB.terminator = new BIRTerminator.GOTO(null, func.basicBlocks.get(0));
        basicBlocks.addAll(func.basicBlocks);
        func.basicBlocks = basicBlocks;
    }

    public void enrichPkgWithInitializers(Map<String, JavaClass> jvmClassMap, String typeOwnerClass, BIRNode.BIRPackage pkg, List<PackageID> moduleImports) {
        JavaClass javaClass = jvmClassMap.get(typeOwnerClass);
        BIRNode.BIRFunction initFunc = this.generateDefaultFunction(moduleImports, pkg, "$moduleInit", ".<init>");
        javaClass.functions.add(initFunc);
        pkg.functions.add(initFunc);
        BIRNode.BIRFunction startFunc = this.generateDefaultFunction(moduleImports, pkg, "$moduleStart", ".<start>");
        javaClass.functions.add(startFunc);
        pkg.functions.add(startFunc);
    }

    private BIRNode.BIRFunction generateDefaultFunction(List<PackageID> imprtMods, BIRNode.BIRPackage pkg, String funcName, String initName) {
        this.nextId = -1;
        this.nextVarId = -1;
        BIRNode.BIRVariableDcl retVar = new BIRNode.BIRVariableDcl(null, this.errorOrNilType, new Name("%ret"), VarScope.FUNCTION, VarKind.RETURN, "");
        BIROperand retVarRef = new BIROperand(retVar);
        BInvokableType funcType = new BInvokableType(Collections.emptyList(), null, this.errorOrNilType, null);
        BIRNode.BIRFunction modInitFunc = new BIRNode.BIRFunction(null, new Name(funcName), 0L, funcType, null, 0, null, SymbolOrigin.VIRTUAL);
        modInitFunc.localVars.add(retVar);
        this.addAndGetNextBasicBlock(modInitFunc);
        BIRNode.BIRVariableDcl boolVal = this.addAndGetNextVar(modInitFunc, this.symbolTable.booleanType);
        BIROperand boolRef = new BIROperand(boolVal);
        for (PackageID id : imprtMods) {
            String initFuncName = MethodGenUtils.encodeModuleSpecialFuncName(initName);
            this.addCheckedInvocation(modInitFunc, id, initFuncName, retVarRef, boolRef);
        }
        PackageID currentModId = MethodGenUtils.packageToModuleId(pkg);
        String currentInitFuncName = MethodGenUtils.encodeModuleSpecialFuncName(initName);
        BIRNode.BIRBasicBlock lastBB = this.addCheckedInvocation(modInitFunc, currentModId, currentInitFuncName, retVarRef, boolRef);
        lastBB.terminator = new BIRTerminator.Return(null);
        return modInitFunc;
    }

    private BIRNode.BIRVariableDcl addAndGetNextVar(BIRNode.BIRFunction func, BType typeVal) {
        BIRNode.BIRVariableDcl nextLocalVar = new BIRNode.BIRVariableDcl(typeVal, this.getNextVarId(), VarScope.FUNCTION, VarKind.LOCAL);
        func.localVars.add(nextLocalVar);
        return nextLocalVar;
    }

    private Name getNextVarId() {
        String varIdPrefix = "%";
        ++this.nextVarId;
        return new Name(varIdPrefix + this.nextVarId);
    }

    private BIRNode.BIRBasicBlock addCheckedInvocation(BIRNode.BIRFunction func, PackageID modId, String initFuncName, BIROperand retVar, BIROperand boolRef) {
        BIRNode.BIRBasicBlock lastBB = func.basicBlocks.get(func.basicBlocks.size() - 1);
        BIRNode.BIRBasicBlock nextBB = this.addAndGetNextBasicBlock(func);
        if (JvmCodeGenUtil.isBuiltInPackage(modId)) {
            lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name(initFuncName), Collections.emptyList(), null, nextBB, Collections.emptyList(), Collections.emptySet());
            return nextBB;
        }
        lastBB.terminator = new BIRTerminator.Call(null, InstructionKind.CALL, false, modId, new Name(initFuncName), Collections.emptyList(), retVar, nextBB, Collections.emptyList(), Collections.emptySet());
        BIRNonTerminator.TypeTest typeTest = new BIRNonTerminator.TypeTest(null, this.symbolTable.errorType, boolRef, retVar);
        nextBB.instructions.add(typeTest);
        BIRNode.BIRBasicBlock trueBB = this.addAndGetNextBasicBlock(func);
        BIRNode.BIRBasicBlock retBB = this.addAndGetNextBasicBlock(func);
        retBB.terminator = new BIRTerminator.Return(null);
        trueBB.terminator = new BIRTerminator.GOTO(null, retBB);
        BIRNode.BIRBasicBlock falseBB = this.addAndGetNextBasicBlock(func);
        nextBB.terminator = new BIRTerminator.Branch(null, boolRef, trueBB, falseBB);
        return falseBB;
    }

    private BIRNode.BIRBasicBlock addAndGetNextBasicBlock(BIRNode.BIRFunction func) {
        BIRNode.BIRBasicBlock nextbb = new BIRNode.BIRBasicBlock(this.getNextBBId());
        func.basicBlocks.add(nextbb);
        return nextbb;
    }

    private Name getNextBBId() {
        String bbIdPrefix = "genBB";
        ++this.nextId;
        return new Name(bbIdPrefix + this.nextId);
    }

    public void resetIds() {
        this.nextId = -1;
        this.nextVarId = -1;
    }

    public int incrementAndGetNextId() {
        return this.nextId++;
    }
}

