/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class MainMethodGen {
    public static final String INIT_FUTURE_VAR = "initFutureVar";
    public static final String START_FUTURE_VAR = "startFutureVar";
    public static final String MAIN_FUTURE_VAR = "mainFutureVar";
    public static final String SCHEDULER_VAR = "schedulerVar";
    private final SymbolTable symbolTable;
    private final BIRVarToJVMIndexMap indexMap;

    public MainMethodGen(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.indexMap = new BIRVarToJVMIndexMap(1);
    }

    public void generateMainMethod(BIRNode.BIRFunction userMainFunc, ClassWriter cw, BIRNode.BIRPackage pkg, String initClass, boolean serviceEPAvailable, AsyncDataCollector asyncDataCollector) {
        MethodVisitor mv = cw.visitMethod(9, "main", "([Ljava/lang/String;)V", null, null);
        mv.visitCode();
        Label tryCatchStart = new Label();
        Label tryCatchEnd = new Label();
        Label tryCatchHandle = new Label();
        mv.visitTryCatchBlock(tryCatchStart, tryCatchEnd, tryCatchHandle, "java/lang/Throwable");
        mv.visitLabel(tryCatchStart);
        this.generateJavaCompatibilityCheck(mv);
        this.initConfigurations(mv);
        this.invokeConfigInit(mv, pkg);
        this.startListeners(mv, serviceEPAvailable);
        this.genInitScheduler(mv);
        this.genShutdownHook(mv, initClass);
        if (MethodGenUtils.hasInitFunction(pkg)) {
            this.generateMethodCall(initClass, asyncDataCollector, mv, "$moduleInit", ".<init>", INIT_FUTURE_VAR);
        }
        if (userMainFunc != null) {
            this.generateUserMainFunctionCall(userMainFunc, initClass, asyncDataCollector, mv);
        }
        if (MethodGenUtils.hasInitFunction(pkg)) {
            this.generateMethodCall(initClass, asyncDataCollector, mv, "$moduleStart", "start", START_FUTURE_VAR);
            this.setListenerFound(mv, serviceEPAvailable);
        }
        this.stopListeners(mv, serviceEPAvailable);
        if (!serviceEPAvailable) {
            this.generateExitRuntime(mv);
        }
        mv.visitLabel(tryCatchEnd);
        mv.visitInsn(177);
        mv.visitLabel(tryCatchHandle);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/RuntimeUtils", "handleRuntimeErrorsAndExit", String.format("(L%s;)V", "java/lang/Throwable"), false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateMethodCall(String initClass, AsyncDataCollector asyncDataCollector, MethodVisitor mv, String lambdaName, String funcName, String futureVar) {
        mv.visitVarInsn(25, this.indexMap.get(SCHEDULER_VAR));
        mv.visitIntInsn(16, 1);
        mv.visitTypeInsn(189, "java/lang/Object");
        this.genSubmitToScheduler(initClass, asyncDataCollector, mv, String.format("$lambda$%s$", lambdaName), funcName, futureVar);
        this.genReturn(mv, this.indexMap, futureVar);
    }

    private void startScheduler(int schedulerVarIndex, MethodVisitor mv) {
        mv.visitVarInsn(25, schedulerVarIndex);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "start", "()V", false);
    }

    private void invokeConfigInit(MethodVisitor mv, BIRNode.BIRPackage module) {
        String configClass = JvmCodeGenUtil.getModuleLevelClassName(module, "$ConfigurationMapper");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, configClass, "$configureInit", "()V", false);
    }

    private void generateJavaCompatibilityCheck(MethodVisitor mv) {
        mv.visitLdcInsn(this.getJavaVersion());
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/CompatibilityChecker", "verifyJavaCompatibility", String.format("(L%s;)V", "java/lang/String"), false);
    }

    private String getJavaVersion() {
        String versionProperty = "java.version";
        String javaVersion = System.getProperty(versionProperty);
        return Objects.requireNonNullElse(javaVersion, "");
    }

    private void initConfigurations(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "initConfigurations", String.format("([L%s;)[L%s;", "java/lang/String", "java/lang/String"), false);
        mv.visitVarInsn(58, 0);
    }

    private void startListeners(MethodVisitor mv, boolean isServiceEPAvailable) {
        mv.visitLdcInsn(isServiceEPAvailable);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "startListeners", "(Z)V", false);
    }

    private void genShutdownHook(MethodVisitor mv, String initClass) {
        String shutdownClassName = initClass + "$SignalListener";
        mv.visitMethodInsn(184, "java/lang/Runtime", "getRuntime", String.format("()L%s;", "java/lang/Runtime"), false);
        mv.visitTypeInsn(187, shutdownClassName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, this.indexMap.get(SCHEDULER_VAR));
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "getListenerRegistry", String.format("()L%s;", "io/ballerina/runtime/internal/scheduling/Scheduler$ListenerRegistry"), false);
        mv.visitMethodInsn(183, shutdownClassName, "<init>", String.format("(L%s;)V", "io/ballerina/runtime/internal/scheduling/Scheduler$ListenerRegistry"), false);
        mv.visitMethodInsn(182, "java/lang/Runtime", "addShutdownHook", String.format("(L%s;)V", "java/lang/Thread"), false);
    }

    private void genInitScheduler(MethodVisitor mv) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/scheduling/Scheduler");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/scheduling/Scheduler", "<init>", "(Z)V", false);
        int schedulerVarIndex = this.indexMap.addIfNotExists(SCHEDULER_VAR, this.symbolTable.anyType);
        mv.visitVarInsn(58, schedulerVarIndex);
    }

    private void setListenerFound(MethodVisitor mv, boolean serviceEPAvailable) {
        if (serviceEPAvailable) {
            int schedulerVarIndex = this.indexMap.get(SCHEDULER_VAR);
            mv.visitVarInsn(25, schedulerVarIndex);
            mv.visitInsn(4);
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "setListenerDeclarationFound", "(Z)V", false);
            this.startScheduler(schedulerVarIndex, mv);
        }
    }

    private void generateUserMainFunctionCall(BIRNode.BIRFunction userMainFunc, String initClass, AsyncDataCollector asyncDataCollector, MethodVisitor mv) {
        boolean isVoidFunction;
        int schedulerVarIndex = this.indexMap.get(SCHEDULER_VAR);
        mv.visitVarInsn(25, schedulerVarIndex);
        this.loadCLIArgsForMain(mv, new ArrayList<BIRNode.BIRFunctionParameter>(userMainFunc.parameters.keySet()), userMainFunc.restParam != null, userMainFunc.annotAttachments);
        this.genSubmitToScheduler(initClass, asyncDataCollector, mv, "$lambda$main$", "main", MAIN_FUTURE_VAR);
        this.handleErrorFromFutureValue(mv, MAIN_FUTURE_VAR);
        boolean bl = isVoidFunction = userMainFunc.type.retType.tag == 10;
        if (!isVoidFunction) {
            this.genReturn(mv, this.indexMap, MAIN_FUTURE_VAR);
        }
    }

    private void storeFuture(BIRVarToJVMIndexMap indexMap, MethodVisitor mv, String futureVar) {
        int mainFutureVarIndex = indexMap.addIfNotExists(futureVar, this.symbolTable.anyType);
        mv.visitVarInsn(58, mainFutureVarIndex);
        mv.visitVarInsn(25, mainFutureVarIndex);
    }

    private void loadCLIArgsForMain(MethodVisitor mv, List<BIRNode.BIRFunctionParameter> params, boolean hasRestParam, List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        List<String> defaultableNames = this.getDefaultableNames(annotAttachments);
        this.createFunctionInfoArray(mv, params, defaultableNames);
        this.loadStrings(mv, hasRestParam);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/ArgumentParser", "extractEntryFuncArgs", String.format("([L%s$ParamInfo;[L%s;Z)[L%s;", "io/ballerina/runtime/internal/util/RuntimeUtils", "java/lang/String", "java/lang/Object"), false);
    }

    private void loadStrings(MethodVisitor mv, boolean hasRestParam) {
        mv.visitVarInsn(25, 0);
        if (hasRestParam) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
    }

    private void createFunctionInfoArray(MethodVisitor mv, List<BIRNode.BIRFunctionParameter> params, List<String> defaultableNames) {
        mv.visitIntInsn(16, params.size());
        mv.visitTypeInsn(189, String.format("%s$ParamInfo", "io/ballerina/runtime/internal/util/RuntimeUtils"));
        int index = 0;
        int defaultableIndex = 0;
        for (BIRNode.BIRFunctionParameter param : params) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, index);
            ++index;
            mv.visitTypeInsn(187, String.format("%s$ParamInfo", "io/ballerina/runtime/internal/util/RuntimeUtils"));
            mv.visitInsn(89);
            if (param != null) {
                if (param.hasDefaultExpr) {
                    mv.visitInsn(4);
                } else {
                    mv.visitInsn(3);
                }
                mv.visitLdcInsn(defaultableNames.get(defaultableIndex));
                ++defaultableIndex;
                JvmTypeGen.loadType(mv, param.type);
            }
            mv.visitMethodInsn(183, String.format("%s$ParamInfo", "io/ballerina/runtime/internal/util/RuntimeUtils"), "<init>", String.format("(ZL%s;L%s;)V", "java/lang/String", "io/ballerina/runtime/api/types/Type"), false);
            mv.visitInsn(83);
        }
    }

    private List<String> getDefaultableNames(List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        ArrayList<String> defaultableNames = new ArrayList<String>();
        int defaultableIndex = 0;
        for (BIRNode.BIRAnnotationAttachment attachment : annotAttachments) {
            if (attachment == null || !attachment.annotTagRef.value.equals("DefaultableArgs")) continue;
            BIRNode.BIRAnnotationRecordValue annotRecValue = (BIRNode.BIRAnnotationRecordValue)attachment.annotValues.get(0);
            Map<String, BIRNode.BIRAnnotationValue> annotFieldMap = annotRecValue.annotValueEntryMap;
            BIRNode.BIRAnnotationArrayValue annotArrayValue = (BIRNode.BIRAnnotationArrayValue)annotFieldMap.get("args");
            for (BIRNode.BIRAnnotationValue entryOptional : annotArrayValue.annotArrayValue) {
                BIRNode.BIRAnnotationLiteralValue argValue = (BIRNode.BIRAnnotationLiteralValue)entryOptional;
                defaultableNames.add(defaultableIndex, (String)argValue.value);
                ++defaultableIndex;
            }
        }
        return defaultableNames;
    }

    private void genReturn(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, String futureVar) {
        mv.visitVarInsn(25, indexMap.get(futureVar));
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "result", String.format("L%s;", "java/lang/Object"));
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/RuntimeUtils", "handleRuntimeReturnValues", String.format("(L%s;)V", "java/lang/Object"), false);
    }

    private void genSubmitToScheduler(String initClass, AsyncDataCollector asyncDataCollector, MethodVisitor mv, String lambdaName, String funcName, String futureVar) {
        JvmCodeGenUtil.createFunctionPointer(mv, initClass, lambdaName);
        mv.visitInsn(1);
        BType anyType = this.symbolTable.anyType;
        JvmTypeGen.loadType(mv, anyType);
        MethodGenUtils.submitToScheduler(mv, initClass, funcName, asyncDataCollector);
        this.storeFuture(this.indexMap, mv, futureVar);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "strand", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/Strand"));
        mv.visitIntInsn(16, 100);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", "frames", String.format("[L%s;", "java/lang/Object"));
        this.startScheduler(this.indexMap.get(SCHEDULER_VAR), mv);
        this.handleErrorFromFutureValue(mv, futureVar);
    }

    private void stopListeners(MethodVisitor mv, boolean isServiceEPAvailable) {
        mv.visitLdcInsn(isServiceEPAvailable);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "stopListeners", "(Z)V", false);
    }

    private void generateExitRuntime(MethodVisitor mv) {
        mv.visitMethodInsn(184, "java/lang/Runtime", "getRuntime", String.format("()L%s;", "java/lang/Runtime"), false);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "java/lang/Runtime", "exit", "(I)V", false);
    }

    private void handleErrorFromFutureValue(MethodVisitor mv, String futureVar) {
        mv.visitVarInsn(25, this.indexMap.get(futureVar));
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        Label labelIf = new Label();
        mv.visitJumpInsn(198, labelIf);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/RuntimeUtils", "handleRuntimeErrorsAndExit", String.format("(L%s;)V", "java/lang/Throwable"), false);
        mv.visitInsn(177);
        mv.visitLabel(labelIf);
    }

    public void generateLambdaForMain(BIRNode.BIRFunction userMainFunc, ClassWriter cw, String mainClass) {
        BType returnType = userMainFunc.type.retType;
        MethodVisitor mv = cw.visitMethod(9, "$lambda$main$", String.format("([L%s;)L%s;", "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        List<BType> paramTypes = userMainFunc.type.paramTypes;
        int paramIndex = 1;
        for (BType pType : paramTypes) {
            mv.visitVarInsn(25, 0);
            mv.visitIntInsn(16, paramIndex);
            mv.visitInsn(50);
            JvmCastGen.addUnboxInsn(mv, pType);
            ++paramIndex;
        }
        mv.visitMethodInsn(184, mainClass, userMainFunc.name.value, JvmCodeGenUtil.getMethodDesc(paramTypes, returnType), false);
        JvmCastGen.addBoxInsn(mv, returnType);
        MethodGenUtils.visitReturn(mv);
    }
}

