/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;

public class ModuleStopMethodGen {
    public static final String SCHEDULER_VAR = "schedulerVar";
    public static final String FUTURE_VAR = "futureVar";
    public static final String ARR_VAR = "arrVar";
    private final SymbolTable symbolTable;
    private final BIRVarToJVMIndexMap indexMap;

    public ModuleStopMethodGen(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.indexMap = new BIRVarToJVMIndexMap(1);
    }

    public void generateExecutionStopMethod(ClassWriter cw, String initClass, BIRNode.BIRPackage module, List<PackageID> imprtMods, AsyncDataCollector asyncDataCollector) {
        MethodVisitor mv = cw.visitMethod(9, "$moduleStop", String.format("(L%s;)V", "io/ballerina/runtime/internal/scheduling/Scheduler$ListenerRegistry"), null, null);
        mv.visitCode();
        int schedulerIndex = this.indexMap.addIfNotExists(SCHEDULER_VAR, this.symbolTable.anyType);
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/scheduling/Scheduler");
        mv.visitInsn(89);
        mv.visitInsn(4);
        mv.visitInsn(3);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/scheduling/Scheduler", "<init>", "(IZ)V", false);
        mv.visitVarInsn(58, schedulerIndex);
        PackageID currentModId = MethodGenUtils.packageToModuleId(module);
        String moduleInitClass = this.getModuleInitClassName(currentModId);
        String fullFuncName = MethodGenUtils.calculateLambdaStopFuncName(currentModId);
        String lambdaName = this.generateStopDynamicListenerLambdaBody(cw);
        this.generateCallStopDynamicListenersLambda(mv, lambdaName, moduleInitClass, asyncDataCollector);
        this.scheduleStopLambda(mv, initClass, fullFuncName, moduleInitClass, asyncDataCollector);
        for (int i = imprtMods.size() - 1; i >= 0; --i) {
            PackageID id = imprtMods.get(i);
            fullFuncName = MethodGenUtils.calculateLambdaStopFuncName(id);
            moduleInitClass = this.getModuleInitClassName(id);
            this.scheduleStopLambda(mv, initClass, fullFuncName, moduleInitClass, asyncDataCollector);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String generateStopDynamicListenerLambdaBody(ClassWriter cw) {
        String lambdaName = "$lambda$stopdynamic";
        MethodVisitor mv = cw.visitMethod(9, lambdaName, String.format("([L%s;)L%s;", "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        this.generateCallSchedulerStopDynamicListeners(mv);
        return lambdaName;
    }

    private void generateCallStopDynamicListenersLambda(MethodVisitor mv, String lambdaName, String moduleInitClass, AsyncDataCollector asyncDataCollector) {
        this.addListenerRegistryAsParameter(mv);
        int futureIndex = this.indexMap.addIfNotExists(FUTURE_VAR, this.symbolTable.anyType);
        this.generateMethodBody(mv, moduleInitClass, lambdaName, asyncDataCollector);
        Label labelIf = new Label();
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        mv.visitJumpInsn(198, labelIf);
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/RuntimeUtils", "handleRuntimeErrors", String.format("(L%s;)V", "java/lang/Throwable"), false);
        mv.visitLabel(labelIf);
    }

    private void generateCallSchedulerStopDynamicListeners(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Scheduler$ListenerRegistry");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler$ListenerRegistry", "stopListeners", String.format("(L%s;)V", "io/ballerina/runtime/internal/scheduling/Strand"), false);
        mv.visitInsn(1);
        MethodGenUtils.visitReturn(mv);
    }

    private void addListenerRegistryAsParameter(MethodVisitor mv) {
        int arrIndex = this.indexMap.addIfNotExists(ARR_VAR, this.symbolTable.anyType);
        mv.visitIntInsn(16, 2);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitVarInsn(58, arrIndex);
        mv.visitVarInsn(25, arrIndex);
        mv.visitInsn(4);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(83);
        mv.visitVarInsn(25, this.indexMap.get(SCHEDULER_VAR));
        mv.visitVarInsn(25, arrIndex);
    }

    private void scheduleStopLambda(MethodVisitor mv, String initClass, String stopFuncName, String moduleClass, AsyncDataCollector asyncDataCollector) {
        Label labelIf = this.createIfLabel(mv, moduleClass);
        mv.visitVarInsn(25, this.indexMap.get(SCHEDULER_VAR));
        mv.visitIntInsn(16, 1);
        mv.visitTypeInsn(189, "java/lang/Object");
        this.generateMethodBody(mv, initClass, stopFuncName, asyncDataCollector);
        this.genHandleRuntimeErrors(mv, moduleClass, labelIf);
    }

    private void generateMethodBody(MethodVisitor mv, String initClass, String stopFuncName, AsyncDataCollector asyncDataCollector) {
        JvmCodeGenUtil.createFunctionPointer(mv, initClass, stopFuncName);
        mv.visitInsn(1);
        JvmTypeGen.loadType(mv, new BNilType());
        MethodGenUtils.submitToScheduler(mv, initClass, "stop", asyncDataCollector);
        int futureIndex = this.indexMap.get(FUTURE_VAR);
        mv.visitVarInsn(58, futureIndex);
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "strand", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/Strand"));
        mv.visitIntInsn(16, 100);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", "frames", String.format("[L%s;", "java/lang/Object"));
        int schedulerIndex = this.indexMap.get(SCHEDULER_VAR);
        mv.visitVarInsn(25, schedulerIndex);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "start", "()V", false);
    }

    private void genHandleRuntimeErrors(MethodVisitor mv, String moduleClass, Label labelIf) {
        int futureIndex = this.indexMap.get(FUTURE_VAR);
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        mv.visitJumpInsn(198, labelIf);
        mv.visitFieldInsn(178, moduleClass, "$moduleStarted", "Z");
        mv.visitJumpInsn(153, labelIf);
        mv.visitVarInsn(25, futureIndex);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/RuntimeUtils", "handleRuntimeErrors", String.format("(L%s;)V", "java/lang/Throwable"), false);
        mv.visitLabel(labelIf);
    }

    private Label createIfLabel(MethodVisitor mv, String moduleClass) {
        mv.visitFieldInsn(178, moduleClass, "$moduleStartAttempted", "Z");
        Label labelIf = new Label();
        mv.visitJumpInsn(153, labelIf);
        return labelIf;
    }

    private String getModuleInitClassName(PackageID id) {
        return JvmCodeGenUtil.getModuleLevelClassName(id.orgName.value, id.name.value, id.version.value, "$_init");
    }
}

