/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.ballerina.tools.diagnostics.Location;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.writer.BIRBinaryWriter;
import org.wso2.ballerinalang.compiler.bir.writer.BIRWriterUtils;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class BIRInstructionWriter
extends BIRVisitor {
    private ByteBuf buf;
    private ByteBuf scopeBuf;
    private ConstantPool cp;
    private BIRBinaryWriter binaryWriter;
    private int instructionOffset;
    private Set<BirScope> completedScopeSet;
    private int scopeCount;

    BIRInstructionWriter(ByteBuf buf, ByteBuf scopeBuf, ConstantPool cp, BIRBinaryWriter birBinaryWriter) {
        this.buf = buf;
        this.scopeBuf = scopeBuf;
        this.binaryWriter = birBinaryWriter;
        this.cp = cp;
        this.instructionOffset = 0;
        this.completedScopeSet = new HashSet<BirScope>();
        this.scopeCount = 0;
    }

    public int getScopeCount() {
        return this.scopeCount;
    }

    void writeBBs(List<BIRNode.BIRBasicBlock> bbList) {
        this.buf.writeInt(bbList.size());
        bbList.forEach(bb -> bb.accept(this));
    }

    void writeScopes(BIRAbstractInstruction instruction) {
        ++this.instructionOffset;
        BirScope currentScope = instruction.scope;
        this.writeScope(currentScope);
    }

    private void writeScope(BirScope currentScope) {
        if (this.completedScopeSet.contains(currentScope)) {
            return;
        }
        this.completedScopeSet.add(currentScope);
        ++this.scopeCount;
        this.scopeBuf.writeInt(currentScope.id);
        this.scopeBuf.writeInt(this.instructionOffset);
        if (currentScope.parent != null) {
            this.scopeBuf.writeBoolean(true);
            this.scopeBuf.writeInt(currentScope.parent.id);
            this.writeScope(currentScope.parent);
        } else {
            this.scopeBuf.writeBoolean(false);
        }
    }

    @Override
    public void visit(BIRNode.BIRBasicBlock birBasicBlock) {
        this.addCpAndWriteString(birBasicBlock.id.value);
        this.buf.writeInt(birBasicBlock.instructions.size() + 1);
        birBasicBlock.instructions.forEach(instruction -> {
            this.writePosition(instruction.pos);
            this.writeScopes((BIRAbstractInstruction)instruction);
            this.buf.writeByte(instruction.kind.getValue());
            instruction.accept(this);
        });
        BIRTerminator terminator = birBasicBlock.terminator;
        if (terminator == null) {
            throw new BLangCompilerException("Basic block without a terminator : " + birBasicBlock.id);
        }
        this.writePosition(terminator.pos);
        this.buf.writeByte(terminator.kind.getValue());
        terminator.accept(this);
    }

    void writeErrorTable(List<BIRNode.BIRErrorEntry> errorEntries) {
        this.buf.writeInt(errorEntries.size());
        errorEntries.forEach(birErrorEntry -> birErrorEntry.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRErrorEntry errorEntry) {
        this.addCpAndWriteString(errorEntry.trapBB.id.value);
        this.addCpAndWriteString(errorEntry.endBB.id.value);
        errorEntry.errorOp.accept(this);
        this.addCpAndWriteString(errorEntry.targetBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.GOTO birGoto) {
        this.addCpAndWriteString(birGoto.targetBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Lock lock) {
        this.addCpAndWriteString(lock.lockedBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.FieldLock lock) {
        this.addCpAndWriteString(lock.localVar.variableDcl.name.value);
        this.addCpAndWriteString(lock.field);
        this.addCpAndWriteString(lock.lockedBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Unlock unlock) {
        this.addCpAndWriteString(unlock.unlockBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Return birReturn) {
    }

    @Override
    public void visit(BIRTerminator.Branch birBranch) {
        birBranch.op.accept(this);
        this.addCpAndWriteString(birBranch.trueBB.id.value);
        this.addCpAndWriteString(birBranch.falseBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Wait waitEntry) {
        this.buf.writeInt(waitEntry.exprList.size());
        for (BIROperand expr : waitEntry.exprList) {
            expr.accept(this);
        }
        waitEntry.lhsOp.accept(this);
        this.addCpAndWriteString(waitEntry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Flush entry) {
        this.buf.writeInt(entry.channels.length);
        for (BIRNode.ChannelDetails detail : entry.channels) {
            this.addCpAndWriteString(detail.name);
            this.buf.writeBoolean(detail.channelInSameStrand);
            this.buf.writeBoolean(detail.send);
        }
        entry.lhsOp.accept(this);
        this.addCpAndWriteString(entry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.WorkerReceive entry) {
        this.buf.writeInt(this.addStringCPEntry(entry.workerName.getValue()));
        entry.lhsOp.accept(this);
        this.buf.writeBoolean(entry.isSameStrand);
        this.addCpAndWriteString(entry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.WorkerSend entry) {
        this.buf.writeInt(this.addStringCPEntry(entry.channel.getValue()));
        entry.data.accept(this);
        this.buf.writeBoolean(entry.isSameStrand);
        this.buf.writeBoolean(entry.isSync);
        if (entry.isSync) {
            entry.lhsOp.accept(this);
        }
        this.addCpAndWriteString(entry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.WaitAll waitAll) {
        waitAll.lhsOp.accept(this);
        this.buf.writeInt(waitAll.keys.size());
        waitAll.keys.forEach(key -> this.buf.writeInt(this.addStringCPEntry((String)key)));
        this.buf.writeInt(waitAll.valueExprs.size());
        waitAll.valueExprs.forEach(val -> val.accept(this));
        this.addCpAndWriteString(waitAll.thenBB.id.value);
    }

    @Override
    public void visit(BIRNonTerminator.NewTable newTable) {
        this.writeType(newTable.type);
        newTable.lhsOp.accept(this);
        newTable.keyColOp.accept(this);
        newTable.dataOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.Move birMove) {
        birMove.rhsOp.accept(this);
        birMove.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRTerminator.Call birCall) {
        this.writeCallInstruction(birCall);
        this.addCpAndWriteString(birCall.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.AsyncCall birAsyncCall) {
        this.writeCallInstruction(birAsyncCall);
        this.binaryWriter.writeAnnotAttachments(this.buf, birAsyncCall.annotAttachments);
        this.addCpAndWriteString(birAsyncCall.thenBB.id.value);
    }

    private void writeCallInstruction(BIRTerminator.Call birCall) {
        PackageID calleePkg = birCall.calleePkg;
        int pkgIndex = this.addPkgCPEntry(calleePkg);
        this.buf.writeBoolean(birCall.isVirtual);
        this.buf.writeInt(pkgIndex);
        this.buf.writeInt(this.addStringCPEntry(birCall.name.getValue()));
        this.buf.writeInt(birCall.args.size());
        for (BIROperand arg : birCall.args) {
            arg.accept(this);
        }
        if (birCall.lhsOp != null) {
            this.buf.writeByte(1);
            birCall.lhsOp.accept(this);
        } else {
            this.buf.writeByte(0);
        }
    }

    @Override
    public void visit(BIRTerminator.FPCall fpCall) {
        fpCall.fp.accept(this);
        this.buf.writeInt(fpCall.args.size());
        for (BIROperand arg : fpCall.args) {
            arg.accept(this);
        }
        if (fpCall.lhsOp != null) {
            this.buf.writeByte(1);
            fpCall.lhsOp.accept(this);
        } else {
            this.buf.writeByte(0);
        }
        this.buf.writeBoolean(fpCall.isAsync);
        this.addCpAndWriteString(fpCall.thenBB.id.value);
    }

    @Override
    public void visit(BIRNonTerminator.BinaryOp birBinaryOp) {
        birBinaryOp.rhsOp1.accept(this);
        birBinaryOp.rhsOp2.accept(this);
        birBinaryOp.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.UnaryOP birUnaryOp) {
        birUnaryOp.rhsOp.accept(this);
        birUnaryOp.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.ConstantLoad birConstantLoad) {
        this.writeType(birConstantLoad.type);
        birConstantLoad.lhsOp.accept(this);
        BType type = birConstantLoad.type;
        switch (type.tag) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.IntegerCPEntry((Long)birConstantLoad.value)));
                break;
            }
            case 2: {
                int byteValue = ((Number)birConstantLoad.value).intValue();
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.ByteCPEntry(byteValue)));
                break;
            }
            case 6: {
                this.buf.writeBoolean((Boolean)birConstantLoad.value);
                break;
            }
            case 4: 
            case 5: 
            case 44: {
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.StringCPEntry(birConstantLoad.value.toString())));
                break;
            }
            case 3: {
                double value = birConstantLoad.value instanceof Double ? (Double)birConstantLoad.value : Double.parseDouble((String)birConstantLoad.value);
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.FloatCPEntry(value)));
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new IllegalStateException("unsupported constant type: " + type);
            }
        }
    }

    @Override
    public void visit(BIRNonTerminator.NewStructure birNewStructure) {
        birNewStructure.rhsOp.accept(this);
        birNewStructure.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewInstance newInstance) {
        this.buf.writeBoolean(newInstance.isExternalDef);
        if (newInstance.isExternalDef) {
            assert (newInstance.externalPackageId != null);
            this.buf.writeInt(this.addPkgCPEntry(newInstance.externalPackageId));
            this.buf.writeInt(this.addStringCPEntry(newInstance.objectName));
        } else {
            this.buf.writeInt(newInstance.def.index);
        }
        newInstance.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewArray birNewArray) {
        this.writeType(birNewArray.type);
        birNewArray.lhsOp.accept(this);
        birNewArray.sizeOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.FieldAccess birFieldAccess) {
        if (birFieldAccess.kind == InstructionKind.MAP_LOAD || birFieldAccess.kind == InstructionKind.ARRAY_LOAD) {
            this.buf.writeBoolean(birFieldAccess.optionalFieldAccess);
            this.buf.writeBoolean(birFieldAccess.fillingRead);
        }
        birFieldAccess.lhsOp.accept(this);
        birFieldAccess.keyOp.accept(this);
        birFieldAccess.rhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.TypeCast birTypeCast) {
        birTypeCast.lhsOp.accept(this);
        birTypeCast.rhsOp.accept(this);
        this.writeType(birTypeCast.type);
        this.buf.writeBoolean(birTypeCast.checkTypes);
    }

    @Override
    public void visit(BIRNonTerminator.IsLike birIsLike) {
        this.writeType(birIsLike.type);
        birIsLike.lhsOp.accept(this);
        birIsLike.rhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.TypeTest birTypeTest) {
        this.writeType(birTypeTest.type);
        birTypeTest.lhsOp.accept(this);
        birTypeTest.rhsOp.accept(this);
    }

    @Override
    public void visit(BIROperand birOperand) {
        if (birOperand.variableDcl.ignoreVariable) {
            this.buf.writeBoolean(true);
            this.writeType(birOperand.variableDcl.type);
            return;
        }
        this.buf.writeBoolean(false);
        this.buf.writeByte(birOperand.variableDcl.kind.getValue());
        this.buf.writeByte(birOperand.variableDcl.scope.getValue());
        this.addCpAndWriteString(birOperand.variableDcl.name.value);
        if (birOperand.variableDcl.kind == VarKind.GLOBAL || birOperand.variableDcl.kind == VarKind.CONSTANT) {
            int pkgIndex = this.addPkgCPEntry(((BIRNode.BIRGlobalVariableDcl)birOperand.variableDcl).pkgId);
            this.buf.writeInt(pkgIndex);
            this.writeType(birOperand.variableDcl.type);
        }
    }

    @Override
    public void visit(BIRNonTerminator.NewError birNewError) {
        this.writeType(birNewError.type);
        birNewError.lhsOp.accept(this);
        birNewError.messageOp.accept(this);
        birNewError.causeOp.accept(this);
        birNewError.detailOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.FPLoad fpLoad) {
        fpLoad.lhsOp.accept(this);
        PackageID pkgId = fpLoad.pkgId;
        int pkgIndex = this.addPkgCPEntry(pkgId);
        this.buf.writeInt(pkgIndex);
        this.buf.writeInt(this.addStringCPEntry(fpLoad.funcName.getValue()));
        this.writeType(fpLoad.retType);
        this.buf.writeInt(fpLoad.closureMaps.size());
        for (BIROperand op : fpLoad.closureMaps) {
            op.accept(this);
        }
        this.buf.writeInt(fpLoad.params.size());
        fpLoad.params.forEach(param -> {
            this.buf.writeByte(param.kind.getValue());
            this.writeType(param.type);
            this.buf.writeInt(this.addStringCPEntry(param.name.value));
        });
    }

    @Override
    public void visit(BIRTerminator.Panic birPanic) {
        birPanic.errorOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLElement newXMLElement) {
        newXMLElement.lhsOp.accept(this);
        newXMLElement.startTagOp.accept(this);
        newXMLElement.defaultNsURIOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLText newXMLText) {
        newXMLText.lhsOp.accept(this);
        newXMLText.textOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLQName newXMLQName) {
        newXMLQName.lhsOp.accept(this);
        newXMLQName.localnameOp.accept(this);
        newXMLQName.nsURIOp.accept(this);
        newXMLQName.prefixOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewStringXMLQName newStringXMLQName) {
        newStringXMLQName.lhsOp.accept(this);
        newStringXMLQName.stringQNameOP.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.XMLAccess xmlAccess) {
        xmlAccess.lhsOp.accept(this);
        xmlAccess.rhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLComment newXMLComment) {
        newXMLComment.lhsOp.accept(this);
        newXMLComment.textOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLProcIns newXMLProcIns) {
        newXMLProcIns.lhsOp.accept(this);
        newXMLProcIns.dataOp.accept(this);
        newXMLProcIns.targetOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewTypeDesc newTypeDesc) {
        newTypeDesc.lhsOp.accept(this);
        this.writeType(newTypeDesc.type);
    }

    void writePosition(Location pos) {
        BIRWriterUtils.writePosition(pos, this.buf, this.cp);
    }

    int addPkgCPEntry(PackageID packageID) {
        return BIRWriterUtils.addPkgCPEntry(packageID.orgName.value, packageID.name.value, packageID.version.value, this.cp);
    }

    private void addCpAndWriteString(String string) {
        this.buf.writeInt(this.addStringCPEntry(string));
    }

    private int addStringCPEntry(String value) {
        return BIRWriterUtils.addStringCPEntry(value, this.cp);
    }

    private void writeType(BType type) {
        this.buf.writeInt(this.cp.addShapeCPEntry(type));
    }
}

