/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BBuiltInRefType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.TypeFlags;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;

public class BIRTypeWriter
implements TypeVisitor {
    private final ByteBuf buff;
    private final ConstantPool cp;

    public BIRTypeWriter(ByteBuf buff, ConstantPool cp) {
        this.buff = buff;
        this.cp = cp;
    }

    public void visitType(BType type) {
        this.buff.writeByte(type.tag);
        this.buff.writeInt(this.addStringCPEntry(type.name.getValue()));
        this.buff.writeLong(type.flags);
        this.buff.writeInt(TypeFlags.asMask(type.isNullable(), type.isAnydata(), type.isPureType()));
        type.accept(this);
    }

    private void writeTypeCpIndex(BType type) {
        this.buff.writeInt(this.cp.addShapeCPEntry(type));
    }

    @Override
    public void visit(BAnnotationType bAnnotationType) {
        this.throwUnimplementedError(bAnnotationType);
    }

    @Override
    public void visit(BArrayType bArrayType) {
        this.buff.writeByte(bArrayType.state.getValue());
        this.buff.writeInt(bArrayType.size);
        this.writeTypeCpIndex(bArrayType.getElementType());
    }

    @Override
    public void visit(BBuiltInRefType bBuiltInRefType) {
        this.throwUnimplementedError(bBuiltInRefType);
    }

    @Override
    public void visit(BAnyType bAnyType) {
    }

    @Override
    public void visit(BErrorType bErrorType) {
        int orgCPIndex = this.addStringCPEntry(bErrorType.tsymbol.pkgID.orgName.value);
        int nameCPIndex = this.addStringCPEntry(bErrorType.tsymbol.pkgID.name.value);
        int versionCPIndex = this.addStringCPEntry(bErrorType.tsymbol.pkgID.version.value);
        int pkgIndex = this.cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
        this.buff.writeInt(pkgIndex);
        this.buff.writeInt(this.addStringCPEntry(bErrorType.tsymbol.name.value));
        this.writeTypeCpIndex(bErrorType.detailType);
        this.writeTypeIds(bErrorType.typeIdSet);
    }

    private void writeTypeIds(BTypeIdSet typeIdSet) {
        this.buff.writeInt(typeIdSet.primary.size());
        for (BTypeIdSet.BTypeId bTypeId : typeIdSet.primary) {
            this.writeTypeId(bTypeId);
        }
        this.buff.writeInt(typeIdSet.secondary.size());
        for (BTypeIdSet.BTypeId bTypeId : typeIdSet.secondary) {
            this.writeTypeId(bTypeId);
        }
    }

    private void writeTypeId(BTypeIdSet.BTypeId bTypeId) {
        int orgCPIndex = this.addStringCPEntry(bTypeId.packageID.orgName.value);
        int nameCPIndex = this.addStringCPEntry(bTypeId.packageID.name.value);
        int versionCPIndex = this.addStringCPEntry(bTypeId.packageID.version.value);
        int pkgIndex = this.cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
        this.buff.writeInt(pkgIndex);
        this.buff.writeInt(this.addStringCPEntry(bTypeId.name));
        this.buff.writeBoolean(bTypeId.publicId);
    }

    @Override
    public void visit(BFiniteType bFiniteType) {
        BTypeSymbol tsymbol = bFiniteType.tsymbol;
        this.buff.writeInt(this.addStringCPEntry(tsymbol.name.value));
        this.buff.writeLong(tsymbol.flags);
        this.buff.writeInt(bFiniteType.getValueSpace().size());
        for (BLangExpression valueLiteral : bFiniteType.getValueSpace()) {
            if (!(valueLiteral instanceof BLangLiteral)) {
                throw new AssertionError((Object)("Type serialization is not implemented for finite type with value: " + valueLiteral.getKind()));
            }
            this.writeTypeCpIndex(valueLiteral.type);
            this.writeValue(((BLangLiteral)valueLiteral).value, valueLiteral.type);
        }
    }

    @Override
    public void visit(BInvokableType bInvokableType) {
        this.buff.writeInt(bInvokableType.paramTypes.size());
        for (BType params : bInvokableType.paramTypes) {
            this.writeTypeCpIndex(params);
        }
        boolean restTypeExist = bInvokableType.restType != null;
        this.buff.writeBoolean(restTypeExist);
        if (restTypeExist) {
            this.writeTypeCpIndex(bInvokableType.restType);
        }
        this.writeTypeCpIndex(bInvokableType.retType);
    }

    @Override
    public void visit(BJSONType bjsonType) {
    }

    @Override
    public void visit(BMapType bMapType) {
        this.writeTypeCpIndex(bMapType.constraint);
    }

    @Override
    public void visit(BStreamType bStreamType) {
        this.writeTypeCpIndex(bStreamType.constraint);
        if (bStreamType.error != null) {
            this.buff.writeBoolean(true);
            this.writeTypeCpIndex(bStreamType.error);
        } else {
            this.buff.writeBoolean(false);
        }
    }

    @Override
    public void visit(BTypedescType typedescType) {
        this.writeTypeCpIndex(typedescType.constraint);
    }

    @Override
    public void visit(BParameterizedType type) {
        this.writeTypeCpIndex(type.paramValueType);
        this.buff.writeInt(type.paramIndex);
    }

    @Override
    public void visit(BFutureType bFutureType) {
        this.writeTypeCpIndex(bFutureType.constraint);
    }

    @Override
    public void visit(BHandleType bHandleType) {
    }

    @Override
    public void visit(BNeverType bNeverType) {
    }

    @Override
    public void visit(BNilType bNilType) {
    }

    @Override
    public void visit(BNoType bNoType) {
    }

    @Override
    public void visit(BAnydataType bAnydataType) {
    }

    @Override
    public void visit(BPackageType bPackageType) {
        this.throwUnimplementedError(bPackageType);
    }

    @Override
    public void visit(BServiceType bServiceType) {
        this.buff.writeByte(1);
        this.writeObjectAndServiceTypes(bServiceType);
        this.writeTypeIds(bServiceType.typeIdSet);
    }

    @Override
    public void visit(BStructureType bStructureType) {
        this.throwUnimplementedError(bStructureType);
    }

    @Override
    public void visit(BTupleType bTupleType) {
        this.buff.writeInt(bTupleType.tupleTypes.size());
        for (BType memberType : bTupleType.tupleTypes) {
            this.writeTypeCpIndex(memberType);
        }
        if (bTupleType.restType != null) {
            this.buff.writeBoolean(true);
            this.writeTypeCpIndex(bTupleType.restType);
        } else {
            this.buff.writeBoolean(false);
        }
    }

    @Override
    public void visit(BUnionType bUnionType) {
        this.buff.writeInt(bUnionType.getMemberTypes().size());
        for (BType memberType : bUnionType.getMemberTypes()) {
            this.writeTypeCpIndex(memberType);
        }
    }

    @Override
    public void visit(BIntersectionType bIntersectionType) {
        this.buff.writeInt(bIntersectionType.getConstituentTypes().size());
        for (BType constituentType : bIntersectionType.getConstituentTypes()) {
            this.writeTypeCpIndex(constituentType);
        }
        this.writeTypeCpIndex(bIntersectionType.effectiveType);
    }

    @Override
    public void visit(BRecordType bRecordType) {
        BRecordTypeSymbol tsymbol = (BRecordTypeSymbol)bRecordType.tsymbol;
        int orgCPIndex = this.addStringCPEntry(tsymbol.pkgID.orgName.value);
        int nameCPIndex = this.addStringCPEntry(tsymbol.pkgID.name.value);
        int versionCPIndex = this.addStringCPEntry(tsymbol.pkgID.version.value);
        int pkgIndex = this.cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
        this.buff.writeInt(pkgIndex);
        this.buff.writeInt(this.addStringCPEntry(tsymbol.name.value));
        this.buff.writeBoolean(bRecordType.sealed);
        this.writeTypeCpIndex(bRecordType.restFieldType);
        this.buff.writeInt(bRecordType.fields.size());
        for (BField field : bRecordType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            this.buff.writeInt(this.addStringCPEntry(symbol.name.value));
            this.buff.writeLong(symbol.flags);
            this.writeMarkdownDocAttachment(this.buff, field.symbol.markdownDocumentation);
            this.writeTypeCpIndex(field.type);
        }
        BAttachedFunction initializerFunc = tsymbol.initializerFunc;
        if (initializerFunc == null) {
            this.buff.writeByte(0);
            return;
        }
        this.buff.writeByte(1);
        this.buff.writeInt(this.addStringCPEntry(initializerFunc.funcName.value));
        this.buff.writeLong(initializerFunc.symbol.flags);
        this.writeTypeCpIndex(initializerFunc.type);
        this.writeTypeInclusions(bRecordType.typeInclusions);
    }

    @Override
    public void visit(BObjectType bObjectType) {
        this.buff.writeByte(0);
        this.writeObjectAndServiceTypes(bObjectType);
        this.writeTypeIds(bObjectType.typeIdSet);
    }

    private void writeObjectAndServiceTypes(BObjectType bObjectType) {
        ArrayList attachedFuncs;
        BTypeSymbol tSymbol = bObjectType.tsymbol;
        int orgCPIndex = this.addStringCPEntry(tSymbol.pkgID.orgName.value);
        int nameCPIndex = this.addStringCPEntry(tSymbol.pkgID.name.value);
        int versionCPIndex = this.addStringCPEntry(tSymbol.pkgID.version.value);
        int pkgIndex = this.cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
        this.buff.writeInt(pkgIndex);
        this.buff.writeInt(this.addStringCPEntry(tSymbol.name.value));
        this.buff.writeBoolean(Symbols.isFlagOn(tSymbol.flags, 0x10000000L));
        this.buff.writeBoolean(Symbols.isFlagOn(tSymbol.flags, 65536L));
        this.buff.writeInt(bObjectType.fields.size());
        for (BField field : bObjectType.fields.values()) {
            this.buff.writeInt(this.addStringCPEntry(field.name.value));
            this.buff.writeLong(field.symbol.flags);
            this.writeMarkdownDocAttachment(this.buff, field.symbol.markdownDocumentation);
            this.writeTypeCpIndex(field.type);
        }
        if (tSymbol.kind == SymbolKind.OBJECT) {
            attachedFuncs = new ArrayList(((BObjectTypeSymbol)tSymbol).attachedFuncs);
            if (((BObjectTypeSymbol)tSymbol).generatedInitializerFunc != null) {
                this.buff.writeByte(1);
                this.writeAttachFunction(((BObjectTypeSymbol)tSymbol).generatedInitializerFunc);
            } else {
                this.buff.writeByte(0);
            }
            if (((BObjectTypeSymbol)tSymbol).initializerFunc != null) {
                this.buff.writeByte(1);
                this.writeAttachFunction(((BObjectTypeSymbol)tSymbol).initializerFunc);
            } else {
                this.buff.writeByte(0);
            }
        } else {
            attachedFuncs = new ArrayList();
            this.buff.writeByte(0);
            this.buff.writeByte(0);
        }
        this.buff.writeInt(attachedFuncs.size());
        for (BAttachedFunction attachedFunc : attachedFuncs) {
            this.writeAttachFunction(attachedFunc);
        }
        this.writeTypeInclusions(bObjectType.typeInclusions);
    }

    private void writeAttachFunction(BAttachedFunction attachedFunc) {
        this.buff.writeInt(this.addStringCPEntry(attachedFunc.funcName.value));
        this.buff.writeLong(attachedFunc.symbol.flags);
        this.writeTypeCpIndex(attachedFunc.type);
    }

    @Override
    public void visit(BType bType) {
    }

    @Override
    public void visit(BXMLType bxmlType) {
        this.writeTypeCpIndex(bxmlType.constraint);
    }

    @Override
    public void visit(BTableType bTableType) {
        this.writeTypeCpIndex(bTableType.constraint);
        this.buff.writeBoolean(bTableType.fieldNameList != null);
        if (bTableType.fieldNameList != null) {
            this.buff.writeInt(bTableType.fieldNameList.size());
            for (String fieldName : bTableType.fieldNameList) {
                this.buff.writeInt(this.addStringCPEntry(fieldName));
            }
        }
        this.buff.writeBoolean(bTableType.keyTypeConstraint != null);
        if (bTableType.keyTypeConstraint != null) {
            this.writeTypeCpIndex(bTableType.keyTypeConstraint);
        }
    }

    public void writeMarkdownDocAttachment(ByteBuf buf, MarkdownDocAttachment markdownDocAttachment) {
        ByteBuf birbuf = Unpooled.buffer();
        if (markdownDocAttachment == null) {
            birbuf.writeBoolean(false);
        } else {
            birbuf.writeBoolean(true);
            birbuf.writeInt(markdownDocAttachment.description == null ? -1 : this.addStringCPEntry(markdownDocAttachment.description));
            birbuf.writeInt(markdownDocAttachment.returnValueDescription == null ? -1 : this.addStringCPEntry(markdownDocAttachment.returnValueDescription));
            birbuf.writeInt(markdownDocAttachment.parameters.size());
            for (MarkdownDocAttachment.Parameter parameter : markdownDocAttachment.parameters) {
                birbuf.writeInt(parameter.name == null ? -1 : this.addStringCPEntry(parameter.name));
                birbuf.writeInt(parameter.description == null ? -1 : this.addStringCPEntry(parameter.description));
            }
        }
        int length = birbuf.nioBuffer().limit();
        buf.writeInt(length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void throwUnimplementedError(BType bType) {
        throw new AssertionError((Object)("Type serialization is not implemented for " + bType.getClass()));
    }

    private int addStringCPEntry(String value) {
        return this.cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    private int addIntCPEntry(long value) {
        return this.cp.addCPEntry(new CPEntry.IntegerCPEntry(value));
    }

    private int addFloatCPEntry(double value) {
        return this.cp.addCPEntry(new CPEntry.FloatCPEntry(value));
    }

    private int addByteCPEntry(int value) {
        return this.cp.addCPEntry(new CPEntry.ByteCPEntry(value));
    }

    private void writeValue(Object value, BType typeOfValue) {
        ByteBuf byteBuf = Unpooled.buffer();
        switch (typeOfValue.tag) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                byteBuf.writeInt(this.addIntCPEntry((Long)value));
                break;
            }
            case 2: {
                int byteValue = ((Number)value).intValue();
                byteBuf.writeInt(this.addByteCPEntry(byteValue));
                break;
            }
            case 3: {
                double doubleVal = value instanceof String ? Double.parseDouble((String)value) : ((Number)value).doubleValue();
                byteBuf.writeInt(this.addFloatCPEntry(doubleVal));
                break;
            }
            case 4: 
            case 5: 
            case 44: {
                byteBuf.writeInt(this.addStringCPEntry(String.valueOf(value)));
                break;
            }
            case 6: {
                byteBuf.writeBoolean((Boolean)value);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("finite type value is not supported for type: " + typeOfValue);
            }
        }
        int length = byteBuf.nioBuffer().limit();
        this.buff.writeInt(length);
        this.buff.writeBytes(byteBuf.nioBuffer().array(), 0, length);
    }

    private void writeTypeInclusions(List<BType> inclusions) {
        this.buff.writeInt(inclusions.size());
        for (BType inclusion : inclusions) {
            this.writeTypeCpIndex(inclusion);
        }
    }
}

