/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.ballerina.tools.diagnostics.Location;
import io.netty.buffer.ByteBuf;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;

public class BIRWriterUtils {
    public static void writePosition(Location pos, ByteBuf buf, ConstantPool cp) {
        int sLine = Integer.MIN_VALUE;
        int eLine = Integer.MIN_VALUE;
        int sCol = Integer.MIN_VALUE;
        int eCol = Integer.MIN_VALUE;
        String sourceFileName = "";
        if (pos != null) {
            sLine = pos.lineRange().startLine().line();
            eLine = pos.lineRange().endLine().line();
            sCol = pos.lineRange().startLine().offset();
            eCol = pos.lineRange().endLine().offset();
            if (pos.lineRange().filePath() != null) {
                sourceFileName = pos.lineRange().filePath();
            }
        }
        buf.writeInt(BIRWriterUtils.addStringCPEntry(sourceFileName, cp));
        buf.writeInt(sLine);
        buf.writeInt(sCol);
        buf.writeInt(eLine);
        buf.writeInt(eCol);
    }

    public static int addStringCPEntry(String value, ConstantPool cp) {
        return cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    public static int addPkgCPEntry(String orgName, String name, String version, ConstantPool cp) {
        int orgCPIndex = BIRWriterUtils.addStringCPEntry(orgName, cp);
        int nameCPIndex = BIRWriterUtils.addStringCPEntry(name, cp);
        int versionCPIndex = BIRWriterUtils.addStringCPEntry(version, cp);
        return cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
    }

    public static int addPkgCPEntry(BIRNode.BIRPackage birPackage, ConstantPool cp) {
        return BIRWriterUtils.addPkgCPEntry(birPackage.org.value, birPackage.name.value, birPackage.version.value, cp);
    }

    public static int addPkgCPEntry(PackageID packageID, ConstantPool cp) {
        return BIRWriterUtils.addPkgCPEntry(packageID.orgName.value, packageID.name.value, packageID.version.value, cp);
    }
}

