/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.Resolution;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;

public class RepoHierarchy {
    private final Repo[] repos;
    private final RepoHierarchy[] dags;
    private static final boolean verbose = Boolean.parseBoolean(System.getenv("BALLERINA_REPO_LOOKUP_VERBOSE"));
    private static final PrintStream out = System.out;

    RepoHierarchy(Repo[] repos, RepoHierarchy[] dags) {
        this.repos = repos;
        this.dags = dags;
    }

    public Resolution resolve(PackageID pkg) {
        this.log1(pkg);
        for (int i = 0; i < this.repos.length; ++i) {
            Repo repo = this.repos[i];
            Patten patten = repo.calculate(pkg);
            if (patten != Patten.NULL) {
                List<CompilerInput> paths = new ArrayList<CompilerInput>();
                Converter converter = repo.getConverterInstance();
                try {
                    paths = patten.convertToSources(converter, pkg).collect(Collectors.toList());
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                this.log2(repo, patten, paths);
                if (paths.isEmpty()) continue;
                return new Resolution(this.getChildHierarchyForRepo(i), paths);
            }
            this.log3(repo);
        }
        this.log4();
        return Resolution.NOT_FOUND;
    }

    private void log1(PackageID pkg) {
        if (verbose) {
            out.println("Searching " + pkg);
        }
    }

    private void log2(Repo repo, Patten patten, List<CompilerInput> paths) {
        if (verbose) {
            out.println("\t looking in " + repo + " for patten\n\t\t" + patten + " and found \n\t\t\t" + paths);
        }
    }

    private void log3(Repo repo) {
        if (verbose) {
            out.println("\t skipping " + repo);
        }
    }

    private void log4() {
        if (verbose) {
            out.println("\t could not find");
        }
    }

    private RepoHierarchy getChildHierarchyForRepo(int repoIndex) {
        if (repoIndex > 0) {
            return this.dags[repoIndex - 1];
        }
        return this;
    }

    public String toString() {
        return "{r:" + Arrays.toString(this.repos) + ", d:" + Arrays.toString(this.dags) + "}";
    }
}

