/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.ZipConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.RepoUtils;

public class PathBaloRepo
implements Repo<Path> {
    private static final Pattern semVerPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private final Manifest manifest;
    private Map<PackageID, Manifest> dependencyManifests;
    private ZipConverter zipConverter;

    public PathBaloRepo(Manifest manifest, Map<PackageID, Manifest> dependencyManifests) {
        this.manifest = manifest;
        this.dependencyManifests = dependencyManifests;
        this.zipConverter = new ZipConverter(Paths.get("", new String[0]));
    }

    @Override
    public Patten calculate(PackageID moduleID) {
        Matcher semverMatcher;
        if (null == this.manifest) {
            return Patten.NULL;
        }
        Optional<Dependency> tomlDependency = this.manifest.getDependencies().stream().filter(dep -> dep.getOrgName().equals(moduleID.orgName.value) && dep.getModuleName().equals(moduleID.name.value) && null != dep.getMetadata().getPath()).findFirst();
        if (!tomlDependency.isPresent()) {
            return Patten.NULL;
        }
        Dependency dep2 = tomlDependency.get();
        Path baloPath = dep2.getMetadata().getPath();
        if (Files.notExists(baloPath, new LinkOption[0])) {
            throw new BLangCompilerException("balo file for dependency [" + dep2.getModuleID() + "] does not exists: " + dep2.getMetadata().getPath().toAbsolutePath().normalize());
        }
        if (!Files.isRegularFile(baloPath, new LinkOption[0])) {
            throw new BLangCompilerException("balo file for dependency [" + dep2.getModuleID() + "] is not a file: " + dep2.getMetadata().getPath().toAbsolutePath().normalize());
        }
        if (moduleID.version.value.isEmpty() && null != dep2.getMetadata().getVersion() && (semverMatcher = semVerPattern.matcher(dep2.getMetadata().getVersion())).matches()) {
            moduleID.version = new Name(dep2.getMetadata().getVersion());
        }
        Manifest manifestFromBalo = RepoUtils.getManifestFromBalo(baloPath.toAbsolutePath());
        if (moduleID.version.value.isEmpty()) {
            moduleID.version = new Name(manifestFromBalo.getProject().getVersion());
        }
        this.dependencyManifests.put(moduleID, manifestFromBalo);
        return new Patten(Patten.path(baloPath.toAbsolutePath().toString(), "src", dep2.getModuleName()), Patten.WILDCARD_SOURCE);
    }

    @Override
    public Converter<Path> getConverterInstance() {
        return this.zipConverter;
    }

    public String toString() {
        return "{t:'PathBaloRepo', c:'" + this.zipConverter + "'}";
    }
}

