/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.nio.file.Path;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.ZipConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;

public class ZipRepo
implements Repo<Path> {
    private final ZipConverter converter;

    public ZipRepo(Path pathToHiddenDir) {
        this.converter = new ZipConverter(pathToHiddenDir);
    }

    @Override
    public Patten calculate(PackageID pkg) {
        String orgName = pkg.getOrgName().getValue();
        String pkgName = pkg.getName().getValue();
        String version = pkg.getPackageVersion().getValue();
        if (version.isEmpty()) {
            return new Patten(Patten.path("repo", orgName, pkgName), Patten.LATEST_VERSION_DIR, Patten.path(pkgName + ".zip"), Patten.path("src"), Patten.WILDCARD_SOURCE);
        }
        return new Patten(Patten.path("repo", orgName, pkgName, version), Patten.path(pkgName + ".zip"), Patten.path("src"), Patten.WILDCARD_SOURCE);
    }

    @Override
    public Converter<Path> getConverterInstance() {
        return this.converter;
    }

    public String toString() {
        return "{t:'ZipRepo', c:'" + this.converter + "'}";
    }
}

