/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableMultiKeyExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangRestMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class IsolationAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<IsolationAnalyzer> ISOLATION_ANALYZER_KEY = new CompilerContext.Key();
    private static final String VALUE_LANG_LIB = "lang.value";
    private static final String CLONE_LANG_LIB_METHOD = "clone";
    private static final String CLONE_READONLY_LANG_LIB_METHOD = "cloneReadOnly";
    private SymbolEnv env;
    private SymbolTable symTable;
    private SymbolResolver symResolver;
    private Names names;
    private Types types;
    private BLangDiagnosticLog dlog;
    private boolean inferredIsolated = true;
    private boolean inLockStatement = false;
    private Stack<PotentiallyInvalidExpressionInfo> copyInLockInfoStack = new Stack();
    private Stack<Set<BSymbol>> isolatedLetVarStack = new Stack();

    private IsolationAnalyzer(CompilerContext context) {
        context.put(ISOLATION_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
    }

    public static IsolationAnalyzer getInstance(CompilerContext context) {
        IsolationAnalyzer isolationAnalyzer = context.get(ISOLATION_ANALYZER_KEY);
        if (isolationAnalyzer == null) {
            isolationAnalyzer = new IsolationAnalyzer(context);
        }
        return isolationAnalyzer;
    }

    private void analyzeNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        if (node != null) {
            node.accept(this);
        }
        this.env = prevEnv;
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.analyzeNode(pkgNode, pkgEnv);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.ISOLATION_ANALYZE)) {
            return;
        }
        for (BLangTypeDefinition typeDefinition : pkgNode.typeDefinitions) {
            this.analyzeNode(typeDefinition.typeNode, this.env);
        }
        for (BLangClassDefinition classDefinition : pkgNode.classDefinitions) {
            if (classDefinition.flagSet.contains((Object)Flag.ANONYMOUS) && this.isIsolated(classDefinition.type.flags)) {
                classDefinition.flagSet.add(Flag.ISOLATED);
                classDefinition.symbol.flags |= 0x20000000L;
            }
            this.analyzeNode(classDefinition, this.env);
        }
        for (BLangFunction function : pkgNode.functions) {
            this.analyzeNode(function, this.env);
        }
        for (BLangSimpleVariable globalVar : pkgNode.globalVars) {
            this.analyzeNode(globalVar, this.env);
        }
        for (BLangTestablePackage testablePkg : pkgNode.testablePkgs) {
            this.analyze(testablePkg);
        }
        pkgNode.completedPhases.add(CompilerPhase.ISOLATION_ANALYZE);
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangFunction funcNode) {
        boolean prevInferredIsolated = this.inferredIsolated;
        this.inferredIsolated = true;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        for (BLangSimpleVariable requiredParam : funcNode.requiredParams) {
            if (!requiredParam.symbol.defaultableParam) continue;
            this.analyzeNode(requiredParam.expr, funcEnv);
        }
        this.analyzeNode(funcNode.body, funcEnv);
        if (this.isBallerinaModule(this.env.enclPkg) && !this.isIsolated(funcNode.symbol.flags) && this.inferredIsolated && !Symbols.isFlagOn(funcNode.symbol.flags, 0x800000L)) {
            this.dlog.warning(funcNode.pos, DiagnosticWarningCode.FUNCTION_CAN_BE_MARKED_ISOLATED, funcNode.name);
        }
        this.inferredIsolated = this.inferredIsolated && prevInferredIsolated;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        for (BLangStatement statement : body.stmts) {
            this.analyzeNode(statement, bodyEnv);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        this.analyzeNode(body.expr, bodyEnv);
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        this.inferredIsolated = false;
    }

    @Override
    public void visit(BLangService serviceNode) {
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.analyzeNode(typeDefinition.typeNode, this.env);
    }

    @Override
    public void visit(BLangConstant constant) {
        BLangType typeNode = constant.typeNode;
        if (typeNode != null) {
            this.analyzeNode(typeNode, this.env);
        }
        this.analyzeNode(constant.expr, this.env);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        BLangType typeNode = varNode.typeNode;
        if (typeNode != null && (typeNode.type == null || typeNode.type.tsymbol == null || typeNode.type.tsymbol.owner.getKind() != SymbolKind.PACKAGE)) {
            this.analyzeNode(typeNode, this.env);
        }
        BVarSymbol symbol = varNode.symbol;
        long flags = symbol.flags;
        BLangExpression expr = varNode.expr;
        BType fieldType = varNode.type;
        boolean isolatedClassField = this.isIsolatedClassField();
        if (isolatedClassField && this.isExpectedToBeAPrivateField(symbol, fieldType) && !Symbols.isFlagOn(flags, 1024L)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_NON_PRIVATE_MUTABLE_FIELD_IN_ISOLATED_OBJECT, new Object[0]);
        }
        if (expr == null) {
            return;
        }
        if (isolatedClassField || varNode.flagSet.contains((Object)Flag.ISOLATED)) {
            this.validateIsolatedExpression(fieldType, expr);
        }
        this.analyzeNode(expr, this.env);
        BSymbol owner = symbol.owner;
        if (owner != null && (owner.tag & 0x10000000) == 0x10000000 && this.isIsolatedExpression(expr, false)) {
            this.isolatedLetVarStack.peek().add(symbol);
        }
        if (Symbols.isFlagOn(flags, 0x800000L)) {
            this.inferredIsolated = false;
            if (this.isInIsolatedFunction(this.env.enclInvokable)) {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_WORKER_DECLARATION_IN_ISOLATED_FUNCTION, new Object[0]);
            }
        }
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        BLangExpression expr = annAttachmentNode.expr;
        if (expr != null) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        for (BLangStatement statement : blockNode.stmts) {
            this.analyzeNode(statement, blockEnv);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        BLangSimpleVariable var = varDefNode.var;
        if (var.expr == null) {
            return;
        }
        this.analyzeNode(var, this.env);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        BLangExpression varRef = assignNode.varRef;
        this.analyzeNode(varRef, this.env);
        BLangExpression expr = assignNode.expr;
        this.analyzeNode(expr, this.env);
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        if (varRef.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            BLangFieldBasedAccess fieldAccess = (BLangFieldBasedAccess)varRef;
            if (enclInvokable != null && enclInvokable.getKind() == NodeKind.FUNCTION && ((BLangFunction)enclInvokable).objInitFunction && this.isIsolatedObjectFieldAccessViaSelf(fieldAccess, false)) {
                this.validateIsolatedExpression(((BField)((BObjectType)enclInvokable.symbol.owner.type).fields.get((Object)fieldAccess.field.value)).type, expr);
            }
        }
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.analyzeNode(compoundAssignNode.varRef, this.env);
        this.analyzeNode(compoundAssignNode.expr, this.env);
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.analyzeNode(retryNode.retrySpec, this.env);
        this.analyzeNode(retryNode.retryBody, this.env);
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.analyzeNode(retryTransaction.retrySpec, this.env);
        this.analyzeNode(retryTransaction.transaction, this.env);
    }

    @Override
    public void visit(BLangRetrySpec retrySpec) {
        for (BLangExpression argExpr : retrySpec.argExprs) {
            this.analyzeNode(argExpr, this.env);
        }
    }

    @Override
    public void visit(BLangContinue continueNode) {
    }

    @Override
    public void visit(BLangBreak breakNode) {
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.analyzeNode(returnNode.expr, this.env);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.analyzeNode(panicNode.expr, this.env);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.analyzeNode(xmlnsStmtNode.xmlnsDecl, this.env);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.analyzeNode(exprStmtNode.expr, this.env);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.analyzeNode(ifNode.expr, this.env);
        this.analyzeNode(ifNode.body, this.env);
        this.analyzeNode(ifNode.elseStmt, this.env);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        for (BLangNode clause : queryAction.getQueryClauses()) {
            this.analyzeNode(clause, this.env);
        }
        this.analyzeNode(queryAction.doClause, this.env);
    }

    @Override
    public void visit(BLangMatch matchNode) {
        this.analyzeNode(matchNode.expr, this.env);
        for (BLangMatch.BLangMatchBindingPatternClause patternClause : matchNode.patternClauses) {
            this.analyzeNode(patternClause, this.env);
        }
    }

    @Override
    public void visit(BLangMatch.BLangMatchTypedBindingPatternClause patternClauseNode) {
        this.analyzeNode(patternClauseNode.variable, this.env);
        this.analyzeNode(patternClauseNode.body, this.env);
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        this.analyzeNode(matchStatement.expr, this.env);
        for (BLangMatchClause matchClause : matchStatement.matchClauses) {
            this.analyzeNode(matchClause, this.env);
        }
        if (matchStatement.onFailClause != null) {
            this.analyzeNode(matchStatement.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangMatchGuard matchGuard) {
        this.analyzeNode(matchGuard.expr, this.env);
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern) {
        this.analyzeNode(constMatchPattern.expr, this.env);
    }

    @Override
    public void visit(BLangWildCardMatchPattern wildCardMatchPattern) {
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern) {
        for (BLangMatchPattern matchPattern : listMatchPattern.matchPatterns) {
            this.analyzeNode(matchPattern, this.env);
        }
        if (listMatchPattern.restMatchPattern != null) {
            this.analyzeNode(listMatchPattern.restMatchPattern, this.env);
        }
    }

    @Override
    public void visit(BLangRestMatchPattern restMatchPattern) {
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern) {
        this.analyzeNode(varBindingPattern.getBindingPattern(), this.env);
    }

    @Override
    public void visit(BLangCaptureBindingPattern captureBindingPattern) {
    }

    @Override
    public void visit(BLangListBindingPattern listBindingPattern) {
        for (BLangBindingPattern bindingPattern : listBindingPattern.bindingPatterns) {
            this.analyzeNode(bindingPattern, this.env);
        }
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        for (BLangMatchPattern matchPattern : matchClause.matchPatterns) {
            this.analyzeNode(matchPattern, this.env);
        }
        BLangMatchGuard matchGuard = matchClause.matchGuard;
        if (matchGuard != null) {
            this.analyzeNode(matchGuard, this.env);
        }
        this.analyzeNode(matchClause.blockStmt, this.env);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.analyzeNode(foreach.collection, this.env);
        this.analyzeNode(foreach.body, this.env);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.analyzeNode((BLangNode)((Object)fromClause.getVariableDefinitionNode()), this.env);
        this.analyzeNode(fromClause.collection, this.env);
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.analyzeNode((BLangNode)((Object)joinClause.getVariableDefinitionNode()), this.env);
        this.analyzeNode(joinClause.collection, this.env);
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable letVarDeclaration : letClause.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVarDeclaration.definitionNode), this.env);
        }
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.analyzeNode(onClause.lhsExpr, this.env);
        this.analyzeNode(onClause.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        this.analyzeNode(orderKeyClause.expression, this.env);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        for (OrderKeyNode orderKeyNode : orderByClause.orderByKeyList) {
            this.analyzeNode((BLangExpression)orderKeyNode.getOrderKey(), this.env);
        }
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.analyzeNode(selectClause.expression, this.env);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.analyzeNode(whereClause.expression, this.env);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.analyzeNode(doClause.body, this.env);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        this.analyzeNode(onFailClause.body, this.env);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.analyzeNode(onConflictClause.expression, this.env);
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.analyzeNode(limitClause.expression, this.env);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.analyzeNode(whileNode.expr, this.env);
        this.analyzeNode(whileNode.body, this.env);
    }

    @Override
    public void visit(BLangLock lockNode) {
        boolean prevInLockStatement = this.inLockStatement;
        this.inLockStatement = true;
        this.copyInLockInfoStack.push(new PotentiallyInvalidExpressionInfo(lockNode));
        this.analyzeNode(lockNode.body, SymbolEnv.createLockEnv(lockNode, this.env));
        PotentiallyInvalidExpressionInfo copyInLockInfo = this.copyInLockInfoStack.pop();
        this.inLockStatement = prevInLockStatement;
        Map<BSymbol, List<BLangSimpleVarRef>> accessedRestrictedVars = copyInLockInfo.accessedRestrictedVars;
        Set<BSymbol> accessedRestrictedVarKeys = accessedRestrictedVars.keySet();
        if (!accessedRestrictedVarKeys.isEmpty()) {
            if (accessedRestrictedVarKeys.size() > 1) {
                for (BSymbol accessedRestrictedVarKey : accessedRestrictedVarKeys) {
                    for (BLangSimpleVarRef varRef : accessedRestrictedVars.get(accessedRestrictedVarKey)) {
                        this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_USAGE_OF_MULTIPLE_RESTRICTED_VARS_IN_LOCK, new Object[0]);
                    }
                }
            }
            for (BLangSimpleVarRef varRef : copyInLockInfo.nonCaptureBindingPatternVarRefsOnLhs) {
                this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_ASSIGNMENT_IN_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
            for (BLangSimpleVarRef varRef : copyInLockInfo.copyInVarRefs) {
                this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_TRANSFER_INTO_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
            for (BLangSimpleVarRef varRef : copyInLockInfo.copyOutVarRefs) {
                this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_TRANSFER_OUT_OF_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
            for (BLangInvocation invocation : copyInLockInfo.nonIsolatedInvocations) {
                this.dlog.error(invocation.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_IN_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
        }
        if (this.copyInLockInfoStack.empty()) {
            return;
        }
        BLangLock lastCheckedLockNode = lockNode;
        for (int i = this.copyInLockInfoStack.size() - 1; i >= 0; --i) {
            PotentiallyInvalidExpressionInfo prevCopyInLockInfo = (PotentiallyInvalidExpressionInfo)this.copyInLockInfoStack.get(i);
            BLangLock outerLockNode = prevCopyInLockInfo.lockNode;
            if (!this.isEnclosedLockWithinSameFunction(lastCheckedLockNode, outerLockNode)) {
                return;
            }
            lastCheckedLockNode = outerLockNode;
            Map<BSymbol, List<BLangSimpleVarRef>> prevLockAccessedRestrictedVars = prevCopyInLockInfo.accessedRestrictedVars;
            for (Map.Entry<BSymbol, List<BLangSimpleVarRef>> entry : accessedRestrictedVars.entrySet()) {
                BSymbol key = entry.getKey();
                if (prevLockAccessedRestrictedVars.containsKey(key)) {
                    prevLockAccessedRestrictedVars.get(key).addAll((Collection<BLangSimpleVarRef>)entry.getValue());
                    continue;
                }
                prevLockAccessedRestrictedVars.put(key, entry.getValue());
            }
            if (!accessedRestrictedVars.isEmpty()) continue;
            prevCopyInLockInfo.nonCaptureBindingPatternVarRefsOnLhs.addAll(copyInLockInfo.nonCaptureBindingPatternVarRefsOnLhs);
            prevCopyInLockInfo.copyInVarRefs.addAll(copyInLockInfo.copyInVarRefs);
            prevCopyInLockInfo.copyOutVarRefs.addAll(copyInLockInfo.copyOutVarRefs);
            prevCopyInLockInfo.nonIsolatedInvocations.addAll(copyInLockInfo.nonIsolatedInvocations);
        }
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.analyzeNode(transactionNode.transactionBody, this.env);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.analyzeNode(stmt.varRef, this.env);
        this.analyzeNode(stmt.expr, this.env);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        this.analyzeNode(stmt.varRef, this.env);
        this.analyzeNode(stmt.expr, this.env);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        this.analyzeNode(stmt.varRef, this.env);
        this.analyzeNode(stmt.expr, this.env);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.inferredIsolated = false;
        if (this.isInIsolatedFunction(this.env.enclInvokable)) {
            this.dlog.error(forkJoin.pos, DiagnosticErrorCode.INVALID_FORK_STATEMENT_IN_ISOLATED_FUNCTION, new Object[0]);
        }
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        this.analyzeNode(rollbackNode.expr, this.env);
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
    }

    @Override
    public void visit(BLangConstRef constRef) {
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (keyValuePair.key.computedKey) {
                    this.analyzeNode(keyValuePair.key.expr, this.env);
                }
                this.analyzeNode(keyValuePair.valueExpr, this.env);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeNode((BLangRecordLiteral.BLangRecordVarNameField)field, this.env);
                continue;
            }
            this.analyzeNode(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, this.env);
        }
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        for (BLangExpression expression : varRefExpr.expressions) {
            this.analyzeNode(expression, this.env);
        }
        BLangExpression restParam = (BLangExpression)varRefExpr.restParam;
        if (restParam != null) {
            this.analyzeNode(restParam, this.env);
        }
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : varRefExpr.recordRefFields) {
            this.analyzeNode(recordRefField.variableReference, this.env);
        }
        BLangExpression restParam = (BLangExpression)varRefExpr.restParam;
        if (restParam != null) {
            this.analyzeNode(restParam, this.env);
        }
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        BLangType typeNode;
        this.analyzeNode(varRefExpr.message, this.env);
        BLangVariableReference cause = varRefExpr.cause;
        if (cause != null) {
            this.analyzeNode(cause, this.env);
        }
        for (BLangNamedArgsExpression namedArgsExpression : varRefExpr.detail) {
            this.analyzeNode(namedArgsExpression, this.env);
        }
        BLangVariableReference restVar = varRefExpr.restVar;
        if (restVar != null) {
            this.analyzeNode(restVar, this.env);
        }
        if ((typeNode = varRefExpr.typeNode) != null) {
            this.analyzeNode(typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BLangArrowFunction bLangArrowFunction;
        BType accessType = varRefExpr.type;
        BSymbol symbol = varRefExpr.symbol;
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        BLangType enclType = this.env.enclType;
        if (symbol == null) {
            return;
        }
        BLangNode parent = varRefExpr.parent;
        boolean isolatedModuleVariableReference = this.isIsolatedModuleVariableSymbol(symbol);
        if (this.inLockStatement) {
            PotentiallyInvalidExpressionInfo exprInfo = this.copyInLockInfoStack.peek();
            if (isolatedModuleVariableReference || this.isMethodCallOnSelfInIsolatedObject(varRefExpr, parent)) {
                this.addToAccessedRestrictedVars(exprInfo.accessedRestrictedVars, varRefExpr);
            }
            if (parent == null && varRefExpr.lhsVar) {
                if (!Names.SELF.value.equals(varRefExpr.variableName.value) && this.isInvalidCopyIn(varRefExpr, this.env)) {
                    exprInfo.nonCaptureBindingPatternVarRefsOnLhs.add(varRefExpr);
                }
            } else if ((!varRefExpr.lhsVar || parent != null && parent.getKind() != NodeKind.ASSIGNMENT) && !Names.SELF.value.equals(varRefExpr.variableName.value) && this.isInvalidCopyIn(varRefExpr, this.env)) {
                exprInfo.copyInVarRefs.add(varRefExpr);
            } else if (!varRefExpr.lhsVar && parent != null && this.isInvalidTransfer(varRefExpr, true)) {
                exprInfo.copyOutVarRefs.add(varRefExpr);
            }
        } else if (this.isMethodCallOnSelfInIsolatedObject(varRefExpr, parent)) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_REFERENCE_TO_SELF_IN_ISOLATED_OBJECT_OUTSIDE_LOCK, new Object[0]);
        }
        boolean inIsolatedFunction = this.isInIsolatedFunction(enclInvokable);
        boolean recordFieldDefaultValue = this.isRecordFieldDefaultValue(enclType);
        boolean objectFieldDefaultValue = !recordFieldDefaultValue && this.isObjectFieldDefaultValueRequiringIsolation(this.env);
        SymbolEnv enclEnv = this.env.enclEnv;
        if (inIsolatedFunction && enclInvokable == null) {
            bLangArrowFunction = (BLangArrowFunction)enclEnv.node;
            for (BLangSimpleVariable param : bLangArrowFunction.params) {
                if (param.symbol != symbol) continue;
                return;
            }
        }
        if (!recordFieldDefaultValue && !objectFieldDefaultValue && enclInvokable != null && this.isReferenceToVarDefinedInSameInvokable(symbol.owner, enclInvokable.symbol)) {
            return;
        }
        if (Symbols.isFlagOn(symbol.flags, 16384L)) {
            return;
        }
        if (Symbols.isFlagOn(symbol.flags, 4L) && this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(accessType)) {
            return;
        }
        if (this.isDefinitionReference(symbol)) {
            return;
        }
        if (enclEnv != null && enclEnv.node != null && enclEnv.node.getKind() == NodeKind.ARROW_EXPR) {
            bLangArrowFunction = (BLangArrowFunction)enclEnv.node;
            for (BLangSimpleVariable param : bLangArrowFunction.params) {
                if (param.symbol != symbol) continue;
                return;
            }
        }
        this.inferredIsolated = false;
        if (isolatedModuleVariableReference) {
            if (!this.inLockStatement) {
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_ISOLATED_VARIABLE_ACCESS_OUTSIDE_LOCK, new Object[0]);
            }
            return;
        }
        if (inIsolatedFunction) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_ACCESS_IN_ISOLATED_FUNCTION, new Object[0]);
            return;
        }
        if (recordFieldDefaultValue) {
            if (this.isBallerinaModule(this.env.enclPkg)) {
                this.dlog.warning(varRefExpr.pos, DiagnosticWarningCode.WARNING_INVALID_MUTABLE_ACCESS_AS_RECORD_DEFAULT, new Object[0]);
            } else {
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_ACCESS_AS_RECORD_DEFAULT, new Object[0]);
            }
        }
        if (objectFieldDefaultValue) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_ACCESS_AS_OBJECT_DEFAULT, new Object[0]);
        }
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        this.analyzeNode(fieldAccessExpr.expr, this.env);
        if (!this.isValidIsolatedObjectFieldAccessViaSelfOutsideLock(fieldAccessExpr, true)) {
            return;
        }
        if (this.inLockStatement) {
            this.addToAccessedRestrictedVars(this.copyInLockInfoStack.peek().accessedRestrictedVars, (BLangSimpleVarRef)fieldAccessExpr.expr);
            return;
        }
        this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_FIELD_ACCESS_IN_ISOLATED_OBJECT_OUTSIDE_LOCK, new Object[0]);
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.analyzeNode(indexAccessExpr.expr, this.env);
        this.analyzeNode(indexAccessExpr.indexExpr, this.env);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.analyzeInvocation(invocationExpr);
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
        if (!actionInvocationExpr.async) {
            this.analyzeInvocation(actionInvocationExpr);
            return;
        }
        this.inferredIsolated = false;
        if (actionInvocationExpr.functionPointerInvocation) {
            return;
        }
        if (this.isInIsolatedFunction(this.env.enclInvokable)) {
            this.dlog.error(actionInvocationExpr.pos, DiagnosticErrorCode.INVALID_ASYNC_INVOCATION_IN_ISOLATED_FUNCTION, new Object[0]);
        }
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        BSymbol initInvocationSymbol = typeInitExpr.initInvocation.symbol;
        if (initInvocationSymbol != null && !this.isIsolated(initInvocationSymbol.flags)) {
            this.inferredIsolated = false;
            if (this.isInIsolatedFunction(this.env.enclInvokable)) {
                this.dlog.error(typeInitExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INIT_EXPRESSION_IN_ISOLATED_FUNCTION, new Object[0]);
            } else if (this.isRecordFieldDefaultValue(this.env.enclType)) {
                if (this.isBallerinaModule(this.env.enclPkg)) {
                    this.dlog.warning(typeInitExpr.pos, DiagnosticWarningCode.WARNING_INVALID_NON_ISOLATED_INIT_EXPRESSION_AS_RECORD_DEFAULT, new Object[0]);
                } else {
                    this.dlog.error(typeInitExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INIT_EXPRESSION_AS_RECORD_DEFAULT, new Object[0]);
                }
            } else if (this.isObjectFieldDefaultValueRequiringIsolation(this.env)) {
                this.dlog.error(typeInitExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INIT_EXPRESSION_AS_OBJECT_DEFAULT, new Object[0]);
            }
        }
        for (BLangExpression expression : typeInitExpr.argsExpr) {
            this.analyzeNode(expression, this.env);
        }
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.analyzeNode(ternaryExpr.expr, this.env);
        this.analyzeNode(ternaryExpr.thenExpr, this.env);
        this.analyzeNode(ternaryExpr.elseExpr, this.env);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        for (BLangExpression expression : waitExpr.exprList) {
            this.analyzeNode(expression, this.env);
        }
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.analyzeNode(trapExpr.expr, this.env);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.analyzeNode(binaryExpr.lhsExpr, this.env);
        this.analyzeNode(binaryExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.analyzeNode(elvisExpr.lhsExpr, this.env);
        this.analyzeNode(elvisExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.analyzeNode(groupExpr.expression, this.env);
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        this.isolatedLetVarStack.push(new HashSet());
        for (BLangLetVariable letVarDeclaration : letExpr.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVarDeclaration.definitionNode), this.env);
        }
        this.analyzeNode(letExpr.expr, this.env);
        this.isolatedLetVarStack.pop();
    }

    @Override
    public void visit(BLangLetVariable letVariable) {
        this.analyzeNode((BLangNode)((Object)letVariable.definitionNode.getVariable()), this.env);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        for (BLangExpression expr : listConstructorExpr.exprs) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        for (BLangRecordLiteral recordLiteral : tableConstructorExpr.recordLiteralList) {
            this.analyzeNode(recordLiteral, this.env);
        }
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.analyzeNode(unaryExpr.expr, this.env);
    }

    @Override
    public void visit(BLangTypedescExpr typedescExpr) {
        this.analyzeNode(typedescExpr.typeNode, this.env);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.analyzeNode(conversionExpr.typeNode, this.env);
        this.analyzeNode(conversionExpr.expr, this.env);
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.analyzeNode(xmlAttribute.name, this.env);
        this.analyzeNode(xmlAttribute.value, this.env);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        for (BLangExpression child : xmlElementLiteral.children) {
            this.analyzeNode(child, this.env);
        }
        for (BLangXMLAttribute attribute : xmlElementLiteral.attributes) {
            this.analyzeNode(attribute, this.env);
        }
        for (BLangXMLNS inlineNamespace : xmlElementLiteral.inlineNamespaces) {
            this.analyzeNode(inlineNamespace, this.env);
        }
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        for (BLangExpression expr : xmlTextLiteral.textFragments) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        for (BLangExpression textFragment : xmlCommentLiteral.textFragments) {
            this.analyzeNode(textFragment, this.env);
        }
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        for (BLangExpression dataFragment : xmlProcInsLiteral.dataFragments) {
            this.analyzeNode(dataFragment, this.env);
        }
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        for (BLangExpression textFragment : xmlQuotedString.textFragments) {
            this.analyzeNode(textFragment, this.env);
        }
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        for (BLangExpression expr : stringTemplateLiteral.exprs) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        for (BLangExpression insertion : rawTemplateLiteral.insertions) {
            this.analyzeNode(insertion, this.env);
        }
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        SymbolEnv arrowFunctionEnv = SymbolEnv.createArrowFunctionSymbolEnv(bLangArrowFunction, this.env);
        this.analyzeNode(bLangArrowFunction.body, arrowFunctionEnv);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.analyzeNode(intRangeExpression.startExpr, this.env);
        this.analyzeNode(intRangeExpression.endExpr, this.env);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.analyzeNode(bLangVarArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.analyzeNode(bLangNamedArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.analyzeNode(checkedExpr.expr, this.env);
    }

    @Override
    public void visit(BLangDo doNode) {
        this.analyzeNode(doNode.body, this.env);
        if (doNode.onFailClause != null) {
            this.analyzeNode(doNode.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangFail failExpr) {
        this.analyzeNode(failExpr.expr, this.env);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        this.analyzeNode(checkPanickedExpr.expr, this.env);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.analyzeNode(serviceConstructorExpr.serviceNode, this.env);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.analyzeNode(typeTestExpr.expr, this.env);
        this.analyzeNode(typeTestExpr.typeNode, this.env);
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.analyzeNode(annotAccessExpr.expr, this.env);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        for (BLangNode clause : queryExpr.getQueryClauses()) {
            this.analyzeNode(clause, this.env);
        }
    }

    @Override
    public void visit(BLangTableMultiKeyExpr tableMultiKeyExpr) {
        for (BLangExpression value : tableMultiKeyExpr.multiKeyIndexExprs) {
            this.analyzeNode(value, this.env);
        }
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.analyzeNode(arrayType.getElementType(), this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.analyzeNode(constrainedType.constraint, this.env);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.analyzeNode(streamType.constraint, this.env);
        this.analyzeNode(streamType.error, this.env);
    }

    @Override
    public void visit(BLangTableTypeNode tableType) {
        this.analyzeNode(tableType.constraint, this.env);
        if (tableType.tableKeyTypeConstraint != null) {
            this.analyzeNode(tableType.tableKeyTypeConstraint.keyType, this.env);
        }
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        for (BLangVariable param : functionTypeNode.params) {
            this.analyzeNode(param.typeNode, this.env);
        }
        this.analyzeNode(functionTypeNode.returnTypeNode, this.env);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        for (BLangType memberTypeNode : unionTypeNode.memberTypeNodes) {
            this.analyzeNode(memberTypeNode, this.env);
        }
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            this.analyzeNode(constituentTypeNode, this.env);
        }
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        SymbolEnv objectEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, this.env);
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            this.analyzeNode(field, objectEnv);
        }
        for (BLangSimpleVariable referencedField : objectTypeNode.referencedFields) {
            this.analyzeNode(referencedField, objectEnv);
        }
        BLangFunction initFunction = objectTypeNode.initFunction;
        if (initFunction != null) {
            this.analyzeNode(initFunction, objectEnv);
        }
        for (BLangFunction function : objectTypeNode.functions) {
            this.analyzeNode(function, objectEnv);
        }
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        SymbolEnv classEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, this.env);
        for (BLangSimpleVariable bLangSimpleVariable : classDefinition.fields) {
            this.analyzeNode(bLangSimpleVariable, classEnv);
        }
        for (BLangSimpleVariable field : classDefinition.referencedFields) {
            this.analyzeNode(field, classEnv);
        }
        BLangFunction initFunction = classDefinition.initFunction;
        if (initFunction != null) {
            this.analyzeNode(initFunction, classEnv);
        }
        for (BLangFunction function : classDefinition.functions) {
            this.analyzeNode(function, classEnv);
        }
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        this.visit(objectConstructorExpression.typeInit);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        SymbolEnv typeEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            this.analyzeNode(field, typeEnv);
        }
        for (BLangSimpleVariable referencedField : recordTypeNode.referencedFields) {
            this.analyzeNode(referencedField, typeEnv);
        }
        BLangType restFieldType = recordTypeNode.restFieldType;
        if (restFieldType != null) {
            this.analyzeNode(restFieldType, typeEnv);
        }
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        for (BLangExpression expression : finiteTypeNode.valueSpace) {
            this.analyzeNode(expression, this.env);
        }
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        for (BLangType memberTypeNode : tupleTypeNode.memberTypeNodes) {
            this.analyzeNode(memberTypeNode, this.env);
        }
        this.analyzeNode(tupleTypeNode.restParamType, this.env);
    }

    @Override
    public void visit(BLangErrorType errorTypeNode) {
        this.analyzeNode(errorTypeNode.detailType, this.env);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.analyzeNode(bLangTupleVariable.typeNode, this.env);
        BLangExpression expr = bLangTupleVariable.expr;
        if (expr != null) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.analyzeNode(bLangTupleVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        this.analyzeNode(bLangRecordVariable.typeNode, this.env);
        BLangExpression expr = bLangRecordVariable.expr;
        if (expr != null) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.analyzeNode(bLangRecordVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.analyzeNode(bLangErrorVariable.typeNode, this.env);
        this.analyzeNode(bLangErrorVariable.expr, this.env);
        for (BLangErrorVariable.BLangErrorDetailEntry bLangErrorDetailEntry : bLangErrorVariable.detail) {
            this.analyzeNode(bLangErrorDetailEntry.valueBindingPattern, this.env);
        }
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.analyzeNode(bLangErrorVariableDef.errorVariable, this.env);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause matchStaticBindingPatternClause) {
        this.analyzeNode(matchStaticBindingPatternClause.body, this.env);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause matchStmtStructuredBindingPatternClause) {
        this.analyzeNode(matchStmtStructuredBindingPatternClause.bindingPatternVariable, this.env);
        BLangExpression typeGuardExpr = matchStmtStructuredBindingPatternClause.typeGuardExpr;
        if (typeGuardExpr != null) {
            this.analyzeNode(typeGuardExpr, this.env);
        }
        this.analyzeNode(matchStmtStructuredBindingPatternClause.body, this.env);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValuePair : waitForAllExpr.keyValuePairs) {
            this.analyzeNode(keyValuePair, this.env);
        }
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        BLangExpression valueExpr;
        BLangExpression keyExpr = waitKeyValue.keyExpr;
        if (keyExpr != null) {
            this.analyzeNode(keyExpr, this.env);
        }
        if ((valueExpr = waitKeyValue.valueExpr) != null) {
            this.analyzeNode(valueExpr, this.env);
        }
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        BLangExpression childIndex = xmlNavigation.childIndex;
        if (childIndex != null) {
            this.analyzeNode(childIndex, this.env);
        }
    }

    private void analyzeInvocation(BLangInvocation invocationExpr) {
        BInvokableSymbol symbol;
        List<BLangExpression> requiredArgs = invocationExpr.requiredArgs;
        List<BLangExpression> restArgs = invocationExpr.restArgs;
        BLangExpression expr = invocationExpr.expr;
        if (expr != null && (requiredArgs.isEmpty() || requiredArgs.get(0) != expr)) {
            this.analyzeNode(expr, this.env);
        }
        if ((symbol = (BInvokableSymbol)invocationExpr.symbol) == null || symbol.getKind() == SymbolKind.ERROR_CONSTRUCTOR) {
            this.analyzeArgs(requiredArgs, restArgs);
            return;
        }
        boolean inIsolatedFunction = this.isInIsolatedFunction(this.env.enclInvokable);
        boolean recordFieldDefaultValue = this.isRecordFieldDefaultValue(this.env.enclType);
        boolean objectFieldDefaultValueRequiringIsolation = this.isObjectFieldDefaultValueRequiringIsolation(this.env);
        boolean expectsIsolation = inIsolatedFunction || recordFieldDefaultValue || objectFieldDefaultValueRequiringIsolation;
        boolean isolatedFunctionCall = this.isIsolated(symbol.type.flags);
        if (isolatedFunctionCall) {
            if (!expectsIsolation) {
                this.analyzeArgs(requiredArgs, restArgs);
                return;
            }
            this.analyzeArgIsolatedness(requiredArgs, restArgs, symbol);
            return;
        }
        this.analyzeArgs(requiredArgs, restArgs);
        if (this.inLockStatement && !isolatedFunctionCall) {
            this.copyInLockInfoStack.peek().nonIsolatedInvocations.add(invocationExpr);
        }
        if (Symbols.isFlagOn(symbol.flags, 0x40000000L)) {
            return;
        }
        this.inferredIsolated = false;
        if (inIsolatedFunction) {
            this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_IN_ISOLATED_FUNCTION, new Object[0]);
            return;
        }
        if (recordFieldDefaultValue) {
            if (this.isBallerinaModule(this.env.enclPkg)) {
                this.dlog.warning(invocationExpr.pos, DiagnosticWarningCode.WARNING_INVALID_NON_ISOLATED_INVOCATION_AS_RECORD_DEFAULT, new Object[0]);
            } else {
                this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_AS_RECORD_DEFAULT, new Object[0]);
            }
        }
        if (objectFieldDefaultValueRequiringIsolation) {
            this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_AS_OBJECT_DEFAULT, new Object[0]);
        }
    }

    private void analyzeArgs(List<BLangExpression> requiredArgs, List<BLangExpression> restArgs) {
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>(requiredArgs);
        args.addAll(restArgs);
        for (BLangExpression argExpr : args) {
            this.analyzeNode(argExpr, this.env);
        }
    }

    private void analyzeAndSetArrowFuncFlagForIsolatedParamArg(BLangExpression arg) {
        BLangExpression argExpr;
        if (arg.getKind() == NodeKind.REST_ARGS_EXPR) {
            BLangExpression expr = ((BLangRestArgsExpression)arg).expr;
            if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_EXPR) {
                this.analyzeNode(arg, this.env);
                return;
            }
            for (BLangExpression expression : ((BLangListConstructorExpr)expr).exprs) {
                this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(expression);
            }
            return;
        }
        boolean namedArg = arg.getKind() == NodeKind.NAMED_ARGS_EXPR;
        BLangExpression bLangExpression = argExpr = namedArg ? ((BLangNamedArgsExpression)arg).expr : arg;
        if (argExpr.getKind() != NodeKind.ARROW_EXPR) {
            this.analyzeNode(argExpr, this.env);
            return;
        }
        boolean prevInferredIsolatedness = this.inferredIsolated;
        this.inferredIsolated = true;
        this.analyzeNode(argExpr, this.env);
        if (this.inferredIsolated) {
            BInvokableType invokableType = (BInvokableType)argExpr.type;
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
            BInvokableTypeSymbol dupInvokableTypeSymbol = new BInvokableTypeSymbol(tsymbol.tag, tsymbol.flags | 0x20000000L, tsymbol.pkgID, null, tsymbol.owner, tsymbol.pos, tsymbol.origin);
            BInvokableType dupInvokableType = new BInvokableType(invokableType.paramTypes, invokableType.restType, invokableType.retType, dupInvokableTypeSymbol);
            dupInvokableType.flags |= 0x20000000L;
            dupInvokableTypeSymbol.type = dupInvokableType;
            argExpr.type = dupInvokableType;
            if (namedArg) {
                arg.type = dupInvokableType;
            }
        }
        this.inferredIsolated = prevInferredIsolatedness && this.inferredIsolated;
    }

    private void analyzeArgIsolatedness(List<BLangExpression> requiredArgs, List<BLangExpression> restArgs, BInvokableSymbol symbol) {
        List<BVarSymbol> params = symbol.params;
        int paramsCount = params.size();
        if (restArgs.isEmpty()) {
            int nextParamIndex = 0;
            for (BLangExpression arg : requiredArgs) {
                if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                    BVarSymbol varSymbol = params.get(nextParamIndex++);
                    if (!Symbols.isFlagOn(varSymbol.flags, 0x40000000L)) {
                        this.analyzeNode(arg, this.env);
                        continue;
                    }
                    this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                    if (Symbols.isFlagOn(arg.type.flags, 0x20000000L)) continue;
                    this.dlog.error(arg.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
                    continue;
                }
                String name = ((BLangNamedArgsExpression)arg).name.value;
                for (BVarSymbol param : params) {
                    if (!param.name.value.equals(name)) continue;
                    if (!Symbols.isFlagOn(param.flags, 0x40000000L)) {
                        this.analyzeNode(arg, this.env);
                        continue;
                    }
                    this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                    if (Symbols.isFlagOn(arg.type.flags, 0x20000000L)) continue;
                    this.dlog.error(arg.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
                }
            }
            return;
        }
        int reqArgCount = requiredArgs.size();
        for (int i = 0; i < reqArgCount; ++i) {
            BLangExpression arg = requiredArgs.get(i);
            if (!Symbols.isFlagOn(params.get((int)i).flags, 0x40000000L)) {
                this.analyzeNode(arg, this.env);
                continue;
            }
            if (arg.type == this.symTable.semanticError) continue;
            this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
            if (Symbols.isFlagOn(arg.type.flags, 0x20000000L)) continue;
            this.dlog.error(arg.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
        }
        if (restArgs.get(restArgs.size() - 1).getKind() == NodeKind.REST_ARGS_EXPR) {
            BLangRestArgsExpression varArg = (BLangRestArgsExpression)restArgs.get(restArgs.size() - 1);
            BType varArgType = varArg.type;
            Location varArgPos = varArg.pos;
            if (varArgType == this.symTable.semanticError) {
                return;
            }
            if (reqArgCount == paramsCount) {
                if (!Symbols.isFlagOn(symbol.restParam.flags, 0x40000000L)) {
                    this.analyzeNode(varArg, this.env);
                    return;
                }
                this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(varArg);
                this.analyzeVarArgIsolatedness(varArg, varArgPos);
                return;
            }
            if (reqArgCount < paramsCount) {
                BLangExpression arg;
                BLangListConstructorExpr listConstructorExpr;
                BTupleType tupleType = (BTupleType)varArgType;
                List<BType> memberTypes = tupleType.tupleTypes;
                BLangExpression varArgExpr = varArg.expr;
                boolean listConstrVarArg = varArgExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR;
                BLangListConstructorExpr bLangListConstructorExpr = listConstructorExpr = listConstrVarArg ? (BLangListConstructorExpr)varArgExpr : null;
                if (!listConstrVarArg) {
                    this.analyzeNode(varArg, this.env);
                }
                int tupleIndex = 0;
                for (int i = reqArgCount; i < paramsCount; ++i) {
                    if (!Symbols.isFlagOn(params.get((int)i).flags, 0x40000000L)) {
                        if (listConstrVarArg) {
                            this.analyzeNode(listConstructorExpr.exprs.get(tupleIndex), this.env);
                        }
                        ++tupleIndex;
                        continue;
                    }
                    BType type = memberTypes.get(tupleIndex);
                    if (listConstrVarArg) {
                        BLangExpression arg2 = listConstructorExpr.exprs.get(tupleIndex);
                        this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg2);
                        type = arg2.type;
                    }
                    if (!Symbols.isFlagOn(type.flags, 0x20000000L)) {
                        this.dlog.error(varArgPos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
                    }
                    ++tupleIndex;
                }
                BVarSymbol restParam = symbol.restParam;
                if (restParam == null) {
                    return;
                }
                if (!Symbols.isFlagOn(restParam.flags, 0x40000000L)) {
                    if (listConstructorExpr == null) {
                        return;
                    }
                    List<BLangExpression> exprs = listConstructorExpr.exprs;
                    for (int i = tupleIndex; i < exprs.size(); ++i) {
                        this.analyzeNode(exprs.get(i), this.env);
                    }
                    return;
                }
                int memberTypeCount = memberTypes.size();
                if (tupleIndex < memberTypeCount) {
                    for (int i = tupleIndex; i < memberTypeCount; ++i) {
                        BType type = memberTypes.get(i);
                        if (listConstrVarArg) {
                            arg = listConstructorExpr.exprs.get(i);
                            this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                            type = arg.type;
                        }
                        if (Symbols.isFlagOn(type.flags, 0x20000000L)) continue;
                        this.dlog.error(varArgPos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
                    }
                }
                if (listConstrVarArg) {
                    List<BLangExpression> exprs = listConstructorExpr.exprs;
                    for (int i = tupleIndex; i < exprs.size(); ++i) {
                        arg = exprs.get(i);
                        this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                        if (Symbols.isFlagOn(arg.type.flags, 0x20000000L)) continue;
                        this.dlog.error(varArgPos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
                    }
                    return;
                }
                BType tupleRestType = tupleType.restType;
                if (tupleRestType == null) {
                    return;
                }
                if (!Symbols.isFlagOn(tupleRestType.flags, 0x20000000L)) {
                    this.dlog.error(varArgPos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
                }
                return;
            }
        }
        if (!Symbols.isFlagOn(symbol.restParam.flags, 0x40000000L)) {
            for (BLangExpression restArg : restArgs) {
                this.analyzeNode(restArg, this.env);
            }
            return;
        }
        this.analyzeRestArgsForRestParam(restArgs, symbol);
    }

    private void analyzeRestArgsForRestParam(List<BLangExpression> restArgs, BInvokableSymbol symbol) {
        if (Symbols.isFlagOn(((BArrayType)symbol.restParam.type).eType.flags, 0x40000000L)) {
            for (BLangExpression restArg : restArgs) {
                this.analyzeNode(restArg, this.env);
            }
            return;
        }
        for (BLangExpression restArg : restArgs) {
            this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(restArg);
        }
        int size = restArgs.size();
        BLangExpression lastArg = restArgs.get(size - 1);
        boolean lastArgIsVarArg = lastArg.getKind() == NodeKind.REST_ARGS_EXPR;
        for (int i = 0; i < (lastArgIsVarArg ? size - 1 : size); ++i) {
            BLangExpression arg = restArgs.get(i);
            if (Symbols.isFlagOn(arg.type.flags, 0x20000000L)) continue;
            this.dlog.error(arg.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
        }
        if (lastArgIsVarArg) {
            this.analyzeVarArgIsolatedness((BLangRestArgsExpression)lastArg, lastArg.pos);
        }
    }

    private void analyzeVarArgIsolatedness(BLangRestArgsExpression restArgsExpression, Location pos) {
        BLangExpression expr = restArgsExpression.expr;
        if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
            for (BLangExpression expression : ((BLangListConstructorExpr)expr).exprs) {
                this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(expression);
                if (Symbols.isFlagOn(expression.type.flags, 0x20000000L)) continue;
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
            }
            return;
        }
        BType varArgType = restArgsExpression.type;
        if (varArgType.tag == 19) {
            if (!Symbols.isFlagOn(((BArrayType)varArgType).eType.flags, 0x20000000L)) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
            }
            return;
        }
        BTupleType tupleType = (BTupleType)varArgType;
        for (BType type : tupleType.tupleTypes) {
            if (Symbols.isFlagOn(type.flags, 0x20000000L)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
        }
        BType restType = tupleType.restType;
        if (restType != null && !Symbols.isFlagOn(restType.flags, 0x20000000L)) {
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
        }
    }

    private boolean isBallerinaModule(BLangPackage module) {
        String orgName = module.packageID.orgName.value;
        return orgName.equals("ballerina") || orgName.equals("ballerinax");
    }

    private boolean isInIsolatedFunction(BLangInvokableNode enclInvokable) {
        if (enclInvokable == null) {
            if (this.env.node.getKind() != NodeKind.EXPR_FUNCTION_BODY || this.env.enclEnv.node.getKind() != NodeKind.ARROW_EXPR) {
                return false;
            }
            return this.isIsolated(((BLangArrowFunction)this.env.enclEnv.node).funcType.flags);
        }
        return this.isIsolated(enclInvokable.symbol.flags);
    }

    private boolean isRecordFieldDefaultValue(BLangType enclType) {
        if (enclType == null) {
            return false;
        }
        return enclType.getKind() == NodeKind.RECORD_TYPE;
    }

    private boolean isObjectFieldDefaultValueRequiringIsolation(SymbolEnv env) {
        BLangNode node = env.node;
        NodeKind kind = node.getKind();
        if (kind != NodeKind.CLASS_DEFN) {
            return false;
        }
        BLangClassDefinition classDefinition = (BLangClassDefinition)node;
        BLangFunction initFunction = classDefinition.initFunction;
        if (initFunction == null) {
            return true;
        }
        return this.isIsolated(initFunction.symbol.flags);
    }

    private boolean isDefinitionReference(BSymbol symbol) {
        return Symbols.isTagOn(symbol, 132) || Symbols.isTagOn(symbol, 65564) || Symbols.isTagOn(symbol, 820);
    }

    private boolean isIsolated(long flags) {
        return Symbols.isFlagOn(flags, 0x20000000L);
    }

    private boolean isIsolatedClassField() {
        BLangNode node = this.env.node;
        return node.getKind() == NodeKind.CLASS_DEFN && ((BLangClassDefinition)node).flagSet.contains((Object)Flag.ISOLATED);
    }

    private boolean isExpectedToBeAPrivateField(BVarSymbol symbol, BType type) {
        return !Symbols.isFlagOn(symbol.flags, 4L) || !this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(type);
    }

    private boolean isIsolatedObjectFieldAccessViaSelf(BLangFieldBasedAccess fieldAccessExpr, boolean ignoreInit) {
        BLangExpression expr = fieldAccessExpr.expr;
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        if (!Names.SELF.value.equals(((BLangSimpleVarRef)expr).variableName.value)) {
            return false;
        }
        return this.isInIsolatedObjectMethod(this.env, ignoreInit);
    }

    private boolean isValidIsolatedObjectFieldAccessViaSelfOutsideLock(BLangFieldBasedAccess fieldAccessExpr, boolean ignoreInit) {
        if (!this.isIsolatedObjectFieldAccessViaSelf(fieldAccessExpr, ignoreInit)) {
            return false;
        }
        BField field = (BField)((BObjectType)this.env.enclInvokable.symbol.owner.type).fields.get(fieldAccessExpr.field.value);
        return this.isExpectedToBeAPrivateField(field.symbol, field.type);
    }

    private void validateIsolatedExpression(BType type, BLangExpression expression) {
        if (this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(type)) {
            return;
        }
        this.validateIsolatedExpression(expression);
    }

    private void validateIsolatedExpression(BLangExpression expression) {
        this.isIsolatedExpression(expression, true);
    }

    private boolean isIsolatedExpression(BLangExpression expression, boolean logErrors) {
        BType type = expression.type;
        if (type != null && this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(type)) {
            return true;
        }
        switch (expression.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                if (!this.isReferenceOfLetVarInitializedWithAnIsolatedExpression((BLangSimpleVarRef)expression)) break;
                return true;
            }
            case LITERAL: 
            case NUMERIC_LITERAL: {
                return true;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                for (BLangExpression expr : ((BLangListConstructorExpr)expression).exprs) {
                    if (this.isIsolatedExpression(expr, logErrors) || logErrors) continue;
                    return false;
                }
                return true;
            }
            case TABLE_CONSTRUCTOR_EXPR: {
                for (BLangRecordLiteral mappingConstr : ((BLangTableConstructorExpr)expression).recordLiteralList) {
                    if (this.isIsolatedExpression(mappingConstr, logErrors) || logErrors) continue;
                    return false;
                }
                return true;
            }
            case RECORD_LITERAL_EXPR: {
                for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)expression).fields) {
                    if (field.isKeyValueField()) {
                        BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        BLangRecordLiteral.BLangRecordKey key = keyValueField.key;
                        if (key.computedKey && !this.isIsolatedExpression(key.expr, logErrors) && !logErrors) {
                            return false;
                        }
                        if (this.isIsolatedExpression(keyValueField.valueExpr, logErrors) || logErrors) continue;
                        return false;
                    }
                    if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                        if (this.isIsolatedExpression(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, logErrors) || logErrors) continue;
                        return false;
                    }
                    if (this.isIsolatedExpression((BLangRecordLiteral.BLangRecordVarNameField)field, logErrors) || logErrors) continue;
                    return false;
                }
                return true;
            }
            case XML_COMMENT_LITERAL: {
                BLangXMLCommentLiteral commentLiteral = (BLangXMLCommentLiteral)expression;
                for (BLangExpression textFragment : commentLiteral.textFragments) {
                    if (this.isIsolatedExpression(textFragment, logErrors) || logErrors) continue;
                    return false;
                }
                BLangExpression commentLiteralConcatExpr = commentLiteral.concatExpr;
                if (commentLiteralConcatExpr == null) {
                    return true;
                }
                return this.isIsolatedExpression(commentLiteralConcatExpr, logErrors);
            }
            case XML_TEXT_LITERAL: {
                BLangXMLTextLiteral textLiteral = (BLangXMLTextLiteral)expression;
                for (BLangExpression textFragment : textLiteral.textFragments) {
                    if (this.isIsolatedExpression(textFragment, logErrors) || logErrors) continue;
                    return false;
                }
                BLangExpression textLiteralConcatExpr = textLiteral.concatExpr;
                if (textLiteralConcatExpr == null) {
                    return true;
                }
                return this.isIsolatedExpression(textLiteralConcatExpr, logErrors);
            }
            case XML_PI_LITERAL: {
                BLangXMLProcInsLiteral procInsLiteral = (BLangXMLProcInsLiteral)expression;
                for (BLangExpression dataFragment : procInsLiteral.dataFragments) {
                    if (this.isIsolatedExpression(dataFragment, logErrors) || logErrors) continue;
                    return false;
                }
                BLangExpression procInsLiteralConcatExpr = procInsLiteral.dataConcatExpr;
                if (procInsLiteralConcatExpr == null) {
                    return true;
                }
                return this.isIsolatedExpression(procInsLiteralConcatExpr, logErrors);
            }
            case XML_ELEMENT_LITERAL: {
                for (BLangExpression child : ((BLangXMLElementLiteral)expression).children) {
                    if (this.isIsolatedExpression(child, logErrors) || logErrors) continue;
                    return false;
                }
                return true;
            }
            case XML_SEQUENCE_LITERAL: {
                for (BLangExpression xmlItem : ((BLangXMLSequenceLiteral)expression).xmlItems) {
                    if (this.isIsolatedExpression(xmlItem, logErrors) || logErrors) continue;
                    return false;
                }
                return true;
            }
            case STRING_TEMPLATE_LITERAL: {
                for (BLangExpression expr : ((BLangStringTemplateLiteral)expression).exprs) {
                    if (this.isIsolatedExpression(expr, logErrors) || logErrors) continue;
                    return false;
                }
                return true;
            }
            case TYPE_CONVERSION_EXPR: {
                return this.isIsolatedExpression(((BLangTypeConversionExpr)expression).expr, logErrors);
            }
            case CHECK_EXPR: 
            case CHECK_PANIC_EXPR: {
                return this.isIsolatedExpression(((BLangCheckedExpr)expression).expr, logErrors);
            }
            case TRAP_EXPR: {
                return this.isIsolatedExpression(((BLangTrapExpr)expression).expr, logErrors);
            }
            case TERNARY_EXPR: {
                BLangTernaryExpr ternaryExpr = (BLangTernaryExpr)expression;
                if (!this.isIsolatedExpression(ternaryExpr.expr, logErrors) && !logErrors) {
                    return false;
                }
                if (!this.isIsolatedExpression(ternaryExpr.thenExpr, logErrors) && !logErrors) {
                    return false;
                }
                return this.isIsolatedExpression(ternaryExpr.elseExpr, logErrors);
            }
            case ELVIS_EXPR: {
                BLangElvisExpr elvisExpr = (BLangElvisExpr)expression;
                if (!this.isIsolatedExpression(elvisExpr.lhsExpr, logErrors) && !logErrors) {
                    return false;
                }
                return this.isIsolatedExpression(elvisExpr.rhsExpr, logErrors);
            }
            case LET_EXPR: {
                return this.isIsolatedExpression(((BLangLetExpression)expression).expr, logErrors);
            }
            case GROUP_EXPR: {
                return this.isIsolatedExpression(((BLangGroupExpr)expression).expression, logErrors);
            }
            case TYPE_INIT_EXPR: {
                BLangTypeInit typeInitExpr = (BLangTypeInit)expression;
                if (typeInitExpr == null) {
                    return true;
                }
                expression = typeInitExpr.initInvocation;
                break;
            }
            case OBJECT_CTOR_EXPRESSION: {
                BLangObjectConstructorExpression objectConstructorExpression = (BLangObjectConstructorExpression)expression;
                BLangTypeInit typeInitExpr = objectConstructorExpression.typeInit;
                if (typeInitExpr == null) {
                    return true;
                }
                expression = typeInitExpr.initInvocation;
            }
        }
        if (expression.getKind() == NodeKind.INVOCATION) {
            BLangInvocation invocation = (BLangInvocation)expression;
            if (this.isCloneOrCloneReadOnlyInvocation(invocation)) {
                return true;
            }
            BSymbol invocationSymbol = invocation.symbol;
            if (invocationSymbol == null) {
                List<BLangExpression> argExprs = invocation.argExprs;
                if (argExprs.isEmpty()) {
                    return true;
                }
                return this.isIsolatedExpression(argExprs.get(0), logErrors);
            }
            if (this.isIsolated(invocationSymbol.type.flags)) {
                List<BLangExpression> requiredArgs = invocation.requiredArgs;
                BLangExpression calledOnExpr = invocation.expr;
                if (!(calledOnExpr == null || !requiredArgs.isEmpty() && calledOnExpr == requiredArgs.get(0) || this.isIsolatedExpression(calledOnExpr, logErrors) || logErrors)) {
                    return false;
                }
                for (BLangExpression requiredArg : requiredArgs) {
                    if (requiredArg.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                        if (this.isIsolatedExpression(((BLangNamedArgsExpression)requiredArg).expr, logErrors) || logErrors) continue;
                        return false;
                    }
                    if (this.isIsolatedExpression(requiredArg, logErrors) || logErrors) continue;
                    return false;
                }
                for (BLangExpression restArg : invocation.restArgs) {
                    if (restArg.getKind() == NodeKind.REST_ARGS_EXPR) {
                        if (this.isIsolatedExpression(((BLangRestArgsExpression)restArg).expr, logErrors) || logErrors) continue;
                        return false;
                    }
                    if (this.isIsolatedExpression(restArg, logErrors) || logErrors) continue;
                    return false;
                }
                return true;
            }
        }
        if (logErrors) {
            this.dlog.error(expression.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_EXPRESSION_AS_INITIAL_VALUE, new Object[0]);
        }
        return false;
    }

    private boolean isCloneOrCloneReadOnlyInvocation(BLangInvocation invocation) {
        if (!invocation.langLibInvocation) {
            return false;
        }
        String methodName = invocation.symbol.name.value;
        return invocation.symbol.pkgID.name.value.equals(VALUE_LANG_LIB) && (methodName.equals(CLONE_LANG_LIB_METHOD) || methodName.equals(CLONE_READONLY_LANG_LIB_METHOD));
    }

    private boolean isInvalidTransfer(BLangSimpleVarRef expression, boolean transferOut) {
        return this.isInvalidTransfer(expression, transferOut, Names.SELF.value.equals(expression.variableName.value));
    }

    private boolean isInvalidTransfer(BLangExpression expression, boolean transferOut, boolean invokedOnSelf) {
        BLangNode parent = expression.parent;
        NodeKind parentExprKind = parent.getKind();
        if (!(parent instanceof BLangExpression)) {
            if (!transferOut) {
                return !this.isIsolatedExpression(expression, false);
            }
            switch (parentExprKind) {
                case ASSIGNMENT: {
                    BLangExpression varRef = ((BLangAssignment)parent).varRef;
                    if (varRef.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
                        return false;
                    }
                    BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)varRef;
                    if (this.isDefinedOutsideLock(this.names.fromIdNode(simpleVarRef.variableName), simpleVarRef.symbol.tag, this.env)) {
                        return !this.isIsolatedExpression(expression, false);
                    }
                    return false;
                }
                case RECORD_DESTRUCTURE: {
                    return this.hasRefDefinedOutsideLock(((BLangRecordDestructure)parent).varRef);
                }
                case TUPLE_DESTRUCTURE: {
                    return this.hasRefDefinedOutsideLock(((BLangTupleDestructure)parent).varRef);
                }
                case ERROR_DESTRUCTURE: {
                    return this.hasRefDefinedOutsideLock(((BLangErrorDestructure)parent).varRef);
                }
                case RETURN: {
                    return !this.isIsolatedExpression(expression, false);
                }
            }
            return false;
        }
        BLangExpression parentExpression = (BLangExpression)parent;
        if (parentExprKind != NodeKind.INVOCATION) {
            if (!this.isSelfReference(expression) && this.isIsolatedExpression(expression, false)) {
                return false;
            }
            return this.isInvalidTransfer(parentExpression, transferOut, invokedOnSelf);
        }
        BLangInvocation invocation = (BLangInvocation)parentExpression;
        BLangExpression calledOnExpr = invocation.expr;
        if (calledOnExpr == expression) {
            if (invokedOnSelf && (!transferOut || invocation.type.tag == 10)) {
                return false;
            }
            if (this.isCloneOrCloneReadOnlyInvocation(invocation)) {
                return false;
            }
            if (!invokedOnSelf && invocation.type.tag == 10) {
                if (transferOut) {
                    return false;
                }
                return !this.isIsolatedExpression(expression, false);
            }
            return this.isInvalidTransfer(parentExpression, transferOut, invokedOnSelf);
        }
        if (transferOut) {
            return false;
        }
        return !this.isIsolatedExpression(expression, false);
    }

    private boolean isSelfReference(BLangExpression expression) {
        return expression.getKind() == NodeKind.SIMPLE_VARIABLE_REF && Names.SELF.value.equals(((BLangSimpleVarRef)expression).variableName.value);
    }

    private boolean hasRefDefinedOutsideLock(BLangExpression variableReference) {
        switch (variableReference.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)variableReference;
                return this.isDefinedOutsideLock(this.names.fromIdNode(simpleVarRef.variableName), simpleVarRef.symbol.tag, this.env);
            }
            case RECORD_VARIABLE_REF: {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)variableReference;
                for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : recordVarRef.recordRefFields) {
                    if (!this.hasRefDefinedOutsideLock(recordRefField.variableReference)) continue;
                    return true;
                }
                ExpressionNode recordRestParam = recordVarRef.restParam;
                return recordRestParam != null && this.hasRefDefinedOutsideLock((BLangExpression)recordRestParam);
            }
            case TUPLE_VARIABLE_REF: {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)variableReference;
                for (BLangExpression expression : tupleVarRef.expressions) {
                    if (!this.hasRefDefinedOutsideLock(expression)) continue;
                    return true;
                }
                ExpressionNode tupleRestParam = tupleVarRef.restParam;
                return tupleRestParam != null && this.hasRefDefinedOutsideLock((BLangExpression)tupleRestParam);
            }
            case ERROR_VARIABLE_REF: {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)variableReference;
                BLangVariableReference message = errorVarRef.message;
                if (message != null && this.hasRefDefinedOutsideLock(message)) {
                    return true;
                }
                BLangVariableReference cause = errorVarRef.cause;
                if (cause != null && this.hasRefDefinedOutsideLock(cause)) {
                    return true;
                }
                for (BLangNamedArgsExpression namedArgsExpression : errorVarRef.detail) {
                    if (!this.hasRefDefinedOutsideLock(namedArgsExpression.expr)) continue;
                    return true;
                }
                BLangVariableReference errorRestVar = errorVarRef.restVar;
                return errorRestVar != null && this.hasRefDefinedOutsideLock(errorRestVar);
            }
        }
        return false;
    }

    private boolean isDefinedOutsideLock(Name name, int symTag, SymbolEnv currentEnv) {
        if (Names.IGNORE == name || this.symResolver.lookupSymbolInGivenScope(currentEnv, name, symTag) != this.symTable.notFoundSymbol) {
            return false;
        }
        if (currentEnv.node.getKind() == NodeKind.LOCK) {
            return true;
        }
        return this.isDefinedOutsideLock(name, symTag, currentEnv.enclEnv);
    }

    private boolean isInIsolatedObjectMethod(SymbolEnv env, boolean ignoreInit) {
        BLangInvokableNode enclInvokable = env.enclInvokable;
        if (enclInvokable == null || enclInvokable.getKind() != NodeKind.FUNCTION) {
            return false;
        }
        BLangFunction enclFunction = (BLangFunction)enclInvokable;
        if (!enclFunction.attachedFunction) {
            return false;
        }
        if (enclFunction.objInitFunction && ignoreInit) {
            return false;
        }
        BType ownerType = enclInvokable.symbol.owner.type;
        return ownerType.tag == 33 && this.isIsolated(ownerType.flags);
    }

    private boolean isInvalidCopyIn(BLangSimpleVarRef varRefExpr, SymbolEnv currentEnv) {
        return this.isInvalidCopyIn(varRefExpr, this.names.fromIdNode(varRefExpr.variableName), varRefExpr.symbol.tag, currentEnv);
    }

    private boolean isInvalidCopyIn(BLangSimpleVarRef varRefExpr, Name name, int symTag, SymbolEnv currentEnv) {
        BSymbol symbol = this.symResolver.lookupSymbolInGivenScope(currentEnv, name, symTag);
        if (!(symbol == this.symTable.notFoundSymbol || symbol instanceof BVarSymbol && ((BVarSymbol)symbol).originalSymbol != null)) {
            return false;
        }
        if (currentEnv.node.getKind() == NodeKind.LOCK) {
            if (varRefExpr.parent == null) {
                return true;
            }
            return this.isInvalidTransfer(varRefExpr, false);
        }
        return this.isInvalidCopyIn(varRefExpr, name, symTag, currentEnv.enclEnv);
    }

    private boolean isMethodCallOnSelfInIsolatedObject(BLangSimpleVarRef varRefExpr, BLangNode parent) {
        return this.isSelfVarInIsolatedObject(varRefExpr) && parent != null && parent.getKind() != NodeKind.FIELD_BASED_ACCESS_EXPR;
    }

    private boolean isSelfVarInIsolatedObject(BLangSimpleVarRef varRefExpr) {
        return this.isInIsolatedObjectMethod(this.env, true) && Names.SELF.value.equals(varRefExpr.variableName.value);
    }

    private boolean isIsolatedModuleVariableSymbol(BSymbol symbol) {
        return symbol.owner.getKind() == SymbolKind.PACKAGE && this.isIsolated(symbol.flags);
    }

    private BSymbol getOriginalSymbol(BSymbol symbol) {
        if (!(symbol instanceof BVarSymbol)) {
            return symbol;
        }
        BVarSymbol varSymbol = (BVarSymbol)symbol;
        BVarSymbol originalSymbol = varSymbol.originalSymbol;
        return originalSymbol == null ? varSymbol : this.getOriginalSymbol(originalSymbol);
    }

    private void addToAccessedRestrictedVars(Map<BSymbol, List<BLangSimpleVarRef>> accessedRestrictedVars, final BLangSimpleVarRef varRef) {
        BSymbol originalSymbol = this.getOriginalSymbol(varRef.symbol);
        if (accessedRestrictedVars.containsKey(originalSymbol)) {
            accessedRestrictedVars.get(originalSymbol).add(varRef);
            return;
        }
        accessedRestrictedVars.put(originalSymbol, (List<BLangSimpleVarRef>)new ArrayList<BLangSimpleVarRef>(){
            {
                this.add(varRef);
            }
        });
    }

    private boolean isEnclosedLockWithinSameFunction(BLangLock currentLock, BLangLock potentialOuterLock) {
        return this.isEnclosedLockWithinSameFunction(currentLock.parent, potentialOuterLock);
    }

    private boolean isEnclosedLockWithinSameFunction(BLangNode parent, BLangLock potentialOuterLock) {
        if (parent == potentialOuterLock) {
            return true;
        }
        if (parent == null || parent.getKind() == NodeKind.FUNCTION) {
            return false;
        }
        return this.isEnclosedLockWithinSameFunction(parent.parent, potentialOuterLock);
    }

    private boolean isReferenceOfLetVarInitializedWithAnIsolatedExpression(BLangSimpleVarRef varRef) {
        BSymbol symbol = varRef.symbol;
        if ((symbol.owner.tag & 0x10000000) != 0x10000000) {
            return false;
        }
        BSymbol originalSymbol = this.getOriginalSymbol(symbol);
        for (int i = this.isolatedLetVarStack.size() - 1; i >= 0; --i) {
            if (!((Set)this.isolatedLetVarStack.get(i)).contains(originalSymbol)) continue;
            return true;
        }
        return false;
    }

    private boolean isReferenceToVarDefinedInSameInvokable(BSymbol currentOwner, BInvokableSymbol enclInvokableSymbol) {
        if (currentOwner == enclInvokableSymbol) {
            return true;
        }
        if ((currentOwner.tag & 0x100) == 256) {
            return false;
        }
        BSymbol nextOwner = currentOwner.owner;
        if (nextOwner == null) {
            return false;
        }
        return this.isReferenceToVarDefinedInSameInvokable(nextOwner, enclInvokableSymbol);
    }

    private static class PotentiallyInvalidExpressionInfo {
        BLangLock lockNode;
        Map<BSymbol, List<BLangSimpleVarRef>> accessedRestrictedVars = new HashMap<BSymbol, List<BLangSimpleVarRef>>();
        List<BLangSimpleVarRef> nonCaptureBindingPatternVarRefsOnLhs = new ArrayList<BLangSimpleVarRef>();
        List<BLangSimpleVarRef> copyInVarRefs = new ArrayList<BLangSimpleVarRef>();
        List<BLangSimpleVarRef> copyOutVarRefs = new ArrayList<BLangSimpleVarRef>();
        List<BLangInvocation> nonIsolatedInvocations = new ArrayList<BLangInvocation>();

        private PotentiallyInvalidExpressionInfo(BLangLock lockNode) {
            this.lockNode = lockNode;
        }
    }
}

