/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BBuiltInRefType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class SymbolResolver
extends BLangNodeVisitor {
    private static final CompilerContext.Key<SymbolResolver> SYMBOL_RESOLVER_KEY = new CompilerContext.Key();
    private SymbolTable symTable;
    private Names names;
    private BLangDiagnosticLog dlog;
    private Types types;
    private SymbolEnv env;
    private BType resultType;
    private DiagnosticCode diagCode;
    private SymbolEnter symbolEnter;
    private BLangAnonymousModelHelper anonymousModelHelper;
    private BLangMissingNodesHelper missingNodesHelper;
    private ResolvedTypeBuilder typeBuilder;

    public static SymbolResolver getInstance(CompilerContext context) {
        SymbolResolver symbolResolver = context.get(SYMBOL_RESOLVER_KEY);
        if (symbolResolver == null) {
            symbolResolver = new SymbolResolver(context);
        }
        return symbolResolver;
    }

    public SymbolResolver(CompilerContext context) {
        context.put(SYMBOL_RESOLVER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.types = Types.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.typeBuilder = new ResolvedTypeBuilder();
    }

    public boolean checkForUniqueSymbol(Location pos, SymbolEnv env, BSymbol symbol) {
        int dotPosition;
        BSymbol foundSym = this.symTable.notFoundSymbol;
        int expSymTag = symbol.tag;
        if ((expSymTag & 1) == 1) {
            foundSym = this.lookupSymbolInPrefixSpace(env, symbol.name);
        } else if ((expSymTag & 2) == 2) {
            foundSym = this.lookupSymbolInAnnotationSpace(env, symbol.name);
        } else if ((expSymTag & 0x8000100) == 0x8000100) {
            foundSym = this.lookupSymbolInConstructorSpace(env, symbol.name);
        } else if ((expSymTag & 4) == 4) {
            foundSym = this.lookupSymbolForDecl(env, symbol.name, 4);
        }
        if (foundSym == this.symTable.notFoundSymbol && symbol.tag == 820 && (dotPosition = symbol.name.value.indexOf(46)) > 0 && dotPosition != symbol.name.value.length()) {
            String funcName = symbol.name.value.substring(dotPosition + 1);
            foundSym = this.lookupSymbolForDecl(env, this.names.fromString(funcName), 4);
        }
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        if (this.isRedeclaredSymbol(symbol, foundSym)) {
            this.dlog.error(pos, DiagnosticErrorCode.REDECLARED_SYMBOL, symbol.name);
            return false;
        }
        if ((foundSym.tag & 0x84) == 132) {
            return false;
        }
        return this.isDistinctSymbol(pos, symbol, foundSym);
    }

    private boolean isRedeclaredSymbol(BSymbol symbol, BSymbol foundSym) {
        return this.hasSameOwner(symbol, foundSym) || this.isSymbolRedeclaredInTestPackage(symbol, foundSym);
    }

    public boolean checkForUniqueSymbol(SymbolEnv env, BSymbol symbol) {
        BSymbol foundSym = this.lookupSymbolInMainSpace(env, symbol.name);
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        return this.isDistinctSymbol(symbol, foundSym);
    }

    public boolean checkForUniqueSymbolInCurrentScope(Location pos, SymbolEnv env, BSymbol symbol, int expSymTag) {
        BSymbol foundSym = this.lookupSymbolInGivenScope(env, symbol.name, expSymTag);
        if (foundSym == this.symTable.notFoundSymbol) {
            return true;
        }
        return this.isDistinctSymbol(pos, symbol, foundSym);
    }

    private boolean isDistinctSymbol(Location pos, BSymbol symbol, BSymbol foundSym) {
        if (symbol.tag == 0x8000100 && foundSym.tag == 589852) {
            return false;
        }
        if (this.isSymbolDefinedInRootPkgLvl(foundSym)) {
            this.dlog.error(pos, DiagnosticErrorCode.REDECLARED_BUILTIN_SYMBOL, symbol.name);
            return false;
        }
        return true;
    }

    private boolean isDistinctSymbol(BSymbol symbol, BSymbol foundSym) {
        if (symbol.tag == 0x8000100 && foundSym.tag == 589852) {
            return false;
        }
        if (this.isSymbolDefinedInRootPkgLvl(foundSym)) {
            return false;
        }
        return !this.hasSameOwner(symbol, foundSym);
    }

    private boolean hasSameOwner(BSymbol symbol, BSymbol foundSym) {
        if (foundSym.owner == symbol.owner) {
            return true;
        }
        if (Symbols.isFlagOn(symbol.owner.flags, 0x100000L) && (foundSym.owner.tag & 0x100) == 256) {
            return true;
        }
        return (symbol.owner.tag & 0x10000000) == 0x10000000 && (foundSym.owner.tag & 0x100) == 256;
    }

    private boolean isSymbolRedeclaredInTestPackage(BSymbol symbol, BSymbol foundSym) {
        return Symbols.isFlagOn(symbol.owner.flags, 8192L) && !Symbols.isFlagOn(foundSym.owner.flags, 8192L);
    }

    private boolean isSymbolDefinedInRootPkgLvl(BSymbol foundSym) {
        return this.symTable.rootPkgSymbol.pkgID.equals(foundSym.pkgID) && (foundSym.tag & 0x14) == 20;
    }

    public BSymbol lookupSymbolInGivenScope(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if (this.symTable.rootPkgSymbol.pkgID.equals(entry.symbol.pkgID) && (entry.symbol.tag & 0x14) == 20) {
                return entry.symbol;
            }
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        return this.symTable.notFoundSymbol;
    }

    public boolean checkForUniqueMemberSymbol(Location pos, SymbolEnv env, BSymbol symbol) {
        BSymbol foundSym = this.lookupMemberSymbol(pos, env.scope, env, symbol.name, symbol.tag);
        if (foundSym != this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.REDECLARED_SYMBOL, symbol.name);
            return false;
        }
        return true;
    }

    public BSymbol resolveBinaryOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        return this.resolveOperator(this.names.fromString(opKind.value()), Lists.of(lhsType, rhsType));
    }

    BSymbol createEqualityOperator(OperatorKind opKind, BType lhsType, BType rhsType) {
        List<BType> paramTypes = Lists.of(lhsType, rhsType);
        BType retType = this.symTable.booleanType;
        BInvokableType opType = new BInvokableType(paramTypes, retType, null);
        return new BOperatorSymbol(this.names.fromString(opKind.value()), null, opType, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    public BSymbol resolveUnaryOperator(Location pos, OperatorKind opKind, BType type) {
        return this.resolveOperator(this.names.fromString(opKind.value()), Lists.of(type));
    }

    public BSymbol resolveOperator(Name name, List<BType> types) {
        Scope.ScopeEntry entry = this.symTable.rootScope.lookup(name);
        return this.resolveOperator(entry, types);
    }

    public BSymbol resolvePkgSymbol(Location pos, SymbolEnv env, Name pkgAlias) {
        if (pkgAlias == Names.EMPTY) {
            return env.enclPkg.symbol;
        }
        BSymbol pkgSymbol = this.lookupSymbolInPrefixSpace(env, pkgAlias);
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
        }
        return pkgSymbol;
    }

    public BSymbol resolvePrefixSymbol(SymbolEnv env, Name pkgAlias, Name compUnit) {
        if (pkgAlias == Names.EMPTY) {
            return env.enclPkg.symbol;
        }
        Scope.ScopeEntry entry = env.scope.lookup(pkgAlias);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x2001) == 8193) {
                return entry.symbol;
            }
            if ((entry.symbol.tag & 1) == 1 && ((BPackageSymbol)entry.symbol).compUnit.equals(compUnit)) {
                ((BPackageSymbol)entry.symbol).isUsed = true;
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.resolvePrefixSymbol(env.enclEnv, pkgAlias, compUnit);
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol resolveAnnotation(Location pos, SymbolEnv env, Name pkgAlias, Name annotationName) {
        return this.lookupAnnotationSpaceSymbolInPackage(pos, env, pkgAlias, annotationName);
    }

    public BSymbol resolveStructField(Location location, SymbolEnv env, Name fieldName, BTypeSymbol structSymbol) {
        return this.lookupMemberSymbol(location, structSymbol.scope, env, fieldName, 52);
    }

    public BSymbol resolveObjectField(Location location, SymbolEnv env, Name fieldName, BTypeSymbol objectSymbol) {
        return this.lookupMemberSymbol(location, objectSymbol.scope, env, fieldName, 52);
    }

    public BSymbol resolveObjectMethod(Location pos, SymbolEnv env, Name fieldName, BObjectTypeSymbol objectSymbol) {
        return this.lookupMemberSymbol(pos, objectSymbol.scope, env, fieldName, 52);
    }

    public BType resolveTypeNode(BLangType typeNode, SymbolEnv env) {
        return this.resolveTypeNode(typeNode, env, DiagnosticErrorCode.UNKNOWN_TYPE);
    }

    public BType resolveTypeNode(BLangType typeNode, SymbolEnv env, DiagnosticCode diagCode) {
        SymbolEnv prevEnv = this.env;
        DiagnosticCode preDiagCode = this.diagCode;
        this.env = env;
        this.diagCode = diagCode;
        typeNode.accept(this);
        this.env = prevEnv;
        this.diagCode = preDiagCode;
        if (typeNode.nullable && this.resultType.tag == 20) {
            BUnionType unionType = (BUnionType)this.resultType;
            unionType.add(this.symTable.nilType);
        } else if (typeNode.nullable && this.resultType.tag != 7 && this.resultType.tag != 17) {
            this.resultType = BUnionType.create(null, this.resultType, this.symTable.nilType);
        }
        typeNode.type = this.resultType;
        return this.resultType;
    }

    private BSymbol lookupSymbolForDecl(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) == expSymTag) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.lookupSymbol(env.enclEnv, name, expSymTag);
        }
        return this.symTable.notFoundSymbol;
    }

    private BSymbol lookupSymbol(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv != null) {
            return this.lookupSymbol(env.enclEnv, name, expSymTag);
        }
        return this.symTable.notFoundSymbol;
    }

    private boolean isFieldRefFromWithinARecord(BSymbol symbol, SymbolEnv env) {
        return (symbol.owner.tag & 0x5005C) == 327772 && env.enclType != null && env.enclType.getKind() == NodeKind.RECORD_TYPE;
    }

    public BSymbol lookupSymbolInMainSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 4);
    }

    public BSymbol lookupSymbolInAnnotationSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 2);
    }

    public BSymbol lookupSymbolInPrefixSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 1);
    }

    public BSymbol lookupSymbolInConstructorSpace(SymbolEnv env, Name name) {
        return this.lookupSymbol(env, name, 0x8000100);
    }

    public BSymbol lookupLangLibMethod(BType type, Name name) {
        BSymbol bSymbol;
        if (this.symTable.langAnnotationModuleSymbol == null) {
            return this.symTable.notFoundSymbol;
        }
        switch (type.tag) {
            case 19: 
            case 30: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langArrayModuleSymbol, name);
                break;
            }
            case 4: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langDecimalModuleSymbol, name);
                break;
            }
            case 28: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langErrorModuleSymbol, name);
                break;
            }
            case 3: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langFloatModuleSymbol, name);
                break;
            }
            case 31: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langFutureModuleSymbol, name);
                break;
            }
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langIntModuleSymbol, name);
                break;
            }
            case 12: 
            case 15: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langMapModuleSymbol, name);
                break;
            }
            case 33: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langObjectModuleSymbol, name);
                break;
            }
            case 14: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langStreamModuleSymbol, name);
                break;
            }
            case 9: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langTableModuleSymbol, name);
                break;
            }
            case 5: 
            case 44: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langStringModuleSymbol, name);
                break;
            }
            case 13: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langTypedescModuleSymbol, name);
                break;
            }
            case 8: 
            case 45: 
            case 46: 
            case 47: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langXmlModuleSymbol, name);
                break;
            }
            case 48: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langXmlModuleSymbol, name);
                if (bSymbol != this.symTable.notFoundSymbol) break;
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langStringModuleSymbol, name);
                break;
            }
            case 6: {
                bSymbol = this.lookupLangLibMethodInModule(this.symTable.langBooleanModuleSymbol, name);
                break;
            }
            case 20: {
                Iterator<BType> itr = ((BUnionType)type).getMemberTypes().iterator();
                if (!itr.hasNext()) {
                    throw new IllegalArgumentException(String.format("Union type '%s' does not have member types", type.toString()));
                }
                BType member = itr.next();
                if (this.types.isSubTypeOfBaseType(type, member.tag)) {
                    bSymbol = this.lookupLangLibMethod(member, name);
                    break;
                }
                bSymbol = this.symTable.notFoundSymbol;
                break;
            }
            default: {
                bSymbol = this.symTable.notFoundSymbol;
            }
        }
        if (bSymbol == this.symTable.notFoundSymbol) {
            bSymbol = this.lookupLangLibMethodInModule(this.symTable.langValueModuleSymbol, name);
        }
        if (bSymbol == this.symTable.notFoundSymbol) {
            bSymbol = this.lookupLangLibMethodInModule(this.symTable.langInternalModuleSymbol, name);
        }
        if (bSymbol == this.symTable.notFoundSymbol) {
            bSymbol = this.lookupLangLibMethodInModule(this.symTable.langTransactionModuleSymbol, name);
        }
        if (bSymbol == this.symTable.notFoundSymbol) {
            bSymbol = this.lookupLangLibMethodInModule(this.symTable.langQueryModuleSymbol, name);
        }
        return bSymbol;
    }

    public BSymbol lookupClosureVarSymbol(SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = env.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if (this.symTable.rootPkgSymbol.pkgID.equals(entry.symbol.pkgID) && (entry.symbol.tag & 0x14) == 20) {
                return entry.symbol;
            }
            if ((entry.symbol.tag & expSymTag) == expSymTag && !this.isFieldRefFromWithinARecord(entry.symbol, env)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        if (env.enclEnv == null || env.enclEnv.node == null) {
            return this.symTable.notFoundSymbol;
        }
        return this.lookupClosureVarSymbol(env.enclEnv, name, expSymTag);
    }

    public BSymbol lookupMainSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInMainSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.lineRange().filePath()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 4);
    }

    public BSymbol lookupPrefixSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInPrefixSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.lineRange().filePath()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 1);
    }

    public BSymbol lookupAnnotationSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInAnnotationSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.lineRange().filePath()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 2);
    }

    public BSymbol lookupConstructorSpaceSymbolInPackage(Location pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return this.lookupSymbolInConstructorSpace(env, name);
        }
        BSymbol pkgSymbol = this.resolvePrefixSymbol(env, pkgAlias, this.names.fromString(pos.lineRange().filePath()));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias.value);
            return pkgSymbol;
        }
        return this.lookupMemberSymbol(pos, pkgSymbol.scope, env, name, 0x8000100);
    }

    public BSymbol lookupLangLibMethodInModule(BPackageSymbol moduleSymbol, Name name) {
        Scope.ScopeEntry entry = moduleSymbol.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x334) != 820) {
                entry = entry.next;
                continue;
            }
            if (this.isMemberAccessAllowed(this.env, entry.symbol)) {
                return entry.symbol;
            }
            return this.symTable.notFoundSymbol;
        }
        return this.symTable.notFoundSymbol;
    }

    public BSymbol lookupMemberSymbol(Location pos, Scope scope, SymbolEnv env, Name name, int expSymTag) {
        Scope.ScopeEntry entry = scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & expSymTag) != expSymTag) {
                entry = entry.next;
                continue;
            }
            if (this.isMemberAccessAllowed(env, entry.symbol)) {
                return entry.symbol;
            }
            this.dlog.error(pos, DiagnosticErrorCode.ATTEMPT_REFER_NON_ACCESSIBLE_SYMBOL, entry.symbol.name);
            return this.symTable.notFoundSymbol;
        }
        return this.symTable.notFoundSymbol;
    }

    public Map<Name, BXMLNSSymbol> resolveAllNamespaces(SymbolEnv env) {
        LinkedHashMap<Name, BXMLNSSymbol> namespaces = new LinkedHashMap<Name, BXMLNSSymbol>();
        this.addNamespacesInScope(namespaces, env);
        return namespaces;
    }

    public void reloadErrorAndDependentTypes() {
        Scope.ScopeEntry entry = this.symTable.rootPkgSymbol.scope.lookup(Names.ERROR);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xC) != 12) {
                entry = entry.next;
                continue;
            }
            this.symTable.errorType = (BErrorType)entry.symbol.type;
            this.symTable.detailType = (BMapType)this.symTable.errorType.detailType;
            this.symTable.errorConstructor = ((BErrorTypeSymbol)this.symTable.errorType.tsymbol).ctorSymbol;
            this.symTable.pureType = BUnionType.create(null, this.symTable.anydataType, this.symTable.errorType);
            this.symTable.streamType = new BStreamType(14, this.symTable.pureType, null, null);
            this.symTable.tableType = new BTableType(9, this.symTable.pureType, null);
            this.symTable.defineOperators();
            this.symTable.pureType = BUnionType.create(null, this.symTable.anydataType, this.symTable.errorType);
            this.symTable.errorOrNilType = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
            this.symTable.anyOrErrorType = BUnionType.create(null, this.symTable.anyType, this.symTable.errorType);
            this.symTable.mapAllType = new BMapType(15, this.symTable.anyOrErrorType, null);
            this.symTable.arrayAllType = new BArrayType(this.symTable.anyOrErrorType);
            this.symTable.typeDesc.constraint = this.symTable.anyOrErrorType;
            this.symTable.futureType.constraint = this.symTable.anyOrErrorType;
            return;
        }
        throw new IllegalStateException("built-in error not found ?");
    }

    public void reloadIntRangeType() {
        Scope.ScopeEntry entry = this.symTable.langInternalModuleSymbol.scope.lookup(Names.CREATE_INT_RANGE);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0x100) != 256) {
                entry = entry.next;
                continue;
            }
            this.symTable.intRangeType = (BObjectType)((BInvokableType)entry.symbol.type).retType;
            this.symTable.defineBinaryOperator(OperatorKind.CLOSED_RANGE, this.symTable.intType, this.symTable.intType, this.symTable.intRangeType);
            this.symTable.defineBinaryOperator(OperatorKind.HALF_OPEN_RANGE, this.symTable.intType, this.symTable.intType, this.symTable.intRangeType);
            return;
        }
        throw new IllegalStateException("built-in Integer Range type not found ?");
    }

    public void loadRawTemplateType() {
        Scope.ScopeEntry entry = this.symTable.langObjectModuleSymbol.scope.lookup(Names.RAW_TEMPLATE);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 0xC) != 12) {
                entry = entry.next;
                continue;
            }
            this.symTable.rawTemplateType = (BObjectType)entry.symbol.type;
            return;
        }
        throw new IllegalStateException("'lang.object:RawTemplate' type not found");
    }

    @Override
    public void visit(BLangValueType valueTypeNode) {
        this.visitBuiltInTypeNode(valueTypeNode, valueTypeNode.typeKind, this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
        this.visitBuiltInTypeNode(builtInRefType, builtInRefType.typeKind, this.env);
    }

    @Override
    public void visit(BLangArrayType arrayTypeNode) {
        this.resultType = this.resolveTypeNode(arrayTypeNode.elemtype, this.env, this.diagCode);
        if (this.resultType == this.symTable.noType) {
            return;
        }
        boolean isError = false;
        for (int i = 0; i < arrayTypeNode.dimensions; ++i) {
            BArrayType arrType;
            BTypeSymbol arrayTypeSymbol = Symbols.createTypeSymbol(0x101001C, 1L, Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, arrayTypeNode.pos, SymbolOrigin.SOURCE);
            if (arrayTypeNode.sizes.length == 0) {
                arrType = new BArrayType(this.resultType, arrayTypeSymbol);
            } else {
                BLangExpression size = arrayTypeNode.sizes[i];
                if (size.getKind() == NodeKind.LITERAL || size.getKind() == NodeKind.NUMERIC_LITERAL) {
                    Integer sizeIndicator = (Integer)((BLangLiteral)size).getValue();
                    BArrayState arrayState = sizeIndicator == -1 ? BArrayState.OPEN : (sizeIndicator == -2 ? BArrayState.INFERRED : BArrayState.CLOSED);
                    arrType = new BArrayType(this.resultType, arrayTypeSymbol, sizeIndicator, arrayState);
                } else {
                    Name typeName;
                    if (size.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, ((BLangTypedescExpr)size).getTypeNode());
                        isError = true;
                        continue;
                    }
                    BLangSimpleVarRef sizeReference = (BLangSimpleVarRef)size;
                    Name pkgAlias = this.names.fromIdNode(sizeReference.pkgAlias);
                    BSymbol sizeSymbol = this.lookupMainSpaceSymbolInPackage(size.pos, this.env, pkgAlias, typeName = this.names.fromIdNode(sizeReference.variableName));
                    if (this.symTable.notFoundSymbol == sizeSymbol) {
                        this.dlog.error(arrayTypeNode.pos, DiagnosticErrorCode.UNDEFINED_SYMBOL, size);
                        isError = true;
                        continue;
                    }
                    if (sizeSymbol.tag != 33554460) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INVALID_ARRAY_SIZE_REFERENCE, sizeSymbol);
                        isError = true;
                        continue;
                    }
                    BConstantSymbol sizeConstSymbol = (BConstantSymbol)sizeSymbol;
                    BType lengthLiteralType = sizeConstSymbol.literalType;
                    if (lengthLiteralType.tag != 1) {
                        this.dlog.error(size.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, sizeConstSymbol.literalType);
                        isError = true;
                        continue;
                    }
                    int length = Integer.parseInt(sizeConstSymbol.type.toString());
                    arrType = new BArrayType(this.resultType, arrayTypeSymbol, length, BArrayState.CLOSED);
                }
            }
            this.resultType = arrayTypeSymbol.type = arrType;
            this.markParameterizedType((BType)arrType, arrType.eType);
        }
        if (isError) {
            this.resultType = this.symTable.semanticError;
        }
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        LinkedHashSet memberTypes = unionTypeNode.memberTypeNodes.stream().map(memTypeNode -> this.resolveTypeNode((BLangType)memTypeNode, this.env)).flatMap(memBType -> memBType.tag == 20 && !Symbols.isFlagOn(memBType.tsymbol.flags, 0x200000L) ? ((BUnionType)memBType).getMemberTypes().stream() : Stream.of(memBType)).collect(Collectors.toCollection(LinkedHashSet::new));
        BTypeSymbol unionTypeSymbol = Symbols.createTypeSymbol(2162716, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, unionTypeNode.pos, SymbolOrigin.SOURCE);
        if (memberTypes.contains(this.symTable.noType)) {
            this.resultType = this.symTable.noType;
            return;
        }
        BUnionType unionType = BUnionType.create(unionTypeSymbol, memberTypes);
        unionTypeSymbol.type = unionType;
        this.markParameterizedType((BType)unionType, memberTypes);
        this.resultType = unionType;
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        this.resultType = this.computeIntersectionType(intersectionTypeNode);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        EnumSet<Flag> flags = EnumSet.copyOf(objectTypeNode.flagSet);
        if (objectTypeNode.isAnonymous) {
            flags.add(Flag.PUBLIC);
        }
        int typeFlags = 0;
        if (objectTypeNode.flagSet.contains((Object)Flag.READONLY)) {
            flags.add(Flag.READONLY);
            typeFlags = (int)((long)typeFlags | 0x20L);
        }
        if (objectTypeNode.flagSet.contains((Object)Flag.ISOLATED)) {
            flags.add(Flag.ISOLATED);
            typeFlags = (int)((long)typeFlags | 0x20000000L);
        }
        BObjectTypeSymbol objectSymbol = Symbols.createObjectSymbol(Flags.asMask(flags), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, objectTypeNode.pos, SymbolOrigin.SOURCE);
        BObjectType objectType = flags.contains((Object)Flag.SERVICE) ? new BServiceType(objectSymbol) : new BObjectType(objectSymbol, typeFlags);
        objectSymbol.type = objectType;
        objectTypeNode.symbol = objectSymbol;
        this.resultType = objectType;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        if (recordTypeNode.symbol == null) {
            EnumSet<Flag> flags = recordTypeNode.isAnonymous ? EnumSet.of(Flag.PUBLIC, Flag.ANONYMOUS) : EnumSet.noneOf(Flag.class);
            BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(flags), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, recordTypeNode.pos, recordTypeNode.isAnonymous ? SymbolOrigin.VIRTUAL : SymbolOrigin.SOURCE);
            BRecordType recordType = new BRecordType(recordSymbol);
            recordSymbol.type = recordType;
            recordTypeNode.symbol = recordSymbol;
            if (this.env.node.getKind() != NodeKind.PACKAGE) {
                recordSymbol.name = this.names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(this.env.enclPkg.packageID));
                this.symbolEnter.defineSymbol(recordTypeNode.pos, recordTypeNode.symbol, this.env);
                this.symbolEnter.defineNode(recordTypeNode, this.env);
            }
            this.resultType = recordType;
        } else {
            this.resultType = recordTypeNode.symbol.type;
        }
    }

    @Override
    public void visit(BLangStreamType streamTypeNode) {
        BType error;
        BType type = this.resolveTypeNode(streamTypeNode.type, this.env);
        BType constraintType = this.resolveTypeNode(streamTypeNode.constraint, this.env);
        BType bType = error = streamTypeNode.error != null ? this.resolveTypeNode(streamTypeNode.error, this.env) : null;
        if (constraintType == this.symTable.noType) {
            this.resultType = this.symTable.noType;
            return;
        }
        BStreamType streamType = new BStreamType(14, constraintType, error, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        streamType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.pkgID, streamType, typeSymbol.owner, streamTypeNode.pos, SymbolOrigin.SOURCE);
        this.markParameterizedType((BType)streamType, constraintType);
        if (error != null) {
            this.markParameterizedType((BType)streamType, error);
        }
        this.resultType = streamType;
    }

    @Override
    public void visit(BLangTableTypeNode tableTypeNode) {
        BType type = this.resolveTypeNode(tableTypeNode.type, this.env);
        BType constraintType = this.resolveTypeNode(tableTypeNode.constraint, this.env);
        if (constraintType == this.symTable.noType) {
            this.resultType = this.symTable.noType;
            return;
        }
        BTableType tableType = new BTableType(9, constraintType, null);
        BTypeSymbol typeSymbol = type.tsymbol;
        tableType.tsymbol = Symbols.createTypeSymbol(12, Flags.asMask(EnumSet.noneOf(Flag.class)), typeSymbol.name, this.env.enclPkg.symbol.pkgID, tableType, this.env.scope.owner, tableTypeNode.pos, SymbolOrigin.SOURCE);
        tableType.constraintPos = tableTypeNode.constraint.pos;
        if (tableTypeNode.tableKeyTypeConstraint != null) {
            tableType.keyTypeConstraint = this.resolveTypeNode(tableTypeNode.tableKeyTypeConstraint.keyType, this.env);
            tableType.keyPos = tableTypeNode.tableKeyTypeConstraint.pos;
        } else if (tableTypeNode.tableKeySpecifier != null) {
            BLangTableKeySpecifier tableKeySpecifier = tableTypeNode.tableKeySpecifier;
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (IdentifierNode identifier : tableKeySpecifier.fieldNameIdentifierList) {
                fieldNameList.add(((BLangIdentifier)identifier).value);
            }
            tableType.fieldNameList = fieldNameList;
            tableType.keyPos = tableKeySpecifier.pos;
        }
        this.markParameterizedType((BType)tableType, constraintType);
        this.resultType = tableType;
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(0x10001C, Flags.asMask(EnumSet.noneOf(Flag.class)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, finiteTypeNode.pos, SymbolOrigin.SOURCE);
        BFiniteType finiteType = new BFiniteType(finiteTypeSymbol);
        for (BLangExpression literal : finiteTypeNode.valueSpace) {
            ((BLangLiteral)literal).type = this.symTable.getTypeFromTag(((BLangLiteral)literal).type.tag);
            finiteType.addValue(literal);
        }
        finiteTypeSymbol.type = finiteType;
        this.resultType = finiteType;
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        List<BType> memberTypes = tupleTypeNode.memberTypeNodes.stream().map(memTypeNode -> this.resolveTypeNode((BLangType)memTypeNode, this.env)).collect(Collectors.toList());
        if (memberTypes.contains(this.symTable.noType)) {
            this.resultType = this.symTable.noType;
            return;
        }
        BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(8454172, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, tupleTypeNode.pos, SymbolOrigin.SOURCE);
        BTupleType tupleType = new BTupleType(tupleTypeSymbol, memberTypes);
        tupleTypeSymbol.type = tupleType;
        if (tupleTypeNode.restParamType != null) {
            tupleType.restType = this.resolveTypeNode(tupleTypeNode.restParamType, this.env);
            this.markParameterizedType((BType)tupleType, tupleType.restType);
        }
        this.markParameterizedType((BType)tupleType, memberTypes);
        this.resultType = tupleType;
    }

    @Override
    public void visit(BLangErrorType errorTypeNode) {
        BType detailType = Optional.ofNullable(errorTypeNode.detailType).map(bLangType -> this.resolveTypeNode((BLangType)bLangType, this.env)).orElse(this.symTable.detailType);
        boolean distinctErrorDef = errorTypeNode.flagSet.contains((Object)Flag.DISTINCT);
        if (detailType == this.symTable.detailType && !distinctErrorDef && !this.env.enclPkg.packageID.equals(PackageID.ANNOTATIONS)) {
            this.resultType = this.symTable.errorType;
            return;
        }
        BErrorTypeSymbol errorTypeSymbol = Symbols.createErrorSymbol(Flags.asMask(errorTypeNode.flagSet), Names.EMPTY, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, errorTypeNode.pos, SymbolOrigin.SOURCE);
        BErrorType errorType = new BErrorType(errorTypeSymbol, detailType);
        errorType.flags |= errorTypeSymbol.flags;
        errorTypeSymbol.type = errorType;
        this.markParameterizedType((BType)errorType, detailType);
        errorType.typeIdSet = BTypeIdSet.emptySet();
        this.resultType = errorType;
    }

    @Override
    public void visit(BLangConstrainedType constrainedTypeNode) {
        BType type = this.resolveTypeNode(constrainedTypeNode.type, this.env);
        BType constraintType = this.resolveTypeNode(constrainedTypeNode.constraint, this.env);
        if (constraintType == this.symTable.noType) {
            this.resultType = this.symTable.noType;
            return;
        }
        BBuiltInRefType constrainedType = null;
        if (type.tag == 31) {
            constrainedType = new BFutureType(31, constraintType, null);
        } else if (type.tag == 15) {
            constrainedType = new BMapType(15, constraintType, null);
        } else if (type.tag == 13) {
            constrainedType = new BTypedescType(constraintType, null);
        } else if (type.tag == 8) {
            if (constraintType.tag == 51) {
                BType typedescType = ((BParameterizedType)constraintType).paramSymbol.type;
                BType typedescConstraint = ((BTypedescType)typedescType).constraint;
                this.validateXMLConstraintType(typedescConstraint, constrainedTypeNode.pos);
            } else {
                this.validateXMLConstraintType(constraintType, constrainedTypeNode.pos);
            }
            constrainedType = new BXMLType(constraintType, null);
        } else {
            return;
        }
        BTypeSymbol typeSymbol = type.tsymbol;
        constrainedType.tsymbol = Symbols.createTypeSymbol(typeSymbol.tag, typeSymbol.flags, typeSymbol.name, typeSymbol.pkgID, constrainedType, typeSymbol.owner, constrainedTypeNode.pos, SymbolOrigin.SOURCE);
        this.markParameterizedType((BType)constrainedType, constraintType);
        this.resultType = constrainedType;
    }

    private void validateXMLConstraintType(BType constraintType, Location pos) {
        if (constraintType.tag == 20) {
            this.checkUnionTypeForXMLSubTypes((BUnionType)constraintType, pos);
            return;
        }
        if (!TypeTags.isXMLTypeTag(constraintType.tag) && constraintType.tag != 49) {
            this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_CONSTRAINT, this.symTable.xmlType, constraintType);
        }
    }

    private void checkUnionTypeForXMLSubTypes(BUnionType constraintUnionType, Location pos) {
        for (BType memberType : constraintUnionType.getMemberTypes()) {
            if (memberType.tag == 20) {
                this.checkUnionTypeForXMLSubTypes((BUnionType)memberType, pos);
            }
            if (TypeTags.isXMLTypeTag(memberType.tag)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_CONSTRAINT, this.symTable.xmlType, constraintUnionType);
        }
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedTypeNode) {
        Name pkgAlias = this.names.fromIdNode(userDefinedTypeNode.pkgAlias);
        Name typeName = this.names.fromIdNode(userDefinedTypeNode.typeName);
        BSymbol symbol = this.symTable.notFoundSymbol;
        if (this.env.scope.owner.tag == 2) {
            symbol = this.lookupAnnotationSpaceSymbolInPackage(userDefinedTypeNode.pos, this.env, pkgAlias, typeName);
        }
        if (symbol == this.symTable.notFoundSymbol) {
            BSymbol tempSymbol = this.lookupMainSpaceSymbolInPackage(userDefinedTypeNode.pos, this.env, pkgAlias, typeName);
            if ((tempSymbol.tag & 0xC) == 12) {
                symbol = tempSymbol;
            } else if (Symbols.isTagOn(tempSymbol, 52) && this.env.node.getKind() == NodeKind.FUNCTION) {
                BType paramValType;
                BLangFunction func = (BLangFunction)this.env.node;
                boolean errored = false;
                if (func.returnTypeNode == null || func.hasBody() && func.body.getKind() != NodeKind.EXTERN_FUNCTION_BODY) {
                    this.dlog.error(userDefinedTypeNode.pos, DiagnosticErrorCode.INVALID_NON_EXTERNAL_DEPENDENTLY_TYPED_FUNCTION, new Object[0]);
                    errored = true;
                }
                if (tempSymbol.type.tag != 13) {
                    this.dlog.error(userDefinedTypeNode.pos, DiagnosticErrorCode.INVALID_PARAM_TYPE_FOR_RETURN_TYPE, tempSymbol.type);
                    errored = true;
                }
                if (errored) {
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                ParameterizedTypeInfo parameterizedTypeInfo = this.getTypedescParamValueType(func.requiredParams, tempSymbol);
                BType bType = paramValType = parameterizedTypeInfo == null ? null : parameterizedTypeInfo.paramValueType;
                if (paramValType == this.symTable.semanticError) {
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                if (paramValType != null) {
                    BTypeSymbol tSymbol = new BTypeSymbol(12, 0x4000000L | tempSymbol.flags, tempSymbol.name, tempSymbol.pkgID, null, func.symbol, tempSymbol.pos, SymbolOrigin.VIRTUAL);
                    tSymbol.type = new BParameterizedType(paramValType, (BVarSymbol)tempSymbol, tSymbol, tempSymbol.name, parameterizedTypeInfo.index);
                    tSymbol.type.flags |= 0x4000000L;
                    this.resultType = tSymbol.type;
                    return;
                }
            }
        }
        if (symbol == this.symTable.notFoundSymbol) {
            symbol = this.lookupMemberSymbol(userDefinedTypeNode.pos, this.symTable.rootScope, this.env, typeName, 20);
        }
        if (this.env.logErrors && symbol == this.symTable.notFoundSymbol) {
            if (!(this.missingNodesHelper.isMissingNode(pkgAlias) || this.missingNodesHelper.isMissingNode(typeName) || this.symbolEnter.isUnknownTypeRef(userDefinedTypeNode))) {
                this.dlog.error(userDefinedTypeNode.pos, this.diagCode, typeName);
            }
            this.resultType = this.symTable.semanticError;
            return;
        }
        this.resultType = symbol.type;
    }

    private ParameterizedTypeInfo getTypedescParamValueType(List<BLangSimpleVariable> params, BSymbol varSym) {
        for (int i = 0; i < params.size(); ++i) {
            BLangSimpleVariable param = params.get(i);
            if (!param.name.value.equals(varSym.name.value)) continue;
            if (param.expr == null) {
                return new ParameterizedTypeInfo(((BTypedescType)varSym.type).constraint, i);
            }
            NodeKind defaultValueExprKind = param.expr.getKind();
            if (defaultValueExprKind == NodeKind.TYPEDESC_EXPRESSION) {
                return new ParameterizedTypeInfo(this.resolveTypeNode(((BLangTypedescExpr)param.expr).typeNode, this.env), i);
            }
            if (defaultValueExprKind == NodeKind.SIMPLE_VARIABLE_REF) {
                Name varName = this.names.fromIdNode(((BLangSimpleVarRef)param.expr).variableName);
                BSymbol typeRefSym = this.lookupSymbolInMainSpace(this.env, varName);
                if (typeRefSym != this.symTable.notFoundSymbol) {
                    return new ParameterizedTypeInfo(typeRefSym.type, i);
                }
                return new ParameterizedTypeInfo(this.symTable.semanticError);
            }
            this.dlog.error(param.pos, DiagnosticErrorCode.INVALID_TYPEDESC_PARAM, new Object[0]);
            return new ParameterizedTypeInfo(this.symTable.semanticError);
        }
        return null;
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        this.resultType = this.createInvokableType(functionTypeNode.getParams(), functionTypeNode.restParam, functionTypeNode.returnTypeNode, Flags.asMask(functionTypeNode.flagSet), this.env, functionTypeNode.pos);
    }

    /*
     * WARNING - void declaration
     */
    public BType createInvokableType(List<? extends BLangVariable> paramVars, BLangVariable restVariable, BLangType retTypeVar, long flags, SymbolEnv env, Location location) {
        void var13_15;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>();
        boolean foundDefaultableParam = false;
        ArrayList<String> paramNames = new ArrayList<String>();
        for (BLangVariable bLangVariable : paramVars) {
            BVarSymbol symbol;
            BType type;
            BLangSimpleVariable param = (BLangSimpleVariable)bLangVariable;
            Name paramName = this.names.fromIdNode(param.name);
            if (paramName != Names.EMPTY) {
                if (paramNames.contains(paramName.value)) {
                    this.dlog.error(param.name.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, paramName.value);
                } else {
                    paramNames.add(paramName.value);
                }
            }
            if ((type = this.resolveTypeNode(param.getTypeNode(), env)) == this.symTable.noType) {
                return this.symTable.noType;
            }
            bLangVariable.type = type;
            paramTypes.add(type);
            if (param.expr != null) {
                foundDefaultableParam = true;
            }
            param.symbol = symbol = new BVarSymbol(type.flags, paramName, env.enclPkg.symbol.pkgID, type, env.scope.owner, param.pos, SymbolOrigin.SOURCE);
            if (param.expr == null && foundDefaultableParam) {
                this.dlog.error(param.pos, DiagnosticErrorCode.REQUIRED_PARAM_DEFINED_AFTER_DEFAULTABLE_PARAM, new Object[0]);
            }
            if (param.flagSet.contains((Object)Flag.PUBLIC)) {
                symbol.flags |= 1L;
            }
            if (param.flagSet.contains((Object)Flag.TRANSACTIONAL)) {
                symbol.flags |= 0x2000000L;
            }
            if (param.expr != null) {
                symbol.flags |= 0x1000L;
                symbol.defaultableParam = true;
            }
            params.add(symbol);
        }
        BType retType = this.resolveTypeNode(retTypeVar, env);
        if (retType == this.symTable.noType) {
            return this.symTable.noType;
        }
        Object var13_13 = null;
        BType restType = null;
        if (restVariable != null) {
            restType = this.resolveTypeNode(restVariable.typeNode, env);
            if (restType == this.symTable.noType) {
                return this.symTable.noType;
            }
            restVariable.type = restType;
            BVarSymbol bVarSymbol = new BVarSymbol(restType.flags, this.names.fromIdNode(((BLangSimpleVariable)restVariable).name), env.enclPkg.symbol.pkgID, restType, env.scope.owner, restVariable.pos, SymbolOrigin.SOURCE);
        }
        BInvokableType bInvokableType = new BInvokableType(paramTypes, restType, retType, null);
        bInvokableType.flags = flags;
        BInvokableTypeSymbol tsymbol = Symbols.createInvokableTypeSymbol(67108892, flags, env.enclPkg.symbol.pkgID, bInvokableType, env.scope.owner, location, SymbolOrigin.SOURCE);
        tsymbol.params = params;
        tsymbol.restParam = var13_15;
        tsymbol.returnType = retType;
        bInvokableType.tsymbol = tsymbol;
        ArrayList<BType> allConstituentTypes = new ArrayList<BType>(paramTypes);
        allConstituentTypes.add(restType);
        allConstituentTypes.add(retType);
        this.markParameterizedType((BType)bInvokableType, allConstituentTypes);
        return bInvokableType;
    }

    public Map<Name, List<Scope.ScopeEntry>> getAllVisibleInScopeSymbols(SymbolEnv env) {
        HashMap<Name, List<Scope.ScopeEntry>> visibleEntries = new HashMap<Name, List<Scope.ScopeEntry>>();
        env.scope.entries.forEach((key, value) -> {
            ArrayList<Scope.ScopeEntry> entryList = new ArrayList<Scope.ScopeEntry>();
            entryList.add((Scope.ScopeEntry)value);
            visibleEntries.put((Name)key, (List<Scope.ScopeEntry>)entryList);
        });
        if (env.enclEnv != null) {
            this.getAllVisibleInScopeSymbols(env.enclEnv).forEach((name, entryList) -> {
                if (!visibleEntries.containsKey(name)) {
                    visibleEntries.put((Name)name, (List<Scope.ScopeEntry>)entryList);
                } else {
                    List scopeEntries = (List)visibleEntries.get(name);
                    entryList.forEach(scopeEntry -> {
                        if (!scopeEntries.contains(scopeEntry) && !(scopeEntry.symbol instanceof BVarSymbol)) {
                            scopeEntries.add(scopeEntry);
                        }
                    });
                }
            });
        }
        return visibleEntries;
    }

    public BSymbol getBinaryEqualityForTypeSets(OperatorKind opKind, BType lhsType, BType rhsType, BLangBinaryExpr binaryExpr) {
        boolean validEqualityIntersectionExists;
        switch (opKind) {
            case EQUAL: 
            case NOT_EQUAL: {
                validEqualityIntersectionExists = this.types.validEqualityIntersectionExists(lhsType, rhsType);
                break;
            }
            case REF_EQUAL: 
            case REF_NOT_EQUAL: {
                validEqualityIntersectionExists = this.types.isAssignable(lhsType, rhsType) || this.types.isAssignable(rhsType, lhsType);
                break;
            }
            default: {
                return this.symTable.notFoundSymbol;
            }
        }
        if (validEqualityIntersectionExists) {
            if (!this.types.isValueType(lhsType) && !this.types.isValueType(rhsType) || this.types.isValueType(lhsType) && this.types.isValueType(rhsType)) {
                return this.createEqualityOperator(opKind, lhsType, rhsType);
            }
            this.types.setImplicitCastExpr(binaryExpr.rhsExpr, rhsType, this.symTable.anyType);
            this.types.setImplicitCastExpr(binaryExpr.lhsExpr, lhsType, this.symTable.anyType);
            switch (opKind) {
                case REF_EQUAL: {
                    return this.createEqualityOperator(OperatorKind.EQUAL, this.symTable.anyType, this.symTable.anyType);
                }
                case REF_NOT_EQUAL: {
                    return this.createEqualityOperator(OperatorKind.NOT_EQUAL, this.symTable.anyType, this.symTable.anyType);
                }
            }
            return this.createEqualityOperator(opKind, this.symTable.anyType, this.symTable.anyType);
        }
        return this.symTable.notFoundSymbol;
    }

    public boolean markParameterizedType(BType type, BType constituentType) {
        if (Symbols.isFlagOn(constituentType.flags, 0x4000000L)) {
            type.tsymbol.flags |= 0x4000000L;
            type.flags |= 0x4000000L;
            return true;
        }
        return false;
    }

    public void markParameterizedType(BType enclosingType, Collection<BType> constituentTypes) {
        if (Symbols.isFlagOn(enclosingType.flags, 0x4000000L)) {
            return;
        }
        for (BType type : constituentTypes) {
            if (type != null && this.markParameterizedType(enclosingType, type)) break;
        }
    }

    private BSymbol resolveOperator(Scope.ScopeEntry entry, List<BType> types) {
        BSymbol foundSymbol = this.symTable.notFoundSymbol;
        while (entry != Scope.NOT_FOUND_ENTRY) {
            BInvokableType opType = (BInvokableType)entry.symbol.type;
            if (types.size() == opType.paramTypes.size()) {
                boolean match = true;
                for (int i = 0; i < types.size(); ++i) {
                    if (types.get((int)i).tag == opType.paramTypes.get((int)i).tag) continue;
                    match = false;
                }
                if (match) {
                    foundSymbol = entry.symbol;
                    break;
                }
            }
            entry = entry.next;
        }
        return foundSymbol;
    }

    private void visitBuiltInTypeNode(BLangType typeNode, TypeKind typeKind, SymbolEnv env) {
        Name typeName = this.names.fromTypeKind(typeKind);
        BSymbol typeSymbol = this.lookupMemberSymbol(typeNode.pos, this.symTable.rootScope, env, typeName, 12);
        if (typeSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(typeNode.pos, this.diagCode, typeName);
        }
        this.resultType = typeNode.type = typeSymbol.type;
    }

    private void addNamespacesInScope(Map<Name, BXMLNSSymbol> namespaces, SymbolEnv env) {
        if (env == null) {
            return;
        }
        env.scope.entries.forEach((name, scopeEntry) -> {
            if (scopeEntry.symbol.kind == SymbolKind.XMLNS) {
                BXMLNSSymbol nsSymbol = (BXMLNSSymbol)scopeEntry.symbol;
                if (!namespaces.containsKey(name)) {
                    namespaces.put((Name)name, nsSymbol);
                }
            }
        });
        this.addNamespacesInScope(namespaces, env.enclEnv);
    }

    private boolean isMemberAccessAllowed(SymbolEnv env, BSymbol symbol) {
        if (Symbols.isPublic(symbol)) {
            return true;
        }
        if (!Symbols.isPrivate(symbol)) {
            return env.enclPkg.symbol.pkgID == symbol.pkgID;
        }
        if (env.enclType != null) {
            return env.enclType.type.tsymbol == symbol.owner;
        }
        return this.isMemberAllowed(env, symbol);
    }

    private boolean isMemberAllowed(SymbolEnv env, BSymbol symbol) {
        return env != null && (env.enclInvokable != null && env.enclInvokable.symbol.receiverSymbol != null && env.enclInvokable.symbol.receiverSymbol.type.tsymbol == symbol.owner || this.isMemberAllowed(env.enclEnv, symbol));
    }

    private BType computeIntersectionType(BLangIntersectionTypeNode intersectionTypeNode) {
        List<BLangType> constituentTypeNodes = intersectionTypeNode.constituentTypeNodes;
        HashMap<BType, BLangType> typeBLangTypeMap = new HashMap<BType, BLangType>();
        boolean validIntersection = true;
        BLangType bLangTypeOne = constituentTypeNodes.get(0);
        BType typeOne = this.resolveTypeNode(bLangTypeOne, this.env);
        if (typeOne == this.symTable.noType) {
            return this.symTable.noType;
        }
        typeBLangTypeMap.put(typeOne, bLangTypeOne);
        BLangType bLangTypeTwo = constituentTypeNodes.get(1);
        BType typeTwo = this.resolveTypeNode(bLangTypeTwo, this.env);
        if (typeTwo == this.symTable.noType) {
            return this.symTable.noType;
        }
        typeBLangTypeMap.put(typeTwo, bLangTypeTwo);
        boolean hasReadOnlyType = typeOne == this.symTable.readonlyType || typeTwo == this.symTable.readonlyType;
        BType potentialIntersectionType = this.getPotentialReadOnlyIntersection(typeOne, typeTwo);
        if (potentialIntersectionType == this.symTable.semanticError) {
            validIntersection = false;
        } else {
            for (int i = 2; i < constituentTypeNodes.size(); ++i) {
                BLangType bLangType = constituentTypeNodes.get(i);
                BType type = this.resolveTypeNode(bLangType, this.env);
                typeBLangTypeMap.put(type, bLangType);
                if (!hasReadOnlyType) {
                    boolean bl = hasReadOnlyType = type == this.symTable.readonlyType;
                }
                if (type == this.symTable.noType) {
                    return this.symTable.noType;
                }
                if ((potentialIntersectionType = this.getPotentialReadOnlyIntersection(potentialIntersectionType, type)) != this.symTable.semanticError) continue;
                validIntersection = false;
                break;
            }
        }
        if (!validIntersection) {
            this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, intersectionTypeNode);
            return this.symTable.semanticError;
        }
        if (!hasReadOnlyType) {
            this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.INVALID_NON_READONLY_INTERSECTION_TYPE, intersectionTypeNode);
            return this.symTable.semanticError;
        }
        if (this.types.isInherentlyImmutableType(potentialIntersectionType)) {
            return potentialIntersectionType;
        }
        if (!this.types.isSelectivelyImmutableType(potentialIntersectionType, true, false)) {
            if (this.types.isSelectivelyImmutableType(potentialIntersectionType)) {
                this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.INVALID_READONLY_OBJECT_INTERSECTION_TYPE, new Object[0]);
            } else {
                this.dlog.error(intersectionTypeNode.pos, DiagnosticErrorCode.INVALID_READONLY_INTERSECTION_TYPE, potentialIntersectionType);
            }
            return this.symTable.semanticError;
        }
        BLangType typeNode = (BLangType)typeBLangTypeMap.get(potentialIntersectionType);
        Set<Object> flagSet = typeNode == null ? new HashSet() : (typeNode.getKind() == NodeKind.OBJECT_TYPE ? ((BLangObjectTypeNode)typeNode).flagSet : (typeNode.getKind() == NodeKind.USER_DEFINED_TYPE ? ((BLangUserDefinedType)typeNode).flagSet : new HashSet()));
        return ImmutableTypeCloner.getImmutableIntersectionType(intersectionTypeNode.pos, this.types, (SelectivelyImmutableReferenceType)((Object)potentialIntersectionType), this.env, this.symTable, this.anonymousModelHelper, this.names, flagSet);
    }

    private BType getPotentialReadOnlyIntersection(BType lhsType, BType rhsType) {
        if (lhsType == this.symTable.readonlyType) {
            return rhsType;
        }
        if (rhsType == this.symTable.readonlyType) {
            return lhsType;
        }
        return this.types.getTypeIntersection(lhsType, rhsType);
    }

    private static class ParameterizedTypeInfo {
        BType paramValueType;
        int index = -1;

        private ParameterizedTypeInfo(BType paramValueType) {
            this.paramValueType = paramValueType;
        }

        private ParameterizedTypeInfo(BType paramValueType, int index) {
            this.paramValueType = paramValueType;
            this.index = index;
        }
    }
}

