/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.runtime.internal.IdentifierUtils;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.ActionNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.NamedArgNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TupleType;
import org.ballerinalang.model.types.Type;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeNarrower;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BLetSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangInputClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableMultiKeyExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;
import org.wso2.ballerinalang.compiler.util.TypeDefBuilderHelper;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class TypeChecker
extends BLangNodeVisitor {
    private static final CompilerContext.Key<TypeChecker> TYPE_CHECKER_KEY = new CompilerContext.Key();
    private static Set<String> listLengthModifierFunctions = new HashSet<String>();
    private static Map<String, HashSet<String>> modifierFunctions = new HashMap<String, HashSet<String>>();
    private static final String TABLE_TNAME = "table";
    private static final String LIST_LANG_LIB = "lang.array";
    private static final String MAP_LANG_LIB = "lang.map";
    private static final String TABLE_LANG_LIB = "lang.table";
    private static final String VALUE_LANG_LIB = "lang.value";
    private static final String XML_LANG_LIB = "lang.xml";
    private static final String FUNCTION_NAME_PUSH = "push";
    private static final String FUNCTION_NAME_POP = "pop";
    private static final String FUNCTION_NAME_SHIFT = "shift";
    private static final String FUNCTION_NAME_UNSHIFT = "unshift";
    private static final String FUNCTION_NAME_ENSURE_TYPE = "ensureType";
    private Names names;
    private SymbolTable symTable;
    private SymbolEnter symbolEnter;
    private SymbolResolver symResolver;
    private NodeCloner nodeCloner;
    private Types types;
    private BLangDiagnosticLog dlog;
    private SymbolEnv env;
    private boolean isTypeChecked;
    private TypeNarrower typeNarrower;
    private TypeParamAnalyzer typeParamAnalyzer;
    private BLangAnonymousModelHelper anonymousModelHelper;
    private SemanticAnalyzer semanticAnalyzer;
    private ResolvedTypeBuilder typeBuilder;
    private boolean nonErrorLoggingCheck = false;
    private int letCount = 0;
    private Stack<SymbolEnv> queryEnvs;
    private Stack<SymbolEnv> prevEnvs;
    private Stack<BLangSelectClause> selectClauses;
    private BLangMissingNodesHelper missingNodesHelper;
    private BType expType;
    private BType resultType;
    private DiagnosticCode diagCode;

    public static TypeChecker getInstance(CompilerContext context) {
        TypeChecker typeChecker = context.get(TYPE_CHECKER_KEY);
        if (typeChecker == null) {
            typeChecker = new TypeChecker(context);
        }
        return typeChecker;
    }

    public TypeChecker(CompilerContext context) {
        context.put(TYPE_CHECKER_KEY, this);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.typeBuilder = new ResolvedTypeBuilder();
        this.selectClauses = new Stack();
        this.queryEnvs = new Stack();
        this.prevEnvs = new Stack();
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env) {
        return this.checkExpr(expr, env, this.symTable.noType);
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType) {
        return this.checkExpr(expr, env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES);
    }

    public BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType, DiagnosticCode diagCode) {
        if (expr.typeChecked) {
            return expr.type;
        }
        if (expType.tag == 21) {
            expType = ((BIntersectionType)expType).effectiveType;
        }
        SymbolEnv prevEnv = this.env;
        BType preExpType = this.expType;
        DiagnosticCode preDiagCode = this.diagCode;
        this.env = env;
        this.diagCode = diagCode;
        this.expType = expType;
        this.isTypeChecked = true;
        expr.expectedType = expType;
        expr.accept(this);
        if (this.resultType.tag == 21) {
            this.resultType = ((BIntersectionType)this.resultType).effectiveType;
        }
        expr.type = this.resultType;
        expr.typeChecked = this.isTypeChecked;
        this.env = prevEnv;
        this.expType = preExpType;
        this.diagCode = preDiagCode;
        this.validateAndSetExprExpectedType(expr);
        return this.resultType;
    }

    private void validateAndSetExprExpectedType(BLangExpression expr) {
        if (this.resultType.tag == 27) {
            return;
        }
        if (expr.getKind() == NodeKind.RECORD_LITERAL_EXPR && expr.expectedType != null && expr.expectedType.tag == 15 && expr.type.tag == 12) {
            return;
        }
        expr.expectedType = this.resultType;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        BType literalType = this.setLiteralValueAndGetType(literalExpr, this.expType);
        if (literalType == this.symTable.semanticError || literalExpr.isFiniteContext) {
            return;
        }
        this.resultType = this.types.checkType(literalExpr, literalType, this.expType);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.checkXMLNamespacePrefixes(xmlElementAccess.filters);
        this.checkExpr(xmlElementAccess.expr, this.env, this.symTable.xmlType);
        this.resultType = new BXMLType(this.symTable.xmlElementType, null);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        if (xmlNavigation.lhsVar) {
            this.dlog.error(xmlNavigation.pos, DiagnosticErrorCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
        }
        this.checkXMLNamespacePrefixes(xmlNavigation.filters);
        if (xmlNavigation.childIndex != null) {
            this.checkExpr(xmlNavigation.childIndex, this.env, this.symTable.intType);
        }
        BType actualType = this.checkExpr(xmlNavigation.expr, this.env, this.symTable.xmlType);
        this.types.checkType(xmlNavigation, actualType, this.expType);
        this.resultType = xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.CHILDREN ? this.symTable.xmlType : new BXMLType(this.symTable.xmlElementType, null);
    }

    private void checkXMLNamespacePrefixes(List<BLangXMLElementFilter> filters) {
        for (BLangXMLElementFilter filter : filters) {
            BSymbol nsSymbol;
            if (filter.namespace.isEmpty()) continue;
            Name nsName = this.names.fromString(filter.namespace);
            filter.namespaceSymbol = nsSymbol = this.symResolver.lookupSymbolInPrefixSpace(this.env, nsName);
            if (nsSymbol != this.symTable.notFoundSymbol) continue;
            this.dlog.error(filter.nsPos, DiagnosticErrorCode.CANNOT_FIND_XML_NAMESPACE, nsName);
        }
    }

    private BType setLiteralValueAndGetType(BLangLiteral literalExpr, BType expType) {
        BType literalType = this.symTable.getTypeFromTag(literalExpr.type.tag);
        Object literalValue = literalExpr.value;
        literalExpr.isJSONContext = this.types.isJSONContext(expType);
        if (literalType.tag == 1) {
            if (expType.tag == 3) {
                literalType = this.symTable.floatType;
                literalExpr.value = ((Long)literalValue).doubleValue();
            } else if (expType.tag == 4 && !NumericLiteralSupport.hasHexIndicator(literalExpr.originalValue)) {
                literalType = this.symTable.decimalType;
                literalExpr.value = String.valueOf(literalValue);
            } else if (TypeTags.isIntegerTypeTag(expType.tag) || expType.tag == 2) {
                if ((literalType = this.getIntLiteralType(literalExpr.pos, expType, literalType, literalValue)) == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
            } else if (expType.tag == 32 && this.types.isAssignableToFiniteType(expType, literalExpr)) {
                BFiniteType finiteType = (BFiniteType)expType;
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 1)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.intType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 2)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.byteType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 3)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.floatType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 4)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 38)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.signed32IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 39)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.signed16IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 40)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.signed8IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 41)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.unsigned32IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 42)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.unsigned16IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 43)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.unsigned8IntType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
            } else if (expType.tag == 20) {
                BType setType;
                Set<BType> memberTypes = ((BUnionType)expType).getMemberTypes();
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 1 || memType.tag == 7 || memType.tag == 11 || memType.tag == 17)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.intType);
                }
                BType finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.intType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 2)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.byteType);
                }
                finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.byteType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 3)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.floatType);
                }
                finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.floatType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
                if (memberTypes.stream().anyMatch(memType -> memType.tag == 4)) {
                    return this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                }
                finiteType = this.getFiniteTypeWithValuesOfSingleType((BUnionType)expType, this.symTable.decimalType);
                if (finiteType != this.symTable.semanticError) {
                    setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
                    if (literalExpr.isFiniteContext) {
                        return setType;
                    }
                }
            }
        } else if (literalType.tag == 3) {
            BUnionType unionType;
            BType unionMember;
            String literal = String.valueOf(literalValue);
            String numericLiteral = NumericLiteralSupport.stripDiscriminator(literal);
            boolean isDiscriminatedFloat = NumericLiteralSupport.isFloatDiscriminated(literal);
            if (expType.tag == 4) {
                if (isDiscriminatedFloat || NumericLiteralSupport.isHexLiteral(numericLiteral)) {
                    this.dlog.error(literalExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, this.symTable.floatType);
                    this.resultType = this.symTable.semanticError;
                    return this.resultType;
                }
                literalType = this.symTable.decimalType;
                literalExpr.value = numericLiteral;
            } else if (expType.tag == 3) {
                literalExpr.value = Double.parseDouble(String.valueOf(numericLiteral));
            } else if (expType.tag == 32 && this.types.isAssignableToFiniteType(expType, literalExpr)) {
                BFiniteType finiteType = (BFiniteType)expType;
                if (this.literalAssignableToFiniteType(literalExpr, finiteType, 3)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.floatType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
                if (!isDiscriminatedFloat && this.literalAssignableToFiniteType(literalExpr, finiteType, 4)) {
                    BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                    this.setLiteralValueForFiniteType(literalExpr, valueType);
                    return valueType;
                }
            } else if (expType.tag == 20 && (unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType = (BUnionType)expType, this.symTable.floatType)) != this.symTable.noType) {
                return unionMember;
            }
        } else {
            BUnionType unionType;
            boolean foundMember;
            if (literalType.tag == 4) {
                return this.decimalLiteral(literalValue, literalExpr, expType);
            }
            if (literalType.tag == 5 && this.expType.tag == 44 && this.types.isCharLiteralValue((String)literalValue)) {
                return this.symTable.charStringType;
            }
            BType expected = this.getResolvedIntersectionType(this.expType);
            if (expected.tag == 32) {
                boolean foundMember2 = this.types.isAssignableToFiniteType(expected, literalExpr);
                if (foundMember2) {
                    this.setLiteralValueForFiniteType(literalExpr, literalType);
                    return literalType;
                }
            } else if (expected.tag == 20 && (foundMember = (unionType = (BUnionType)expected).getMemberTypes().stream().anyMatch(memberType -> this.types.isAssignableToFiniteType((BType)memberType, literalExpr)))) {
                this.setLiteralValueForFiniteType(literalExpr, literalType);
                return literalType;
            }
        }
        if (literalExpr.type.tag == 34) {
            literalType = new BArrayType(this.symTable.byteType);
        }
        return literalType;
    }

    private BType getAndSetAssignableUnionMember(BLangLiteral literalExpr, BUnionType expType, BType desiredType) {
        BType setType;
        Set<BType> memberTypes = expType.getMemberTypes();
        if (memberTypes.stream().anyMatch(memType -> memType.tag == desiredType.tag || memType.tag == 7 || memType.tag == 11 || memType.tag == 17)) {
            return this.setLiteralValueAndGetType(literalExpr, desiredType);
        }
        BType finiteType = this.getFiniteTypeWithValuesOfSingleType(expType, this.symTable.floatType);
        if (finiteType != this.symTable.semanticError) {
            setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
            if (literalExpr.isFiniteContext) {
                return setType;
            }
        }
        if (memberTypes.stream().anyMatch(memType -> memType.tag == 4)) {
            return this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
        }
        finiteType = this.getFiniteTypeWithValuesOfSingleType(expType, this.symTable.decimalType);
        if (finiteType != this.symTable.semanticError) {
            setType = this.setLiteralValueAndGetType(literalExpr, finiteType);
            if (literalExpr.isFiniteContext) {
                return setType;
            }
        }
        return this.symTable.noType;
    }

    private boolean literalAssignableToFiniteType(BLangLiteral literalExpr, BFiniteType finiteType, int targetMemberTypeTag) {
        for (BLangExpression valueExpr : finiteType.getValueSpace()) {
            if (valueExpr.type.tag != targetMemberTypeTag || !this.types.checkLiteralAssignabilityBasedOnType((BLangLiteral)valueExpr, literalExpr)) continue;
            return true;
        }
        return false;
    }

    private BType decimalLiteral(Object literalValue, BLangLiteral literalExpr, BType expType) {
        BUnionType unionType;
        BType unionMember;
        String literal = String.valueOf(literalValue);
        if (expType.tag == 3 && NumericLiteralSupport.isDecimalDiscriminated(literal)) {
            this.dlog.error(literalExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, this.symTable.decimalType);
            this.resultType = this.symTable.semanticError;
            return this.resultType;
        }
        if (expType.tag == 32 && this.types.isAssignableToFiniteType(expType, literalExpr)) {
            BFiniteType finiteType = (BFiniteType)expType;
            if (this.literalAssignableToFiniteType(literalExpr, finiteType, 4)) {
                BType valueType = this.setLiteralValueAndGetType(literalExpr, this.symTable.decimalType);
                this.setLiteralValueForFiniteType(literalExpr, valueType);
                return valueType;
            }
        } else if (expType.tag == 20 && (unionMember = this.getAndSetAssignableUnionMember(literalExpr, unionType = (BUnionType)expType, this.symTable.decimalType)) != this.symTable.noType) {
            return unionMember;
        }
        literalExpr.value = NumericLiteralSupport.stripDiscriminator(literal);
        this.resultType = this.symTable.decimalType;
        return this.symTable.decimalType;
    }

    private void setLiteralValueForFiniteType(BLangLiteral literalExpr, BType type) {
        this.types.setImplicitCastExpr(literalExpr, type, this.expType);
        this.resultType = type;
        literalExpr.isFiniteContext = true;
    }

    private BType getFiniteTypeWithValuesOfSingleType(BUnionType unionType, BType matchType) {
        List finiteTypeMembers = unionType.getMemberTypes().stream().filter(memType -> memType.tag == 32).map(memFiniteType -> (BFiniteType)memFiniteType).collect(Collectors.toList());
        if (finiteTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        int tag = matchType.tag;
        LinkedHashSet<BLangExpression> matchedValueSpace = new LinkedHashSet<BLangExpression>();
        for (BFiniteType finiteType : finiteTypeMembers) {
            HashSet<BLangExpression> set = new HashSet<BLangExpression>();
            for (BLangExpression expression : finiteType.getValueSpace()) {
                if (expression.type.tag != tag) continue;
                set.add(expression);
            }
            matchedValueSpace.addAll(set);
        }
        if (matchedValueSpace.isEmpty()) {
            return this.symTable.semanticError;
        }
        return new BFiniteType(null, matchedValueSpace);
    }

    private BType getIntLiteralType(Location location, BType expType, BType literalType, Object literalValue) {
        switch (expType.tag) {
            case 1: {
                return this.symTable.intType;
            }
            case 2: {
                if (!this.types.isByteLiteralValue((Long)literalValue)) break;
                return this.symTable.byteType;
            }
            case 38: {
                if (!this.types.isSigned32LiteralValue((Long)literalValue)) break;
                return this.symTable.signed32IntType;
            }
            case 39: {
                if (!this.types.isSigned16LiteralValue((Long)literalValue)) break;
                return this.symTable.signed16IntType;
            }
            case 40: {
                if (!this.types.isSigned8LiteralValue((Long)literalValue)) break;
                return this.symTable.signed8IntType;
            }
            case 41: {
                if (!this.types.isUnsigned32LiteralValue((Long)literalValue)) break;
                return this.symTable.unsigned32IntType;
            }
            case 42: {
                if (!this.types.isUnsigned16LiteralValue((Long)literalValue)) break;
                return this.symTable.unsigned16IntType;
            }
            case 43: {
                if (!this.types.isUnsigned8LiteralValue((Long)literalValue)) break;
                return this.symTable.unsigned8IntType;
            }
        }
        this.dlog.error(location, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, literalType);
        this.resultType = this.symTable.semanticError;
        return this.resultType;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructor) {
        if (this.expType.tag == 23 || this.expType.tag == 37) {
            BType inferredType = this.getInferredTupleType(listConstructor, this.expType);
            this.resultType = inferredType == this.symTable.semanticError ? this.symTable.semanticError : this.types.checkType(listConstructor, inferredType, this.expType);
            return;
        }
        this.resultType = this.checkListConstructorCompatibility(this.expType, listConstructor);
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        BType applicableExpType;
        if (this.expType.tag == 23) {
            List<BType> memTypes = this.checkExprList(new ArrayList<BLangExpression>(tableConstructorExpr.recordLiteralList), this.env);
            for (BType memType : memTypes) {
                if (memType != this.symTable.semanticError) continue;
                this.resultType = this.symTable.semanticError;
                return;
            }
            if (tableConstructorExpr.recordLiteralList.size() == 0) {
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.CANNOT_INFER_MEMBER_TYPE_FOR_TABLE, new Object[0]);
                this.resultType = this.symTable.semanticError;
                return;
            }
            BType inherentMemberType = this.inferTableMemberType(memTypes, tableConstructorExpr);
            BTableType tableType = new BTableType(9, inherentMemberType, null);
            for (BLangRecordLiteral recordLiteral : tableConstructorExpr.recordLiteralList) {
                recordLiteral.type = inherentMemberType;
            }
            if (!this.validateTableConstructorExpr(tableConstructorExpr, tableType)) {
                this.resultType = this.symTable.semanticError;
                return;
            }
            if (this.checkKeySpecifier(tableConstructorExpr, tableType)) {
                return;
            }
            this.resultType = tableType;
            return;
        }
        BType bType = applicableExpType = this.expType.tag == 21 ? ((BIntersectionType)this.expType).effectiveType : this.expType;
        if (applicableExpType.tag == 9) {
            ArrayList<BType> memTypes = new ArrayList<BType>();
            Object tableType = tableConstructorExpr.recordLiteralList.iterator();
            while (tableType.hasNext()) {
                BType recordType;
                BLangRecordLiteral recordLiteral;
                BLangRecordLiteral clonedExpr = recordLiteral = tableType.next();
                if (this.nonErrorLoggingCheck) {
                    ++clonedExpr.cloneAttempt;
                    clonedExpr = this.nodeCloner.clone(recordLiteral);
                }
                if ((recordType = this.checkExpr(clonedExpr, this.env, ((BTableType)applicableExpType).constraint)) == this.symTable.semanticError) {
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                memTypes.add(recordType);
            }
            if (((BTableType)applicableExpType).constraint.tag == 15) {
                this.validateMapConstraintTable(tableConstructorExpr, applicableExpType);
                return;
            }
            if (!this.validateTableType((BTableType)applicableExpType, tableConstructorExpr.recordLiteralList) || !this.validateTableConstructorExpr(tableConstructorExpr, (BTableType)applicableExpType)) {
                this.resultType = this.symTable.semanticError;
                return;
            }
            tableType = new BTableType(9, this.inferTableMemberType(memTypes, applicableExpType), null);
            if (Symbols.isFlagOn(applicableExpType.flags, 32L)) {
                ((BTableType)tableType).flags |= 0x20L;
            }
            if (this.checkKeySpecifier(tableConstructorExpr, (BTableType)tableType)) {
                return;
            }
            BTableType expectedTableType = (BTableType)applicableExpType;
            if (expectedTableType.fieldNameList != null && ((BTableType)tableType).fieldNameList == null) {
                ((BTableType)tableType).fieldNameList = expectedTableType.fieldNameList;
            }
            this.resultType = tableType;
        } else if (applicableExpType.tag == 20) {
            boolean prevNonErrorLoggingCheck = this.nonErrorLoggingCheck;
            this.nonErrorLoggingCheck = true;
            int errorCount = this.dlog.errorCount();
            this.dlog.mute();
            ArrayList<BType> matchingTypes = new ArrayList<BType>();
            BUnionType expectedType = (BUnionType)applicableExpType;
            for (BType memType : expectedType.getMemberTypes()) {
                BType resultType;
                this.dlog.resetErrorCount();
                BLangTableConstructorExpr clonedTableExpr = tableConstructorExpr;
                if (this.nonErrorLoggingCheck) {
                    ++tableConstructorExpr.cloneAttempt;
                    clonedTableExpr = this.nodeCloner.clone(tableConstructorExpr);
                }
                if ((resultType = this.checkExpr(clonedTableExpr, this.env, memType)) == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.isUniqueType(matchingTypes, resultType)) continue;
                matchingTypes.add(resultType);
            }
            this.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            this.dlog.setErrorCount(errorCount);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            if (matchingTypes.isEmpty()) {
                BLangTableConstructorExpr exprToLog = tableConstructorExpr;
                if (this.nonErrorLoggingCheck) {
                    ++tableConstructorExpr.cloneAttempt;
                    exprToLog = this.nodeCloner.clone(tableConstructorExpr);
                }
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.expType, this.getInferredTableType(exprToLog));
            } else if (matchingTypes.size() != 1) {
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, this.expType);
            } else {
                this.resultType = this.checkExpr(tableConstructorExpr, this.env, (BType)matchingTypes.get(0));
                return;
            }
            this.resultType = this.symTable.semanticError;
        } else {
            this.resultType = this.symTable.semanticError;
        }
    }

    private BType getInferredTableType(BLangTableConstructorExpr exprToLog) {
        List<BType> memTypes = this.checkExprList(new ArrayList<BLangExpression>(exprToLog.recordLiteralList), this.env);
        for (BType memType : memTypes) {
            if (memType != this.symTable.semanticError) continue;
            return this.symTable.semanticError;
        }
        return new BTableType(9, this.inferTableMemberType(memTypes, exprToLog), null);
    }

    private boolean checkKeySpecifier(BLangTableConstructorExpr tableConstructorExpr, BTableType tableType) {
        if (tableConstructorExpr.tableKeySpecifier != null) {
            if (!this.validateTableConstructorRecordLiterals(this.getTableKeyNameList(tableConstructorExpr.tableKeySpecifier), tableConstructorExpr.recordLiteralList)) {
                this.resultType = this.symTable.semanticError;
                return true;
            }
            tableType.fieldNameList = this.getTableKeyNameList(tableConstructorExpr.tableKeySpecifier);
        }
        return false;
    }

    private BType inferTableMemberType(List<BType> memTypes, BType expType) {
        if (memTypes.isEmpty()) {
            return ((BTableType)expType).constraint;
        }
        LinkedHashSet<BType> result = new LinkedHashSet<BType>();
        result.add(memTypes.get(0));
        BUnionType unionType = BUnionType.create(null, result);
        for (int i = 1; i < memTypes.size(); ++i) {
            BType source = memTypes.get(i);
            if (this.types.isAssignable(source, unionType)) continue;
            result.add(source);
            unionType = BUnionType.create(null, result);
        }
        if (unionType.getMemberTypes().size() == 1) {
            return memTypes.get(0);
        }
        return unionType;
    }

    private BType inferTableMemberType(List<BType> memTypes, BLangTableConstructorExpr tableConstructorExpr) {
        BLangTableKeySpecifier keySpecifier = tableConstructorExpr.tableKeySpecifier;
        ArrayList<String> keySpecifierFieldNames = new ArrayList<String>();
        LinkedHashSet<BField> allFieldSet = new LinkedHashSet<BField>();
        for (BType bType : memTypes) {
            allFieldSet.addAll(((BRecordType)bType).fields.values());
        }
        LinkedHashSet commonFieldSet = new LinkedHashSet(allFieldSet);
        for (BType bType : memTypes) {
            commonFieldSet.retainAll(((BRecordType)bType).fields.values());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (keySpecifier != null) {
            for (IdentifierNode identifierNode : keySpecifier.fieldNameIdentifierList) {
                arrayList.add(((BLangIdentifier)identifierNode).value);
                keySpecifierFieldNames.add(((BLangIdentifier)identifierNode).value);
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (BField field : allFieldSet) {
            String fieldName = field.name.value;
            if (arrayList2.contains(fieldName)) {
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.CANNOT_INFER_MEMBER_TYPE_FOR_TABLE_DUE_AMBIGUITY, fieldName);
                return this.symTable.semanticError;
            }
            arrayList2.add(fieldName);
            boolean isOptional = true;
            for (BField commonField : commonFieldSet) {
                if (!commonField.name.value.equals(fieldName)) continue;
                isOptional = false;
                arrayList.add(commonField.name.value);
            }
            if (isOptional) {
                field.symbol.flags = Flags.asMask(EnumSet.of(Flag.OPTIONAL));
                continue;
            }
            if (arrayList.contains(fieldName) && keySpecifierFieldNames.contains(fieldName)) {
                field.symbol.flags = Flags.asMask(EnumSet.of(Flag.REQUIRED)) + Flags.asMask(EnumSet.of(Flag.READONLY));
                continue;
            }
            if (!arrayList.contains(fieldName)) continue;
            field.symbol.flags = Flags.asMask(EnumSet.of(Flag.REQUIRED));
        }
        return this.createTableConstraintRecordType(allFieldSet, tableConstructorExpr.pos);
    }

    private BRecordType createTableConstraintRecordType(Set<BField> allFieldSet, Location pos) {
        PackageID pkgID = this.env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, pos, SymbolOrigin.VIRTUAL);
        for (BField field : allFieldSet) {
            recordSymbol.scope.define(field.name, field.symbol);
        }
        BRecordType recordType = new BRecordType(recordSymbol);
        recordType.fields = allFieldSet.stream().collect(this.getFieldCollector());
        recordSymbol.type = recordType;
        recordType.tsymbol = recordSymbol;
        BLangRecordTypeNode recordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(recordType, pkgID, this.symTable, pos);
        recordTypeNode.initFunction = TypeDefBuilderHelper.createInitFunctionForRecordType(recordTypeNode, this.env, this.names, this.symTable);
        TypeDefBuilderHelper.addTypeDefinition(recordType, recordSymbol, recordTypeNode, this.env);
        recordType.sealed = true;
        recordType.restFieldType = this.symTable.noType;
        return recordType;
    }

    private Collector<BField, ?, LinkedHashMap<String, BField>> getFieldCollector() {
        BinaryOperator mergeFunc = (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
        return Collectors.toMap(field -> field.name.value, Function.identity(), mergeFunc, LinkedHashMap::new);
    }

    private boolean validateTableType(BTableType tableType, List<BLangRecordLiteral> recordLiterals) {
        BType constraint = tableType.constraint;
        if (!this.types.isAssignable(constraint, this.symTable.mapAllType)) {
            this.dlog.error(tableType.constraintPos, DiagnosticErrorCode.TABLE_CONSTRAINT_INVALID_SUBTYPE, constraint);
            this.resultType = this.symTable.semanticError;
            return false;
        }
        List<String> fieldNameList = tableType.fieldNameList;
        if (fieldNameList != null) {
            return this.validateKeySpecifier(fieldNameList, constraint.tag != 21 ? constraint : ((BIntersectionType)constraint).effectiveType, tableType.keyPos) && this.validateTableConstructorRecordLiterals(fieldNameList, recordLiterals);
        }
        return true;
    }

    private boolean validateTableConstructorRecordLiterals(List<String> keySpecifierFieldNames, List<BLangRecordLiteral> recordLiterals) {
        for (String fieldName : keySpecifierFieldNames) {
            for (BLangRecordLiteral recordLiteral : recordLiterals) {
                BLangRecordLiteral.BLangRecordKeyValueField recordKeyValueField = this.getRecordKeyValueField(recordLiteral, fieldName);
                if (recordKeyValueField.getValue().getKind() == NodeKind.LITERAL || recordKeyValueField.getValue().getKind() == NodeKind.NUMERIC_LITERAL || recordKeyValueField.getValue().getKind() == NodeKind.RECORD_LITERAL_EXPR || recordKeyValueField.getValue().getKind() == NodeKind.ARRAY_LITERAL_EXPR || recordKeyValueField.getValue().getKind() == NodeKind.TUPLE_LITERAL_EXPR || recordKeyValueField.getValue().getKind() == NodeKind.XML_ELEMENT_LITERAL || recordKeyValueField.getValue().getKind() == NodeKind.XML_TEXT_LITERAL) continue;
                this.dlog.error(recordLiteral.pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_VALUE_MUST_BE_CONSTANT, fieldName);
                this.resultType = this.symTable.semanticError;
                return false;
            }
        }
        return true;
    }

    private BLangRecordLiteral.BLangRecordKeyValueField getRecordKeyValueField(BLangRecordLiteral recordLiteral, String fieldName) {
        for (RecordLiteralNode.RecordField recordField : recordLiteral.fields) {
            BLangRecordLiteral.BLangRecordKeyValueField recordKeyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)recordField;
            if (!fieldName.equals(recordKeyValueField.key.toString())) continue;
            return recordKeyValueField;
        }
        return null;
    }

    private boolean validateKeySpecifier(List<String> fieldNameList, BType constraint, Location pos) {
        for (String fieldName : fieldNameList) {
            BField field = this.types.getTableConstraintField(constraint, fieldName);
            if (field == null) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_FIELD_NAMES_IN_KEY_SPECIFIER, fieldName, constraint);
                this.resultType = this.symTable.semanticError;
                return false;
            }
            if (!Symbols.isFlagOn(field.symbol.flags, 32L)) {
                this.dlog.error(pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_MUST_BE_READONLY, fieldName);
                this.resultType = this.symTable.semanticError;
                return false;
            }
            if (!Symbols.isFlagOn(field.symbol.flags, 256L)) {
                this.dlog.error(pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_MUST_BE_REQUIRED, fieldName);
                this.resultType = this.symTable.semanticError;
                return false;
            }
            if (this.types.isAssignable(field.type, this.symTable.anydataType)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.KEY_SPECIFIER_FIELD_MUST_BE_ANYDATA, fieldName, constraint);
            this.resultType = this.symTable.semanticError;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateTableConstructorExpr(BLangTableConstructorExpr tableConstructorExpr, BTableType tableType) {
        BType keyTypeConstraint;
        BType constraintType = tableType.constraint;
        if (tableConstructorExpr.tableKeySpecifier != null) {
            List<String> fieldNameList = this.getTableKeyNameList(tableConstructorExpr.tableKeySpecifier);
            if (tableType.fieldNameList == null && !this.validateKeySpecifier(fieldNameList, constraintType.tag != 21 ? constraintType : ((BIntersectionType)constraintType).effectiveType, tableConstructorExpr.tableKeySpecifier.pos)) {
                return false;
            }
            if (tableType.fieldNameList != null && !tableType.fieldNameList.equals(fieldNameList)) {
                this.dlog.error(tableConstructorExpr.tableKeySpecifier.pos, DiagnosticErrorCode.TABLE_KEY_SPECIFIER_MISMATCH, tableType.fieldNameList.toString(), fieldNameList.toString());
                this.resultType = this.symTable.semanticError;
                return false;
            }
        }
        if ((keyTypeConstraint = tableType.keyTypeConstraint) != null) {
            ArrayList<BType> memberTypes = new ArrayList<BType>();
            if (keyTypeConstraint.tag == 30) {
                for (Type type : ((TupleType)((Object)keyTypeConstraint)).getTupleTypes()) {
                    memberTypes.add((BType)type);
                }
            } else {
                memberTypes.add(keyTypeConstraint);
            }
            if (tableConstructorExpr.tableKeySpecifier == null && keyTypeConstraint.tag == 49) {
                return true;
            }
            if (tableConstructorExpr.tableKeySpecifier == null || tableConstructorExpr.tableKeySpecifier.fieldNameIdentifierList.size() != memberTypes.size()) {
                this.dlog.error(tableConstructorExpr.pos, DiagnosticErrorCode.KEY_SPECIFIER_SIZE_MISMATCH_WITH_KEY_CONSTRAINT, memberTypes.size(), tableConstructorExpr.tableKeySpecifier == null ? 0 : tableConstructorExpr.tableKeySpecifier.fieldNameIdentifierList.size());
                this.resultType = this.symTable.semanticError;
                return false;
            }
            List<IdentifierNode> fieldNameIdentifierList = tableConstructorExpr.tableKeySpecifier.fieldNameIdentifierList;
            boolean bl = false;
            for (IdentifierNode identifier : fieldNameIdentifierList) {
                void var7_9;
                BField field = this.types.getTableConstraintField(constraintType, ((BLangIdentifier)identifier).value);
                if (!this.types.isAssignable(field.type, (BType)memberTypes.get((int)var7_9))) {
                    this.dlog.error(tableConstructorExpr.tableKeySpecifier.pos, DiagnosticErrorCode.KEY_SPECIFIER_MISMATCH_WITH_KEY_CONSTRAINT, fieldNameIdentifierList.toString(), ((Object)memberTypes).toString());
                    this.resultType = this.symTable.semanticError;
                    return false;
                }
                ++var7_9;
            }
        }
        return true;
    }

    private void validateMapConstraintTable(BLangTableConstructorExpr tableConstructorExpr, BType expType) {
        if (((BTableType)expType).fieldNameList != null || ((BTableType)expType).keyTypeConstraint != null) {
            this.dlog.error(((BTableType)expType).keyPos, DiagnosticErrorCode.KEY_CONSTRAINT_NOT_SUPPORTED_FOR_TABLE_WITH_MAP_CONSTRAINT, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (tableConstructorExpr.tableKeySpecifier != null) {
            this.dlog.error(tableConstructorExpr.tableKeySpecifier.pos, DiagnosticErrorCode.KEY_CONSTRAINT_NOT_SUPPORTED_FOR_TABLE_WITH_MAP_CONSTRAINT, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (!this.validateTableType((BTableType)expType, tableConstructorExpr.recordLiteralList)) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        this.resultType = expType;
    }

    private List<String> getTableKeyNameList(BLangTableKeySpecifier tableKeySpecifier) {
        ArrayList<String> fieldNamesList = new ArrayList<String>();
        for (IdentifierNode identifier : tableKeySpecifier.fieldNameIdentifierList) {
            fieldNamesList.add(((BLangIdentifier)identifier).value);
        }
        return fieldNamesList;
    }

    private BType createTableKeyConstraint(List<String> fieldNames, BType constraintType) {
        if (fieldNames == null) {
            return this.symTable.semanticError;
        }
        ArrayList<BType> memTypes = new ArrayList<BType>();
        for (String fieldName : fieldNames) {
            BField tableConstraintField = this.types.getTableConstraintField(constraintType, fieldName);
            if (tableConstraintField == null) {
                return this.symTable.semanticError;
            }
            BType fieldType = tableConstraintField.type;
            memTypes.add(fieldType);
        }
        if (memTypes.size() == 1) {
            return (BType)memTypes.get(0);
        }
        return new BTupleType(memTypes);
    }

    private BType checkListConstructorCompatibility(BType bType, BLangListConstructorExpr listConstructor) {
        int tag = bType.tag;
        if (tag == 20) {
            boolean prevNonErrorLoggingCheck = this.nonErrorLoggingCheck;
            int errorCount = this.dlog.errorCount();
            this.nonErrorLoggingCheck = true;
            this.dlog.mute();
            ArrayList<BType> compatibleTypes = new ArrayList<BType>();
            boolean erroredExpType = false;
            for (BType memberType : ((BUnionType)bType).getMemberTypes()) {
                if (memberType == this.symTable.semanticError) {
                    if (erroredExpType) continue;
                    erroredExpType = true;
                    continue;
                }
                BType listCompatibleMemType = this.getListConstructorCompatibleNonUnionType(memberType);
                if (listCompatibleMemType == this.symTable.semanticError) continue;
                this.dlog.resetErrorCount();
                BType memCompatibiltyType = this.checkListConstructorCompatibility(listCompatibleMemType, listConstructor);
                if (memCompatibiltyType == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.isUniqueType(compatibleTypes, memCompatibiltyType)) continue;
                compatibleTypes.add(memCompatibiltyType);
            }
            this.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            this.dlog.setErrorCount(errorCount);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            if (compatibleTypes.isEmpty()) {
                BLangListConstructorExpr exprToLog = listConstructor;
                if (this.nonErrorLoggingCheck) {
                    ++listConstructor.cloneAttempt;
                    exprToLog = this.nodeCloner.clone(listConstructor);
                }
                BType inferredTupleType = this.getInferredTupleType(exprToLog, this.symTable.noType);
                if (!erroredExpType && inferredTupleType != this.symTable.semanticError) {
                    this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.expType, inferredTupleType);
                }
                return this.symTable.semanticError;
            }
            if (compatibleTypes.size() != 1) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, this.expType);
                return this.symTable.semanticError;
            }
            return this.checkListConstructorCompatibility((BType)compatibleTypes.get(0), listConstructor);
        }
        if (tag == 21) {
            return this.checkListConstructorCompatibility(((BIntersectionType)bType).effectiveType, listConstructor);
        }
        BType possibleType = this.getListConstructorCompatibleNonUnionType(bType);
        switch (possibleType.tag) {
            case 19: {
                return this.checkArrayType(listConstructor, (BArrayType)possibleType);
            }
            case 30: {
                return this.checkTupleType(listConstructor, (BTupleType)possibleType);
            }
            case 37: {
                return this.checkReadOnlyListType(listConstructor);
            }
            case 13: {
                ArrayList<BType> results = new ArrayList<BType>();
                listConstructor.isTypedescExpr = true;
                for (int i = 0; i < listConstructor.exprs.size(); ++i) {
                    results.add(this.checkExpr(listConstructor.exprs.get(i), this.env, this.symTable.noType));
                }
                ArrayList<BType> actualTypes = new ArrayList<BType>();
                for (int i = 0; i < listConstructor.exprs.size(); ++i) {
                    BLangExpression expr = listConstructor.exprs.get(i);
                    if (expr.getKind() == NodeKind.TYPEDESC_EXPRESSION) {
                        actualTypes.add(((BLangTypedescExpr)expr).resolvedType);
                        continue;
                    }
                    if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                        actualTypes.add(((BLangSimpleVarRef)expr).symbol.type);
                        continue;
                    }
                    actualTypes.add((BType)results.get(i));
                }
                listConstructor.typedescType = actualTypes.size() == 1 ? (BType)actualTypes.get(0) : new BTupleType(actualTypes);
                return new BTypedescType(listConstructor.typedescType, null);
            }
        }
        BLangListConstructorExpr exprToLog = listConstructor;
        if (this.nonErrorLoggingCheck) {
            ++listConstructor.cloneAttempt;
            exprToLog = this.nodeCloner.clone(listConstructor);
        }
        if (bType == this.symTable.semanticError) {
            this.getInferredTupleType(exprToLog, this.symTable.semanticError);
        } else {
            this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, bType, this.getInferredTupleType(exprToLog, this.symTable.noType));
        }
        return this.symTable.semanticError;
    }

    private BType getListConstructorCompatibleNonUnionType(BType type) {
        switch (type.tag) {
            case 13: 
            case 19: 
            case 30: 
            case 37: {
                return type;
            }
            case 7: {
                return !Symbols.isFlagOn(type.flags, 32L) ? this.symTable.arrayJsonType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayJsonType, this.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 11: {
                return !Symbols.isFlagOn(type.flags, 32L) ? this.symTable.arrayAnydataType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayAnydataType, this.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 17: {
                return !Symbols.isFlagOn(type.flags, 32L) ? this.symTable.arrayType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.arrayType, this.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 21: {
                return ((BIntersectionType)type).effectiveType;
            }
        }
        return this.symTable.semanticError;
    }

    private BType checkArrayType(BLangListConstructorExpr listConstructor, BArrayType arrayType) {
        BType eType = arrayType.eType;
        if (arrayType.state == BArrayState.INFERRED) {
            arrayType.size = listConstructor.exprs.size();
            arrayType.state = BArrayState.CLOSED;
        } else if (arrayType.state != BArrayState.OPEN && arrayType.size != listConstructor.exprs.size()) {
            if (arrayType.size < listConstructor.exprs.size()) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.MISMATCHING_ARRAY_LITERAL_VALUES, arrayType.size, listConstructor.exprs.size());
                return this.symTable.semanticError;
            }
            if (!this.types.hasFillerValue(eType)) {
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.INVALID_LIST_CONSTRUCTOR_ELEMENT_TYPE, this.expType);
                return this.symTable.semanticError;
            }
        }
        boolean errored = false;
        for (BLangExpression expr : listConstructor.exprs) {
            if (!this.exprIncompatible(eType, expr) || errored) continue;
            errored = true;
        }
        return errored ? this.symTable.semanticError : arrayType;
    }

    private BType checkTupleType(BLangListConstructorExpr listConstructor, BTupleType tupleType) {
        int i;
        int memberTypeSize;
        List<BLangExpression> exprs = listConstructor.exprs;
        List<BType> memberTypes = tupleType.tupleTypes;
        BType restType = tupleType.restType;
        int listExprSize = exprs.size();
        if (listExprSize < (memberTypeSize = memberTypes.size())) {
            for (int i2 = listExprSize; i2 < memberTypeSize; ++i2) {
                if (this.types.hasFillerValue(memberTypes.get(i2))) continue;
                this.dlog.error(listConstructor.pos, DiagnosticErrorCode.SYNTAX_ERROR, "tuple and expression size does not match");
                return this.symTable.semanticError;
            }
        } else if (listExprSize > memberTypeSize && restType == null) {
            this.dlog.error(listConstructor.pos, DiagnosticErrorCode.SYNTAX_ERROR, "tuple and expression size does not match");
            return this.symTable.semanticError;
        }
        boolean errored = false;
        int nonRestCountToCheck = listExprSize < memberTypeSize ? listExprSize : memberTypeSize;
        for (i = 0; i < nonRestCountToCheck; ++i) {
            if (!this.exprIncompatible(memberTypes.get(i), exprs.get(i)) || errored) continue;
            errored = true;
        }
        for (i = nonRestCountToCheck; i < exprs.size(); ++i) {
            if (!this.exprIncompatible(restType, exprs.get(i)) || errored) continue;
            errored = true;
        }
        return errored ? this.symTable.semanticError : tupleType;
    }

    private BType checkReadOnlyListType(BLangListConstructorExpr listConstructor) {
        if (!this.nonErrorLoggingCheck) {
            BType inferredType = this.getInferredTupleType(listConstructor, this.symTable.readonlyType);
            if (inferredType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            return this.types.checkType(listConstructor, inferredType, this.symTable.readonlyType);
        }
        for (BLangExpression expr : listConstructor.exprs) {
            if (!this.exprIncompatible(this.symTable.readonlyType, expr)) continue;
            return this.symTable.semanticError;
        }
        return this.symTable.readonlyType;
    }

    private boolean exprIncompatible(BType eType, BLangExpression expr) {
        if (expr.typeChecked) {
            return expr.type == this.symTable.semanticError;
        }
        BLangExpression exprToCheck = expr;
        if (this.nonErrorLoggingCheck) {
            ++expr.cloneAttempt;
            exprToCheck = this.nodeCloner.clone(expr);
        }
        return this.checkExpr(exprToCheck, this.env, eType) == this.symTable.semanticError;
    }

    private List<BType> checkExprList(List<BLangExpression> exprs, SymbolEnv env) {
        return this.checkExprList(exprs, env, this.symTable.noType);
    }

    private List<BType> checkExprList(List<BLangExpression> exprs, SymbolEnv env, BType expType) {
        ArrayList<BType> types = new ArrayList<BType>();
        SymbolEnv prevEnv = this.env;
        BType preExpType = this.expType;
        this.env = env;
        this.expType = expType;
        for (BLangExpression e : exprs) {
            this.checkExpr(e, this.env, expType);
            types.add(this.resultType);
        }
        this.env = prevEnv;
        this.expType = preExpType;
        return types;
    }

    private BType getInferredTupleType(BLangListConstructorExpr listConstructor, BType expType) {
        List<BType> memTypes = this.checkExprList(listConstructor.exprs, this.env, expType);
        for (BType memType : memTypes) {
            if (memType != this.symTable.semanticError) continue;
            return this.symTable.semanticError;
        }
        BTupleType tupleType = new BTupleType(memTypes);
        if (expType.tag != 37) {
            return tupleType;
        }
        tupleType.flags |= 0x20L;
        return tupleType;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        int expTypeTag = this.expType.tag;
        if (expTypeTag == 23 || expTypeTag == 37) {
            this.expType = this.defineInferredRecordType(recordLiteral, this.expType);
        } else if (expTypeTag == 33) {
            this.dlog.error(recordLiteral.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL, this.expType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        this.resultType = this.getEffectiveMappingType(recordLiteral, this.checkMappingConstructorCompatibility(this.expType, recordLiteral));
    }

    private BType getEffectiveMappingType(BLangRecordLiteral recordLiteral, BType applicableMappingType) {
        if (applicableMappingType == this.symTable.semanticError || applicableMappingType.tag == 12 && Symbols.isFlagOn(applicableMappingType.flags, 32L)) {
            return applicableMappingType;
        }
        LinkedHashMap<String, RecordLiteralNode.RecordField> readOnlyFields = new LinkedHashMap<String, RecordLiteralNode.RecordField>();
        LinkedHashMap applicableTypeFields = applicableMappingType.tag == 12 ? ((BRecordType)applicableMappingType).fields : new LinkedHashMap();
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            String name;
            if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) continue;
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (!keyValueField.readonly) continue;
                BLangExpression bLangExpression = keyValueField.key.expr;
                name = bLangExpression.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? ((BLangSimpleVarRef)bLangExpression).variableName.value : (String)((BLangLiteral)bLangExpression).value;
            } else {
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                if (!varNameField.readonly) continue;
                name = varNameField.variableName.value;
            }
            if (applicableTypeFields.containsKey(name) && Symbols.isFlagOn(((BField)applicableTypeFields.get((Object)name)).symbol.flags, 32L)) continue;
            readOnlyFields.put(name, field);
        }
        if (readOnlyFields.isEmpty()) {
            return applicableMappingType;
        }
        PackageID pkgID = this.env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, recordLiteral.pos, SymbolOrigin.VIRTUAL);
        LinkedHashMap<String, BField> newFields = new LinkedHashMap<String, BField>();
        for (Map.Entry entry : readOnlyFields.entrySet()) {
            RecordLiteralNode.RecordField field = (RecordLiteralNode.RecordField)entry.getValue();
            String key = (String)entry.getKey();
            Name fieldName = this.names.fromString(key);
            BType readOnlyFieldType = field.isKeyValueField() ? ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr.type : ((BLangRecordLiteral.BLangRecordVarNameField)field).type;
            BVarSymbol fieldSymbol = new BVarSymbol(Flags.asMask((Set<Flag>)new HashSet<Flag>(){
                {
                    this.add(Flag.REQUIRED);
                    this.add(Flag.READONLY);
                }
            }), fieldName, pkgID, readOnlyFieldType, recordSymbol, ((BLangNode)((Object)field)).pos, SymbolOrigin.VIRTUAL);
            newFields.put(key, new BField(fieldName, null, fieldSymbol));
            recordSymbol.scope.define(fieldName, fieldSymbol);
        }
        BRecordType recordType = new BRecordType(recordSymbol, recordSymbol.flags);
        if (applicableMappingType.tag == 15) {
            recordType.sealed = false;
            recordType.restFieldType = ((BMapType)applicableMappingType).constraint;
        } else {
            BRecordType bRecordType = (BRecordType)applicableMappingType;
            boolean allReadOnlyFields = true;
            for (Map.Entry origEntry : bRecordType.fields.entrySet()) {
                String fieldName = (String)origEntry.getKey();
                BField field = (BField)origEntry.getValue();
                if (readOnlyFields.containsKey(fieldName)) continue;
                BVarSymbol origFieldSymbol = field.symbol;
                long origFieldFlags = origFieldSymbol.flags;
                if (allReadOnlyFields && !Symbols.isFlagOn(origFieldFlags, 32L)) {
                    allReadOnlyFields = false;
                }
                BVarSymbol fieldSymbol = new BVarSymbol(origFieldFlags, field.name, pkgID, origFieldSymbol.type, recordSymbol, field.pos, SymbolOrigin.VIRTUAL);
                newFields.put(fieldName, new BField(field.name, null, fieldSymbol));
                recordSymbol.scope.define(field.name, fieldSymbol);
            }
            recordType.sealed = bRecordType.sealed;
            recordType.restFieldType = bRecordType.restFieldType;
            if (recordType.sealed && allReadOnlyFields) {
                recordType.flags |= 0x20L;
                recordType.tsymbol.flags |= 0x20L;
            }
        }
        recordType.fields = newFields;
        recordSymbol.type = recordType;
        recordType.tsymbol = recordSymbol;
        BLangRecordTypeNode bLangRecordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(recordType, pkgID, this.symTable, recordLiteral.pos);
        bLangRecordTypeNode.initFunction = TypeDefBuilderHelper.createInitFunctionForRecordType(bLangRecordTypeNode, this.env, this.names, this.symTable);
        TypeDefBuilderHelper.addTypeDefinition(recordType, recordSymbol, bLangRecordTypeNode, this.env);
        if (applicableMappingType.tag == 15) {
            recordLiteral.expectedType = applicableMappingType;
        }
        return recordType;
    }

    private BType checkMappingConstructorCompatibility(BType bType, BLangRecordLiteral mappingConstructor) {
        int tag = bType.tag;
        if (tag == 20) {
            boolean prevNonErrorLoggingCheck = this.nonErrorLoggingCheck;
            this.nonErrorLoggingCheck = true;
            int errorCount = this.dlog.errorCount();
            this.dlog.mute();
            ArrayList<BType> compatibleTypes = new ArrayList<BType>();
            boolean erroredExpType = false;
            for (BType memberType : ((BUnionType)bType).getMemberTypes()) {
                if (memberType == this.symTable.semanticError) {
                    if (erroredExpType) continue;
                    erroredExpType = true;
                    continue;
                }
                BType listCompatibleMemType = this.getMappingConstructorCompatibleNonUnionType(memberType);
                if (listCompatibleMemType == this.symTable.semanticError) continue;
                this.dlog.resetErrorCount();
                BType memCompatibiltyType = this.checkMappingConstructorCompatibility(listCompatibleMemType, mappingConstructor);
                if (memCompatibiltyType == this.symTable.semanticError || this.dlog.errorCount() != 0 || !this.isUniqueType(compatibleTypes, memCompatibiltyType)) continue;
                compatibleTypes.add(memCompatibiltyType);
            }
            this.nonErrorLoggingCheck = prevNonErrorLoggingCheck;
            this.dlog.setErrorCount(errorCount);
            if (!prevNonErrorLoggingCheck) {
                this.dlog.unmute();
            }
            if (compatibleTypes.isEmpty()) {
                if (!erroredExpType) {
                    this.reportIncompatibleMappingConstructorError(mappingConstructor, bType);
                }
                this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError);
                return this.symTable.semanticError;
            }
            if (compatibleTypes.size() != 1) {
                this.dlog.error(mappingConstructor.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, bType);
                this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError);
                return this.symTable.semanticError;
            }
            return this.checkMappingConstructorCompatibility((BType)compatibleTypes.get(0), mappingConstructor);
        }
        if (tag == 21) {
            return this.checkMappingConstructorCompatibility(((BIntersectionType)bType).effectiveType, mappingConstructor);
        }
        BType possibleType = this.getMappingConstructorCompatibleNonUnionType(bType);
        switch (possibleType.tag) {
            case 15: {
                return this.validateSpecifiedFields(mappingConstructor, possibleType) ? possibleType : this.symTable.semanticError;
            }
            case 12: {
                boolean isSpecifiedFieldsValid = this.validateSpecifiedFields(mappingConstructor, possibleType);
                boolean hasAllRequiredFields = this.validateRequiredFields((BRecordType)possibleType, mappingConstructor.fields, mappingConstructor.pos);
                return isSpecifiedFieldsValid && hasAllRequiredFields ? possibleType : this.symTable.semanticError;
            }
            case 37: {
                return this.checkReadOnlyMappingType(mappingConstructor);
            }
        }
        this.reportIncompatibleMappingConstructorError(mappingConstructor, bType);
        this.validateSpecifiedFields(mappingConstructor, this.symTable.semanticError);
        return this.symTable.semanticError;
    }

    private BType checkReadOnlyMappingType(BLangRecordLiteral mappingConstructor) {
        if (!this.nonErrorLoggingCheck) {
            BType inferredType = this.defineInferredRecordType(mappingConstructor, this.symTable.readonlyType);
            if (inferredType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            return this.checkMappingConstructorCompatibility(inferredType, mappingConstructor);
        }
        for (RecordLiteralNode.RecordField field : mappingConstructor.fields) {
            BLangExpression exprToCheck = field.isKeyValueField() ? ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr : (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP ? ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr : (BLangRecordLiteral.BLangRecordVarNameField)field);
            if (!this.exprIncompatible(this.symTable.readonlyType, exprToCheck)) continue;
            return this.symTable.semanticError;
        }
        return this.symTable.readonlyType;
    }

    private BType getMappingConstructorCompatibleNonUnionType(BType type) {
        switch (type.tag) {
            case 12: 
            case 15: 
            case 37: {
                return type;
            }
            case 7: {
                return !Symbols.isFlagOn(type.flags, 32L) ? this.symTable.mapJsonType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapJsonType, this.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 11: {
                return !Symbols.isFlagOn(type.flags, 32L) ? this.symTable.mapAnydataType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapAnydataType, this.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 17: {
                return !Symbols.isFlagOn(type.flags, 32L) ? this.symTable.mapType : ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, this.symTable.mapType, this.env, this.symTable, this.anonymousModelHelper, this.names);
            }
            case 21: {
                return ((BIntersectionType)type).effectiveType;
            }
        }
        return this.symTable.semanticError;
    }

    private boolean isMappingConstructorCompatibleType(BType type) {
        return type.tag == 12 || type.tag == 15;
    }

    private void reportIncompatibleMappingConstructorError(BLangRecordLiteral mappingConstructorExpr, BType expType) {
        if (expType == this.symTable.semanticError) {
            return;
        }
        if (expType.tag != 20) {
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, expType);
            return;
        }
        BUnionType unionType = (BUnionType)expType;
        BType[] memberTypes = unionType.getMemberTypes().toArray(new BType[0]);
        if (memberTypes.length == 2) {
            BRecordType recType = null;
            if (memberTypes[0].tag == 12 && memberTypes[1].tag == 10) {
                recType = (BRecordType)memberTypes[0];
            } else if (memberTypes[1].tag == 12 && memberTypes[0].tag == 10) {
                recType = (BRecordType)memberTypes[1];
            }
            if (recType != null) {
                this.validateSpecifiedFields(mappingConstructorExpr, recType);
                this.validateRequiredFields(recType, mappingConstructorExpr.fields, mappingConstructorExpr.pos);
                return;
            }
        }
        for (BType bType : memberTypes) {
            if (!this.isMappingConstructorCompatibleType(bType)) continue;
            this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_MAPPING_CONSTRUCTOR, unionType);
            return;
        }
        this.dlog.error(mappingConstructorExpr.pos, DiagnosticErrorCode.MAPPING_CONSTRUCTOR_COMPATIBLE_TYPE_NOT_FOUND, unionType);
    }

    private boolean validateSpecifiedFields(BLangRecordLiteral mappingConstructor, BType possibleType) {
        boolean isFieldsValid = true;
        for (RecordLiteralNode.RecordField field : mappingConstructor.fields) {
            BType checkedType = this.checkMappingField(field, possibleType);
            if (!isFieldsValid || checkedType != this.symTable.semanticError) continue;
            isFieldsValid = false;
        }
        return isFieldsValid;
    }

    private boolean validateRequiredFields(BRecordType type, List<RecordLiteralNode.RecordField> specifiedFields, Location pos) {
        HashSet<String> specFieldNames = this.getFieldNames(specifiedFields);
        boolean hasAllRequiredFields = true;
        for (BField field : type.fields.values()) {
            String fieldName = field.name.value;
            if (specFieldNames.contains(fieldName) || !Symbols.isFlagOn(field.symbol.flags, 256L)) continue;
            this.dlog.error(pos, DiagnosticErrorCode.MISSING_REQUIRED_RECORD_FIELD, field.name);
            if (!hasAllRequiredFields) continue;
            hasAllRequiredFields = false;
        }
        return hasAllRequiredFields;
    }

    private HashSet<String> getFieldNames(List<RecordLiteralNode.RecordField> specifiedFields) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (RecordLiteralNode.RecordField specifiedField : specifiedFields) {
            if (specifiedField.isKeyValueField()) {
                String name = this.getKeyValueFieldName((BLangRecordLiteral.BLangRecordKeyValueField)specifiedField);
                if (name == null) continue;
                fieldNames.add(name);
                continue;
            }
            if (specifiedField.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                fieldNames.add(this.getVarNameFieldName((BLangRecordLiteral.BLangRecordVarNameField)specifiedField));
                continue;
            }
            fieldNames.addAll(this.getSpreadOpFieldRequiredFieldNames((BLangRecordLiteral.BLangRecordSpreadOperatorField)specifiedField));
        }
        return fieldNames;
    }

    private String getKeyValueFieldName(BLangRecordLiteral.BLangRecordKeyValueField field) {
        BLangRecordLiteral.BLangRecordKey key = field.key;
        if (key.computedKey) {
            return null;
        }
        BLangExpression keyExpr = key.expr;
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            return ((BLangSimpleVarRef)keyExpr).variableName.value;
        }
        if (keyExpr.getKind() == NodeKind.LITERAL) {
            return (String)((BLangLiteral)keyExpr).value;
        }
        return null;
    }

    private String getVarNameFieldName(BLangRecordLiteral.BLangRecordVarNameField field) {
        return field.variableName.value;
    }

    private List<String> getSpreadOpFieldRequiredFieldNames(BLangRecordLiteral.BLangRecordSpreadOperatorField field) {
        BType spreadType = this.checkExpr(field.expr, this.env);
        if (spreadType.tag != 12) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (BField bField : ((BRecordType)spreadType).getFields().values()) {
            if (Symbols.isOptional(bField.symbol)) continue;
            fieldNames.add(bField.name.value);
        }
        return fieldNames;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        if (workerFlushExpr.workerIdentifier != null) {
            String workerName = workerFlushExpr.workerIdentifier.getValue();
            if (!this.workerExists(this.env, workerName)) {
                this.dlog.error(workerFlushExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
            } else {
                BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromString(workerName));
                if (symbol != this.symTable.notFoundSymbol) {
                    workerFlushExpr.workerSymbol = symbol;
                }
            }
        }
        BUnionType actualType = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
        this.resultType = this.types.checkType(workerFlushExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        String workerName;
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(syncSendExpr.workerIdentifier));
        if (this.symTable.notFoundSymbol.equals(symbol)) {
            syncSendExpr.workerType = this.symTable.semanticError;
        } else {
            syncSendExpr.workerType = symbol.type;
            syncSendExpr.workerSymbol = symbol;
        }
        syncSendExpr.env = this.env;
        this.checkExpr(syncSendExpr.expr, this.env);
        if (!syncSendExpr.expr.type.isAnydata()) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.INVALID_TYPE_FOR_SEND, syncSendExpr.expr.type);
        }
        if (!this.workerExists(this.env, workerName = syncSendExpr.workerIdentifier.getValue())) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
        }
        syncSendExpr.expectedType = this.expType;
        this.resultType = this.expType == this.symTable.noType ? this.symTable.nilType : this.expType;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveExpr) {
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(workerReceiveExpr.workerIdentifier));
        workerReceiveExpr.env = this.env;
        if (this.symTable.notFoundSymbol.equals(symbol)) {
            workerReceiveExpr.workerType = this.symTable.semanticError;
        } else {
            workerReceiveExpr.workerType = symbol.type;
            workerReceiveExpr.workerSymbol = symbol;
        }
        if (this.symTable.noType == this.expType) {
            this.dlog.error(workerReceiveExpr.pos, DiagnosticErrorCode.INVALID_USAGE_OF_RECEIVE_EXPRESSION, new Object[0]);
        }
        workerReceiveExpr.type = this.expType;
        this.resultType = this.expType;
    }

    private boolean workerExists(SymbolEnv env, String workerName) {
        if (workerName.equals("default")) {
            return true;
        }
        BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(env, new Name(workerName));
        return symbol != this.symTable.notFoundSymbol && symbol.type.tag == 31 && ((BFutureType)symbol.type).workerDerivative;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        constRef.symbol = this.symResolver.lookupMainSpaceSymbolInPackage(constRef.pos, this.env, this.names.fromIdNode(constRef.pkgAlias), this.names.fromIdNode(constRef.variableName));
        this.types.setImplicitCastExpr(constRef, constRef.type, this.expType);
        this.resultType = constRef.type;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BType actualType = this.symTable.semanticError;
        Name varName = this.names.fromIdNode(varRefExpr.variableName);
        if (varName == Names.IGNORE) {
            if (varRefExpr.lhsVar) {
                varRefExpr.type = this.symTable.anyType;
            } else {
                varRefExpr.type = this.symTable.semanticError;
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.UNDERSCORE_NOT_ALLOWED, new Object[0]);
            }
            varRefExpr.symbol = new BVarSymbol(0L, varName, this.env.enclPkg.symbol.pkgID, varRefExpr.type, this.env.scope.owner, varRefExpr.pos, SymbolOrigin.VIRTUAL);
            this.resultType = varRefExpr.type;
            return;
        }
        Name compUnitName = this.getCurrentCompUnit(varRefExpr);
        varRefExpr.pkgSymbol = this.symResolver.resolvePrefixSymbol(this.env, this.names.fromIdNode(varRefExpr.pkgAlias), compUnitName);
        if (varRefExpr.pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, varRefExpr.pkgAlias);
        }
        if (varRefExpr.pkgSymbol.tag == 8193) {
            actualType = this.symTable.stringType;
        } else if (varRefExpr.pkgSymbol != this.symTable.notFoundSymbol) {
            BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(varRefExpr.pos, this.env, this.names.fromIdNode(varRefExpr.pkgAlias), varName);
            if (symbol == this.symTable.notFoundSymbol && this.env.enclType != null) {
                Name objFuncName = this.names.fromString(Symbols.getAttachedFuncSymbolName(this.env.enclType.type.tsymbol.name.value, varName.value));
                symbol = this.symResolver.resolveStructField(varRefExpr.pos, this.env, objFuncName, this.env.enclType.type.tsymbol);
            }
            if ((symbol.tag & 0x34) == 52) {
                BVarSymbol varSym = (BVarSymbol)symbol;
                this.checkSelfReferences(varRefExpr.pos, this.env, varSym);
                varRefExpr.symbol = varSym;
                actualType = varSym.type;
                this.markAndRegisterClosureVariable(symbol, varRefExpr.pos);
            } else if ((symbol.tag & 0x1001C) == 65564) {
                actualType = symbol.type.tag == 13 ? symbol.type : new BTypedescType(symbol.type, null);
                varRefExpr.symbol = symbol;
            } else if ((symbol.tag & 0x200001C) == 33554460) {
                BConstantSymbol constSymbol = (BConstantSymbol)symbol;
                varRefExpr.symbol = constSymbol;
                BType symbolType = symbol.type;
                actualType = symbolType != this.symTable.noType && this.expType.tag == 32 || this.expType.tag == 20 && ((BUnionType)this.expType).getMemberTypes().stream().anyMatch(memType -> memType.tag == 32 && this.types.isAssignable(symbolType, (BType)memType)) ? symbolType : constSymbol.literalType;
                if (varRefExpr.lhsVar || varRefExpr.compoundAssignmentLhsVar) {
                    actualType = this.symTable.semanticError;
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_CONSTANT_VALUE, new Object[0]);
                }
            } else {
                this.logUndefinedSymbolError(varRefExpr.pos, varName.value);
            }
        }
        if (this.expType.tag == 19 && this.isArrayOpenSealedType((BArrayType)this.expType)) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.SEALED_ARRAY_TYPE_CAN_NOT_INFER_SIZE, new Object[0]);
            return;
        }
        this.resultType = this.types.checkType(varRefExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        String recordName = this.anonymousModelHelper.getNextAnonymousTypeKey(this.env.enclPkg.symbol.pkgID);
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(2048L, this.names.fromString(recordName), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, varRefExpr.pos, SymbolOrigin.SOURCE);
        this.symbolEnter.defineSymbol(varRefExpr.pos, recordSymbol, this.env);
        boolean unresolvedReference = false;
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : varRefExpr.recordRefFields) {
            ((BLangVariableReference)recordRefField.variableReference).lhsVar = true;
            this.checkExpr(recordRefField.variableReference, this.env);
            if (((BLangVariableReference)recordRefField.variableReference).symbol == null || !this.isValidVariableReference(recordRefField.variableReference)) {
                unresolvedReference = true;
                continue;
            }
            BVarSymbol bVarSymbol = (BVarSymbol)((BLangVariableReference)recordRefField.variableReference).symbol;
            BField field = new BField(this.names.fromIdNode(recordRefField.variableName), varRefExpr.pos, new BVarSymbol(0L, this.names.fromIdNode(recordRefField.variableName), this.env.enclPkg.symbol.pkgID, bVarSymbol.type, recordSymbol, varRefExpr.pos, SymbolOrigin.SOURCE));
            fields.put(field.name.value, field);
        }
        BLangExpression restParam = (BLangExpression)varRefExpr.restParam;
        if (restParam != null) {
            this.checkExpr(restParam, this.env);
            boolean bl = unresolvedReference = !this.isValidVariableReference(restParam);
        }
        if (unresolvedReference) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        BRecordType bRecordType = new BRecordType(recordSymbol);
        bRecordType.fields = fields;
        recordSymbol.type = bRecordType;
        varRefExpr.symbol = new BVarSymbol(0L, recordSymbol.name, this.env.enclPkg.symbol.pkgID, bRecordType, this.env.scope.owner, varRefExpr.pos, SymbolOrigin.SOURCE);
        if (restParam == null) {
            bRecordType.sealed = true;
            bRecordType.restFieldType = this.symTable.noType;
        } else if (restParam.type == this.symTable.semanticError) {
            bRecordType.restFieldType = this.symTable.mapType;
        } else {
            BMapType restParamType = (BMapType)restParam.type;
            bRecordType.restFieldType = restParamType.constraint;
        }
        this.resultType = bRecordType;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        BType errorRefRestFieldType;
        if (varRefExpr.typeNode != null) {
            BType bType;
            varRefExpr.type = bType = this.symResolver.resolveTypeNode(varRefExpr.typeNode, this.env);
            this.checkIndirectErrorVarRef(varRefExpr);
            this.resultType = bType;
            return;
        }
        if (varRefExpr.message != null) {
            varRefExpr.message.lhsVar = true;
            this.checkExpr(varRefExpr.message, this.env);
            if (!this.types.isAssignable(this.symTable.stringType, varRefExpr.message.type)) {
                this.dlog.error(varRefExpr.message.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.stringType, varRefExpr.message.type);
            }
        }
        if (varRefExpr.cause != null) {
            varRefExpr.cause.lhsVar = true;
            this.checkExpr(varRefExpr.cause, this.env);
            if (!this.types.isAssignable(this.symTable.errorOrNilType, varRefExpr.cause.type)) {
                this.dlog.error(varRefExpr.cause.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.errorOrNilType, varRefExpr.cause.type);
            }
        }
        boolean unresolvedReference = false;
        for (BLangNamedArgsExpression detailItem : varRefExpr.detail) {
            BLangVariableReference refItem = (BLangVariableReference)detailItem.expr;
            refItem.lhsVar = true;
            this.checkExpr(refItem, this.env);
            if (!this.isValidVariableReference(refItem)) {
                unresolvedReference = true;
                continue;
            }
            if (refItem.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || refItem.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                this.dlog.error(refItem.pos, DiagnosticErrorCode.INVALID_VARIABLE_REFERENCE_IN_BINDING_PATTERN, refItem);
                unresolvedReference = true;
                continue;
            }
            if (refItem.symbol != null) continue;
            unresolvedReference = true;
        }
        if (varRefExpr.restVar != null) {
            varRefExpr.restVar.lhsVar = true;
            if (varRefExpr.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.checkExpr(varRefExpr.restVar, this.env);
                unresolvedReference = unresolvedReference || varRefExpr.restVar.symbol == null || !this.isValidVariableReference(varRefExpr.restVar);
            } else if (varRefExpr.restVar.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR || varRefExpr.restVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                unresolvedReference = this.checkErrorRestParamVarRef(varRefExpr, unresolvedReference);
            }
        }
        if (unresolvedReference) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (varRefExpr.restVar == null) {
            errorRefRestFieldType = this.symTable.anydataOrReadonly;
        } else if (varRefExpr.restVar.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)varRefExpr.restVar).variableName.value.equals(Names.IGNORE.value)) {
            errorRefRestFieldType = this.symTable.anydataOrReadonly;
        } else if (varRefExpr.restVar.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR || varRefExpr.restVar.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            errorRefRestFieldType = varRefExpr.restVar.type;
        } else if (varRefExpr.restVar.type.tag == 15) {
            errorRefRestFieldType = ((BMapType)varRefExpr.restVar.type).constraint;
        } else {
            this.dlog.error(varRefExpr.restVar.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, varRefExpr.restVar.type, this.symTable.detailType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BType errorDetailType = errorRefRestFieldType == this.symTable.anydataOrReadonly ? this.symTable.errorType.detailType : new BMapType(15, errorRefRestFieldType, null, 1L);
        this.resultType = new BErrorType(this.symTable.errorType.tsymbol, errorDetailType);
    }

    private void checkIndirectErrorVarRef(BLangErrorVarRef varRefExpr) {
        for (BLangNamedArgsExpression detailItem : varRefExpr.detail) {
            this.checkExpr(detailItem.expr, this.env);
            this.checkExpr(detailItem, this.env, detailItem.expr.type);
        }
        if (varRefExpr.restVar != null) {
            this.checkExpr(varRefExpr.restVar, this.env);
        }
        if (varRefExpr.message != null) {
            varRefExpr.message.lhsVar = true;
            this.checkExpr(varRefExpr.message, this.env);
        }
        if (varRefExpr.cause != null) {
            varRefExpr.cause.lhsVar = true;
            this.checkExpr(varRefExpr.cause, this.env);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkErrorRestParamVarRef(BLangErrorVarRef varRefExpr, boolean unresolvedReference) {
        BLangAccessExpression accessExpression = (BLangAccessExpression)varRefExpr.restVar;
        Name exprName = this.names.fromIdNode(((BLangSimpleVarRef)accessExpression.expr).variableName);
        BSymbol fSym = this.symResolver.lookupSymbolInMainSpace(this.env, exprName);
        if (fSym == null) return true;
        if (fSym.type.getKind() != TypeKind.MAP) throw new UnsupportedOperationException("rec field base access");
        BType constraint = ((BMapType)fSym.type).constraint;
        varRefExpr.restVar.type = this.types.isAssignable(constraint, this.symTable.anydataOrReadonly) ? constraint : this.symTable.anydataOrReadonly;
        return unresolvedReference;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        ArrayList<BType> results = new ArrayList<BType>();
        for (int i = 0; i < varRefExpr.expressions.size(); ++i) {
            ((BLangVariableReference)varRefExpr.expressions.get((int)i)).lhsVar = true;
            results.add(this.checkExpr(varRefExpr.expressions.get(i), this.env, this.symTable.noType));
        }
        BTupleType actualType = new BTupleType(results);
        if (varRefExpr.restParam != null) {
            BLangExpression restExpr = (BLangExpression)varRefExpr.restParam;
            ((BLangVariableReference)restExpr).lhsVar = true;
            BType checkedType = this.checkExpr(restExpr, this.env, this.symTable.noType);
            if (checkedType.tag != 19) {
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_TYPE_FOR_REST_DESCRIPTOR, checkedType);
                this.resultType = this.symTable.semanticError;
                return;
            }
            actualType.restType = ((BArrayType)checkedType).eType;
        }
        this.resultType = this.types.checkType(varRefExpr, actualType, this.expType);
    }

    public boolean isArrayOpenSealedType(BArrayType arrayType) {
        if (arrayType.state == BArrayState.INFERRED) {
            return true;
        }
        if (arrayType.eType.tag == 19) {
            return this.isArrayOpenSealedType((BArrayType)arrayType.eType);
        }
        return false;
    }

    private SymbolEnv findEnclosingInvokableEnv(SymbolEnv env, BLangInvokableNode encInvokable) {
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.ARROW_EXPR) {
            return env.enclEnv;
        }
        if (env.enclEnv.node != null && (env.enclEnv.node.getKind() == NodeKind.TRANSACTION || env.enclEnv.node.getKind() == NodeKind.RETRY || env.enclEnv.node.getKind() == NodeKind.ON_FAIL)) {
            return env.enclEnv;
        }
        if (env.enclInvokable != null && env.enclInvokable == encInvokable) {
            return this.findEnclosingInvokableEnv(env.enclEnv, encInvokable);
        }
        return env;
    }

    private SymbolEnv findEnclosingInvokableEnv(SymbolEnv env, BLangRecordTypeNode recordTypeNode) {
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.ARROW_EXPR) {
            return env.enclEnv;
        }
        if (env.enclEnv.node != null && (env.enclEnv.node.getKind() == NodeKind.TRANSACTION || env.enclEnv.node.getKind() == NodeKind.RETRY || env.enclEnv.node.getKind() == NodeKind.ON_FAIL)) {
            return env.enclEnv;
        }
        if (env.enclType != null && env.enclType == recordTypeNode) {
            return this.findEnclosingInvokableEnv(env.enclEnv, recordTypeNode);
        }
        return env;
    }

    private boolean isFunctionArgument(BSymbol symbol, List<BLangSimpleVariable> params) {
        return params.stream().anyMatch(param -> param.symbol.name.equals(symbol.name) && param.type.tag == symbol.type.tag);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        BType actualType;
        ((BLangVariableReference)fieldAccessExpr.expr).lhsVar = fieldAccessExpr.lhsVar;
        ((BLangVariableReference)fieldAccessExpr.expr).compoundAssignmentLhsVar = fieldAccessExpr.compoundAssignmentLhsVar;
        BType varRefType = this.getTypeOfExprInFieldAccess(fieldAccessExpr.expr);
        if (fieldAccessExpr instanceof BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess && !this.isXmlAccess(fieldAccessExpr)) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.INVALID_FIELD_ACCESS_EXPRESSION, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (fieldAccessExpr.optionalFieldAccess) {
            if (fieldAccessExpr.lhsVar || fieldAccessExpr.compoundAssignmentLhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPTIONAL_FIELD_ACCESS_NOT_REQUIRED_ON_LHS, new Object[0]);
                this.resultType = this.symTable.semanticError;
                return;
            }
            actualType = this.checkOptionalFieldAccessExpr(fieldAccessExpr, varRefType, this.names.fromIdNode(fieldAccessExpr.field));
        } else {
            actualType = this.checkFieldAccessExpr(fieldAccessExpr, varRefType, this.names.fromIdNode(fieldAccessExpr.field));
            if (actualType != this.symTable.semanticError && (fieldAccessExpr.lhsVar || fieldAccessExpr.compoundAssignmentLhsVar)) {
                if (this.isAllReadonlyTypes(varRefType)) {
                    if (varRefType.tag != 33 || !this.isInitializationInInit(varRefType)) {
                        this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_VALUE_OF_TYPE, varRefType);
                        this.resultType = this.symTable.semanticError;
                        return;
                    }
                } else if (this.types.isSubTypeOfBaseType(varRefType, 12) && this.isInvalidReadonlyFieldUpdate(varRefType, fieldAccessExpr.field.value)) {
                    this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_RECORD_FIELD, fieldAccessExpr.field.value, varRefType);
                    this.resultType = this.symTable.semanticError;
                    return;
                }
            }
        }
        this.resultType = this.types.checkType(fieldAccessExpr, actualType, this.expType);
    }

    private boolean isAllReadonlyTypes(BType type) {
        if (type.tag != 20) {
            return Symbols.isFlagOn(type.flags, 32L);
        }
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            if (this.isAllReadonlyTypes(memberType)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitializationInInit(BType type) {
        BObjectType objectType = (BObjectType)type;
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        BAttachedFunction initializerFunc = objectTypeSymbol.initializerFunc;
        return this.env.enclInvokable != null && initializerFunc != null && this.env.enclInvokable.symbol == initializerFunc.symbol;
    }

    private boolean isInvalidReadonlyFieldUpdate(BType type, String fieldName) {
        if (type.tag == 12) {
            if (Symbols.isFlagOn(type.flags, 32L)) {
                return true;
            }
            BRecordType recordType = (BRecordType)type;
            for (BField field : recordType.fields.values()) {
                if (!field.name.value.equals(fieldName)) continue;
                return Symbols.isFlagOn(field.symbol.flags, 32L);
            }
            return recordType.sealed;
        }
        boolean allInvalidUpdates = true;
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            if (this.isInvalidReadonlyFieldUpdate(memberType, fieldName)) continue;
            allInvalidUpdates = false;
        }
        return allInvalidUpdates;
    }

    private boolean isXmlAccess(BLangFieldBasedAccess fieldAccessExpr) {
        BLangExpression expr = fieldAccessExpr.expr;
        BType exprType = expr.type;
        if (exprType.tag == 8 || exprType.tag == 45) {
            return true;
        }
        if (expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)expr) && exprType.tag == 20) {
            Set<BType> memberTypes = ((BUnionType)exprType).getMemberTypes();
            return memberTypes.contains(this.symTable.xmlType) || memberTypes.contains(this.symTable.xmlElementType);
        }
        return false;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexBasedAccessExpr) {
        BLangExpression containerExpression = indexBasedAccessExpr.expr;
        if (containerExpression.getKind() == NodeKind.TYPEDESC_EXPRESSION) {
            this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_INDEXING, ((BLangTypedescExpr)containerExpression).typeNode);
            this.resultType = this.symTable.semanticError;
            return;
        }
        ((BLangVariableReference)containerExpression).lhsVar = indexBasedAccessExpr.lhsVar;
        ((BLangVariableReference)containerExpression).compoundAssignmentLhsVar = indexBasedAccessExpr.compoundAssignmentLhsVar;
        this.checkExpr(containerExpression, this.env, this.symTable.noType);
        if (indexBasedAccessExpr.indexExpr.getKind() == NodeKind.TABLE_MULTI_KEY && containerExpression.type.tag != 9) {
            this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.MULTI_KEY_MEMBER_ACCESS_NOT_SUPPORTED, containerExpression.type);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BType actualType = this.checkIndexAccessExpr(indexBasedAccessExpr);
        BType exprType = containerExpression.type;
        BLangExpression indexExpr = indexBasedAccessExpr.indexExpr;
        if (actualType != this.symTable.semanticError && (indexBasedAccessExpr.lhsVar || indexBasedAccessExpr.compoundAssignmentLhsVar)) {
            if (this.isAllReadonlyTypes(exprType)) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_VALUE_OF_TYPE, exprType);
                this.resultType = this.symTable.semanticError;
                return;
            }
            if (this.types.isSubTypeOfBaseType(exprType, 12) && (indexExpr.getKind() == NodeKind.LITERAL || this.isConst(indexExpr)) && this.isInvalidReadonlyFieldUpdate(exprType, this.getConstFieldName(indexExpr))) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_RECORD_FIELD, this.getConstFieldName(indexExpr), exprType);
                this.resultType = this.symTable.semanticError;
                return;
            }
        }
        if (indexBasedAccessExpr.lhsVar) {
            indexBasedAccessExpr.originalType = actualType;
            indexBasedAccessExpr.type = actualType;
            this.resultType = actualType;
            return;
        }
        this.resultType = this.types.checkType(indexBasedAccessExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangInvocation iExpr) {
        if (iExpr.expr == null) {
            this.checkFunctionInvocationExpr(iExpr);
            return;
        }
        if (this.invalidModuleAliasUsage(iExpr)) {
            return;
        }
        this.checkExpr(iExpr.expr, this.env, this.symTable.noType);
        BType varRefType = iExpr.expr.type;
        switch (varRefType.tag) {
            case 33: {
                this.checkObjectFunctionInvocationExpr(iExpr, (BObjectType)varRefType);
                break;
            }
            case 12: {
                this.checkFieldFunctionPointer(iExpr, this.env);
                break;
            }
            case 23: {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION, iExpr.name);
                break;
            }
            case 27: {
                break;
            }
            default: {
                this.checkInLangLib(iExpr, varRefType);
            }
        }
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation aInv) {
        if (aInv.expr == null) {
            this.checkFunctionInvocationExpr(aInv);
            return;
        }
        if (this.invalidModuleAliasUsage(aInv)) {
            return;
        }
        this.checkExpr(aInv.expr, this.env, this.symTable.noType);
        BLangExpression varRef = aInv.expr;
        switch (varRef.type.tag) {
            case 33: {
                this.checkActionInvocation(aInv, (BObjectType)varRef.type);
                break;
            }
            case 12: {
                this.checkFieldFunctionPointer(aInv, this.env);
                break;
            }
            case 23: {
                this.dlog.error(aInv.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION, aInv.name);
                this.resultType = this.symTable.semanticError;
                break;
            }
            default: {
                this.dlog.error(aInv.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION, varRef.type);
                this.resultType = this.symTable.semanticError;
            }
        }
    }

    private boolean invalidModuleAliasUsage(BLangInvocation invocation) {
        Name pkgAlias = this.names.fromIdNode(invocation.pkgAlias);
        if (pkgAlias != Names.EMPTY) {
            this.dlog.error(invocation.pos, DiagnosticErrorCode.PKG_ALIAS_NOT_ALLOWED_HERE, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        BLetSymbol letSymbol = new BLetSymbol(0x10000000, Flags.asMask(new HashSet<Flag>(Lists.of(new Flag[0]))), new Name(String.format("$let_symbol_%d$", this.letCount++)), this.env.enclPkg.symbol.pkgID, letExpression.type, this.env.scope.owner, letExpression.pos);
        letExpression.env = SymbolEnv.createExprEnv(letExpression, this.env, letSymbol);
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.semanticAnalyzer.analyzeDef((BLangNode)((Object)letVariable.definitionNode), letExpression.env);
        }
        BType exprType = this.checkExpr(letExpression.expr, letExpression.env);
        this.types.checkType(letExpression, exprType, this.expType);
    }

    private void checkInLangLib(BLangInvocation iExpr, BType varRefType) {
        BSymbol langLibMethodSymbol = this.getLangLibMethod(iExpr, varRefType);
        if (langLibMethodSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION_IN_TYPE, iExpr.name.value, iExpr.expr.type);
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (this.checkInvalidImmutableValueUpdate(iExpr, varRefType, langLibMethodSymbol)) {
            return;
        }
        this.checkIllegalStorageSizeChangeMethodCall(iExpr, varRefType);
    }

    private boolean checkInvalidImmutableValueUpdate(BLangInvocation iExpr, BType varRefType, BSymbol langLibMethodSymbol) {
        if (!Symbols.isFlagOn(varRefType.flags, 32L)) {
            return false;
        }
        String packageId = langLibMethodSymbol.pkgID.name.value;
        if (!modifierFunctions.containsKey(packageId)) {
            return false;
        }
        String funcName = langLibMethodSymbol.name.value;
        if (!modifierFunctions.get(packageId).contains(funcName)) {
            return false;
        }
        if (funcName.equals("mergeJson") && varRefType.tag != 15) {
            return false;
        }
        this.dlog.error(iExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_READONLY_VALUE_OF_TYPE, varRefType);
        this.resultType = this.symTable.semanticError;
        return true;
    }

    private boolean isFixedLengthList(BType type) {
        switch (type.tag) {
            case 19: {
                return ((BArrayType)type).state != BArrayState.OPEN;
            }
            case 30: {
                return ((BTupleType)type).restType == null;
            }
            case 20: {
                BUnionType unionType = (BUnionType)type;
                for (BType member : unionType.getMemberTypes()) {
                    if (this.isFixedLengthList(member)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void checkIllegalStorageSizeChangeMethodCall(BLangInvocation iExpr, BType varRefType) {
        String invocationName = iExpr.name.getValue();
        if (!listLengthModifierFunctions.contains(invocationName)) {
            return;
        }
        if (this.isFixedLengthList(varRefType)) {
            this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.ILLEGAL_FUNCTION_CHANGE_LIST_SIZE, invocationName, varRefType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (this.isShiftOnIncompatibleTuples(varRefType, invocationName)) {
            this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.ILLEGAL_FUNCTION_CHANGE_TUPLE_SHAPE, invocationName, varRefType);
            this.resultType = this.symTable.semanticError;
            return;
        }
    }

    private boolean isShiftOnIncompatibleTuples(BType varRefType, String invocationName) {
        if (varRefType.tag == 30 && invocationName.compareTo(FUNCTION_NAME_SHIFT) == 0 && this.hasDifferentTypeThanRest((BTupleType)varRefType)) {
            return true;
        }
        if (varRefType.tag == 20 && invocationName.compareTo(FUNCTION_NAME_SHIFT) == 0) {
            BUnionType unionVarRef = (BUnionType)varRefType;
            boolean allMemberAreFixedShapeTuples = true;
            for (BType member : unionVarRef.getMemberTypes()) {
                if (member.tag != 30) {
                    allMemberAreFixedShapeTuples = false;
                    break;
                }
                if (this.hasDifferentTypeThanRest((BTupleType)member)) continue;
                allMemberAreFixedShapeTuples = false;
                break;
            }
            return allMemberAreFixedShapeTuples;
        }
        return false;
    }

    private boolean hasDifferentTypeThanRest(BTupleType tupleType) {
        if (tupleType.restType == null) {
            return false;
        }
        for (BType member : tupleType.getTupleTypes()) {
            if (this.types.isSameType(tupleType.restType, member)) continue;
            return true;
        }
        return false;
    }

    private boolean checkFieldFunctionPointer(BLangInvocation iExpr, SymbolEnv env) {
        BType type = this.checkExpr(iExpr.expr, env);
        BLangIdentifier invocationIdentifier = iExpr.name;
        if (type == this.symTable.semanticError) {
            return false;
        }
        BSymbol funcSymbol = this.symResolver.resolveStructField(iExpr.pos, env, this.names.fromIdNode(invocationIdentifier), type.tsymbol);
        if (funcSymbol == this.symTable.notFoundSymbol) {
            BSymbol langLibMethodSymbol = this.getLangLibMethod(iExpr, type);
            if (langLibMethodSymbol == this.symTable.notFoundSymbol) {
                this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.UNDEFINED_FIELD_IN_RECORD, invocationIdentifier, type);
                this.resultType = this.symTable.semanticError;
            } else {
                this.checkInvalidImmutableValueUpdate(iExpr, type, langLibMethodSymbol);
            }
            return false;
        }
        iExpr.symbol = funcSymbol;
        iExpr.type = ((BInvokableSymbol)funcSymbol).retType;
        this.checkInvocationParamAndReturnType(iExpr);
        iExpr.functionPointerInvocation = true;
        return true;
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectCtorExpression) {
        if (objectCtorExpression.referenceType == null && objectCtorExpression.expectedType != null) {
            BObjectType objectType = (BObjectType)objectCtorExpression.classNode.type;
            if (objectCtorExpression.expectedType.tag == 33) {
                BObjectType expObjType = (BObjectType)objectCtorExpression.expectedType;
                objectType.typeIdSet = expObjType.typeIdSet;
            } else if (objectCtorExpression.expectedType.tag != 23 && !this.checkAndLoadTypeIdSet(objectCtorExpression.expectedType, objectType)) {
                this.dlog.error(objectCtorExpression.pos, DiagnosticErrorCode.INVALID_TYPE_OBJECT_CONSTRUCTOR, objectCtorExpression.expectedType);
                this.resultType = this.symTable.semanticError;
                return;
            }
        }
        this.visit(objectCtorExpression.typeInit);
    }

    private boolean isDefiniteObjectType(BType type, Set<BTypeIdSet> typeIdSets) {
        if (type.tag != 33 && type.tag != 20) {
            return false;
        }
        HashSet<BType> visitedTypes = new HashSet<BType>();
        if (!this.collectObjectTypeIds(type, typeIdSets, visitedTypes)) {
            return false;
        }
        return typeIdSets.size() <= 1;
    }

    private boolean collectObjectTypeIds(BType type, Set<BTypeIdSet> typeIdSets, Set<BType> visitedTypes) {
        if (type.tag == 33) {
            BObjectType objectType = (BObjectType)type;
            typeIdSets.add(objectType.typeIdSet);
            return true;
        }
        if (type.tag == 20) {
            if (!visitedTypes.add(type)) {
                return true;
            }
            for (BType member : ((BUnionType)type).getMemberTypes()) {
                if (this.collectObjectTypeIds(member, typeIdSets, visitedTypes)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkAndLoadTypeIdSet(BType type, BObjectType objectType) {
        HashSet<BTypeIdSet> typeIdSets = new HashSet<BTypeIdSet>();
        if (!this.isDefiniteObjectType(type, typeIdSets)) {
            return false;
        }
        if (typeIdSets.isEmpty()) {
            objectType.typeIdSet = BTypeIdSet.emptySet();
            return true;
        }
        Iterator typeIdIterator = typeIdSets.iterator();
        if (typeIdIterator.hasNext()) {
            BTypeIdSet typeIdSet;
            objectType.typeIdSet = typeIdSet = (BTypeIdSet)typeIdIterator.next();
            return true;
        }
        return true;
    }

    @Override
    public void visit(BLangTypeInit cIExpr) {
        if (this.expType.tag == 17 && cIExpr.userDefinedType == null || this.expType.tag == 12) {
            this.dlog.error(cIExpr.pos, DiagnosticErrorCode.INVALID_TYPE_NEW_LITERAL, this.expType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BType actualType = cIExpr.userDefinedType != null ? this.symResolver.resolveTypeNode(cIExpr.userDefinedType, this.env) : this.expType;
        if (actualType == this.symTable.semanticError) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (actualType.tag == 21) {
            actualType = ((BIntersectionType)actualType).effectiveType;
        }
        switch (actualType.tag) {
            case 33: {
                BObjectType actualObjectType = (BObjectType)actualType;
                if (this.isObjectConstructorExpr(cIExpr, actualObjectType)) {
                    BLangClassDefinition classDefForConstructor = this.getClassDefinitionForObjectConstructorExpr(cIExpr, this.env);
                    SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(this.env.enclPkg.symbol);
                    if (Symbols.isFlagOn(this.expType.flags, 32L)) {
                        this.handleObjectConstrExprForReadOnlyCET(cIExpr, actualObjectType, classDefForConstructor, pkgEnv);
                    } else {
                        this.semanticAnalyzer.analyzeNode(classDefForConstructor, pkgEnv);
                    }
                    this.markConstructedObjectIsolatedness(actualObjectType);
                }
                if ((actualType.tsymbol.flags & 0x10000000L) != 0x10000000L) {
                    this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INITIALIZE_ABSTRACT_OBJECT, actualType.tsymbol);
                    cIExpr.initInvocation.argExprs.forEach(expr -> this.checkExpr((BLangExpression)expr, this.env, this.symTable.noType));
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                if (((BObjectTypeSymbol)actualType.tsymbol).initializerFunc != null) {
                    cIExpr.initInvocation.symbol = ((BObjectTypeSymbol)actualType.tsymbol).initializerFunc.symbol;
                    this.checkInvocationParam(cIExpr.initInvocation);
                    cIExpr.initInvocation.type = ((BInvokableSymbol)cIExpr.initInvocation.symbol).retType;
                    break;
                }
                if (this.isValidInitInvocation(cIExpr, (BObjectType)actualType)) break;
                return;
            }
            case 14: {
                BType error;
                if (cIExpr.initInvocation.argExprs.size() > 1) {
                    this.dlog.error(cIExpr.pos, DiagnosticErrorCode.INVALID_STREAM_CONSTRUCTOR, cIExpr.initInvocation);
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                BStreamType actualStreamType = (BStreamType)actualType;
                if (actualStreamType.error != null && (error = actualStreamType.error) != this.symTable.neverType && !this.types.containsErrorType(error)) {
                    this.dlog.error(cIExpr.pos, DiagnosticErrorCode.ERROR_TYPE_EXPECTED, error.toString());
                    this.resultType = this.symTable.semanticError;
                    return;
                }
                if (!cIExpr.initInvocation.argExprs.isEmpty()) {
                    BLangExpression iteratorExpr = cIExpr.initInvocation.argExprs.get(0);
                    BType constructType = this.checkExpr(iteratorExpr, this.env, this.symTable.noType);
                    BUnionType expectedNextReturnType = this.createNextReturnType(cIExpr.pos, (BStreamType)actualType);
                    BAttachedFunction closeFunc = this.types.getAttachedFuncFromObject((BObjectType)constructType, "close");
                    if (closeFunc != null) {
                        BType closeableIteratorType = this.symTable.langQueryModuleSymbol.scope.lookup((Name)Names.ABSTRACT_CLOSEABLE_ITERATOR).symbol.type;
                        if (!this.types.isAssignable(constructType, closeableIteratorType)) {
                            this.dlog.error(iteratorExpr.pos, DiagnosticErrorCode.INVALID_STREAM_CONSTRUCTOR_CLOSEABLE_ITERATOR, expectedNextReturnType, constructType);
                            this.resultType = this.symTable.semanticError;
                            return;
                        }
                    } else {
                        BType iteratorType = this.symTable.langQueryModuleSymbol.scope.lookup((Name)Names.ABSTRACT_ITERATOR).symbol.type;
                        if (!this.types.isAssignable(constructType, iteratorType)) {
                            this.dlog.error(iteratorExpr.pos, DiagnosticErrorCode.INVALID_STREAM_CONSTRUCTOR_ITERATOR, expectedNextReturnType, constructType);
                            this.resultType = this.symTable.semanticError;
                            return;
                        }
                    }
                    BUnionType nextReturnType = this.types.getVarTypeFromIteratorFuncReturnType(constructType);
                    this.types.checkType(iteratorExpr.pos, (BType)nextReturnType, (BType)expectedNextReturnType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                }
                this.resultType = actualType;
                return;
            }
            case 20: {
                List<BType> matchingMembers = this.findMembersWithMatchingInitFunc(cIExpr, (BUnionType)actualType);
                BType matchedType = this.getMatchingType(matchingMembers, cIExpr, actualType);
                cIExpr.initInvocation.type = this.symTable.nilType;
                if (matchedType.tag == 33) {
                    if (((BObjectTypeSymbol)matchedType.tsymbol).initializerFunc != null) {
                        cIExpr.initInvocation.symbol = ((BObjectTypeSymbol)matchedType.tsymbol).initializerFunc.symbol;
                        this.checkInvocationParam(cIExpr.initInvocation);
                        cIExpr.initInvocation.type = ((BInvokableSymbol)cIExpr.initInvocation.symbol).retType;
                        actualType = matchedType;
                        break;
                    }
                    if (!this.isValidInitInvocation(cIExpr, (BObjectType)matchedType)) {
                        return;
                    }
                }
                this.types.checkType(cIExpr, matchedType, this.expType);
                cIExpr.type = matchedType;
                this.resultType = matchedType;
                return;
            }
            default: {
                this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INFER_OBJECT_TYPE_FROM_LHS, actualType);
                this.resultType = this.symTable.semanticError;
                return;
            }
        }
        if (cIExpr.initInvocation.type == null) {
            cIExpr.initInvocation.type = this.symTable.nilType;
        }
        BType actualTypeInitType = this.getObjectConstructorReturnType(actualType, cIExpr.initInvocation.type);
        this.resultType = this.types.checkType(cIExpr, actualTypeInitType, this.expType);
    }

    private BUnionType createNextReturnType(Location pos, BStreamType streamType) {
        BRecordType recordType = new BRecordType(null, 2048L);
        recordType.restFieldType = this.symTable.noType;
        recordType.sealed = true;
        Name fieldName = Names.VALUE;
        BField field = new BField(fieldName, pos, new BVarSymbol(1L, fieldName, this.env.enclPkg.packageID, streamType.constraint, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL));
        field.type = streamType.constraint;
        recordType.fields.put(field.name.value, field);
        recordType.tsymbol = Symbols.createRecordSymbol(2048L, Names.EMPTY, this.env.enclPkg.packageID, recordType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        recordType.tsymbol.scope = new Scope(this.env.scope.owner);
        recordType.tsymbol.scope.define(fieldName, field.symbol);
        LinkedHashSet<BType> retTypeMembers = new LinkedHashSet<BType>();
        retTypeMembers.add(recordType);
        if (streamType.error != this.symTable.neverType && streamType.error != null) {
            retTypeMembers.add(streamType.error);
        }
        retTypeMembers.add(this.symTable.nilType);
        BUnionType unionType = BUnionType.create(null, retTypeMembers);
        unionType.tsymbol = Symbols.createTypeSymbol(2162716, 0L, Names.EMPTY, this.env.enclPkg.symbol.pkgID, unionType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        return unionType;
    }

    private boolean isValidInitInvocation(BLangTypeInit cIExpr, BObjectType objType) {
        if (!cIExpr.initInvocation.argExprs.isEmpty() && ((BObjectTypeSymbol)objType.tsymbol).initializerFunc == null) {
            this.dlog.error(cIExpr.pos, DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL, cIExpr.initInvocation.exprSymbol);
            cIExpr.initInvocation.argExprs.forEach(expr -> this.checkExpr((BLangExpression)expr, this.env, this.symTable.noType));
            this.resultType = this.symTable.semanticError;
            return false;
        }
        return true;
    }

    private BType getObjectConstructorReturnType(BType objType, BType initRetType) {
        if (initRetType.tag == 20) {
            LinkedHashSet<BType> retTypeMembers = new LinkedHashSet<BType>();
            retTypeMembers.add(objType);
            retTypeMembers.addAll(((BUnionType)initRetType).getMemberTypes());
            retTypeMembers.remove(this.symTable.nilType);
            BUnionType unionType = BUnionType.create(null, retTypeMembers);
            unionType.tsymbol = Symbols.createTypeSymbol(2162716, 0L, Names.EMPTY, this.env.enclPkg.symbol.pkgID, unionType, this.env.scope.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            return unionType;
        }
        if (initRetType.tag == 10) {
            return objType;
        }
        return this.symTable.semanticError;
    }

    private List<BType> findMembersWithMatchingInitFunc(BLangTypeInit cIExpr, BUnionType lhsUnionType) {
        int objectCount = 0;
        for (BType memberType : lhsUnionType.getMemberTypes()) {
            int tag = memberType.tag;
            if (tag == 33) {
                ++objectCount;
                continue;
            }
            if (tag != 21 || ((BIntersectionType)memberType).effectiveType.tag != 33) continue;
            ++objectCount;
        }
        boolean containsSingleObject = objectCount == 1;
        ArrayList<BType> matchingLhsMemberTypes = new ArrayList<BType>();
        for (BType memberType : lhsUnionType.getMemberTypes()) {
            if (memberType.tag != 33) continue;
            if ((memberType.tsymbol.flags & 0x10000000L) != 0x10000000L) {
                this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INITIALIZE_ABSTRACT_OBJECT, lhsUnionType.tsymbol);
            }
            if (containsSingleObject) {
                return Collections.singletonList(memberType);
            }
            BAttachedFunction initializerFunc = ((BObjectTypeSymbol)memberType.tsymbol).initializerFunc;
            if (!this.isArgsMatchesFunction(cIExpr.argsExpr, initializerFunc)) continue;
            matchingLhsMemberTypes.add(memberType);
        }
        return matchingLhsMemberTypes;
    }

    private BType getMatchingType(List<BType> matchingLhsMembers, BLangTypeInit cIExpr, BType lhsUnion) {
        if (matchingLhsMembers.isEmpty()) {
            this.dlog.error(cIExpr.pos, DiagnosticErrorCode.CANNOT_INFER_OBJECT_TYPE_FROM_LHS, lhsUnion);
            this.resultType = this.symTable.semanticError;
            return this.symTable.semanticError;
        }
        if (matchingLhsMembers.size() == 1) {
            return matchingLhsMembers.get((int)0).tsymbol.type;
        }
        this.dlog.error(cIExpr.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, lhsUnion);
        this.resultType = this.symTable.semanticError;
        return this.symTable.semanticError;
    }

    private boolean isArgsMatchesFunction(List<BLangExpression> invocationArguments, BAttachedFunction function) {
        invocationArguments.forEach(expr -> this.checkExpr((BLangExpression)expr, this.env, this.symTable.noType));
        if (function == null) {
            return invocationArguments.isEmpty();
        }
        if (function.symbol.params.isEmpty() && invocationArguments.isEmpty()) {
            return true;
        }
        ArrayList<BLangNamedArgsExpression> namedArgs = new ArrayList<BLangNamedArgsExpression>();
        ArrayList<BLangExpression> positionalArgs = new ArrayList<BLangExpression>();
        for (BLangExpression argument : invocationArguments) {
            if (argument.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                namedArgs.add((BLangNamedArgsExpression)argument);
                continue;
            }
            positionalArgs.add(argument);
        }
        List requiredParams = function.symbol.params.stream().filter(param -> !param.defaultableParam).collect(Collectors.toList());
        if (requiredParams.size() > invocationArguments.size()) {
            return false;
        }
        List defaultableParams = function.symbol.params.stream().filter(param -> param.defaultableParam).collect(Collectors.toList());
        int givenRequiredParamCount = 0;
        for (int i = 0; i < positionalArgs.size(); ++i) {
            if (function.symbol.params.size() > i) {
                ++givenRequiredParamCount;
                BVarSymbol functionParam = function.symbol.params.get(i);
                if (!this.types.isAssignable(((BLangExpression)positionalArgs.get((int)i)).type, functionParam.type)) {
                    return false;
                }
                requiredParams.remove(functionParam);
                defaultableParams.remove(functionParam);
                continue;
            }
            if (function.symbol.restParam != null) {
                BType restParamType = ((BArrayType)function.symbol.restParam.type).eType;
                if (this.types.isAssignable(((BLangExpression)positionalArgs.get((int)i)).type, restParamType)) continue;
                return false;
            }
            return false;
        }
        for (BLangNamedArgsExpression namedArg : namedArgs) {
            boolean foundNamedArg = false;
            List<BVarSymbol> params = function.symbol.params;
            for (int i = givenRequiredParamCount; i < params.size(); ++i) {
                BVarSymbol functionParam = params.get(i);
                if (!namedArg.name.value.equals(functionParam.name.value)) continue;
                foundNamedArg = true;
                BType namedArgExprType = this.checkExpr(namedArg.expr, this.env);
                if (!this.types.isAssignable(functionParam.type, namedArgExprType)) {
                    return false;
                }
                requiredParams.remove(functionParam);
                defaultableParams.remove(functionParam);
            }
            if (foundNamedArg) continue;
            return false;
        }
        return requiredParams.size() <= 0;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        switch (this.expType.tag) {
            case 12: {
                this.checkTypesForRecords(waitForAllExpr);
                break;
            }
            case 15: {
                this.checkTypesForMap(waitForAllExpr.keyValuePairs, ((BMapType)this.expType).constraint);
                LinkedHashSet<BType> memberTypesForMap = this.collectWaitExprTypes(waitForAllExpr.keyValuePairs);
                if (memberTypesForMap.size() == 1) {
                    this.resultType = new BMapType(15, (BType)memberTypesForMap.iterator().next(), this.symTable.mapType.tsymbol);
                    break;
                }
                BUnionType constraintTypeForMap = BUnionType.create(null, memberTypesForMap);
                this.resultType = new BMapType(15, constraintTypeForMap, this.symTable.mapType.tsymbol);
                break;
            }
            case 17: 
            case 23: {
                this.checkTypesForMap(waitForAllExpr.keyValuePairs, this.expType);
                LinkedHashSet<BType> memberTypes = this.collectWaitExprTypes(waitForAllExpr.keyValuePairs);
                if (memberTypes.size() == 1) {
                    this.resultType = new BMapType(15, (BType)memberTypes.iterator().next(), this.symTable.mapType.tsymbol);
                    break;
                }
                BUnionType constraintType = BUnionType.create(null, memberTypes);
                this.resultType = new BMapType(15, constraintType, this.symTable.mapType.tsymbol);
                break;
            }
            default: {
                this.dlog.error(waitForAllExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.expType, this.getWaitForAllExprReturnType(waitForAllExpr.keyValuePairs, waitForAllExpr.pos));
                this.resultType = this.symTable.semanticError;
            }
        }
        waitForAllExpr.type = this.resultType;
        if (this.resultType != null && this.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(waitForAllExpr, waitForAllExpr.type, this.expType);
        }
    }

    private BRecordType getWaitForAllExprReturnType(List<BLangWaitForAllExpr.BLangWaitKeyValue> keyVals, Location pos) {
        BRecordType retType = new BRecordType(null, 2048L);
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : keyVals) {
            BLangIdentifier fieldName = keyVal.valueExpr == null || keyVal.valueExpr.getKind() != NodeKind.SIMPLE_VARIABLE_REF ? keyVal.key : ((BLangSimpleVarRef)keyVal.valueExpr).variableName;
            BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(fieldName));
            BType fieldType = symbol.type.tag == 31 ? ((BFutureType)symbol.type).constraint : symbol.type;
            BField field = new BField(this.names.fromIdNode(keyVal.key), null, new BVarSymbol(0L, this.names.fromIdNode(keyVal.key), this.env.enclPkg.packageID, fieldType, null, keyVal.pos, SymbolOrigin.VIRTUAL));
            retType.fields.put(field.name.value, field);
        }
        retType.restFieldType = this.symTable.noType;
        retType.sealed = true;
        retType.tsymbol = Symbols.createRecordSymbol(2048L, Names.EMPTY, this.env.enclPkg.packageID, retType, null, pos, SymbolOrigin.VIRTUAL);
        return retType;
    }

    private LinkedHashSet<BType> collectWaitExprTypes(List<BLangWaitForAllExpr.BLangWaitKeyValue> keyVals) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : keyVals) {
            BType bType;
            BType bType2 = bType = keyVal.keyExpr != null ? keyVal.keyExpr.type : keyVal.valueExpr.type;
            if (bType.tag == 31) {
                memberTypes.add(((BFutureType)bType).constraint);
                continue;
            }
            memberTypes.add(bType);
        }
        return memberTypes;
    }

    private void checkTypesForMap(List<BLangWaitForAllExpr.BLangWaitKeyValue> keyValuePairs, BType expType) {
        keyValuePairs.forEach(keyVal -> this.checkWaitKeyValExpr((BLangWaitForAllExpr.BLangWaitKeyValue)keyVal, expType));
    }

    private void checkTypesForRecords(BLangWaitForAllExpr waitExpr) {
        List<BLangWaitForAllExpr.BLangWaitKeyValue> rhsFields = waitExpr.getKeyValuePairs();
        LinkedHashMap lhsFields = ((BRecordType)this.expType).fields;
        if (((BRecordType)this.expType).sealed && rhsFields.size() > lhsFields.size()) {
            this.dlog.error(waitExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.expType, this.getWaitForAllExprReturnType(waitExpr.keyValuePairs, waitExpr.pos));
            this.resultType = this.symTable.semanticError;
            return;
        }
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyVal : rhsFields) {
            String key = keyVal.key.value;
            if (!lhsFields.containsKey(key)) {
                if (((BRecordType)this.expType).sealed) {
                    this.dlog.error(waitExpr.pos, DiagnosticErrorCode.INVALID_FIELD_NAME_RECORD_LITERAL, key, this.expType);
                    this.resultType = this.symTable.semanticError;
                    continue;
                }
                BType restFieldType = ((BRecordType)this.expType).restFieldType;
                this.checkWaitKeyValExpr(keyVal, restFieldType);
                continue;
            }
            this.checkWaitKeyValExpr(keyVal, ((BField)lhsFields.get((Object)key)).type);
        }
        this.checkMissingReqFieldsForWait((BRecordType)this.expType, rhsFields, waitExpr.pos);
        if (this.symTable.semanticError != this.resultType) {
            this.resultType = this.expType;
        }
    }

    private void checkMissingReqFieldsForWait(BRecordType type, List<BLangWaitForAllExpr.BLangWaitKeyValue> keyValPairs, Location pos) {
        type.fields.values().forEach(field -> {
            boolean hasField = keyValPairs.stream().anyMatch(keyVal -> field.name.value.equals(keyVal.key.value));
            if (!hasField && Symbols.isFlagOn(field.symbol.flags, 256L)) {
                this.dlog.error(pos, DiagnosticErrorCode.MISSING_REQUIRED_RECORD_FIELD, field.name);
            }
        });
    }

    private void checkWaitKeyValExpr(BLangWaitForAllExpr.BLangWaitKeyValue keyVal, BType type) {
        BLangExpression expr;
        if (keyVal.keyExpr != null) {
            BSymbol symbol = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(((BLangSimpleVarRef)keyVal.keyExpr).variableName));
            keyVal.keyExpr.type = symbol.type;
            expr = keyVal.keyExpr;
        } else {
            expr = keyVal.valueExpr;
        }
        BFutureType futureType = new BFutureType(31, type, null);
        this.checkExpr(expr, this.env, futureType);
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        BType condExprType = this.checkExpr(ternaryExpr.expr, this.env, this.symTable.booleanType);
        SymbolEnv thenEnv = this.typeNarrower.evaluateTruth(ternaryExpr.expr, ternaryExpr.thenExpr, this.env);
        BType thenType = this.checkExpr(ternaryExpr.thenExpr, thenEnv, this.expType);
        SymbolEnv elseEnv = this.typeNarrower.evaluateFalsity(ternaryExpr.expr, ternaryExpr.elseExpr, this.env);
        BType elseType = this.checkExpr(ternaryExpr.elseExpr, elseEnv, this.expType);
        if (condExprType == this.symTable.semanticError || thenType == this.symTable.semanticError || elseType == this.symTable.semanticError) {
            this.resultType = this.symTable.semanticError;
        } else if (this.expType == this.symTable.noType) {
            if (this.types.isAssignable(elseType, thenType)) {
                this.resultType = thenType;
            } else if (this.types.isAssignable(thenType, elseType)) {
                this.resultType = elseType;
            } else {
                this.dlog.error(ternaryExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, thenType, elseType);
                this.resultType = this.symTable.semanticError;
            }
        } else {
            this.resultType = this.expType;
        }
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        this.expType = new BFutureType(31, this.expType, null);
        this.checkExpr(waitExpr.getExpression(), this.env, this.expType);
        if (this.resultType.tag == 20) {
            LinkedHashSet<BType> memberTypes = this.collectMemberTypes((BUnionType)this.resultType, new LinkedHashSet<BType>());
            this.resultType = memberTypes.size() == 1 ? memberTypes.toArray(new BType[0])[0] : BUnionType.create(null, memberTypes);
        } else if (this.resultType != this.symTable.semanticError) {
            this.resultType = ((BFutureType)this.resultType).constraint;
        }
        waitExpr.type = this.resultType;
        if (this.resultType != null && this.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(waitExpr, waitExpr.type, ((BFutureType)this.expType).constraint);
        }
    }

    private LinkedHashSet<BType> collectMemberTypes(BUnionType unionType, LinkedHashSet<BType> memberTypes) {
        for (BType memberType : unionType.getMemberTypes()) {
            if (memberType.tag == 31) {
                memberTypes.add(((BFutureType)memberType).constraint);
                continue;
            }
            memberTypes.add(memberType);
        }
        return memberTypes;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        BType actualType;
        boolean definedWithVar;
        boolean firstVisit = trapExpr.expr.type == null;
        BType exprType = this.checkExpr(trapExpr.expr, this.env, this.expType);
        boolean bl = definedWithVar = this.expType == this.symTable.noType;
        if (trapExpr.expr.getKind() == NodeKind.WORKER_RECEIVE) {
            if (firstVisit) {
                this.isTypeChecked = false;
                this.resultType = this.expType;
                return;
            }
            this.expType = trapExpr.type;
            exprType = trapExpr.expr.type;
        }
        if (this.expType == this.symTable.semanticError || exprType == this.symTable.semanticError) {
            actualType = this.symTable.semanticError;
        } else {
            LinkedHashSet<BType> resultTypes = new LinkedHashSet<BType>();
            if (exprType.tag == 20) {
                resultTypes.addAll(((BUnionType)exprType).getMemberTypes());
            } else {
                resultTypes.add(exprType);
            }
            resultTypes.add(this.symTable.errorType);
            actualType = BUnionType.create(null, resultTypes);
        }
        this.resultType = this.types.checkType(trapExpr, actualType, this.expType);
        if (definedWithVar && this.resultType != null && this.resultType != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(trapExpr.expr, trapExpr.expr.type, this.resultType);
        }
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        if (this.expType.tag == 31 && binaryExpr.opKind == OperatorKind.BITWISE_OR) {
            BType lhsResultType = this.checkExpr(binaryExpr.lhsExpr, this.env, this.expType);
            BType rhsResultType = this.checkExpr(binaryExpr.rhsExpr, this.env, this.expType);
            if (lhsResultType == this.symTable.semanticError || rhsResultType == this.symTable.semanticError) {
                this.resultType = this.symTable.semanticError;
                return;
            }
            this.resultType = BUnionType.create(null, lhsResultType, rhsResultType);
            return;
        }
        this.checkDecimalCompatibilityForBinaryArithmeticOverLiteralValues(binaryExpr);
        BType lhsType = this.checkExpr(binaryExpr.lhsExpr, this.env);
        SymbolEnv rhsExprEnv = binaryExpr.opKind == OperatorKind.AND ? this.typeNarrower.evaluateTruth(binaryExpr.lhsExpr, binaryExpr.rhsExpr, this.env, true) : (binaryExpr.opKind == OperatorKind.OR ? this.typeNarrower.evaluateFalsity(binaryExpr.lhsExpr, binaryExpr.rhsExpr, this.env) : this.env);
        BType rhsType = this.checkExpr(binaryExpr.rhsExpr, rhsExprEnv);
        BType actualType = this.symTable.semanticError;
        switch (binaryExpr.opKind) {
            case ADD: {
                BType leftConstituent = this.getXMLConstituents(lhsType);
                BType rightConstituent = this.getXMLConstituents(rhsType);
                if (leftConstituent != null && rightConstituent != null) {
                    actualType = new BXMLType(BUnionType.create(null, leftConstituent, rightConstituent), null);
                    break;
                }
            }
            default: {
                if (lhsType == this.symTable.semanticError || rhsType == this.symTable.semanticError) break;
                BSymbol opSymbol = this.symResolver.resolveBinaryOperator(binaryExpr.opKind, lhsType, rhsType);
                if (opSymbol == this.symTable.notFoundSymbol) {
                    opSymbol = this.symResolver.getBinaryEqualityForTypeSets(binaryExpr.opKind, lhsType, rhsType, binaryExpr);
                }
                if (opSymbol == this.symTable.notFoundSymbol) {
                    this.dlog.error(binaryExpr.pos, DiagnosticErrorCode.BINARY_OP_INCOMPATIBLE_TYPES, new Object[]{binaryExpr.opKind, lhsType, rhsType});
                    break;
                }
                if ((binaryExpr.opKind == OperatorKind.EQUAL || binaryExpr.opKind == OperatorKind.NOT_EQUAL) && this.couldHoldTableValues(lhsType, new ArrayList<BType>()) && this.couldHoldTableValues(rhsType, new ArrayList<BType>())) {
                    this.dlog.error(binaryExpr.pos, DiagnosticErrorCode.EQUALITY_NOT_YET_SUPPORTED, TABLE_TNAME);
                }
                binaryExpr.opSymbol = (BOperatorSymbol)opSymbol;
                actualType = opSymbol.type.getReturnType();
            }
        }
        this.resultType = this.types.checkType(binaryExpr, actualType, this.expType);
    }

    private SymbolEnv getEnvBeforeInputNode(SymbolEnv env, BLangNode node) {
        while (env != null && env.node != node) {
            env = env.enclEnv;
        }
        return env != null && env.enclEnv != null ? env.enclEnv.createClone() : new SymbolEnv(node, null);
    }

    private SymbolEnv getEnvAfterJoinNode(SymbolEnv env, BLangNode node) {
        SymbolEnv clone = env.createClone();
        while (clone != null && clone.node != node) {
            clone = clone.enclEnv;
        }
        if (clone != null) {
            clone.enclEnv = this.getEnvBeforeInputNode(clone.enclEnv, this.getLastInputNodeFromEnv(clone.enclEnv));
        } else {
            clone = new SymbolEnv(node, null);
        }
        return clone;
    }

    private BLangNode getLastInputNodeFromEnv(SymbolEnv env) {
        while (env != null && env.node.getKind() != NodeKind.FROM && env.node.getKind() != NodeKind.JOIN) {
            env = env.enclEnv;
        }
        return env != null ? env.node : null;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        this.resultType = this.types.checkType(transactionalExpr, this.symTable.booleanType, this.expType);
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        BUnionType actualType = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
        this.resultType = this.types.checkType(commitExpr, actualType, this.expType);
    }

    private BType getXMLConstituents(BType type) {
        BType constituent = null;
        if (type.tag == 8) {
            constituent = ((BXMLType)type).constraint;
        } else if (TypeTags.isXMLNonSequenceType(type.tag)) {
            constituent = type;
        }
        return constituent;
    }

    private void checkDecimalCompatibilityForBinaryArithmeticOverLiteralValues(BLangBinaryExpr binaryExpr) {
        if (this.expType.tag != 4) {
            return;
        }
        switch (binaryExpr.opKind) {
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: {
                this.checkExpr(binaryExpr.lhsExpr, this.env, this.expType);
                this.checkExpr(binaryExpr.rhsExpr, this.env, this.expType);
                break;
            }
        }
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        BType lhsType = this.checkExpr(elvisExpr.lhsExpr, this.env);
        BType actualType = this.symTable.semanticError;
        if (lhsType != this.symTable.semanticError) {
            if (lhsType.tag == 20 && lhsType.isNullable()) {
                BUnionType unionType = (BUnionType)lhsType;
                LinkedHashSet memberTypes = unionType.getMemberTypes().stream().filter(type -> type.tag != 10).collect(Collectors.toCollection(LinkedHashSet::new));
                actualType = memberTypes.size() == 1 ? memberTypes.toArray(new BType[0])[0] : BUnionType.create(null, memberTypes);
            } else {
                this.dlog.error(elvisExpr.pos, DiagnosticErrorCode.OPERATOR_NOT_SUPPORTED, new Object[]{OperatorKind.ELVIS, lhsType});
            }
        }
        BType rhsReturnType = this.checkExpr(elvisExpr.rhsExpr, this.env, this.expType);
        BType lhsReturnType = this.types.checkType(elvisExpr.lhsExpr.pos, actualType, this.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        if (rhsReturnType == this.symTable.semanticError || lhsReturnType == this.symTable.semanticError) {
            this.resultType = this.symTable.semanticError;
        } else if (this.expType == this.symTable.noType) {
            if (this.types.isSameType(rhsReturnType, lhsReturnType)) {
                this.resultType = lhsReturnType;
            } else {
                this.dlog.error(elvisExpr.rhsExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, lhsReturnType, rhsReturnType);
                this.resultType = this.symTable.semanticError;
            }
        } else {
            this.resultType = this.expType;
        }
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.resultType = this.checkExpr(groupExpr.expression, this.env, this.expType);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        if (accessExpr.typeNode == null) {
            return;
        }
        accessExpr.resolvedType = this.symResolver.resolveTypeNode(accessExpr.typeNode, this.env);
        int resolveTypeTag = accessExpr.resolvedType.tag;
        BType actualType = resolveTypeTag != 13 && resolveTypeTag != 23 ? new BTypedescType(accessExpr.resolvedType, null) : accessExpr.resolvedType;
        this.resultType = this.types.checkType(accessExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        BType actualType = this.symTable.semanticError;
        if (OperatorKind.UNTAINT.equals((Object)unaryExpr.operator)) {
            BType exprType = this.checkExpr(unaryExpr.expr, this.env);
            if (exprType != this.symTable.semanticError) {
                actualType = exprType;
            }
        } else if (OperatorKind.TYPEOF.equals((Object)unaryExpr.operator)) {
            BType exprType = this.checkExpr(unaryExpr.expr, this.env);
            if (exprType != this.symTable.semanticError) {
                actualType = new BTypedescType(exprType, null);
            }
        } else {
            BType exprType;
            BType bType = exprType = OperatorKind.ADD.equals((Object)unaryExpr.operator) ? this.checkExpr(unaryExpr.expr, this.env, this.expType) : this.checkExpr(unaryExpr.expr, this.env);
            if (exprType != this.symTable.semanticError) {
                BSymbol symbol = this.symResolver.resolveUnaryOperator(unaryExpr.pos, unaryExpr.operator, exprType);
                if (symbol == this.symTable.notFoundSymbol) {
                    this.dlog.error(unaryExpr.pos, DiagnosticErrorCode.UNARY_OP_INCOMPATIBLE_TYPES, new Object[]{unaryExpr.operator, exprType});
                } else {
                    unaryExpr.opSymbol = (BOperatorSymbol)symbol;
                    actualType = symbol.type.getReturnType();
                }
            }
        }
        this.resultType = this.types.checkType(unaryExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        BType actualType = this.symTable.semanticError;
        for (BLangAnnotationAttachment annAttachment : conversionExpr.annAttachments) {
            annAttachment.attachPoints.add(AttachPoint.Point.TYPE);
            this.semanticAnalyzer.analyzeNode(annAttachment, this.env);
        }
        BLangExpression expr = conversionExpr.expr;
        if (conversionExpr.typeNode == null && !conversionExpr.annAttachments.isEmpty()) {
            this.resultType = this.checkExpr(expr, this.env, this.expType);
            return;
        }
        BType targetType = this.symResolver.resolveTypeNode(conversionExpr.typeNode, this.env);
        boolean requiresTypeInference = this.requireTypeInference(expr, false);
        if (requiresTypeInference) {
            targetType = this.getEffectiveReadOnlyType(conversionExpr.typeNode.pos, targetType);
        }
        conversionExpr.targetType = targetType;
        BType expType = requiresTypeInference ? targetType : this.symTable.noType;
        BType sourceType = this.checkExpr(expr, this.env, expType);
        if (this.types.isTypeCastable(expr, sourceType, targetType)) {
            actualType = targetType;
        } else {
            this.dlog.error(conversionExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_CAST, sourceType, targetType);
        }
        this.resultType = this.types.checkType(conversionExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        bLangLambdaFunction.type = bLangLambdaFunction.function.symbol.type;
        bLangLambdaFunction.capturedClosureEnv = this.env.createClone();
        this.env.enclPkg.lambdaFunctions.add(bLangLambdaFunction);
        this.resultType = this.types.checkType(bLangLambdaFunction, bLangLambdaFunction.type, this.expType);
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        BUnionType unionType;
        BType invokableType;
        BType expectedType = this.expType;
        if (expectedType.tag == 20 && (invokableType = (unionType = (BUnionType)expectedType).getMemberTypes().stream().filter(type -> type.tag == 16).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() != 1) {
                return null;
            }
            return (BType)list.get(0);
        }))) != null) {
            expectedType = invokableType;
        }
        if (expectedType.tag != 16) {
            this.dlog.error(bLangArrowFunction.pos, DiagnosticErrorCode.ARROW_EXPRESSION_CANNOT_INFER_TYPE_FROM_LHS, new Object[0]);
            this.resultType = this.symTable.semanticError;
            return;
        }
        BInvokableType expectedInvocation = (BInvokableType)expectedType;
        this.populateArrowExprParamTypes(bLangArrowFunction, expectedInvocation.paramTypes);
        bLangArrowFunction.body.expr.type = this.populateArrowExprReturn(bLangArrowFunction, expectedInvocation.retType);
        if (expectedInvocation.retType.tag == 23) {
            expectedInvocation.retType = bLangArrowFunction.body.expr.type;
        }
        this.resultType = bLangArrowFunction.funcType = expectedInvocation;
    }

    @Override
    public void visit(BLangXMLQName bLangXMLQName) {
        String prefix = bLangXMLQName.prefix.value;
        this.resultType = this.types.checkType(bLangXMLQName, this.symTable.stringType, this.expType);
        if (this.env.node.getKind() == NodeKind.XML_ATTRIBUTE && prefix.isEmpty() && bLangXMLQName.localname.value.equals("xmlns")) {
            ((BLangXMLAttribute)this.env.node).isNamespaceDeclr = true;
            return;
        }
        if (this.env.node.getKind() == NodeKind.XML_ATTRIBUTE && prefix.equals("xmlns")) {
            ((BLangXMLAttribute)this.env.node).isNamespaceDeclr = true;
            return;
        }
        if (prefix.equals("xmlns")) {
            this.dlog.error(bLangXMLQName.pos, DiagnosticErrorCode.INVALID_NAMESPACE_PREFIX, prefix);
            bLangXMLQName.type = this.symTable.semanticError;
            return;
        }
        if (bLangXMLQName.prefix.value.isEmpty()) {
            return;
        }
        BSymbol xmlnsSymbol = this.symResolver.lookupSymbolInPrefixSpace(this.env, this.names.fromIdNode(bLangXMLQName.prefix));
        if (prefix.isEmpty() && xmlnsSymbol == this.symTable.notFoundSymbol) {
            return;
        }
        if (!prefix.isEmpty() && xmlnsSymbol == this.symTable.notFoundSymbol) {
            this.logUndefinedSymbolError(bLangXMLQName.pos, prefix);
            bLangXMLQName.type = this.symTable.semanticError;
            return;
        }
        if (xmlnsSymbol.getKind() == SymbolKind.PACKAGE) {
            xmlnsSymbol = this.findXMLNamespaceFromPackageConst(bLangXMLQName.localname.value, bLangXMLQName.prefix.value, (BPackageSymbol)xmlnsSymbol, bLangXMLQName.pos);
        }
        if (xmlnsSymbol == null || xmlnsSymbol.getKind() != SymbolKind.XMLNS) {
            this.resultType = this.symTable.semanticError;
            return;
        }
        bLangXMLQName.nsSymbol = (BXMLNSSymbol)xmlnsSymbol;
        bLangXMLQName.namespaceURI = bLangXMLQName.nsSymbol.namespaceURI;
    }

    private BSymbol findXMLNamespaceFromPackageConst(String localname, String prefix, BPackageSymbol pkgSymbol, Location pos) {
        BSymbol constSymbol = this.symResolver.lookupMemberSymbol(pos, pkgSymbol.scope, this.env, this.names.fromString(localname), 33554460);
        if (constSymbol == this.symTable.notFoundSymbol) {
            if (!this.missingNodesHelper.isMissingNode(prefix) && !this.missingNodesHelper.isMissingNode(localname)) {
                this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_SYMBOL, prefix + ":" + localname);
            }
            return null;
        }
        BConstantSymbol constantSymbol = (BConstantSymbol)constSymbol;
        if (constantSymbol.literalType.tag != 5) {
            this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.stringType, constantSymbol.literalType);
            return null;
        }
        String constVal = (String)constantSymbol.value.value;
        int s = constVal.indexOf(123);
        int e = constVal.lastIndexOf(125);
        if (e > s + 1) {
            pkgSymbol.isUsed = true;
            String nsURI = constVal.substring(s + 1, e);
            String local = constVal.substring(e);
            return new BXMLNSSymbol(this.names.fromString(local), nsURI, constantSymbol.pkgID, constantSymbol.owner, pos, SymbolOrigin.SOURCE);
        }
        this.dlog.error(pos, DiagnosticErrorCode.INVALID_ATTRIBUTE_REFERENCE, prefix + ":" + localname);
        return null;
    }

    @Override
    public void visit(BLangXMLAttribute bLangXMLAttribute) {
        SymbolEnv xmlAttributeEnv = SymbolEnv.getXMLAttributeEnv(bLangXMLAttribute, this.env);
        BLangXMLQName name = (BLangXMLQName)bLangXMLAttribute.name;
        this.checkExpr(name, xmlAttributeEnv, this.symTable.stringType);
        if (name.prefix.value.isEmpty()) {
            name.namespaceURI = null;
        }
        this.checkExpr(bLangXMLAttribute.value, xmlAttributeEnv, this.symTable.stringType);
        this.symbolEnter.defineNode(bLangXMLAttribute, this.env);
    }

    @Override
    public void visit(BLangXMLElementLiteral bLangXMLElementLiteral) {
        SymbolEnv xmlElementEnv = SymbolEnv.getXMLElementEnv(bLangXMLElementLiteral, this.env);
        HashSet<String> usedPrefixes = new HashSet<String>();
        BLangIdentifier elemNamePrefix = ((BLangXMLQName)bLangXMLElementLiteral.startTagName).prefix;
        if (elemNamePrefix != null && !elemNamePrefix.value.isEmpty()) {
            usedPrefixes.add(elemNamePrefix.value);
        }
        for (BLangXMLAttribute attribute2 : bLangXMLElementLiteral.attributes) {
            BLangIdentifier prefix;
            if (attribute2.name.getKind() == NodeKind.XML_QNAME && this.isXmlNamespaceAttribute(attribute2)) {
                BLangXMLQuotedString value = attribute2.value;
                if (value.getKind() == NodeKind.XML_QUOTED_STRING && value.textFragments.size() > 1) {
                    this.dlog.error(value.pos, DiagnosticErrorCode.INVALID_XML_NS_INTERPOLATION, new Object[0]);
                }
                this.checkExpr(attribute2, xmlElementEnv, this.symTable.noType);
            }
            if ((prefix = ((BLangXMLQName)attribute2.name).prefix) == null || prefix.value.isEmpty()) continue;
            usedPrefixes.add(prefix.value);
        }
        bLangXMLElementLiteral.attributes.forEach(attribute -> {
            if (attribute.name.getKind() != NodeKind.XML_QNAME || !this.isXmlNamespaceAttribute((BLangXMLAttribute)attribute)) {
                this.checkExpr((BLangExpression)attribute, xmlElementEnv, this.symTable.noType);
            }
        });
        Map<Name, BXMLNSSymbol> namespaces = this.symResolver.resolveAllNamespaces(xmlElementEnv);
        Name defaultNs = this.names.fromString("");
        if (namespaces.containsKey(defaultNs)) {
            bLangXMLElementLiteral.defaultNsSymbol = namespaces.remove(defaultNs);
        }
        for (Map.Entry<Name, BXMLNSSymbol> nsEntry : namespaces.entrySet()) {
            if (!usedPrefixes.contains(nsEntry.getKey().value)) continue;
            bLangXMLElementLiteral.namespacesInScope.put(nsEntry.getKey(), nsEntry.getValue());
        }
        this.validateTags(bLangXMLElementLiteral, xmlElementEnv);
        bLangXMLElementLiteral.modifiedChildren = this.concatSimilarKindXMLNodes(bLangXMLElementLiteral.children, xmlElementEnv);
        if (this.expType == this.symTable.noType) {
            this.resultType = this.types.checkType(bLangXMLElementLiteral, this.symTable.xmlElementType, this.expType);
            return;
        }
        this.resultType = this.checkXmlSubTypeLiteralCompatibility(bLangXMLElementLiteral.pos, this.symTable.xmlElementType, this.expType);
        if (Symbols.isFlagOn(this.resultType.flags, 32L)) {
            this.markChildrenAsImmutable(bLangXMLElementLiteral);
        }
    }

    private boolean isXmlNamespaceAttribute(BLangXMLAttribute attribute) {
        BLangXMLQName attrName = (BLangXMLQName)attribute.name;
        return attrName.prefix.value.isEmpty() && attrName.localname.value.equals("xmlns") || attrName.prefix.value.equals("xmlns");
    }

    @Override
    public void visit(BLangXMLTextLiteral bLangXMLTextLiteral) {
        this.checkStringTemplateExprs(bLangXMLTextLiteral.textFragments, false);
        this.resultType = this.types.checkType(bLangXMLTextLiteral, this.symTable.xmlTextType, this.expType);
    }

    @Override
    public void visit(BLangXMLCommentLiteral bLangXMLCommentLiteral) {
        this.checkStringTemplateExprs(bLangXMLCommentLiteral.textFragments, false);
        if (this.expType == this.symTable.noType) {
            this.resultType = this.types.checkType(bLangXMLCommentLiteral, this.symTable.xmlCommentType, this.expType);
            return;
        }
        this.resultType = this.checkXmlSubTypeLiteralCompatibility(bLangXMLCommentLiteral.pos, this.symTable.xmlCommentType, this.expType);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral bLangXMLProcInsLiteral) {
        this.checkExpr(bLangXMLProcInsLiteral.target, this.env, this.symTable.stringType);
        this.checkStringTemplateExprs(bLangXMLProcInsLiteral.dataFragments, false);
        if (this.expType == this.symTable.noType) {
            this.resultType = this.types.checkType(bLangXMLProcInsLiteral, this.symTable.xmlPIType, this.expType);
            return;
        }
        this.resultType = this.checkXmlSubTypeLiteralCompatibility(bLangXMLProcInsLiteral.pos, this.symTable.xmlPIType, this.expType);
    }

    @Override
    public void visit(BLangXMLQuotedString bLangXMLQuotedString) {
        this.checkStringTemplateExprs(bLangXMLQuotedString.textFragments, false);
        this.resultType = this.types.checkType(bLangXMLQuotedString, this.symTable.stringType, this.expType);
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        this.dlog.error(xmlAttributeAccessExpr.pos, DiagnosticErrorCode.DEPRECATED_XML_ATTRIBUTE_ACCESS, new Object[0]);
        this.resultType = this.symTable.semanticError;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.checkStringTemplateExprs(stringTemplateLiteral.exprs, false);
        this.resultType = this.types.checkType(stringTemplateLiteral, this.symTable.stringType, this.expType);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        BType insertionsType;
        BType type = this.determineRawTemplateLiteralType(rawTemplateLiteral, this.expType);
        if (type == this.symTable.semanticError) {
            this.resultType = type;
            return;
        }
        BObjectType literalType = (BObjectType)type;
        BType stringsType = ((BField)literalType.fields.get((Object)"strings")).type;
        if (this.evaluateRawTemplateExprs(rawTemplateLiteral.strings, stringsType, DiagnosticErrorCode.INVALID_NUM_STRINGS, rawTemplateLiteral.pos)) {
            type = this.symTable.semanticError;
        }
        if (this.evaluateRawTemplateExprs(rawTemplateLiteral.insertions, insertionsType = ((BField)literalType.fields.get((Object)"insertions")).type, DiagnosticErrorCode.INVALID_NUM_INSERTIONS, rawTemplateLiteral.pos)) {
            type = this.symTable.semanticError;
        }
        this.resultType = type;
    }

    private BType determineRawTemplateLiteralType(BLangRawTemplateLiteral rawTemplateLiteral, BType expType) {
        if (expType == this.symTable.noType || this.containsAnyType(expType)) {
            return this.symTable.rawTemplateType;
        }
        BType compatibleType = this.getCompatibleRawTemplateType(expType, rawTemplateLiteral.pos);
        BType type = this.types.checkType(rawTemplateLiteral, compatibleType, (BType)this.symTable.rawTemplateType, (DiagnosticCode)DiagnosticErrorCode.INVALID_RAW_TEMPLATE_TYPE);
        if (type == this.symTable.semanticError) {
            return type;
        }
        if (Symbols.isFlagOn(type.tsymbol.flags, 0x10000000L)) {
            this.dlog.error(rawTemplateLiteral.pos, DiagnosticErrorCode.INVALID_RAW_TEMPLATE_ASSIGNMENT, type);
            return this.symTable.semanticError;
        }
        BObjectType litObjType = (BObjectType)type;
        BObjectTypeSymbol objTSymbol = (BObjectTypeSymbol)litObjType.tsymbol;
        if (litObjType.fields.size() > 2) {
            this.dlog.error(rawTemplateLiteral.pos, DiagnosticErrorCode.INVALID_NUM_FIELDS, litObjType);
            type = this.symTable.semanticError;
        }
        if (!objTSymbol.attachedFuncs.isEmpty()) {
            this.dlog.error(rawTemplateLiteral.pos, DiagnosticErrorCode.METHODS_NOT_ALLOWED, litObjType);
            type = this.symTable.semanticError;
        }
        return type;
    }

    private boolean evaluateRawTemplateExprs(List<? extends BLangExpression> exprs, BType fieldType, DiagnosticCode code, Location pos) {
        BType listType = this.getResolvedIntersectionType(fieldType);
        boolean errored = false;
        if (listType.tag == 19) {
            BArrayType arrayType = (BArrayType)listType;
            if (arrayType.state == BArrayState.CLOSED && exprs.size() != arrayType.size) {
                this.dlog.error(pos, code, arrayType.size, exprs.size());
                return false;
            }
            for (BLangExpression bLangExpression : exprs) {
                errored = this.checkExpr(bLangExpression, this.env, arrayType.eType) == this.symTable.semanticError || errored;
            }
        } else if (listType.tag == 30) {
            int i;
            int n;
            BTupleType tupleType = (BTupleType)listType;
            int size = exprs.size();
            if (size < (n = tupleType.tupleTypes.size()) || size > n && tupleType.restType == null) {
                this.dlog.error(pos, code, n, size);
                return false;
            }
            List<BType> memberTypes = tupleType.tupleTypes;
            for (i = 0; i < n; ++i) {
                errored = this.checkExpr(exprs.get(i), this.env, memberTypes.get(i)) == this.symTable.semanticError || errored;
            }
            if (size > n) {
                while (i < size) {
                    errored = this.checkExpr(exprs.get(i), this.env, tupleType.restType) == this.symTable.semanticError || errored;
                    ++i;
                }
            }
        } else {
            throw new IllegalStateException("Expected a list type, but found: " + listType);
        }
        return errored;
    }

    private BType getResolvedIntersectionType(BType type) {
        return type.tag != 21 ? type : ((BIntersectionType)type).effectiveType;
    }

    private boolean containsAnyType(BType type) {
        if (type == this.symTable.anyType) {
            return true;
        }
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().contains(this.symTable.anyType);
        }
        return false;
    }

    private BType getCompatibleRawTemplateType(BType expType, Location pos) {
        if (expType.tag != 20) {
            return expType;
        }
        BUnionType unionType = (BUnionType)expType;
        ArrayList<BType> compatibleTypes = new ArrayList<BType>();
        for (BType type : unionType.getMemberTypes()) {
            if (!this.types.isAssignable(type, this.symTable.rawTemplateType)) continue;
            compatibleTypes.add(type);
        }
        if (compatibleTypes.size() == 0) {
            return expType;
        }
        if (compatibleTypes.size() > 1) {
            this.dlog.error(pos, DiagnosticErrorCode.MULTIPLE_COMPATIBLE_RAW_TEMPLATE_TYPES, this.symTable.rawTemplateType, expType);
            return this.symTable.semanticError;
        }
        return (BType)compatibleTypes.get(0);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.checkExpr(intRangeExpression.startExpr, this.env, this.symTable.intType);
        this.checkExpr(intRangeExpression.endExpr, this.env, this.symTable.intType);
        this.resultType = new BArrayType(this.symTable.intType);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangRestArgExpression) {
        this.resultType = this.checkExpr(bLangRestArgExpression.expr, this.env, this.expType);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.resultType = this.checkExpr(bLangNamedArgsExpression.expr, this.env, this.expType);
        bLangNamedArgsExpression.type = bLangNamedArgsExpression.expr.type;
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
        SymbolEnv matchExprEnv = SymbolEnv.createBlockEnv((BLangBlockStmt)TreeBuilder.createBlockNode(), this.env);
        this.checkExpr(bLangMatchExpression.expr, matchExprEnv);
        bLangMatchExpression.patternClauses.forEach(pattern -> {
            if (!pattern.variable.name.value.endsWith(Names.IGNORE.value)) {
                this.symbolEnter.defineNode(pattern.variable, matchExprEnv);
            }
            this.checkExpr(pattern.expr, matchExprEnv, this.expType);
            pattern.variable.type = this.symResolver.resolveTypeNode(pattern.variable.typeNode, matchExprEnv);
        });
        LinkedHashSet<BType> matchExprTypes = this.getMatchExpressionTypes(bLangMatchExpression);
        BType actualType = matchExprTypes.contains(this.symTable.semanticError) ? this.symTable.semanticError : (matchExprTypes.size() == 1 ? matchExprTypes.toArray(new BType[0])[0] : BUnionType.create(null, matchExprTypes));
        this.resultType = this.types.checkType(bLangMatchExpression, actualType, this.expType);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkedExpr) {
        this.visitCheckAndCheckPanicExpr(checkedExpr);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        if (this.prevEnvs.empty()) {
            this.prevEnvs.push(this.env.createClone());
        } else {
            this.prevEnvs.push(this.prevEnvs.peek());
        }
        this.queryEnvs.push(this.prevEnvs.peek().createClone());
        this.selectClauses.push(queryExpr.getSelectClause());
        List<BLangNode> clauses = queryExpr.getQueryClauses();
        BLangExpression collectionNode = (BLangExpression)((BLangFromClause)clauses.get(0)).getCollection();
        clauses.forEach(clause -> clause.accept(this));
        BType actualType = this.resolveQueryType(this.queryEnvs.peek(), this.selectClauses.peek().expression, collectionNode.type, this.expType, queryExpr);
        this.resultType = actualType == this.symTable.semanticError ? actualType : this.types.checkType(queryExpr.pos, actualType, this.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        this.selectClauses.pop();
        this.queryEnvs.pop();
        this.prevEnvs.pop();
    }

    private BType resolveQueryType(SymbolEnv env, BLangExpression selectExp, BType collectionType, BType targetType, BLangQueryExpr queryExpr) {
        BType selectType;
        List resultTypes = this.types.getAllTypes(targetType).stream().filter(t -> !this.types.isAssignable((BType)t, this.symTable.errorType)).filter(t -> !this.types.isAssignable((BType)t, this.symTable.nilType)).collect(Collectors.toList());
        BType actualType = this.symTable.semanticError;
        ArrayList<BType> selectTypes = new ArrayList<BType>();
        ArrayList<BType> resolvedTypes = new ArrayList<BType>();
        for (BType type : resultTypes) {
            BType resolvedType;
            switch (type.tag) {
                case 19: {
                    selectType = this.checkExpr(selectExp, env, ((BArrayType)type).eType);
                    resolvedType = new BArrayType(selectType);
                    break;
                }
                case 9: {
                    selectType = this.checkExpr(selectExp, env, this.types.getSafeType(((BTableType)type).constraint, true, true));
                    resolvedType = this.symTable.tableType;
                    break;
                }
                case 14: {
                    selectType = this.checkExpr(selectExp, env, this.types.getSafeType(((BStreamType)type).constraint, true, true));
                    resolvedType = this.symTable.streamType;
                    break;
                }
                case 5: 
                case 8: {
                    resolvedType = selectType = this.checkExpr(selectExp, env, type);
                    break;
                }
                default: {
                    selectType = this.checkExpr(selectExp, env, type);
                    resolvedType = this.getNonContextualQueryType(selectType, collectionType);
                }
            }
            if (selectType == this.symTable.semanticError) continue;
            if (resolvedType.tag == 14) {
                queryExpr.isStream = true;
            }
            if (resolvedType.tag == 9) {
                queryExpr.isTable = true;
            }
            selectTypes.add(selectType);
            resolvedTypes.add(resolvedType);
        }
        if (selectTypes.size() == 1) {
            BType errorType = this.getErrorType(collectionType);
            selectType = (BType)selectTypes.get(0);
            if (queryExpr.isStream) {
                return new BStreamType(14, selectType, errorType, null);
            }
            actualType = queryExpr.isTable ? this.getQueryTableType(queryExpr, selectType) : (BType)resolvedTypes.get(0);
            if (errorType != null) {
                return BUnionType.create(null, actualType, errorType);
            }
            return actualType;
        }
        if (selectTypes.size() > 1) {
            this.dlog.error(selectExp.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, selectTypes);
            return actualType;
        }
        return actualType;
    }

    private BType getQueryTableType(BLangQueryExpr queryExpr, BType constraintType) {
        BTableType tableType = new BTableType(9, constraintType, null);
        if (!queryExpr.fieldNameIdentifierList.isEmpty()) {
            tableType.fieldNameList = queryExpr.fieldNameIdentifierList.stream().map(identifier -> ((BLangIdentifier)identifier).value).collect(Collectors.toList());
            return BUnionType.create(null, tableType, this.symTable.errorType);
        }
        return tableType;
    }

    private BType getErrorType(BType collectionType) {
        List<BType> errorTypes;
        if (collectionType.tag == 27) {
            return null;
        }
        BType returnType = null;
        BType errorType = null;
        switch (collectionType.tag) {
            case 14: {
                errorType = ((BStreamType)collectionType).error;
                break;
            }
            case 33: {
                returnType = this.types.getVarTypeFromIterableObject((BObjectType)collectionType);
                break;
            }
            default: {
                BInvokableSymbol itrSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionType, this.names.fromString("iterator"));
                returnType = this.types.getResultTypeOfNextInvocation((BObjectType)itrSymbol.retType);
            }
        }
        if (returnType != null && !(errorTypes = this.types.getAllTypes(returnType).stream().filter(t -> this.types.isAssignable((BType)t, this.symTable.errorType)).collect(Collectors.toList())).isEmpty()) {
            errorType = errorTypes.size() == 1 ? (BType)errorTypes.get(0) : BUnionType.create(null, errorTypes.toArray(new BType[0]));
        }
        return errorType;
    }

    private BType getNonContextualQueryType(BType staticType, BType basicType) {
        BType resultType;
        switch (basicType.tag) {
            case 9: {
                resultType = this.symTable.tableType;
                break;
            }
            case 14: {
                resultType = this.symTable.streamType;
                break;
            }
            case 8: {
                resultType = new BXMLType(staticType, null);
                break;
            }
            case 5: {
                resultType = this.symTable.stringType;
                break;
            }
            default: {
                resultType = new BArrayType(staticType);
            }
        }
        return resultType;
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        if (this.prevEnvs.empty()) {
            this.prevEnvs.push(this.env.createClone());
        } else {
            this.prevEnvs.push(this.prevEnvs.peek());
        }
        this.queryEnvs.push(this.prevEnvs.peek().createClone());
        this.selectClauses.push(null);
        BLangDoClause doClause = queryAction.getDoClause();
        List<BLangNode> clauses = queryAction.getQueryClauses();
        clauses.forEach(clause -> clause.accept(this));
        this.semanticAnalyzer.analyzeStmt(doClause.body, SymbolEnv.createBlockEnv(doClause.body, this.queryEnvs.peek()));
        BUnionType actualType = BUnionType.create(null, this.symTable.errorType, this.symTable.nilType);
        this.resultType = this.types.checkType(doClause.pos, (BType)actualType, this.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        this.selectClauses.pop();
        this.queryEnvs.pop();
        this.prevEnvs.pop();
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.queryEnvs.push(SymbolEnv.createTypeNarrowedEnv(fromClause, this.queryEnvs.pop()));
        this.checkExpr(fromClause.collection, this.queryEnvs.peek());
        this.types.setInputClauseTypedBindingPatternType(fromClause);
        this.handleInputClauseVariables(fromClause, this.queryEnvs.peek());
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.queryEnvs.push(SymbolEnv.createTypeNarrowedEnv(joinClause, this.queryEnvs.pop()));
        this.checkExpr(joinClause.collection, this.queryEnvs.peek());
        this.types.setInputClauseTypedBindingPatternType(joinClause);
        this.handleInputClauseVariables(joinClause, this.queryEnvs.peek());
        if (joinClause.onClause != null) {
            ((BLangOnClause)joinClause.onClause).accept(this);
        }
    }

    @Override
    public void visit(BLangLetClause letClause) {
        this.queryEnvs.push(SymbolEnv.createTypeNarrowedEnv(letClause, this.queryEnvs.pop()));
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.semanticAnalyzer.analyzeDef((BLangNode)((Object)letVariable.definitionNode), this.queryEnvs.peek());
        }
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.handleFilterClauses(whereClause.expression);
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
    }

    @Override
    public void visit(BLangDoClause doClause) {
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        BType exprType = this.checkExpr(onConflictClause.expression, this.queryEnvs.peek(), this.symTable.errorType);
        if (!this.types.isAssignable(exprType, this.symTable.errorType)) {
            this.dlog.error(onConflictClause.expression.pos, DiagnosticErrorCode.ERROR_TYPE_EXPECTED, this.symTable.errorType, exprType);
        }
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        BType exprType = this.checkExpr(limitClause.expression, this.queryEnvs.peek());
        if (!this.types.isAssignable(exprType, this.symTable.intType)) {
            this.dlog.error(limitClause.expression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, exprType);
        }
    }

    @Override
    public void visit(BLangOnClause onClause) {
        SymbolEnv rhsExprEnv;
        BType rhsType;
        BLangNode joinNode = this.getLastInputNodeFromEnv(this.queryEnvs.peek());
        SymbolEnv lhsExprEnv = this.getEnvBeforeInputNode(this.queryEnvs.peek(), joinNode);
        BType lhsType = this.checkExpr(onClause.lhsExpr, lhsExprEnv);
        if (!this.types.isAssignable(lhsType, rhsType = this.checkExpr(onClause.rhsExpr, rhsExprEnv = this.getEnvAfterJoinNode(this.queryEnvs.peek(), joinNode)))) {
            this.dlog.error(onClause.rhsExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, lhsType, rhsType);
        }
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        for (OrderKeyNode orderKeyNode : orderByClause.getOrderKeyList()) {
            BType exprType = this.checkExpr((BLangExpression)orderKeyNode.getOrderKey(), this.queryEnvs.peek());
            if (this.types.isOrderedType(exprType)) continue;
            this.dlog.error(((BLangOrderKey)orderKeyNode).expression.pos, DiagnosticErrorCode.ORDER_BY_NOT_SUPPORTED, new Object[0]);
        }
    }

    @Override
    public void visit(BLangDo doNode) {
        if (doNode.onFailClause != null) {
            doNode.onFailClause.accept(this);
        }
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        onFailClause.body.stmts.forEach(stmt -> stmt.accept(this));
    }

    private void handleFilterClauses(BLangExpression filterExpression) {
        this.checkExpr(filterExpression, this.queryEnvs.peek(), this.symTable.booleanType);
        BType actualType = filterExpression.type;
        if (30 == actualType.tag) {
            this.dlog.error(filterExpression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.booleanType, actualType);
        }
        this.queryEnvs.push(this.typeNarrower.evaluateTruth(filterExpression, this.selectClauses.peek(), this.queryEnvs.pop()));
    }

    private void handleInputClauseVariables(BLangInputClause bLangInputClause, SymbolEnv blockEnv) {
        if (bLangInputClause.variableDefinitionNode == null) {
            return;
        }
        BLangVariable variableNode = (BLangVariable)bLangInputClause.variableDefinitionNode.getVariable();
        if (bLangInputClause.isDeclaredWithVar) {
            this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, bLangInputClause.varType, blockEnv);
            return;
        }
        BType typeNodeType = this.symResolver.resolveTypeNode(variableNode.typeNode, blockEnv);
        if (this.types.isAssignable(bLangInputClause.varType, typeNodeType)) {
            this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, bLangInputClause.varType, blockEnv);
            return;
        }
        if (typeNodeType != this.symTable.semanticError) {
            this.dlog.error(variableNode.typeNode.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, bLangInputClause.varType, typeNodeType);
        }
        this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, typeNodeType, blockEnv);
    }

    private void visitCheckAndCheckPanicExpr(BLangCheckedExpr checkedExpr) {
        String operatorType = checkedExpr.getKind() == NodeKind.CHECK_EXPR ? "check" : "checkpanic";
        BLangExpression exprWithCheckingKeyword = checkedExpr.expr;
        boolean firstVisit = exprWithCheckingKeyword.type == null;
        BType typeOfExprWithCheckingKeyword = this.expType == this.symTable.noType ? this.symTable.noType : BUnionType.create(null, this.expType, this.symTable.errorType);
        if (exprWithCheckingKeyword.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && operatorType.equals("check") && this.types.isUnionOfSimpleBasicTypes(this.expType)) {
            ArrayList<BLangExpression> argExprs = new ArrayList<BLangExpression>();
            BTypedescType typedescType = new BTypedescType(this.expType, null);
            BLangTypedescExpr typedescExpr = new BLangTypedescExpr();
            typedescExpr.resolvedType = this.expType;
            typedescExpr.type = typedescType;
            argExprs.add(exprWithCheckingKeyword);
            argExprs.add(typedescExpr);
            BLangInvocation invocation = ASTBuilderUtil.createLangLibInvocationNode(FUNCTION_NAME_ENSURE_TYPE, argExprs, exprWithCheckingKeyword, checkedExpr.pos);
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(typeOfExprWithCheckingKeyword, this.names.fromString(invocation.name.value));
            BInvokableType bInvokableType = (BInvokableType)invokableSymbol.type;
            bInvokableType.retType = typeOfExprWithCheckingKeyword;
            invocation.symbol = invokableSymbol;
            invocation.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
            checkedExpr.expr = invocation;
        }
        BType exprType = this.checkExpr(checkedExpr.expr, this.env, typeOfExprWithCheckingKeyword);
        if (checkedExpr.expr.getKind() == NodeKind.WORKER_RECEIVE) {
            if (firstVisit) {
                this.isTypeChecked = false;
                this.resultType = this.expType;
                return;
            }
            this.expType = checkedExpr.type;
            exprType = checkedExpr.expr.type;
        }
        if (exprType.tag != 20) {
            if (this.types.isAssignable(exprType, this.symTable.errorType)) {
                this.dlog.error(checkedExpr.expr.pos, DiagnosticErrorCode.CHECKED_EXPR_INVALID_USAGE_ALL_ERROR_TYPES_IN_RHS, operatorType);
            } else if (exprType != this.symTable.semanticError) {
                this.dlog.error(checkedExpr.expr.pos, DiagnosticErrorCode.CHECKED_EXPR_INVALID_USAGE_NO_ERROR_TYPE_IN_RHS, operatorType);
            }
            checkedExpr.type = this.symTable.semanticError;
            return;
        }
        BUnionType unionType = (BUnionType)exprType;
        Map<Boolean, List<BType>> resultTypeMap = unionType.getMemberTypes().stream().collect(Collectors.groupingBy(memberType -> this.types.isAssignable((BType)memberType, this.symTable.errorType)));
        checkedExpr.equivalentErrorTypeList = resultTypeMap.get(true);
        if (checkedExpr.equivalentErrorTypeList == null || checkedExpr.equivalentErrorTypeList.size() == 0) {
            this.dlog.error(checkedExpr.expr.pos, DiagnosticErrorCode.CHECKED_EXPR_INVALID_USAGE_NO_ERROR_TYPE_IN_RHS, operatorType);
            checkedExpr.type = this.symTable.semanticError;
            return;
        }
        List<BType> nonErrorTypeList = resultTypeMap.get(false);
        if (nonErrorTypeList == null || nonErrorTypeList.size() == 0) {
            this.dlog.error(checkedExpr.expr.pos, DiagnosticErrorCode.CHECKED_EXPR_INVALID_USAGE_ALL_ERROR_TYPES_IN_RHS, operatorType);
            checkedExpr.type = this.symTable.semanticError;
            return;
        }
        BType actualType = nonErrorTypeList.size() == 1 ? nonErrorTypeList.get(0) : BUnionType.create(null, new LinkedHashSet<BType>(nonErrorTypeList));
        this.resultType = this.types.checkType(checkedExpr, actualType, this.expType);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.resultType = serviceConstructorExpr.serviceNode.symbol.type;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.typeNode.type = this.symResolver.resolveTypeNode(typeTestExpr.typeNode, this.env);
        this.checkExpr(typeTestExpr.expr, this.env);
        this.resultType = this.types.checkType(typeTestExpr, this.symTable.booleanType, this.expType);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.checkExpr(annotAccessExpr.expr, this.env, this.symTable.typeDesc);
        BType actualType = this.symTable.semanticError;
        BSymbol symbol = this.symResolver.resolveAnnotation(annotAccessExpr.pos, this.env, this.names.fromString(annotAccessExpr.pkgAlias.getValue()), this.names.fromString(annotAccessExpr.annotationName.getValue()));
        if (symbol == this.symTable.notFoundSymbol) {
            this.dlog.error(annotAccessExpr.pos, DiagnosticErrorCode.UNDEFINED_ANNOTATION, annotAccessExpr.annotationName.getValue());
        } else {
            annotAccessExpr.annotationSymbol = (BAnnotationSymbol)symbol;
            BType annotType = ((BAnnotationSymbol)symbol).attachedType == null ? this.symTable.trueType : ((BAnnotationSymbol)symbol).attachedType.type;
            actualType = BUnionType.create(null, annotType, this.symTable.nilType);
        }
        this.resultType = this.types.checkType(annotAccessExpr, actualType, this.expType);
    }

    private boolean isValidVariableReference(BLangExpression varRef) {
        switch (varRef.getKind()) {
            case SIMPLE_VARIABLE_REF: 
            case RECORD_VARIABLE_REF: 
            case TUPLE_VARIABLE_REF: 
            case ERROR_VARIABLE_REF: 
            case FIELD_BASED_ACCESS_EXPR: 
            case INDEX_BASED_ACCESS_EXPR: 
            case XML_ATTRIBUTE_ACCESS_EXPR: {
                return true;
            }
        }
        this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_RECORD_BINDING_PATTERN, varRef.type);
        return false;
    }

    private BType getEffectiveReadOnlyType(Location pos, BType origTargetType) {
        if (origTargetType == this.symTable.readonlyType) {
            if (this.types.isInherentlyImmutableType(this.expType) || !this.types.isSelectivelyImmutableType(this.expType)) {
                return origTargetType;
            }
            return ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, (SelectivelyImmutableReferenceType)((Object)this.expType), this.env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>());
        }
        if (origTargetType.tag != 20) {
            return origTargetType;
        }
        boolean hasReadOnlyType = false;
        LinkedHashSet<BType> nonReadOnlyTypes = new LinkedHashSet<BType>();
        for (BType memberType : ((BUnionType)origTargetType).getMemberTypes()) {
            if (memberType == this.symTable.readonlyType) {
                hasReadOnlyType = true;
                continue;
            }
            nonReadOnlyTypes.add(memberType);
        }
        if (!hasReadOnlyType) {
            return origTargetType;
        }
        if (this.types.isInherentlyImmutableType(this.expType) || !this.types.isSelectivelyImmutableType(this.expType)) {
            return origTargetType;
        }
        BUnionType nonReadOnlyUnion = BUnionType.create(null, nonReadOnlyTypes);
        nonReadOnlyUnion.add(ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, (SelectivelyImmutableReferenceType)((Object)this.expType), this.env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>()));
        return nonReadOnlyUnion;
    }

    private BType populateArrowExprReturn(BLangArrowFunction bLangArrowFunction, BType expectedRetType) {
        SymbolEnv arrowFunctionEnv = SymbolEnv.createArrowFunctionSymbolEnv(bLangArrowFunction, this.env);
        bLangArrowFunction.params.forEach(param -> this.symbolEnter.defineNode((BLangNode)param, arrowFunctionEnv));
        return this.checkExpr(bLangArrowFunction.body.expr, arrowFunctionEnv, expectedRetType);
    }

    private void populateArrowExprParamTypes(BLangArrowFunction bLangArrowFunction, List<BType> paramTypes) {
        if (paramTypes.size() != bLangArrowFunction.params.size()) {
            this.dlog.error(bLangArrowFunction.pos, DiagnosticErrorCode.ARROW_EXPRESSION_MISMATCHED_PARAMETER_LENGTH, paramTypes.size(), bLangArrowFunction.params.size());
            this.resultType = this.symTable.semanticError;
            bLangArrowFunction.params.forEach(param -> {
                param.type = this.symTable.semanticError;
            });
            return;
        }
        for (int i = 0; i < bLangArrowFunction.params.size(); ++i) {
            BLangSimpleVariable paramIdentifier = bLangArrowFunction.params.get(i);
            BType bType = paramTypes.get(i);
            BLangValueType valueTypeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
            valueTypeNode.setTypeKind(bType.getKind());
            valueTypeNode.pos = this.symTable.builtinPos;
            paramIdentifier.setTypeNode(valueTypeNode);
            paramIdentifier.type = bType;
        }
    }

    private void checkSelfReferences(Location pos, SymbolEnv env, BVarSymbol varSymbol) {
        if (env.enclVarSym == varSymbol) {
            this.dlog.error(pos, DiagnosticErrorCode.SELF_REFERENCE_VAR, varSymbol.name);
        }
    }

    public List<BType> getListWithErrorTypes(int count) {
        ArrayList<BType> list = new ArrayList<BType>(count);
        for (int i = 0; i < count; ++i) {
            list.add(this.symTable.semanticError);
        }
        return list;
    }

    private void checkFunctionInvocationExpr(BLangInvocation iExpr) {
        boolean langLibPackageID;
        Name funcName = this.names.fromIdNode(iExpr.name);
        Name pkgAlias = this.names.fromIdNode(iExpr.pkgAlias);
        BSymbol funcSymbol = this.symTable.notFoundSymbol;
        BSymbol pkgSymbol = this.symResolver.resolvePrefixSymbol(this.env, pkgAlias, this.getCurrentCompUnit(iExpr));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias);
        } else {
            if (funcSymbol == this.symTable.notFoundSymbol) {
                BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(iExpr.pos, this.env, pkgAlias, funcName);
                if ((symbol.tag & 0x34) == 52) {
                    funcSymbol = symbol;
                }
                if (this.symTable.rootPkgSymbol.pkgID.equals(symbol.pkgID) && (symbol.tag & 0x14) == 20) {
                    funcSymbol = symbol;
                }
            }
            if (funcSymbol == this.symTable.notFoundSymbol || (funcSymbol.tag & 0xC) == 12) {
                BSymbol ctor = this.symResolver.lookupConstructorSpaceSymbolInPackage(iExpr.pos, this.env, pkgAlias, funcName);
                BSymbol bSymbol = funcSymbol = ctor != this.symTable.notFoundSymbol ? ctor : funcSymbol;
            }
        }
        if ((funcSymbol.tag & 0x9001C) == 589852 || (funcSymbol.tag & 0x8000100) == 0x8000100 && funcSymbol.type.tag == 28) {
            iExpr.symbol = funcSymbol;
            iExpr.type = funcSymbol.type;
            this.checkErrorConstructorInvocation(iExpr);
            return;
        }
        if (funcSymbol == this.symTable.notFoundSymbol || this.isNotFunction(funcSymbol)) {
            if (!this.missingNodesHelper.isMissingNode(funcName)) {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION, funcName);
            }
            iExpr.argExprs.forEach(arg -> this.checkExpr((BLangExpression)arg, this.env));
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (this.isFunctionPointer(funcSymbol)) {
            iExpr.functionPointerInvocation = true;
            this.markAndRegisterClosureVariable(funcSymbol, iExpr.pos);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 32768L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_SYNTAX, iExpr.name.value);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 131072L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_RESOURCE_FUNCTION_INVOCATION, new Object[0]);
        }
        if (langLibPackageID = PackageID.isLangLibPackageID(pkgSymbol.pkgID)) {
            this.env = SymbolEnv.createInvocationEnv(iExpr, this.env);
        }
        iExpr.symbol = funcSymbol;
        this.checkInvocationParamAndReturnType(iExpr);
        if (langLibPackageID && !iExpr.argExprs.isEmpty()) {
            this.checkInvalidImmutableValueUpdate(iExpr, iExpr.argExprs.get((int)0).type, funcSymbol);
        }
    }

    private void markAndRegisterClosureVariable(BSymbol symbol, Location pos) {
        SymbolEnv encInvokableEnv;
        BSymbol resolvedSymbol;
        BLangInvokableNode encInvokable = this.env.enclInvokable;
        if (symbol.owner instanceof BPackageSymbol && this.env.node.getKind() != NodeKind.ARROW_EXPR) {
            return;
        }
        if (encInvokable != null && encInvokable.flagSet.contains((Object)Flag.LAMBDA) && !this.isFunctionArgument(symbol, encInvokable.requiredParams) && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(this.env, encInvokable), symbol.name, 52)) != this.symTable.notFoundSymbol && !encInvokable.flagSet.contains((Object)Flag.ATTACHED)) {
            resolvedSymbol.closure = true;
            ((BLangFunction)encInvokable).closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
        }
        if (this.env.node.getKind() == NodeKind.ARROW_EXPR && !this.isFunctionArgument(symbol, ((BLangArrowFunction)this.env.node).params) && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(this.env, encInvokable), symbol.name, 52)) != this.symTable.notFoundSymbol) {
            resolvedSymbol.closure = true;
            ((BLangArrowFunction)this.env.node).closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
        }
        if (this.env.enclType != null && this.env.enclType.getKind() == NodeKind.RECORD_TYPE && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(this.env, (BLangRecordTypeNode)this.env.enclType), symbol.name, 52)) != this.symTable.notFoundSymbol && !encInvokable.flagSet.contains((Object)Flag.ATTACHED)) {
            resolvedSymbol.closure = true;
            ((BLangFunction)encInvokable).closureVarSymbols.add(new ClosureVarSymbol(resolvedSymbol, pos));
        }
        BLangNode node = this.env.node;
        SymbolEnv cEnv = this.env;
        while (node != null && node.getKind() != NodeKind.FUNCTION) {
            if (node.getKind() == NodeKind.TRANSACTION || node.getKind() == NodeKind.RETRY || node.getKind() == NodeKind.ON_FAIL) {
                SymbolEnv encInvokableEnv2 = this.findEnclosingInvokableEnv(this.env, encInvokable);
                BSymbol resolvedSymbol2 = this.symResolver.lookupClosureVarSymbol(encInvokableEnv2, symbol.name, 52);
                if (resolvedSymbol2 == this.symTable.notFoundSymbol) break;
                resolvedSymbol2.closure = true;
                break;
            }
            SymbolEnv enclEnv = cEnv.enclEnv;
            if (enclEnv == null) break;
            cEnv = enclEnv;
            node = cEnv.node;
        }
    }

    private boolean isNotFunction(BSymbol funcSymbol) {
        if ((funcSymbol.tag & 0x334) == 820 || (funcSymbol.tag & 0x8000100) == 0x8000100) {
            return false;
        }
        return !this.isFunctionPointer(funcSymbol);
    }

    private boolean isFunctionPointer(BSymbol funcSymbol) {
        if ((funcSymbol.tag & 0x334) == 820) {
            return false;
        }
        return (funcSymbol.tag & 0x334) == 52 && funcSymbol.kind == SymbolKind.FUNCTION && (funcSymbol.flags & 2L) != 2L;
    }

    private void checkErrorConstructorInvocation(BLangInvocation iExpr) {
        BLangExpression secondArg;
        BErrorType errorType = (BErrorType)iExpr.symbol.type;
        if (this.expType == this.symTable.noType) {
            this.expType = errorType;
        }
        if (!this.types.isAssignable(errorType, this.expType)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.expType, errorType);
            this.resultType = this.symTable.semanticError;
        }
        if (iExpr.argExprs.isEmpty() && !iExpr.requiredArgs.isEmpty()) {
            this.resultType = iExpr.type;
            return;
        }
        if (iExpr.argExprs.isEmpty()) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.MISSING_REQUIRED_ARG_ERROR_MESSAGE, new Object[0]);
            return;
        }
        BLangExpression errorMessageArg = iExpr.argExprs.get(0);
        if (errorMessageArg.getKind() == NodeKind.NAMED_ARGS_EXPR) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.MISSING_REQUIRED_ARG_ERROR_MESSAGE, new Object[0]);
            return;
        }
        this.checkExpr(errorMessageArg, this.env, this.symTable.stringType);
        iExpr.requiredArgs.add(0, errorMessageArg);
        iExpr.argExprs.remove(0);
        if (!iExpr.argExprs.isEmpty() && (secondArg = iExpr.argExprs.get(0)).getKind() != NodeKind.NAMED_ARGS_EXPR) {
            this.checkExpr(secondArg, this.env, this.symTable.errorType);
            iExpr.requiredArgs.add(1, secondArg);
            iExpr.argExprs.remove(0);
        }
        if (errorType.detailType.tag == 15) {
            BMapType detailMapType = (BMapType)errorType.detailType;
            List<BLangNamedArgsExpression> namedArgs = this.getProvidedErrorDetails(iExpr);
            if (namedArgs == null) {
                this.resultType = this.symTable.semanticError;
                return;
            }
            for (BLangNamedArgsExpression namedArg : namedArgs) {
                if (this.types.isAssignable(namedArg.expr.type, detailMapType.constraint)) continue;
                this.dlog.error(namedArg.pos, DiagnosticErrorCode.INVALID_ERROR_DETAIL_ARG_TYPE, namedArg.name, detailMapType.constraint, namedArg.expr.type);
                this.resultType = this.symTable.semanticError;
            }
            if (this.resultType == this.symTable.semanticError) {
                return;
            }
        } else if (errorType.detailType.tag == 12) {
            BRecordType targetErrorDetailRec = (BRecordType)errorType.detailType;
            BRecordType recordType = this.createErrorDetailRecordType(iExpr, targetErrorDetailRec);
            if (this.resultType == this.symTable.semanticError || targetErrorDetailRec == null) {
                return;
            }
            if (!this.types.isAssignable(recordType, targetErrorDetailRec)) {
                this.reportErrorDetailMissmatchError(iExpr, targetErrorDetailRec, recordType);
                this.resultType = this.symTable.semanticError;
                return;
            }
        } else {
            this.resultType = this.symTable.semanticError;
        }
        this.setErrorDetailArgsToNamedArgsList(iExpr);
        this.resultType = errorType;
        if (iExpr.symbol == this.symTable.errorType.tsymbol) {
            iExpr.symbol = ((BErrorTypeSymbol)errorType.tsymbol).ctorSymbol;
        }
    }

    private void reportErrorDetailMissmatchError(BLangInvocation iExpr, BRecordType targetErrorDetailRec, BRecordType recordType) {
        boolean detailedErrorReported = false;
        HashSet<String> checkedFieldNames = new HashSet<String>();
        for (Map.Entry fieldEntry : targetErrorDetailRec.fields.entrySet()) {
            checkedFieldNames.add((String)fieldEntry.getKey());
            BField argField = (BField)recordType.fields.get(fieldEntry.getKey());
            if (argField == null && !Symbols.isOptional(((BField)fieldEntry.getValue()).symbol)) {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.MISSING_ERROR_DETAIL_ARG, fieldEntry.getKey());
                detailedErrorReported = true;
                continue;
            }
            if (this.types.isAssignable(argField.type, ((BField)fieldEntry.getValue()).type)) continue;
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_ERROR_DETAIL_ARG_TYPE, fieldEntry.getKey(), ((BField)fieldEntry.getValue()).type, argField.type);
        }
        if (recordType.fields.size() > checkedFieldNames.size()) {
            for (Map.Entry fieldEntry : recordType.fields.entrySet()) {
                if (checkedFieldNames.contains(fieldEntry.getKey())) continue;
                BField field = (BField)fieldEntry.getValue();
                if (targetErrorDetailRec.sealed) {
                    this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNKNOWN_DETAIL_ARG_TO_SEALED_ERROR_DETAIL_REC, fieldEntry.getKey(), targetErrorDetailRec);
                    detailedErrorReported = true;
                    continue;
                }
                if (this.types.isAssignable(field.type, targetErrorDetailRec.restFieldType)) continue;
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_ERROR_DETAIL_REST_ARG_TYPE, fieldEntry.getKey(), targetErrorDetailRec);
                detailedErrorReported = true;
            }
        }
        if (!detailedErrorReported) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_ERROR_CONSTRUCTOR_DETAIL, iExpr);
        }
    }

    private void setErrorDetailArgsToNamedArgsList(BLangInvocation iExpr) {
        ArrayList<BLangExpression> namedArgPositions = new ArrayList<BLangExpression>(iExpr.argExprs.size());
        for (int i = 0; i < iExpr.argExprs.size(); ++i) {
            BLangExpression argExpr = iExpr.argExprs.get(i);
            if (argExpr.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                iExpr.requiredArgs.add(argExpr);
                namedArgPositions.add(argExpr);
                continue;
            }
            this.dlog.error(argExpr.pos, DiagnosticErrorCode.ERROR_DETAIL_ARG_IS_NOT_NAMED_ARG, new Object[0]);
            this.resultType = this.symTable.semanticError;
        }
        for (BLangExpression expr : namedArgPositions) {
            iExpr.argExprs.remove(expr);
        }
    }

    private BRecordType createErrorDetailRecordType(BLangInvocation iExpr, BRecordType targetErrorDetailsType) {
        List<BLangNamedArgsExpression> namedArgs = this.getProvidedErrorDetails(iExpr);
        if (namedArgs == null) {
            return null;
        }
        BRecordTypeSymbol recordTypeSymbol = new BRecordTypeSymbol(327772, targetErrorDetailsType.tsymbol.flags, Names.EMPTY, targetErrorDetailsType.tsymbol.pkgID, this.symTable.recordType, null, targetErrorDetailsType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        BRecordType recordType = new BRecordType(recordTypeSymbol);
        recordType.sealed = targetErrorDetailsType.sealed;
        recordType.restFieldType = targetErrorDetailsType.restFieldType;
        HashSet<Name> availableErrorDetailFields = new HashSet<Name>();
        for (BLangNamedArgsExpression arg : namedArgs) {
            Name fieldName = this.names.fromIdNode(arg.name);
            BField field = new BField(fieldName, arg.pos, new BVarSymbol(0L, fieldName, null, arg.type, null, arg.pos, SymbolOrigin.VIRTUAL));
            recordType.fields.put(field.name.value, field);
            availableErrorDetailFields.add(fieldName);
        }
        for (BField field : targetErrorDetailsType.fields.values()) {
            boolean notRequired = (field.symbol.flags & 0x100L) != 256L;
            if (!notRequired || availableErrorDetailFields.contains(field.name)) continue;
            BField defaultableField = new BField(field.name, iExpr.pos, new BVarSymbol(field.symbol.flags, field.name, null, field.type, null, iExpr.pos, SymbolOrigin.VIRTUAL));
            recordType.fields.put(defaultableField.name.value, defaultableField);
        }
        return recordType;
    }

    private List<BLangNamedArgsExpression> getProvidedErrorDetails(BLangInvocation iExpr) {
        ArrayList<BLangNamedArgsExpression> namedArgs = new ArrayList<BLangNamedArgsExpression>();
        for (int i = 0; i < iExpr.argExprs.size(); ++i) {
            BLangExpression argExpr = iExpr.argExprs.get(i);
            this.checkExpr(argExpr, this.env);
            if (argExpr.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                this.dlog.error(argExpr.pos, DiagnosticErrorCode.ERROR_DETAIL_ARG_IS_NOT_NAMED_ARG, new Object[0]);
                this.resultType = this.symTable.semanticError;
                return null;
            }
            namedArgs.add((BLangNamedArgsExpression)argExpr);
        }
        return namedArgs;
    }

    private void checkObjectFunctionInvocationExpr(BLangInvocation iExpr, BObjectType objectType) {
        if (!(objectType.getKind() != TypeKind.SERVICE || iExpr.expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && Names.SELF.equals(((BLangSimpleVarRef)iExpr.expr).symbol.name))) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.SERVICE_FUNCTION_INVALID_INVOCATION, new Object[0]);
            return;
        }
        Name funcName = this.names.fromString(Symbols.getAttachedFuncSymbolName(objectType.tsymbol.name.value, iExpr.name.value));
        BSymbol funcSymbol = this.symResolver.resolveObjectMethod(iExpr.pos, this.env, funcName, (BObjectTypeSymbol)objectType.tsymbol);
        if (funcSymbol == this.symTable.notFoundSymbol || funcSymbol.type.tag != 16) {
            if (!this.checkLangLibMethodInvocationExpr(iExpr, objectType)) {
                this.dlog.error(iExpr.name.pos, DiagnosticErrorCode.UNDEFINED_METHOD_IN_OBJECT, iExpr.name.value, objectType);
                this.resultType = this.symTable.semanticError;
                return;
            }
        } else {
            iExpr.symbol = funcSymbol;
        }
        if (iExpr.name.value.equals(Names.USER_DEFINED_INIT_SUFFIX.value) && (iExpr.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF || !Names.SELF.equals(((BLangSimpleVarRef)iExpr.expr).symbol.name))) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_INIT_INVOCATION, new Object[0]);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 32768L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_SYNTAX, iExpr.name.value);
        }
        if (Symbols.isFlagOn(funcSymbol.flags, 131072L)) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_RESOURCE_FUNCTION_INVOCATION, new Object[0]);
        }
        this.checkInvocationParamAndReturnType(iExpr);
    }

    private void checkActionInvocation(BLangInvocation.BLangActionInvocation aInv, BObjectType expType) {
        BLangVariableReference varRef = (BLangVariableReference)aInv.expr;
        if ((varRef.symbol.tag & 0x8034) != 32820 && !aInv.async) {
            this.dlog.error(aInv.pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION, varRef.type);
            this.resultType = this.symTable.semanticError;
            aInv.symbol = this.symTable.notFoundSymbol;
            return;
        }
        BVarSymbol epSymbol = (BVarSymbol)varRef.symbol;
        Name remoteMethodQName = this.names.fromString(Symbols.getAttachedFuncSymbolName(expType.tsymbol.name.value, aInv.name.value));
        Name actionName = this.names.fromIdNode(aInv.name);
        BSymbol remoteFuncSymbol = this.symResolver.lookupMemberSymbol(aInv.pos, epSymbol.type.tsymbol.scope, this.env, remoteMethodQName, 820);
        if (remoteFuncSymbol == this.symTable.notFoundSymbol && !this.checkLangLibMethodInvocationExpr(aInv, expType)) {
            this.dlog.error(aInv.name.pos, DiagnosticErrorCode.UNDEFINED_METHOD_IN_OBJECT, aInv.name.value, expType);
            this.resultType = this.symTable.semanticError;
            return;
        }
        if (!Symbols.isFlagOn(remoteFuncSymbol.flags, 32768L) && aInv.remoteMethodCall) {
            this.dlog.error(aInv.pos, DiagnosticErrorCode.INVALID_METHOD_INVOCATION_SYNTAX, actionName);
            this.resultType = this.symTable.semanticError;
            return;
        }
        aInv.symbol = remoteFuncSymbol;
        this.checkInvocationParamAndReturnType(aInv);
    }

    private boolean checkLangLibMethodInvocationExpr(BLangInvocation iExpr, BType bType) {
        return this.getLangLibMethod(iExpr, bType) != this.symTable.notFoundSymbol;
    }

    private BSymbol getLangLibMethod(BLangInvocation iExpr, BType bType) {
        Name funcName = this.names.fromString(iExpr.name.value);
        BSymbol funcSymbol = this.symResolver.lookupLangLibMethod(bType, funcName);
        if (funcSymbol == this.symTable.notFoundSymbol) {
            return this.symTable.notFoundSymbol;
        }
        iExpr.symbol = funcSymbol;
        iExpr.langLibInvocation = true;
        SymbolEnv enclEnv = this.env;
        this.env = SymbolEnv.createInvocationEnv(iExpr, this.env);
        if (iExpr.argExprs.isEmpty() || !iExpr.argExprs.get(0).equals(iExpr.expr)) {
            iExpr.argExprs.add(0, iExpr.expr);
        }
        this.checkInvocationParamAndReturnType(iExpr);
        this.env = enclEnv;
        return funcSymbol;
    }

    private void checkInvocationParamAndReturnType(BLangInvocation iExpr) {
        BType actualType = this.checkInvocationParam(iExpr);
        this.resultType = this.types.checkType(iExpr, actualType, this.expType);
    }

    private BType checkInvocationParam(BLangInvocation iExpr) {
        if (iExpr.symbol.type.tag != 16) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.INVALID_FUNCTION_INVOCATION, iExpr.symbol.type);
            return this.symTable.noType;
        }
        List<BType> paramTypes = ((BInvokableType)iExpr.symbol.type).getParameterTypes();
        int parameterCount = paramTypes.size();
        iExpr.requiredArgs = new ArrayList<BLangExpression>();
        int i = 0;
        BLangExpression vararg = null;
        boolean foundNamedArg = false;
        block4: for (BLangExpression expr : iExpr.argExprs) {
            switch (expr.getKind()) {
                case NAMED_ARGS_EXPR: {
                    foundNamedArg = true;
                    if (i < parameterCount) {
                        iExpr.requiredArgs.add(expr);
                    } else {
                        this.dlog.error(expr.pos, DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
                    }
                    ++i;
                    continue block4;
                }
                case REST_ARGS_EXPR: {
                    if (foundNamedArg) {
                        this.dlog.error(expr.pos, DiagnosticErrorCode.REST_ARG_DEFINED_AFTER_NAMED_ARG, new Object[0]);
                        continue block4;
                    }
                    vararg = expr;
                    continue block4;
                }
            }
            if (foundNamedArg) {
                this.dlog.error(expr.pos, DiagnosticErrorCode.POSITIONAL_ARG_DEFINED_AFTER_NAMED_ARG, new Object[0]);
            }
            if (i < parameterCount) {
                iExpr.requiredArgs.add(expr);
            } else {
                iExpr.restArgs.add(expr);
            }
            ++i;
        }
        return this.checkInvocationArgs(iExpr, paramTypes, vararg);
    }

    private BType checkInvocationArgs(BLangInvocation iExpr, List<BType> paramTypes, BLangExpression vararg) {
        BType elementType;
        BType restType;
        BInvokableSymbol invokableSymbol = (BInvokableSymbol)iExpr.symbol;
        BInvokableType bInvokableType = (BInvokableType)invokableSymbol.type;
        BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)bInvokableType.tsymbol;
        ArrayList<BVarSymbol> nonRestParams = new ArrayList<BVarSymbol>(invokableTypeSymbol.params);
        List<BLangExpression> nonRestArgs = iExpr.requiredArgs;
        ArrayList<BVarSymbol> valueProvidedParams = new ArrayList<BVarSymbol>();
        ArrayList<BVarSymbol> requiredParams = new ArrayList<BVarSymbol>();
        for (BVarSymbol nonRestParam : nonRestParams) {
            if (nonRestParam.defaultableParam) continue;
            requiredParams.add(nonRestParam);
        }
        for (int i = 0; i < nonRestArgs.size(); ++i) {
            BLangExpression arg = nonRestArgs.get(i);
            BType expectedType = paramTypes.get(i);
            if (i == 0 && arg.typeChecked && iExpr.expr != null && iExpr.expr == arg) {
                this.types.checkType(arg.pos, arg.type, expectedType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                this.types.setImplicitCastExpr(arg, arg.type, expectedType);
            }
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                if (i >= nonRestParams.size()) break;
                BVarSymbol param = (BVarSymbol)nonRestParams.get(i);
                this.checkTypeParamExpr(arg, this.env, param.type, iExpr.langLibInvocation);
                valueProvidedParams.add(param);
                requiredParams.remove(param);
                continue;
            }
            if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) continue;
            BLangIdentifier argName = ((NamedArgNode)((Object)arg)).getName();
            BVarSymbol varSym = null;
            for (BVarSymbol nonRestParam : nonRestParams) {
                if (!nonRestParam.getName().value.equals(argName.value)) continue;
                varSym = nonRestParam;
            }
            if (varSym == null) {
                this.dlog.error(arg.pos, DiagnosticErrorCode.UNDEFINED_PARAMETER, argName);
                break;
            }
            requiredParams.remove(varSym);
            if (valueProvidedParams.contains(varSym)) {
                this.dlog.error(arg.pos, DiagnosticErrorCode.DUPLICATE_NAMED_ARGS, varSym.name.value);
                continue;
            }
            this.checkTypeParamExpr(arg, this.env, varSym.type, iExpr.langLibInvocation);
            valueProvidedParams.add(varSym);
        }
        BVarSymbol restParam = invokableTypeSymbol.restParam;
        boolean errored = false;
        if (!requiredParams.isEmpty() && vararg == null) {
            for (BVarSymbol requiredParam : requiredParams) {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.MISSING_REQUIRED_PARAMETER, requiredParam.name, iExpr.name.value);
            }
            errored = true;
        }
        if (restParam == null && (!iExpr.restArgs.isEmpty() || vararg != null && valueProvidedParams.size() == nonRestParams.size())) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
            errored = true;
        }
        if (errored) {
            return this.symTable.semanticError;
        }
        BType bType = restType = restParam == null ? null : restParam.type;
        if (nonRestArgs.size() < nonRestParams.size() && vararg != null) {
            ArrayList<BType> tupleMemberTypes = new ArrayList<BType>();
            Object tupleRestType = null;
            for (int j = nonRestArgs.size(); j < nonRestParams.size(); ++j) {
                tupleMemberTypes.add(paramTypes.get(j));
            }
            if (restType != null) {
                if (restType.tag == 19) {
                    tupleRestType = ((BArrayType)restType).eType;
                } else if (restType.tag == 30) {
                    BTupleType restTupleType = (BTupleType)restType;
                    tupleMemberTypes.addAll(restTupleType.tupleTypes);
                    if (restTupleType.restType != null) {
                        tupleRestType = restTupleType.restType;
                    }
                }
            }
            BTupleType tupleType = new BTupleType(tupleMemberTypes);
            tupleType.restType = tupleRestType;
            restType = tupleType;
        }
        if (!(restType != null || vararg == null && iExpr.restArgs.isEmpty())) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.TOO_MANY_ARGS_FUNC_CALL, iExpr.name.value);
            return this.symTable.semanticError;
        }
        if (vararg != null && !iExpr.restArgs.isEmpty()) {
            elementType = ((BArrayType)restType).eType;
            for (BLangExpression restArg : iExpr.restArgs) {
                this.checkTypeParamExpr(restArg, this.env, elementType, true);
            }
            this.checkTypeParamExpr(vararg, this.env, restType, iExpr.langLibInvocation);
            iExpr.restArgs.add(vararg);
        } else if (vararg != null) {
            this.checkTypeParamExpr(vararg, this.env, restType, iExpr.langLibInvocation);
            iExpr.restArgs.add(vararg);
        } else if (!iExpr.restArgs.isEmpty()) {
            if (restType.tag == 19) {
                elementType = ((BArrayType)restType).eType;
                for (BLangExpression restArg : iExpr.restArgs) {
                    this.checkTypeParamExpr(restArg, this.env, elementType, true);
                }
            } else {
                BTupleType tupleType = (BTupleType)restType;
                List<BType> tupleMemberTypes = tupleType.tupleTypes;
                BType tupleRestType = tupleType.restType;
                int tupleMemCount = tupleMemberTypes.size();
                for (int j = 0; j < iExpr.restArgs.size(); ++j) {
                    BLangExpression restArg = iExpr.restArgs.get(j);
                    BType memType = j < tupleMemCount ? tupleMemberTypes.get(j) : tupleRestType;
                    this.checkTypeParamExpr(restArg, this.env, memType, true);
                }
            }
        }
        BType retType = this.typeParamAnalyzer.getReturnTypeParams(this.env, bInvokableType.getReturnType());
        if (Symbols.isFlagOn(invokableSymbol.flags, 2L) && Symbols.isFlagOn(retType.flags, 0x4000000L)) {
            retType = this.typeBuilder.build(retType, iExpr);
        }
        boolean langLibPackageID = PackageID.isLangLibPackageID(iExpr.symbol.pkgID);
        String sortFuncName = "sort";
        if (langLibPackageID && sortFuncName.equals(iExpr.name.value)) {
            this.checkArrayLibSortFuncArgs(iExpr);
        }
        if (iExpr instanceof ActionNode && ((BLangInvocation.BLangActionInvocation)iExpr).async) {
            return this.generateFutureType(invokableSymbol, retType);
        }
        return retType;
    }

    private void checkArrayLibSortFuncArgs(BLangInvocation iExpr) {
        BType returnType;
        Location pos;
        if (iExpr.argExprs.size() <= 2 && !this.types.isOrderedType(iExpr.argExprs.get((int)0).type)) {
            this.dlog.error(iExpr.argExprs.get((int)0).pos, DiagnosticErrorCode.INVALID_SORT_ARRAY_MEMBER_TYPE, iExpr.argExprs.get((int)0).type);
        }
        if (iExpr.argExprs.size() != 3) {
            return;
        }
        BLangExpression keyFunction = iExpr.argExprs.get(2);
        BType keyFunctionType = keyFunction.type;
        if (keyFunctionType.tag == 27) {
            return;
        }
        if (keyFunctionType.tag == 10) {
            if (!this.types.isOrderedType(iExpr.argExprs.get((int)0).type)) {
                this.dlog.error(iExpr.argExprs.get((int)0).pos, DiagnosticErrorCode.INVALID_SORT_ARRAY_MEMBER_TYPE, iExpr.argExprs.get((int)0).type);
            }
            return;
        }
        if (keyFunction.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            pos = keyFunction.pos;
            returnType = ((BLangSimpleVarRef)keyFunction).type.getReturnType();
        } else if (keyFunction.getKind() == NodeKind.ARROW_EXPR) {
            BLangArrowFunction arrowFunction = (BLangArrowFunction)keyFunction;
            pos = arrowFunction.body.expr.pos;
            returnType = arrowFunction.body.expr.type;
            if (returnType.tag == 27) {
                return;
            }
        } else {
            BLangLambdaFunction keyLambdaFunction = (BLangLambdaFunction)keyFunction;
            pos = keyLambdaFunction.function.pos;
            returnType = keyLambdaFunction.function.type.getReturnType();
        }
        if (!this.types.isOrderedType(returnType)) {
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_SORT_FUNC_RETURN_TYPE, returnType);
        }
    }

    private BFutureType generateFutureType(BInvokableSymbol invocableSymbol, BType retType) {
        boolean isWorkerStart = invocableSymbol.name.value.startsWith("0");
        return new BFutureType(31, retType, null, isWorkerStart);
    }

    private void checkTypeParamExpr(BLangExpression arg, SymbolEnv env, BType expectedType, boolean inferTypeForNumericLiteral) {
        this.checkTypeParamExpr(arg.pos, arg, env, expectedType, inferTypeForNumericLiteral);
    }

    private void checkTypeParamExpr(Location pos, BLangExpression arg, SymbolEnv env, BType expectedType, boolean inferTypeForNumericLiteral) {
        if (this.typeParamAnalyzer.notRequireTypeParams(env)) {
            this.checkExpr(arg, env, expectedType);
            return;
        }
        if (this.requireTypeInference(arg, inferTypeForNumericLiteral)) {
            BType expType = this.typeParamAnalyzer.getMatchingBoundType(expectedType, env);
            BType inferredType = this.checkExpr(arg, env, expType);
            this.typeParamAnalyzer.checkForTypeParamsInArg(pos, inferredType, this.env, expectedType);
            return;
        }
        this.checkExpr(arg, env, expectedType);
        this.typeParamAnalyzer.checkForTypeParamsInArg(pos, arg.type, this.env, expectedType);
    }

    private boolean requireTypeInference(BLangExpression expr, boolean inferTypeForNumericLiteral) {
        switch (expr.getKind()) {
            case GROUP_EXPR: {
                return this.requireTypeInference(((BLangGroupExpr)expr).expression, inferTypeForNumericLiteral);
            }
            case ARROW_EXPR: 
            case LIST_CONSTRUCTOR_EXPR: 
            case RECORD_LITERAL_EXPR: {
                return true;
            }
            case NUMERIC_LITERAL: {
                return inferTypeForNumericLiteral;
            }
        }
        return false;
    }

    private BType checkMappingField(RecordLiteralNode.RecordField field, BType mappingType) {
        BType fieldType = this.symTable.semanticError;
        boolean keyValueField = field.isKeyValueField();
        boolean spreadOpField = field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP;
        boolean readOnlyConstructorField = false;
        String fieldName = null;
        Location pos = null;
        BLangExpression valueExpr = null;
        if (keyValueField) {
            valueExpr = ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr;
        } else if (!spreadOpField) {
            valueExpr = (BLangRecordLiteral.BLangRecordVarNameField)field;
        }
        switch (mappingType.tag) {
            case 12: {
                if (keyValueField) {
                    BLangRecordLiteral.BLangRecordKeyValueField keyValField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    BLangRecordLiteral.BLangRecordKey key = keyValField.key;
                    fieldType = this.checkRecordLiteralKeyExpr(key.expr, key.computedKey, (BRecordType)mappingType);
                    readOnlyConstructorField = keyValField.readonly;
                    pos = key.expr.pos;
                    fieldName = this.getKeyValueFieldName(keyValField);
                    break;
                }
                if (spreadOpField) {
                    BLangExpression spreadExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
                    this.checkExpr(spreadExpr, this.env);
                    BType spreadExprType = spreadExpr.type;
                    if (spreadExprType.tag == 15) {
                        return this.types.checkType(spreadExpr.pos, ((BMapType)spreadExprType).constraint, this.getAllFieldType((BRecordType)mappingType), (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                    }
                    if (spreadExprType.tag != 12) {
                        this.dlog.error(spreadExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_SPREAD_OP, spreadExprType);
                        return this.symTable.semanticError;
                    }
                    boolean errored = false;
                    for (BField bField : ((BRecordType)spreadExprType).fields.values()) {
                        BType specFieldType = bField.type;
                        BType expectedFieldType = this.checkRecordLiteralKeyByName(spreadExpr.pos, this.env, bField.name, (BRecordType)mappingType);
                        if (expectedFieldType == this.symTable.semanticError || this.types.isAssignable(specFieldType, expectedFieldType)) continue;
                        this.dlog.error(spreadExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_FIELD, expectedFieldType, bField.name, specFieldType);
                        if (errored) continue;
                        errored = true;
                    }
                    return errored ? this.symTable.semanticError : this.symTable.noType;
                }
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                fieldType = this.checkRecordLiteralKeyExpr(varNameField, false, (BRecordType)mappingType);
                readOnlyConstructorField = varNameField.readonly;
                pos = varNameField.pos;
                fieldName = this.getVarNameFieldName(varNameField);
                break;
            }
            case 15: {
                boolean validMapKey;
                if (spreadOpField) {
                    BType spreadOpMemberType;
                    BLangExpression spreadExp = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
                    BType spreadOpType = this.checkExpr(spreadExp, this.env);
                    switch (spreadOpType.tag) {
                        case 12: {
                            ArrayList<BType> types = new ArrayList<BType>();
                            BRecordType recordType = (BRecordType)spreadOpType;
                            for (BField recField : recordType.fields.values()) {
                                types.add(recField.type);
                            }
                            if (!recordType.sealed) {
                                types.add(recordType.restFieldType);
                            }
                            spreadOpMemberType = this.getRepresentativeBroadType(types);
                            break;
                        }
                        case 15: {
                            spreadOpMemberType = ((BMapType)spreadOpType).constraint;
                            break;
                        }
                        default: {
                            this.dlog.error(spreadExp.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES_SPREAD_OP, spreadOpType);
                            return this.symTable.semanticError;
                        }
                    }
                    return this.types.checkType(spreadExp.pos, spreadOpMemberType, ((BMapType)mappingType).constraint, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                }
                if (keyValueField) {
                    BLangRecordLiteral.BLangRecordKeyValueField keyValField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    BLangRecordLiteral.BLangRecordKey key = keyValField.key;
                    validMapKey = this.checkValidJsonOrMapLiteralKeyExpr(key.expr, key.computedKey);
                    readOnlyConstructorField = keyValField.readonly;
                    pos = key.pos;
                    fieldName = this.getKeyValueFieldName(keyValField);
                } else {
                    BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                    validMapKey = this.checkValidJsonOrMapLiteralKeyExpr(varNameField, false);
                    readOnlyConstructorField = varNameField.readonly;
                    pos = varNameField.pos;
                    fieldName = this.getVarNameFieldName(varNameField);
                }
                BType bType = fieldType = validMapKey ? ((BMapType)mappingType).constraint : this.symTable.semanticError;
            }
        }
        if (readOnlyConstructorField) {
            if (this.types.isSelectivelyImmutableType(fieldType)) {
                fieldType = ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, (SelectivelyImmutableReferenceType)((Object)fieldType), this.env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>());
            } else if (!this.types.isInherentlyImmutableType(fieldType)) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_READONLY_MAPPING_FIELD, fieldName, fieldType);
                fieldType = this.symTable.semanticError;
            }
        }
        if (spreadOpField) {
            valueExpr = ((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr;
        }
        BLangExpression exprToCheck = valueExpr;
        if (this.nonErrorLoggingCheck) {
            ++valueExpr.cloneAttempt;
            exprToCheck = this.nodeCloner.clone(valueExpr);
        } else {
            ((BLangNode)((Object)field)).type = fieldType;
        }
        return this.checkExpr(exprToCheck, this.env, fieldType);
    }

    private BType checkRecordLiteralKeyExpr(BLangExpression keyExpr, boolean computedKey, BRecordType recordType) {
        Name fieldName;
        if (computedKey) {
            this.checkExpr(keyExpr, this.env, this.symTable.stringType);
            if (keyExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            LinkedHashSet fieldTypes = recordType.fields.values().stream().map(field -> field.type).collect(Collectors.toCollection(LinkedHashSet::new));
            if (recordType.restFieldType.tag != 23) {
                fieldTypes.add(recordType.restFieldType);
            }
            return BUnionType.create(null, fieldTypes);
        }
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)keyExpr;
            fieldName = this.names.fromIdNode(varRef.variableName);
        } else if (keyExpr.getKind() == NodeKind.LITERAL && ((BLangLiteral)keyExpr).type.tag == 5) {
            fieldName = this.names.fromString((String)((BLangLiteral)keyExpr).value);
        } else {
            this.dlog.error(keyExpr.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL_KEY, new Object[0]);
            return this.symTable.semanticError;
        }
        return this.checkRecordLiteralKeyByName(keyExpr.pos, this.env, fieldName, recordType);
    }

    private BType checkRecordLiteralKeyByName(Location location, SymbolEnv env, Name key, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(location, env, key, recordType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            return fieldSymbol.type;
        }
        if (recordType.sealed) {
            this.dlog.error(location, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, key, recordType.tsymbol.type.getKind().typeName(), recordType);
            return this.symTable.semanticError;
        }
        return recordType.restFieldType;
    }

    private BType getAllFieldType(BRecordType recordType) {
        LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
        for (BField field : recordType.fields.values()) {
            possibleTypes.add(field.type);
        }
        BType restFieldType = recordType.restFieldType;
        if (restFieldType != null && restFieldType != this.symTable.noType) {
            possibleTypes.add(restFieldType);
        }
        return BUnionType.create(null, possibleTypes);
    }

    private boolean checkValidJsonOrMapLiteralKeyExpr(BLangExpression keyExpr, boolean computedKey) {
        if (computedKey) {
            this.checkExpr(keyExpr, this.env, this.symTable.stringType);
            return keyExpr.type != this.symTable.semanticError;
        }
        if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF || keyExpr.getKind() == NodeKind.LITERAL && ((BLangLiteral)keyExpr).type.tag == 5) {
            return true;
        }
        this.dlog.error(keyExpr.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL_KEY, new Object[0]);
        return false;
    }

    private BType addNilForNillableAccessType(BType actualType) {
        if (actualType.isNullable()) {
            return actualType;
        }
        return BUnionType.create(null, actualType, this.symTable.nilType);
    }

    private BType checkRecordRequiredFieldAccess(BLangVariableReference varReferExpr, Name fieldName, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, this.env, fieldName, recordType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol || Symbols.isOptional(fieldSymbol)) {
            return this.symTable.semanticError;
        }
        varReferExpr.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkRecordOptionalFieldAccess(BLangVariableReference varReferExpr, Name fieldName, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, this.env, fieldName, recordType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol || !Symbols.isOptional(fieldSymbol)) {
            return this.symTable.semanticError;
        }
        varReferExpr.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkRecordRestFieldAccess(BLangVariableReference varReferExpr, Name fieldName, BRecordType recordType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(varReferExpr.pos, this.env, fieldName, recordType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            return this.symTable.semanticError;
        }
        if (recordType.sealed) {
            return this.symTable.semanticError;
        }
        return recordType.restFieldType;
    }

    private BType checkObjectFieldAccess(BLangFieldBasedAccess bLangFieldBasedAccess, Name fieldName, BObjectType objectType) {
        BSymbol fieldSymbol = this.symResolver.resolveStructField(bLangFieldBasedAccess.pos, this.env, fieldName, objectType.tsymbol);
        if (fieldSymbol != this.symTable.notFoundSymbol) {
            bLangFieldBasedAccess.symbol = fieldSymbol;
            return fieldSymbol.type;
        }
        Name objFuncName = this.names.fromString(Symbols.getAttachedFuncSymbolName(objectType.tsymbol.name.value, fieldName.value));
        fieldSymbol = this.symResolver.resolveObjectField(bLangFieldBasedAccess.pos, this.env, objFuncName, objectType.tsymbol);
        if (fieldSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(bLangFieldBasedAccess.field.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, fieldName, objectType.tsymbol.type.getKind().typeName(), objectType.tsymbol);
            return this.symTable.semanticError;
        }
        if (Symbols.isFlagOn(fieldSymbol.type.flags, 0x20000000L) && !Symbols.isFlagOn(objectType.flags, 0x20000000L)) {
            fieldSymbol = ASTBuilderUtil.duplicateInvokableSymbol((BInvokableSymbol)fieldSymbol);
            fieldSymbol.flags &= 0xFFFFFFFFDFFFFFFFL;
            fieldSymbol.type.flags &= 0xFFFFFFFFDFFFFFFFL;
        }
        bLangFieldBasedAccess.symbol = fieldSymbol;
        return fieldSymbol.type;
    }

    private BType checkTupleFieldType(BType tupleType, int indexValue) {
        BTupleType bTupleType = (BTupleType)tupleType;
        if (bTupleType.tupleTypes.size() <= indexValue && bTupleType.restType != null) {
            return bTupleType.restType;
        }
        if (indexValue < 0 || bTupleType.tupleTypes.size() <= indexValue) {
            return this.symTable.semanticError;
        }
        return bTupleType.tupleTypes.get(indexValue);
    }

    private void validateTags(BLangXMLElementLiteral bLangXMLElementLiteral, SymbolEnv xmlElementEnv) {
        BLangExpression startTagName = bLangXMLElementLiteral.startTagName;
        this.checkExpr(startTagName, xmlElementEnv, this.symTable.stringType);
        BLangExpression endTagName = bLangXMLElementLiteral.endTagName;
        if (endTagName == null) {
            return;
        }
        this.checkExpr(endTagName, xmlElementEnv, this.symTable.stringType);
        if (startTagName.getKind() == NodeKind.XML_QNAME && endTagName.getKind() == NodeKind.XML_QNAME && startTagName.equals(endTagName)) {
            return;
        }
        if (startTagName.getKind() != NodeKind.XML_QNAME && endTagName.getKind() != NodeKind.XML_QNAME) {
            return;
        }
        this.dlog.error(bLangXMLElementLiteral.pos, DiagnosticErrorCode.XML_TAGS_MISMATCH, new Object[0]);
    }

    private void checkStringTemplateExprs(List<? extends BLangExpression> exprs, boolean allowXml) {
        for (BLangExpression bLangExpression : exprs) {
            this.checkExpr(bLangExpression, this.env);
            BType type = bLangExpression.type;
            if (type == this.symTable.semanticError || type.tag < 7) continue;
            if (allowXml) {
                if (type.tag == 8) continue;
                this.dlog.error(bLangExpression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, BUnionType.create(null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType, this.symTable.booleanType, this.symTable.xmlType), type);
                continue;
            }
            this.dlog.error(bLangExpression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, BUnionType.create(null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType, this.symTable.booleanType), type);
        }
    }

    private List<BLangExpression> concatSimilarKindXMLNodes(List<BLangExpression> exprs, SymbolEnv xmlElementEnv) {
        ArrayList<BLangExpression> newChildren = new ArrayList<BLangExpression>();
        ArrayList<BLangExpression> tempConcatExpressions = new ArrayList<BLangExpression>();
        for (BLangExpression expr : exprs) {
            BType exprType = this.checkExpr(expr, xmlElementEnv);
            if (TypeTags.isXMLTypeTag(exprType.tag)) {
                if (!tempConcatExpressions.isEmpty()) {
                    newChildren.add(this.getXMLTextLiteral(tempConcatExpressions));
                    tempConcatExpressions = new ArrayList();
                }
                newChildren.add(expr);
                continue;
            }
            BType type = expr.type;
            if (type.tag >= 7) {
                if (type == this.symTable.semanticError || TypeTags.isXMLTypeTag(type.tag)) continue;
                this.dlog.error(expr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, BUnionType.create(null, this.symTable.intType, this.symTable.floatType, this.symTable.decimalType, this.symTable.stringType, this.symTable.booleanType, this.symTable.xmlType), type);
                continue;
            }
            tempConcatExpressions.add(expr);
        }
        if (!tempConcatExpressions.isEmpty()) {
            newChildren.add(this.getXMLTextLiteral(tempConcatExpressions));
        }
        return newChildren;
    }

    private BLangExpression getXMLTextLiteral(List<BLangExpression> exprs) {
        BLangXMLTextLiteral xmlTextLiteral = (BLangXMLTextLiteral)TreeBuilder.createXMLTextLiteralNode();
        xmlTextLiteral.textFragments = exprs;
        xmlTextLiteral.pos = exprs.get((int)0).pos;
        xmlTextLiteral.type = this.symTable.xmlType;
        return xmlTextLiteral;
    }

    private BType getTypeOfExprInFieldAccess(BLangExpression expr) {
        this.checkExpr(expr, this.env, this.symTable.noType);
        return expr.type;
    }

    private BType getAccessExprFinalType(BLangAccessExpression accessExpr, BType actualType) {
        accessExpr.originalType = actualType;
        BUnionType unionType = BUnionType.create(null, actualType);
        if (this.returnsNull(accessExpr)) {
            unionType.add(this.symTable.nilType);
        }
        BType parentType = accessExpr.expr.type;
        if (accessExpr.errorSafeNavigation && (parentType.tag == 27 || parentType.tag == 20 && ((BUnionType)parentType).getMemberTypes().contains(this.symTable.errorType))) {
            unionType.add(this.symTable.errorType);
        }
        if (unionType.getMemberTypes().size() == 1) {
            return unionType.getMemberTypes().toArray(new BType[0])[0];
        }
        return unionType;
    }

    private boolean returnsNull(BLangAccessExpression accessExpr) {
        BType parentType = accessExpr.expr.type;
        if (parentType.isNullable() && parentType.tag != 7) {
            return true;
        }
        if (parentType.tag != 15) {
            return false;
        }
        if (accessExpr.getKind() == NodeKind.INDEX_BASED_ACCESS_EXPR && accessExpr.expr.type.tag == 15) {
            BType constraintType = ((BMapType)accessExpr.expr.type).constraint;
            return constraintType != null && constraintType.tag != 17 && constraintType.tag != 7;
        }
        return false;
    }

    private BType checkObjectFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 33) {
            return this.checkObjectFieldAccess(fieldAccessExpr, fieldName, (BObjectType)varRefType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkObjectFieldAccess(fieldAccessExpr, fieldName, (BObjectType)memType);
            if (individualFieldType == this.symTable.semanticError) {
                return individualFieldType;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkRecordFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 12) {
            return this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkRecordFieldAccessExpr(fieldAccessExpr, memType, fieldName);
            if (individualFieldType == this.symTable.semanticError) {
                return individualFieldType;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkRecordFieldAccessLhsExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 12) {
            BType fieldType = this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
            if (fieldType != this.symTable.semanticError) {
                return fieldType;
            }
            return this.checkRecordOptionalFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkRecordFieldAccessLhsExpr(fieldAccessExpr, memType, fieldName);
            if (individualFieldType == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkOptionalRecordFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        if (varRefType.tag == 12) {
            BType fieldType = this.checkRecordRequiredFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
            if (fieldType != this.symTable.semanticError) {
                return fieldType;
            }
            fieldType = this.checkRecordOptionalFieldAccess(fieldAccessExpr, fieldName, (BRecordType)varRefType);
            if (fieldType == this.symTable.semanticError) {
                return fieldType;
            }
            return BUnionType.create(null, fieldType, this.symTable.nilType);
        }
        Set<BType> memberTypes = ((BUnionType)varRefType).getMemberTypes();
        boolean nonMatchedRecordExists = false;
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : memberTypes) {
            BType individualFieldType = this.checkOptionalRecordFieldAccessExpr(fieldAccessExpr, memType, fieldName);
            if (individualFieldType == this.symTable.semanticError) {
                nonMatchedRecordExists = true;
                continue;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.isEmpty()) {
            return this.symTable.semanticError;
        }
        BType fieldType = fieldTypeMembers.size() == 1 ? (BType)fieldTypeMembers.iterator().next() : BUnionType.create(null, fieldTypeMembers);
        return nonMatchedRecordExists ? this.addNilForNillableAccessType(fieldType) : fieldType;
    }

    private BType checkFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        BType actualType = this.symTable.semanticError;
        if (this.types.isSubTypeOfBaseType(varRefType, 33)) {
            fieldAccessExpr.originalType = actualType = this.checkObjectFieldAccessExpr(fieldAccessExpr, varRefType, fieldName);
        } else if (this.types.isSubTypeOfBaseType(varRefType, 12)) {
            actualType = this.checkRecordFieldAccessExpr(fieldAccessExpr, varRefType, fieldName);
            if (actualType != this.symTable.semanticError) {
                fieldAccessExpr.originalType = actualType;
                return actualType;
            }
            if (!fieldAccessExpr.lhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS_FOR_NON_REQUIRED_FIELD, varRefType, fieldName);
                return actualType;
            }
            fieldAccessExpr.originalType = actualType = this.checkRecordFieldAccessLhsExpr(fieldAccessExpr, varRefType, fieldName);
            if (actualType == this.symTable.semanticError) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD_WITH_TYPE, fieldName, varRefType.tsymbol.type.getKind().typeName(), varRefType);
            }
        } else if (this.types.isLax(varRefType)) {
            if (fieldAccessExpr.lhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS_FOR_ASSIGNMENT, varRefType);
                return this.symTable.semanticError;
            }
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            BType laxFieldAccessType = this.getLaxFieldAccessType(varRefType);
            actualType = BUnionType.create(null, laxFieldAccessType, this.symTable.errorType);
            fieldAccessExpr.originalType = laxFieldAccessType;
        } else if (fieldAccessExpr.expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)fieldAccessExpr.expr)) {
            BType laxFieldAccessType = this.getLaxFieldAccessType(((BLangFieldBasedAccess)fieldAccessExpr.expr).originalType);
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            actualType = BUnionType.create(null, laxFieldAccessType, this.symTable.errorType);
            fieldAccessExpr.errorSafeNavigation = true;
            fieldAccessExpr.originalType = laxFieldAccessType;
        } else if (TypeTags.isXMLTypeTag(varRefType.tag)) {
            if (fieldAccessExpr.lhsVar) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
            }
            fieldAccessExpr.originalType = actualType = this.symTable.xmlType;
        } else if (varRefType.tag != 27) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_FIELD_ACCESS, varRefType);
        }
        return actualType;
    }

    private void resolveXMLNamespace(BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess fieldAccessExpr) {
        BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess nsPrefixedFieldAccess = fieldAccessExpr;
        String nsPrefix = nsPrefixedFieldAccess.nsPrefix.value;
        BSymbol nsSymbol = this.symResolver.lookupSymbolInPrefixSpace(this.env, this.names.fromString(nsPrefix));
        if (nsSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(nsPrefixedFieldAccess.nsPrefix.pos, DiagnosticErrorCode.CANNOT_FIND_XML_NAMESPACE, nsPrefixedFieldAccess.nsPrefix);
        } else {
            nsPrefixedFieldAccess.nsSymbol = nsSymbol.getKind() == SymbolKind.PACKAGE ? (BXMLNSSymbol)this.findXMLNamespaceFromPackageConst(nsPrefixedFieldAccess.field.value, nsPrefixedFieldAccess.nsPrefix.value, (BPackageSymbol)nsSymbol, fieldAccessExpr.pos) : (BXMLNSSymbol)nsSymbol;
        }
    }

    private boolean hasLaxOriginalType(BLangFieldBasedAccess fieldBasedAccess) {
        return fieldBasedAccess.originalType != null && this.types.isLax(fieldBasedAccess.originalType);
    }

    private BType getLaxFieldAccessType(BType exprType) {
        switch (exprType.tag) {
            case 7: {
                return this.symTable.jsonType;
            }
            case 8: 
            case 45: {
                return this.symTable.stringType;
            }
            case 15: {
                return ((BMapType)exprType).constraint;
            }
            case 20: {
                BUnionType unionType = (BUnionType)exprType;
                LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
                unionType.getMemberTypes().forEach(bType -> memberTypes.add(this.getLaxFieldAccessType((BType)bType)));
                return memberTypes.size() == 1 ? (BType)memberTypes.iterator().next() : BUnionType.create(null, memberTypes);
            }
        }
        return this.symTable.semanticError;
    }

    private BType checkOptionalFieldAccessExpr(BLangFieldBasedAccess fieldAccessExpr, BType varRefType, Name fieldName) {
        BType laxFieldAccessType;
        Set<BType> memTypes;
        BType actualType = this.symTable.semanticError;
        boolean nillableExprType = false;
        BType effectiveType = varRefType;
        if (varRefType.tag == 20 && (memTypes = ((BUnionType)varRefType).getMemberTypes()).contains(this.symTable.nilType)) {
            LinkedHashSet<BType> nilRemovedSet = new LinkedHashSet<BType>();
            for (BType bType : memTypes) {
                if (bType != this.symTable.nilType) {
                    nilRemovedSet.add(bType);
                    continue;
                }
                nillableExprType = true;
            }
            BType bType = effectiveType = nilRemovedSet.size() == 1 ? (BType)nilRemovedSet.iterator().next() : BUnionType.create(null, nilRemovedSet);
        }
        if (this.types.isSubTypeOfBaseType(effectiveType, 12)) {
            actualType = this.checkOptionalRecordFieldAccessExpr(fieldAccessExpr, effectiveType, fieldName);
            if (actualType == this.symTable.semanticError) {
                this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_OPTIONAL_FIELD_ACCESS_FOR_FIELD, varRefType, fieldName);
            }
            fieldAccessExpr.nilSafeNavigation = nillableExprType;
            fieldAccessExpr.originalType = this.getSafeType(actualType, fieldAccessExpr);
        } else if (this.types.isLax(effectiveType)) {
            laxFieldAccessType = this.getLaxFieldAccessType(effectiveType);
            BType bType = actualType = this.accessCouldResultInError(effectiveType) ? BUnionType.create(null, laxFieldAccessType, this.symTable.errorType) : laxFieldAccessType;
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            fieldAccessExpr.originalType = laxFieldAccessType;
            fieldAccessExpr.nilSafeNavigation = true;
            nillableExprType = true;
        } else if (fieldAccessExpr.expr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR && this.hasLaxOriginalType((BLangFieldBasedAccess)fieldAccessExpr.expr)) {
            laxFieldAccessType = this.getLaxFieldAccessType(((BLangFieldBasedAccess)fieldAccessExpr.expr).originalType);
            BType bType = actualType = this.accessCouldResultInError(effectiveType) ? BUnionType.create(null, laxFieldAccessType, this.symTable.errorType) : laxFieldAccessType;
            if (fieldAccessExpr.fieldKind == FieldKind.WITH_NS) {
                this.resolveXMLNamespace((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr);
            }
            fieldAccessExpr.errorSafeNavigation = true;
            fieldAccessExpr.originalType = laxFieldAccessType;
            fieldAccessExpr.nilSafeNavigation = true;
            nillableExprType = true;
        } else if (varRefType.tag != 27) {
            this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_OPTIONAL_FIELD_ACCESS, varRefType);
        }
        if (nillableExprType && actualType != this.symTable.semanticError && !actualType.isNullable()) {
            actualType = BUnionType.create(null, actualType, this.symTable.nilType);
        }
        return actualType;
    }

    private boolean accessCouldResultInError(BType type) {
        if (type.tag == 7) {
            return true;
        }
        if (type.tag == 15) {
            return false;
        }
        if (type.tag == 8) {
            return true;
        }
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().stream().anyMatch(this::accessCouldResultInError);
        }
        return false;
    }

    private BType checkIndexAccessExpr(BLangIndexBasedAccess indexBasedAccessExpr) {
        Set<BType> memTypes;
        BType varRefType = indexBasedAccessExpr.expr.type;
        boolean nillableExprType = false;
        if (varRefType.tag == 20 && (memTypes = ((BUnionType)varRefType).getMemberTypes()).contains(this.symTable.nilType)) {
            LinkedHashSet<BType> nilRemovedSet = new LinkedHashSet<BType>();
            for (BType bType : memTypes) {
                if (bType != this.symTable.nilType) {
                    nilRemovedSet.add(bType);
                    continue;
                }
                nillableExprType = true;
            }
            if (nillableExprType) {
                BType bType = varRefType = nilRemovedSet.size() == 1 ? (BType)nilRemovedSet.iterator().next() : BUnionType.create(null, nilRemovedSet);
                if (!this.types.isSubTypeOfMapping(varRefType)) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_INDEXING, indexBasedAccessExpr.expr.type);
                    return this.symTable.semanticError;
                }
                if (indexBasedAccessExpr.lhsVar) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_INDEX_ACCESS_FOR_ASSIGNMENT, indexBasedAccessExpr.expr.type);
                    return this.symTable.semanticError;
                }
            }
        }
        BLangExpression indexExpr = indexBasedAccessExpr.indexExpr;
        BType actualType = this.symTable.semanticError;
        if (this.types.isSubTypeOfMapping(varRefType)) {
            this.checkExpr(indexExpr, this.env, this.symTable.stringType);
            if (indexExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            actualType = this.checkMappingIndexBasedAccess(indexBasedAccessExpr, varRefType);
            if (actualType == this.symTable.semanticError) {
                if (indexExpr.type.tag == 5 && this.isConst(indexExpr)) {
                    String fieldName = this.getConstFieldName(indexExpr);
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.UNDEFINED_STRUCTURE_FIELD, fieldName, indexBasedAccessExpr.expr.type);
                    return actualType;
                }
                this.dlog.error(indexExpr.pos, DiagnosticErrorCode.INVALID_RECORD_INDEX_EXPR, indexExpr.type);
                return actualType;
            }
            indexBasedAccessExpr.nilSafeNavigation = nillableExprType;
            indexBasedAccessExpr.originalType = this.getSafeType(actualType, indexBasedAccessExpr);
        } else if (this.types.isSubTypeOfList(varRefType)) {
            this.checkExpr(indexExpr, this.env, this.symTable.intType);
            if (indexExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = actualType = this.checkListIndexBasedAccess(indexBasedAccessExpr, varRefType);
            if (actualType == this.symTable.semanticError) {
                if (indexExpr.type.tag == 1 && this.isConst(indexExpr)) {
                    this.dlog.error(indexBasedAccessExpr.indexExpr.pos, DiagnosticErrorCode.LIST_INDEX_OUT_OF_RANGE, this.getConstIndex(indexExpr));
                    return actualType;
                }
                this.dlog.error(indexExpr.pos, DiagnosticErrorCode.INVALID_LIST_INDEX_EXPR, indexExpr.type);
                return actualType;
            }
        } else if (this.types.isAssignable(varRefType, this.symTable.stringType)) {
            if (indexBasedAccessExpr.lhsVar) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_INDEX_ACCESS_FOR_ASSIGNMENT, indexBasedAccessExpr.expr.type);
                return this.symTable.semanticError;
            }
            this.checkExpr(indexExpr, this.env, this.symTable.intType);
            if (indexExpr.type == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = this.symTable.stringType;
            actualType = this.symTable.stringType;
        } else if (varRefType.tag == 8) {
            if (indexBasedAccessExpr.lhsVar) {
                indexExpr.type = this.symTable.semanticError;
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_XML_SEQUENCE, new Object[0]);
                return actualType;
            }
            BType type = this.checkExpr(indexExpr, this.env, this.symTable.intType);
            if (type == this.symTable.semanticError) {
                return type;
            }
            indexBasedAccessExpr.originalType = actualType = varRefType;
        } else if (varRefType.tag == 9) {
            BType resultType;
            if (indexBasedAccessExpr.lhsVar) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_TABLE_USING_MEMBER_ACCESS, varRefType);
                return this.symTable.semanticError;
            }
            BTableType tableType = (BTableType)indexBasedAccessExpr.expr.type;
            BType keyTypeConstraint = tableType.keyTypeConstraint;
            if (tableType.keyTypeConstraint == null && (keyTypeConstraint = this.createTableKeyConstraint(((BTableType)indexBasedAccessExpr.expr.type).fieldNameList, ((BTableType)indexBasedAccessExpr.expr.type).constraint)) == this.symTable.semanticError) {
                this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.MEMBER_ACCESS_NOT_SUPPORT_FOR_KEYLESS_TABLE, indexBasedAccessExpr.expr);
                return this.symTable.semanticError;
            }
            if (indexExpr.getKind() != NodeKind.TABLE_MULTI_KEY) {
                this.checkExpr(indexExpr, this.env, keyTypeConstraint);
                if (indexExpr.type == this.symTable.semanticError) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.INVALID_KEY_CONSTRAINT_PROVIDED_FOR_ACCESS, keyTypeConstraint);
                    return this.symTable.semanticError;
                }
            } else {
                List<BLangExpression> multiKeyExpressionList = ((BLangTableMultiKeyExpr)indexBasedAccessExpr.indexExpr).multiKeyIndexExprs;
                List<BType> keyConstraintTypes = ((BTupleType)keyTypeConstraint).tupleTypes;
                if (keyConstraintTypes.size() != multiKeyExpressionList.size()) {
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.INVALID_KEY_CONSTRAINT_PROVIDED_FOR_ACCESS, keyTypeConstraint);
                    return this.symTable.semanticError;
                }
                for (int i = 0; i < multiKeyExpressionList.size(); ++i) {
                    BLangExpression keyExpr = multiKeyExpressionList.get(i);
                    this.checkExpr(keyExpr, this.env, keyConstraintTypes.get(i));
                    if (keyExpr.type != this.symTable.semanticError) continue;
                    this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.INVALID_KEY_CONSTRAINT_PROVIDED_FOR_ACCESS, keyTypeConstraint);
                    return this.symTable.semanticError;
                }
            }
            if (this.expType.tag != 23 && (resultType = this.checkExpr(indexBasedAccessExpr.expr, this.env, this.expType)) == this.symTable.semanticError) {
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.originalType = tableType.constraint;
            actualType = tableType.constraint;
        } else {
            if (varRefType == this.symTable.semanticError) {
                indexBasedAccessExpr.indexExpr.type = this.symTable.semanticError;
                return this.symTable.semanticError;
            }
            indexBasedAccessExpr.indexExpr.type = this.symTable.semanticError;
            this.dlog.error(indexBasedAccessExpr.pos, DiagnosticErrorCode.OPERATION_DOES_NOT_SUPPORT_INDEXING, indexBasedAccessExpr.expr.type);
            return this.symTable.semanticError;
        }
        if (nillableExprType && !actualType.isNullable()) {
            actualType = BUnionType.create(null, actualType, this.symTable.nilType);
        }
        return actualType;
    }

    private Long getConstIndex(BLangExpression indexExpr) {
        return indexExpr.getKind() == NodeKind.NUMERIC_LITERAL ? (Long)((BLangLiteral)indexExpr).value : (Long)((BConstantSymbol)((BLangSimpleVarRef)indexExpr).symbol).value.value;
    }

    private String getConstFieldName(BLangExpression indexExpr) {
        return indexExpr.getKind() == NodeKind.LITERAL ? (String)((BLangLiteral)indexExpr).value : (String)((BConstantSymbol)((BLangSimpleVarRef)indexExpr).symbol).value.value;
    }

    private BType checkArrayIndexBasedAccess(BLangIndexBasedAccess indexBasedAccess, BType indexExprType, BArrayType arrayType) {
        BType actualType = this.symTable.semanticError;
        switch (indexExprType.tag) {
            case 1: {
                BLangExpression indexExpr = indexBasedAccess.indexExpr;
                if (!this.isConst(indexExpr) || arrayType.state == BArrayState.OPEN) {
                    actualType = arrayType.eType;
                    break;
                }
                actualType = this.getConstIndex(indexExpr) >= (long)arrayType.size ? this.symTable.semanticError : arrayType.eType;
                break;
            }
            case 32: {
                BFiniteType finiteIndexExpr = (BFiniteType)indexExprType;
                boolean validIndexExists = false;
                for (BLangExpression finiteMember : finiteIndexExpr.getValueSpace()) {
                    int indexValue = ((Long)((BLangLiteral)finiteMember).value).intValue();
                    if (indexValue < 0 || arrayType.state != BArrayState.OPEN && indexValue >= arrayType.size) continue;
                    validIndexExists = true;
                    break;
                }
                if (!validIndexExists) {
                    return this.symTable.semanticError;
                }
                actualType = arrayType.eType;
                break;
            }
            case 20: {
                BFiniteType finiteType;
                List<BFiniteType> finiteTypes = ((BUnionType)indexExprType).getMemberTypes().stream().filter(memType -> memType.tag == 32).map(matchedType -> (BFiniteType)matchedType).collect(Collectors.toList());
                if (finiteTypes.size() == 1) {
                    finiteType = (BFiniteType)finiteTypes.get(0);
                } else {
                    LinkedHashSet<BLangExpression> valueSpace = new LinkedHashSet<BLangExpression>();
                    finiteTypes.forEach(constituent -> valueSpace.addAll(constituent.getValueSpace()));
                    finiteType = new BFiniteType(null, valueSpace);
                }
                BType elementType = this.checkArrayIndexBasedAccess(indexBasedAccess, finiteType, arrayType);
                if (elementType == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
                actualType = arrayType.eType;
            }
        }
        return actualType;
    }

    private BType checkListIndexBasedAccess(BLangIndexBasedAccess accessExpr, BType type) {
        if (type.tag == 19) {
            return this.checkArrayIndexBasedAccess(accessExpr, accessExpr.indexExpr.type, (BArrayType)type);
        }
        if (type.tag == 30) {
            return this.checkTupleIndexBasedAccess(accessExpr, (BTupleType)type, accessExpr.indexExpr.type);
        }
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : ((BUnionType)type).getMemberTypes()) {
            BType individualFieldType = this.checkListIndexBasedAccess(accessExpr, memType);
            if (individualFieldType == this.symTable.semanticError) continue;
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 0) {
            return this.symTable.semanticError;
        }
        if (fieldTypeMembers.size() == 1) {
            return (BType)fieldTypeMembers.iterator().next();
        }
        return BUnionType.create(null, fieldTypeMembers);
    }

    private BType checkTupleIndexBasedAccess(BLangIndexBasedAccess accessExpr, BTupleType tuple, BType currentType) {
        BType actualType = this.symTable.semanticError;
        BLangExpression indexExpr = accessExpr.indexExpr;
        switch (currentType.tag) {
            case 1: {
                if (this.isConst(indexExpr)) {
                    actualType = this.checkTupleFieldType(tuple, this.getConstIndex(indexExpr).intValue());
                    break;
                }
                BTupleType tupleExpr = (BTupleType)accessExpr.expr.type;
                LinkedHashSet<BType> tupleTypes = this.collectTupleFieldTypes(tupleExpr, new LinkedHashSet<BType>());
                actualType = tupleTypes.size() == 1 ? (BType)tupleTypes.iterator().next() : BUnionType.create(null, tupleTypes);
                break;
            }
            case 32: {
                BFiniteType finiteIndexExpr = (BFiniteType)currentType;
                LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
                for (BLangExpression finiteMember : finiteIndexExpr.getValueSpace()) {
                    int indexValue = ((Long)((BLangLiteral)finiteMember).value).intValue();
                    BType fieldType = this.checkTupleFieldType(tuple, indexValue);
                    if (fieldType.tag == 27) continue;
                    possibleTypes.add(fieldType);
                }
                if (possibleTypes.size() == 0) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypes.size() == 1 ? (BType)possibleTypes.iterator().next() : BUnionType.create(null, possibleTypes);
                break;
            }
            case 20: {
                BFiniteType finiteType;
                LinkedHashSet<BType> possibleTypesByMember = new LinkedHashSet<BType>();
                ArrayList finiteTypes = new ArrayList();
                ((BUnionType)currentType).getMemberTypes().forEach(memType -> {
                    if (memType.tag == 32) {
                        finiteTypes.add((BFiniteType)memType);
                    } else {
                        BType possibleType = this.checkTupleIndexBasedAccess(accessExpr, tuple, (BType)memType);
                        if (possibleType.tag == 20) {
                            possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                        } else {
                            possibleTypesByMember.add(possibleType);
                        }
                    }
                });
                if (finiteTypes.size() == 1) {
                    finiteType = (BFiniteType)finiteTypes.get(0);
                } else {
                    LinkedHashSet<BLangExpression> valueSpace = new LinkedHashSet<BLangExpression>();
                    finiteTypes.forEach(constituent -> valueSpace.addAll(constituent.getValueSpace()));
                    finiteType = new BFiniteType(null, valueSpace);
                }
                BType possibleType = this.checkTupleIndexBasedAccess(accessExpr, tuple, finiteType);
                if (possibleType.tag == 20) {
                    possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                } else {
                    possibleTypesByMember.add(possibleType);
                }
                if (possibleTypesByMember.contains(this.symTable.semanticError)) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypesByMember.size() == 1 ? (BType)possibleTypesByMember.iterator().next() : BUnionType.create(null, possibleTypesByMember);
            }
        }
        return actualType;
    }

    private LinkedHashSet<BType> collectTupleFieldTypes(BTupleType tupleType, LinkedHashSet<BType> memberTypes) {
        tupleType.tupleTypes.forEach(memberType -> {
            if (memberType.tag == 20) {
                this.collectMemberTypes((BUnionType)memberType, memberTypes);
            } else {
                memberTypes.add((BType)memberType);
            }
        });
        return memberTypes;
    }

    private BType checkMappingIndexBasedAccess(BLangIndexBasedAccess accessExpr, BType type) {
        if (type.tag == 15) {
            BType constraint = ((BMapType)type).constraint;
            return accessExpr.lhsVar ? constraint : this.addNilForNillableAccessType(constraint);
        }
        if (type.tag == 12) {
            return this.checkRecordIndexBasedAccess(accessExpr, (BRecordType)type, accessExpr.indexExpr.type);
        }
        boolean nonMatchedRecordExists = false;
        LinkedHashSet<BType> fieldTypeMembers = new LinkedHashSet<BType>();
        for (BType memType : ((BUnionType)type).getMemberTypes()) {
            BType individualFieldType = this.checkMappingIndexBasedAccess(accessExpr, memType);
            if (individualFieldType == this.symTable.semanticError) {
                nonMatchedRecordExists = true;
                continue;
            }
            fieldTypeMembers.add(individualFieldType);
        }
        if (fieldTypeMembers.size() == 0) {
            return this.symTable.semanticError;
        }
        BType fieldType = fieldTypeMembers.size() == 1 ? (BType)fieldTypeMembers.iterator().next() : BUnionType.create(null, fieldTypeMembers);
        return nonMatchedRecordExists ? this.addNilForNillableAccessType(fieldType) : fieldType;
    }

    private BType checkRecordIndexBasedAccess(BLangIndexBasedAccess accessExpr, BRecordType record, BType currentType) {
        BType actualType = this.symTable.semanticError;
        BLangExpression indexExpr = accessExpr.indexExpr;
        switch (currentType.tag) {
            case 5: {
                if (this.isConst(indexExpr)) {
                    String fieldName = IdentifierUtils.escapeSpecialCharacters(this.getConstFieldName(indexExpr));
                    actualType = this.checkRecordRequiredFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                    if (actualType != this.symTable.semanticError) {
                        return actualType;
                    }
                    actualType = this.checkRecordOptionalFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                    if (actualType == this.symTable.semanticError) {
                        actualType = this.checkRecordRestFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                        if (actualType == this.symTable.semanticError) {
                            return actualType;
                        }
                        if (actualType == this.symTable.neverType) {
                            return actualType;
                        }
                        return this.addNilForNillableAccessType(actualType);
                    }
                    if (accessExpr.lhsVar) {
                        return actualType;
                    }
                    return this.addNilForNillableAccessType(actualType);
                }
                LinkedHashSet fieldTypes = record.fields.values().stream().map(field -> field.type).collect(Collectors.toCollection(LinkedHashSet::new));
                if (record.restFieldType.tag != 23) {
                    fieldTypes.add(record.restFieldType);
                }
                if (fieldTypes.stream().noneMatch(BType::isNullable)) {
                    fieldTypes.add(this.symTable.nilType);
                }
                actualType = BUnionType.create(null, fieldTypes);
                break;
            }
            case 32: {
                BFiniteType finiteIndexExpr = (BFiniteType)currentType;
                LinkedHashSet<BType> possibleTypes = new LinkedHashSet<BType>();
                for (BLangExpression finiteMember : finiteIndexExpr.getValueSpace()) {
                    String fieldName = (String)((BLangLiteral)finiteMember).value;
                    BType fieldType = this.checkRecordRequiredFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                    if (fieldType == this.symTable.semanticError) {
                        fieldType = this.checkRecordOptionalFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                        if (fieldType == this.symTable.semanticError) {
                            fieldType = this.checkRecordRestFieldAccess(accessExpr, this.names.fromString(fieldName), record);
                        }
                        if (fieldType != this.symTable.semanticError) {
                            fieldType = this.addNilForNillableAccessType(fieldType);
                        }
                    }
                    if (fieldType.tag == 27) continue;
                    possibleTypes.add(fieldType);
                }
                if (possibleTypes.isEmpty()) {
                    return this.symTable.semanticError;
                }
                if (possibleTypes.stream().noneMatch(BType::isNullable)) {
                    possibleTypes.add(this.symTable.nilType);
                }
                actualType = possibleTypes.size() == 1 ? (BType)possibleTypes.iterator().next() : BUnionType.create(null, possibleTypes);
                break;
            }
            case 20: {
                BFiniteType finiteType;
                LinkedHashSet<BType> possibleTypesByMember = new LinkedHashSet<BType>();
                ArrayList finiteTypes = new ArrayList();
                ((BUnionType)currentType).getMemberTypes().forEach(memType -> {
                    if (memType.tag == 32) {
                        finiteTypes.add((BFiniteType)memType);
                    } else {
                        BType possibleType = this.checkRecordIndexBasedAccess(accessExpr, record, (BType)memType);
                        if (possibleType.tag == 20) {
                            possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                        } else {
                            possibleTypesByMember.add(possibleType);
                        }
                    }
                });
                if (finiteTypes.size() == 1) {
                    finiteType = (BFiniteType)finiteTypes.get(0);
                } else {
                    LinkedHashSet<BLangExpression> valueSpace = new LinkedHashSet<BLangExpression>();
                    finiteTypes.forEach(constituent -> valueSpace.addAll(constituent.getValueSpace()));
                    finiteType = new BFiniteType(null, valueSpace);
                }
                BType possibleType = this.checkRecordIndexBasedAccess(accessExpr, record, finiteType);
                if (possibleType.tag == 20) {
                    possibleTypesByMember.addAll(((BUnionType)possibleType).getMemberTypes());
                } else {
                    possibleTypesByMember.add(possibleType);
                }
                if (possibleTypesByMember.contains(this.symTable.semanticError)) {
                    return this.symTable.semanticError;
                }
                actualType = possibleTypesByMember.size() == 1 ? (BType)possibleTypesByMember.iterator().next() : BUnionType.create(null, possibleTypesByMember);
            }
        }
        return actualType;
    }

    private BType getSafeType(BType type, BLangAccessExpression accessExpr) {
        if (type.tag != 20) {
            return type;
        }
        List<BType> lhsTypes = new ArrayList<BType>(((BUnionType)type).getMemberTypes());
        if (accessExpr.errorSafeNavigation) {
            if (!lhsTypes.contains(this.symTable.errorType)) {
                this.dlog.error(accessExpr.pos, DiagnosticErrorCode.SAFE_NAVIGATION_NOT_REQUIRED, type);
                return this.symTable.semanticError;
            }
            if ((lhsTypes = lhsTypes.stream().filter(memberType -> memberType != this.symTable.errorType).collect(Collectors.toList())).isEmpty()) {
                this.dlog.error(accessExpr.pos, DiagnosticErrorCode.SAFE_NAVIGATION_NOT_REQUIRED, type);
                return this.symTable.semanticError;
            }
        }
        if (accessExpr.nilSafeNavigation) {
            lhsTypes = lhsTypes.stream().filter(memberType -> memberType != this.symTable.nilType).collect(Collectors.toList());
        }
        if (lhsTypes.size() == 1) {
            return (BType)lhsTypes.get(0);
        }
        return BUnionType.create(null, new LinkedHashSet<BType>(lhsTypes));
    }

    private List<BType> getTypesList(BType type) {
        if (type.tag == 20) {
            BUnionType unionType = (BUnionType)type;
            return new ArrayList<BType>(unionType.getMemberTypes());
        }
        return Lists.of(type);
    }

    private LinkedHashSet<BType> getMatchExpressionTypes(BLangMatchExpression bLangMatchExpression) {
        List<BType> exprTypes = this.getTypesList(bLangMatchExpression.expr.type);
        LinkedHashSet<BType> matchExprTypes = new LinkedHashSet<BType>();
        for (BType type : exprTypes) {
            boolean assignable = false;
            for (BLangMatchExpression.BLangMatchExprPatternClause pattern : bLangMatchExpression.patternClauses) {
                BType patternExprType = pattern.expr.type;
                matchExprTypes.addAll(this.getTypesList(patternExprType));
                if (type.tag == 27 || patternExprType.tag == 27) {
                    return new LinkedHashSet<BType>(){
                        {
                            this.add(TypeChecker.this.symTable.semanticError);
                        }
                    };
                }
                assignable = this.types.isAssignable(type, pattern.variable.type);
                if (!assignable) continue;
                break;
            }
            if (assignable) continue;
            matchExprTypes.add(type);
        }
        return matchExprTypes;
    }

    private boolean couldHoldTableValues(BType type, List<BType> encounteredTypes) {
        if (encounteredTypes.contains(type)) {
            return false;
        }
        encounteredTypes.add(type);
        switch (type.tag) {
            case 20: {
                for (BType bType1 : ((BUnionType)type).getMemberTypes()) {
                    if (!this.couldHoldTableValues(bType1, encounteredTypes)) continue;
                    return true;
                }
                return false;
            }
            case 15: {
                return this.couldHoldTableValues(((BMapType)type).constraint, encounteredTypes);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.fields.values()) {
                    if (!this.couldHoldTableValues(field.type, encounteredTypes)) continue;
                    return true;
                }
                return !recordType.sealed && this.couldHoldTableValues(recordType.restFieldType, encounteredTypes);
            }
            case 19: {
                return this.couldHoldTableValues(((BArrayType)type).eType, encounteredTypes);
            }
            case 30: {
                for (BType bType : ((BTupleType)type).getTupleTypes()) {
                    if (!this.couldHoldTableValues(bType, encounteredTypes)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isConst(BLangExpression expression) {
        if (ConstantAnalyzer.isValidConstantExpressionNode(expression)) {
            return true;
        }
        if (expression.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        return (((BLangSimpleVarRef)expression).symbol.tag & 0x200001C) == 33554460;
    }

    private Name getCurrentCompUnit(BLangNode node) {
        return this.names.fromString(node.pos.lineRange().filePath());
    }

    private BType getRepresentativeBroadType(List<BType> inferredTypeList) {
        block0: for (int i = 0; i < inferredTypeList.size(); ++i) {
            BType type = inferredTypeList.get(i);
            if (type.tag == 27) {
                return type;
            }
            for (int j = i + 1; j < inferredTypeList.size(); ++j) {
                BType otherType = inferredTypeList.get(j);
                if (otherType.tag == 27) {
                    return otherType;
                }
                if (this.types.isAssignable(otherType, type)) {
                    inferredTypeList.remove(j);
                    --j;
                    continue;
                }
                if (!this.types.isAssignable(type, otherType)) continue;
                inferredTypeList.remove(i);
                --i;
                continue block0;
            }
        }
        if (inferredTypeList.size() == 1) {
            return inferredTypeList.get(0);
        }
        return BUnionType.create(null, inferredTypeList.toArray(new BType[0]));
    }

    private BType defineInferredRecordType(BLangRecordLiteral recordLiteral, BType expType) {
        PackageID pkgID = this.env.enclPkg.symbol.pkgID;
        BRecordTypeSymbol recordSymbol = this.createRecordTypeSymbol(pkgID, recordLiteral.pos, SymbolOrigin.VIRTUAL);
        LinkedHashMap<String, FieldInfo> nonRestFieldTypes = new LinkedHashMap<String, FieldInfo>();
        ArrayList<BType> restFieldTypes = new ArrayList<BType>();
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangRecordLiteral.BLangRecordKey bLangRecordKey = keyValue.key;
                BLangExpression expression = keyValue.valueExpr;
                BLangExpression keyExpr = bLangRecordKey.expr;
                if (bLangRecordKey.computedKey) {
                    this.checkExpr(keyExpr, this.env, this.symTable.stringType);
                    BType exprType = this.checkExpr(expression, this.env, expType);
                    if (!this.isUniqueType(restFieldTypes, exprType)) continue;
                    restFieldTypes.add(exprType);
                    continue;
                }
                this.addToNonRestFieldTypes(nonRestFieldTypes, this.getKeyName(keyExpr), keyValue.readonly ? this.checkExpr(expression, this.env, this.symTable.readonlyType) : this.checkExpr(expression, this.env, expType), true, keyValue.readonly);
                continue;
            }
            if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                BType restFieldType;
                BType constraintType;
                BType type = this.checkExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, this.env, expType);
                int n = type.tag;
                if (n == 15 && this.isUniqueType(restFieldTypes, constraintType = ((BMapType)type).constraint)) {
                    restFieldTypes.add(constraintType);
                }
                if (type.tag != 12) continue;
                BRecordType recordType = (BRecordType)type;
                for (BField recField : recordType.fields.values()) {
                    this.addToNonRestFieldTypes(nonRestFieldTypes, recField.name.value, recField.type, !Symbols.isOptional(recField.symbol), false);
                }
                if (recordType.sealed || !this.isUniqueType(restFieldTypes, restFieldType = recordType.restFieldType)) continue;
                restFieldTypes.add(restFieldType);
                continue;
            }
            BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
            this.addToNonRestFieldTypes(nonRestFieldTypes, this.getKeyName(varNameField), varNameField.readonly ? this.checkExpr(varNameField, this.env, this.symTable.readonlyType) : this.checkExpr(varNameField, this.env, expType), true, varNameField.readonly);
        }
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        boolean allReadOnlyNonRestFields = true;
        for (Map.Entry entry : nonRestFieldTypes.entrySet()) {
            FieldInfo fieldInfo = (FieldInfo)entry.getValue();
            List<BType> types = fieldInfo.types;
            if (types.contains(this.symTable.semanticError)) {
                return this.symTable.semanticError;
            }
            String key = (String)entry.getKey();
            Name fieldName = this.names.fromString(key);
            BType type = types.size() == 1 ? types.get(0) : BUnionType.create(null, types.toArray(new BType[0]));
            HashSet<Flag> flags = new HashSet<Flag>();
            if (fieldInfo.required) {
                flags.add(Flag.REQUIRED);
            } else {
                flags.add(Flag.OPTIONAL);
            }
            if (fieldInfo.readonly) {
                flags.add(Flag.READONLY);
            } else if (allReadOnlyNonRestFields) {
                allReadOnlyNonRestFields = false;
            }
            BVarSymbol fieldSymbol = new BVarSymbol(Flags.asMask(flags), fieldName, pkgID, type, recordSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            fields.put(fieldName.value, new BField(fieldName, null, fieldSymbol));
            recordSymbol.scope.define(fieldName, fieldSymbol);
        }
        BRecordType recordType = new BRecordType(recordSymbol);
        recordType.fields = fields;
        if (restFieldTypes.contains(this.symTable.semanticError)) {
            return this.symTable.semanticError;
        }
        if (restFieldTypes.isEmpty()) {
            recordType.sealed = true;
            recordType.restFieldType = this.symTable.noType;
        } else {
            recordType.restFieldType = restFieldTypes.size() == 1 ? (BType)restFieldTypes.get(0) : BUnionType.create(null, restFieldTypes.toArray(new BType[0]));
        }
        recordSymbol.type = recordType;
        recordType.tsymbol = recordSymbol;
        if (expType == this.symTable.readonlyType || recordType.sealed && allReadOnlyNonRestFields) {
            recordType.flags |= 0x20L;
            recordSymbol.flags |= 0x20L;
        }
        BLangRecordTypeNode bLangRecordTypeNode = TypeDefBuilderHelper.createRecordTypeNode(recordType, pkgID, this.symTable, recordLiteral.pos);
        bLangRecordTypeNode.initFunction = TypeDefBuilderHelper.createInitFunctionForRecordType(bLangRecordTypeNode, this.env, this.names, this.symTable);
        TypeDefBuilderHelper.addTypeDefinition(recordType, recordSymbol, bLangRecordTypeNode, this.env);
        return recordType;
    }

    private BRecordTypeSymbol createRecordTypeSymbol(PackageID pkgID, Location location, SymbolOrigin origin) {
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(2048L, this.names.fromString(this.anonymousModelHelper.getNextAnonymousTypeKey(pkgID)), pkgID, null, this.env.scope.owner, location, origin);
        BInvokableType bInvokableType = new BInvokableType(new ArrayList<BType>(), this.symTable.nilType, null);
        BInvokableSymbol initFuncSymbol = Symbols.createFunctionSymbol(1L, Names.EMPTY, this.env.enclPkg.symbol.pkgID, bInvokableType, this.env.scope.owner, false, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        initFuncSymbol.retType = this.symTable.nilType;
        recordSymbol.initializerFunc = new BAttachedFunction(Names.INIT_FUNCTION_SUFFIX, initFuncSymbol, bInvokableType, location);
        recordSymbol.scope = new Scope(recordSymbol);
        recordSymbol.scope.define(this.names.fromString(recordSymbol.name.value + "." + recordSymbol.initializerFunc.funcName.value), recordSymbol.initializerFunc.symbol);
        return recordSymbol;
    }

    private String getKeyName(BLangExpression key) {
        return key.getKind() == NodeKind.SIMPLE_VARIABLE_REF ? ((BLangSimpleVarRef)key).variableName.value : (String)((BLangLiteral)key).value;
    }

    private void addToNonRestFieldTypes(Map<String, FieldInfo> nonRestFieldTypes, String keyString, final BType exprType, boolean required, boolean readonly) {
        if (!nonRestFieldTypes.containsKey(keyString)) {
            nonRestFieldTypes.put(keyString, new FieldInfo((List<BType>)new ArrayList<BType>(){
                {
                    this.add(exprType);
                }
            }, required, readonly));
            return;
        }
        FieldInfo fieldInfo = nonRestFieldTypes.get(keyString);
        List<BType> typeList = fieldInfo.types;
        if (this.isUniqueType(typeList, exprType)) {
            typeList.add(exprType);
        }
        if (required && !fieldInfo.required) {
            fieldInfo.required = true;
        }
    }

    private boolean isUniqueType(List<BType> typeList, BType type) {
        boolean isRecord = type.tag == 12;
        for (BType bType : typeList) {
            if (!(isRecord ? type == bType : this.types.isSameType(type, bType))) continue;
            return false;
        }
        return true;
    }

    private BType checkXmlSubTypeLiteralCompatibility(Location location, BXMLSubType mutableXmlSubType, BType expType) {
        boolean unionExpType;
        if (expType == this.symTable.semanticError) {
            return expType;
        }
        boolean bl = unionExpType = expType.tag == 20;
        if (expType == mutableXmlSubType) {
            return expType;
        }
        if (!unionExpType && this.types.isAssignable(mutableXmlSubType, expType)) {
            return mutableXmlSubType;
        }
        BXMLSubType immutableXmlSubType = (BXMLSubType)ImmutableTypeCloner.getEffectiveImmutableType(location, this.types, mutableXmlSubType, this.env, this.symTable, this.anonymousModelHelper, this.names);
        if (expType == immutableXmlSubType) {
            return expType;
        }
        if (!unionExpType && this.types.isAssignable(immutableXmlSubType, expType)) {
            return immutableXmlSubType;
        }
        if (!unionExpType) {
            this.dlog.error(location, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, mutableXmlSubType);
            return this.symTable.semanticError;
        }
        ArrayList<BType> compatibleTypes = new ArrayList<BType>();
        for (BType memberType : ((BUnionType)expType).getMemberTypes()) {
            if (compatibleTypes.contains(memberType)) continue;
            if (memberType == mutableXmlSubType || memberType == immutableXmlSubType) {
                compatibleTypes.add(memberType);
                continue;
            }
            if (this.types.isAssignable(mutableXmlSubType, memberType) && !compatibleTypes.contains(mutableXmlSubType)) {
                compatibleTypes.add(mutableXmlSubType);
                continue;
            }
            if (!this.types.isAssignable(immutableXmlSubType, memberType) || compatibleTypes.contains(immutableXmlSubType)) continue;
            compatibleTypes.add(immutableXmlSubType);
        }
        if (compatibleTypes.isEmpty()) {
            this.dlog.error(location, DiagnosticErrorCode.INCOMPATIBLE_TYPES, expType, mutableXmlSubType);
            return this.symTable.semanticError;
        }
        if (compatibleTypes.size() == 1) {
            return (BType)compatibleTypes.get(0);
        }
        this.dlog.error(location, DiagnosticErrorCode.AMBIGUOUS_TYPES, expType);
        return this.symTable.semanticError;
    }

    private void markChildrenAsImmutable(BLangXMLElementLiteral bLangXMLElementLiteral) {
        for (BLangExpression modifiedChild : bLangXMLElementLiteral.modifiedChildren) {
            BType childType = modifiedChild.type;
            if (Symbols.isFlagOn(childType.flags, 32L) || !this.types.isSelectivelyImmutableType(childType)) continue;
            modifiedChild.type = ImmutableTypeCloner.getEffectiveImmutableType(modifiedChild.pos, this.types, (SelectivelyImmutableReferenceType)((Object)childType), this.env, this.symTable, this.anonymousModelHelper, this.names);
            if (modifiedChild.getKind() != NodeKind.XML_ELEMENT_LITERAL) continue;
            this.markChildrenAsImmutable((BLangXMLElementLiteral)modifiedChild);
        }
    }

    private void logUndefinedSymbolError(Location pos, String name) {
        if (!this.missingNodesHelper.isMissingNode(name)) {
            this.dlog.error(pos, DiagnosticErrorCode.UNDEFINED_SYMBOL, name);
        }
    }

    private void markTypeAsIsolated(BType actualType) {
        actualType.flags |= 0x20000000L;
        actualType.tsymbol.flags |= 0x20000000L;
    }

    private boolean isObjectConstructorExpr(BLangTypeInit cIExpr, BType actualType) {
        return cIExpr.getType() != null && Symbols.isFlagOn(actualType.tsymbol.flags, 2048L);
    }

    private BLangClassDefinition getClassDefinitionForObjectConstructorExpr(BLangTypeInit cIExpr, SymbolEnv env) {
        List<BLangClassDefinition> classDefinitions = env.enclPkg.classDefinitions;
        BLangUserDefinedType userDefinedType = (BLangUserDefinedType)cIExpr.getType();
        BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(userDefinedType.pos, env, this.names.fromIdNode(userDefinedType.pkgAlias), this.names.fromIdNode(userDefinedType.typeName));
        for (BLangClassDefinition classDefinition : classDefinitions) {
            if (classDefinition.symbol != symbol) continue;
            return classDefinition;
        }
        return null;
    }

    private void handleObjectConstrExprForReadOnlyCET(BLangTypeInit cIExpr, BObjectType actualObjectType, BLangClassDefinition classDefForConstructor, SymbolEnv env) {
        for (BField field : actualObjectType.fields.values()) {
            BType fieldType = field.type;
            if (this.types.isInherentlyImmutableType(fieldType) || this.types.isSelectivelyImmutableType(fieldType, false, false)) continue;
            this.semanticAnalyzer.analyzeNode(classDefForConstructor, env);
            return;
        }
        classDefForConstructor.flagSet.add(Flag.READONLY);
        actualObjectType.flags |= 0x20L;
        actualObjectType.tsymbol.flags |= 0x20L;
        ImmutableTypeCloner.markFieldsAsImmutable(classDefForConstructor, env, actualObjectType, this.types, this.anonymousModelHelper, this.symTable, this.names, cIExpr.pos);
        this.semanticAnalyzer.analyzeNode(classDefForConstructor, env);
    }

    private void markConstructedObjectIsolatedness(BObjectType actualObjectType) {
        if (Symbols.isFlagOn(actualObjectType.flags, 32L)) {
            this.markTypeAsIsolated(actualObjectType);
            return;
        }
        for (BField field : actualObjectType.fields.values()) {
            if (Symbols.isFlagOn(field.symbol.flags, 4L) && this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(field.type)) continue;
            return;
        }
        this.markTypeAsIsolated(actualObjectType);
    }

    static {
        listLengthModifierFunctions.add(FUNCTION_NAME_PUSH);
        listLengthModifierFunctions.add(FUNCTION_NAME_POP);
        listLengthModifierFunctions.add(FUNCTION_NAME_SHIFT);
        listLengthModifierFunctions.add(FUNCTION_NAME_UNSHIFT);
        modifierFunctions.put(LIST_LANG_LIB, new HashSet<String>(){
            {
                this.add("remove");
                this.add("removeAll");
                this.add("setLength");
                this.add("reverse");
                this.add("sort");
                this.add(TypeChecker.FUNCTION_NAME_POP);
                this.add(TypeChecker.FUNCTION_NAME_PUSH);
                this.add(TypeChecker.FUNCTION_NAME_SHIFT);
                this.add(TypeChecker.FUNCTION_NAME_UNSHIFT);
            }
        });
        modifierFunctions.put(MAP_LANG_LIB, new HashSet<String>(){
            {
                this.add("remove");
                this.add("removeIfHasKey");
                this.add("removeAll");
            }
        });
        modifierFunctions.put(TABLE_LANG_LIB, new HashSet<String>(){
            {
                this.add("put");
                this.add("add");
                this.add("remove");
                this.add("removeIfHasKey");
                this.add("removeAll");
            }
        });
        modifierFunctions.put(VALUE_LANG_LIB, new HashSet<String>(){
            {
                this.add("mergeJson");
            }
        });
        modifierFunctions.put(XML_LANG_LIB, new HashSet<String>(){
            {
                this.add("setName");
                this.add("setChildren");
                this.add("strip");
            }
        });
    }

    private static class FieldInfo {
        List<BType> types;
        boolean required;
        boolean readonly;

        private FieldInfo(List<BType> types, boolean required, boolean readonly) {
            this.types = types;
            this.required = required;
            this.readonly = readonly;
        }
    }
}

