/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;

public class TaintRecord {
    public TaintedStatus returnTaintedStatus;
    public List<TaintedStatus> parameterTaintedStatusList;
    public List<TaintError> taintError;

    public TaintRecord(List<TaintError> taintError) {
        this.taintError = taintError;
    }

    public TaintRecord(TaintedStatus returnTaintedStatus, List<TaintedStatus> parameterTaintedStatusList) {
        this.returnTaintedStatus = returnTaintedStatus;
        this.parameterTaintedStatusList = parameterTaintedStatusList;
    }

    public static enum TaintAnnotation {
        NON,
        TAINTED,
        UNTAINTED;

    }

    public static class TaintError {
        public Location pos;
        public List<String> paramName;
        public DiagnosticCode diagnosticCode;

        public TaintError(Location location, String paramName, DiagnosticCode diagnosticCode) {
            this.pos = location;
            this.paramName = new ArrayList<String>(1);
            this.paramName.add(paramName);
            this.diagnosticCode = diagnosticCode;
        }

        public TaintError(Location location, List<String> paramName, DiagnosticCode diagnosticCode) {
            this.pos = location;
            this.paramName = paramName;
            this.diagnosticCode = diagnosticCode;
        }

        public TaintError(Location pos, String paramName, String paramName2, DiagnosticCode diagnosticCode) {
            this.pos = pos;
            this.paramName = new ArrayList<String>(1);
            this.paramName.add(paramName);
            this.paramName.add(paramName2);
            this.diagnosticCode = diagnosticCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaintError that = (TaintError)o;
            if (!this.pos.toString().equals(that.pos.toString())) {
                return false;
            }
            if (!this.paramName.equals(that.paramName)) {
                return false;
            }
            return this.diagnosticCode == that.diagnosticCode;
        }

        public int hashCode() {
            int result = this.pos.toString().hashCode();
            result = 31 * result + this.paramName.hashCode();
            result = 31 * result + this.diagnosticCode.hashCode();
            return result;
        }
    }

    public static enum TaintedStatus {
        UNTAINTED(0),
        TAINTED(1),
        IGNORED(2);

        private final byte byteValue;

        private TaintedStatus(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte getByteValue() {
            return this.byteValue;
        }
    }
}

