/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import org.ballerinalang.model.types.ArrayType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.BArrayState;

public class BArrayType
extends BType
implements ArrayType {
    private static final String SEMI_COLON = ";";
    public BType eType;
    public BIntersectionType immutableType;
    public int size = -1;
    public BArrayState state = BArrayState.OPEN;

    public BArrayType(BType elementType) {
        super(19, null);
        this.eType = elementType;
    }

    public BArrayType(BType elementType, BTypeSymbol tsymbol) {
        super(19, tsymbol);
        this.eType = elementType;
    }

    public BArrayType(BType elementType, BTypeSymbol tsymbol, int size, BArrayState state) {
        super(19, tsymbol);
        this.eType = elementType;
        this.size = size;
        this.state = state;
    }

    public BArrayType(BType elementType, BTypeSymbol tsymbol, int size, BArrayState state, long flags) {
        super(19, tsymbol, flags);
        this.eType = elementType;
        this.size = size;
        this.state = state;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public BType getElementType() {
        return this.eType;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ARRAY;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        String tempSize;
        StringBuilder sb = new StringBuilder(this.eType.toString());
        String string = tempSize = this.state == BArrayState.INFERRED ? "*" : String.valueOf(this.size);
        if (this.eType.tag == 19) {
            if (this.state != BArrayState.OPEN) {
                sb.insert(sb.indexOf("["), "[" + tempSize + "]");
            } else {
                sb.insert(sb.indexOf("["), "[]");
            }
        } else if (this.state != BArrayState.OPEN) {
            sb.append("[").append(tempSize).append("]");
        } else {
            sb.append("[]");
        }
        return !Symbols.isFlagOn(this.flags, 32L) ? sb.toString() : sb.append(" & readonly").toString();
    }

    @Override
    public final boolean isAnydata() {
        return this.eType.isPureType();
    }

    @Override
    public BIntersectionType getImmutableType() {
        return this.immutableType;
    }
}

