/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.Optional;
import org.ballerinalang.model.types.RecordType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BRecordType
extends BStructureType
implements RecordType {
    private static final String SPACE = " ";
    private static final String RECORD = "record";
    private static final String CLOSE_LEFT = "{|";
    private static final String SEMI = ";";
    private static final String CLOSE_RIGHT = "|}";
    private static final String REST = "...";
    public static final String OPTIONAL = "?";
    public static final String EMPTY = "";
    public static final String READONLY = "readonly";
    public boolean sealed;
    public BType restFieldType;
    private Optional<Boolean> isAnyData = Optional.empty();
    private boolean resolving = false;
    public BIntersectionType immutableType;
    public BRecordType mutableType;

    public BRecordType(BTypeSymbol tSymbol) {
        super(12, tSymbol);
    }

    public BRecordType(BTypeSymbol tSymbol, long flags) {
        super(12, tSymbol, flags);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.RECORD;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        if (this.shouldPrintShape(this.tsymbol.name)) {
            StringBuilder sb = new StringBuilder();
            sb.append(RECORD).append(SPACE).append(CLOSE_LEFT);
            for (BField field : this.fields.values()) {
                sb.append(SPACE);
                if (Symbols.isFlagOn(field.symbol.flags, 32L)) {
                    sb.append(READONLY).append(SPACE);
                }
                sb.append(field.type).append(SPACE).append(field.name).append(Symbols.isOptional(field.symbol) ? OPTIONAL : EMPTY).append(SEMI);
            }
            if (this.sealed) {
                sb.append(SPACE).append(CLOSE_RIGHT);
                return !Symbols.isFlagOn(this.flags, 32L) ? sb.toString() : sb.toString().concat(" & readonly");
            }
            sb.append(SPACE).append(this.restFieldType).append(REST).append(SEMI).append(SPACE).append(CLOSE_RIGHT);
            return !Symbols.isFlagOn(this.flags, 32L) ? sb.toString() : sb.toString().concat(" & readonly");
        }
        return this.tsymbol.toString();
    }

    @Override
    public final boolean isAnydata() {
        if (!this.isAnyData.isPresent()) {
            if (this.resolving) {
                return true;
            }
            this.resolving = true;
            this.isAnyData = Optional.of(this.findIsAnyData());
            this.resolving = false;
        }
        return this.isAnyData.get();
    }

    private boolean findIsAnyData() {
        for (BField field : this.fields.values()) {
            if (field.type.isPureType()) continue;
            return false;
        }
        return this.sealed || this.restFieldType.isPureType();
    }

    @Override
    public BIntersectionType getImmutableType() {
        return this.immutableType;
    }
}

