/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;

public class BTypeIdSet {
    public final Set<BTypeId> primary;
    public final Set<BTypeId> secondary;
    private Set<BTypeId> all = null;
    private static final Set<BTypeId> emptySet = Collections.unmodifiableSet(new HashSet());
    private static final BTypeIdSet empty = new BTypeIdSet(emptySet);

    public BTypeIdSet(Set<BTypeId> primary, Set<BTypeId> secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    public BTypeIdSet(Set<BTypeId> primary) {
        this(primary, new HashSet<BTypeId>());
    }

    public BTypeIdSet() {
        this(new HashSet<BTypeId>(), new HashSet<BTypeId>());
    }

    public static BTypeIdSet from(PackageID packageID, String typeId, boolean publicId) {
        HashSet<BTypeId> set = new HashSet<BTypeId>();
        set.add(new BTypeId(packageID, typeId, publicId));
        return new BTypeIdSet(set);
    }

    public static BTypeIdSet from(PackageID packageID, String typeId, boolean publicId, BTypeIdSet secondary) {
        HashSet<BTypeId> primarySet = new HashSet<BTypeId>();
        primarySet.add(new BTypeId(packageID, typeId, publicId));
        HashSet<BTypeId> secondarySet = new HashSet<BTypeId>(secondary.primary);
        secondarySet.addAll(secondary.secondary);
        return new BTypeIdSet(primarySet, secondarySet);
    }

    public static BTypeIdSet emptySet() {
        return empty;
    }

    public boolean isAssignableFrom(BTypeIdSet sourceTypeIdSet) {
        HashSet<BTypeId> tAll;
        if (sourceTypeIdSet == null) {
            return false;
        }
        if (sourceTypeIdSet == this) {
            return true;
        }
        if (this.all == null) {
            tAll = new HashSet<BTypeId>(this.primary);
            tAll.addAll(this.secondary);
            this.all = tAll;
        }
        if (sourceTypeIdSet.all == null) {
            tAll = new HashSet<BTypeId>(sourceTypeIdSet.primary);
            tAll.addAll(sourceTypeIdSet.secondary);
            sourceTypeIdSet.all = tAll;
        }
        return sourceTypeIdSet.all.containsAll(this.all);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BTypeIdSet)) {
            return false;
        }
        BTypeIdSet that = (BTypeIdSet)obj;
        return this.primary.equals(that.primary) && this.secondary.equals(that.secondary);
    }

    public int hashCode() {
        int hashCode = 1;
        for (BTypeId bTypeId : this.primary) {
            hashCode = hashCode * 31 + bTypeId.hashCode();
        }
        for (BTypeId bTypeId : this.secondary) {
            hashCode = hashCode * 31 + bTypeId.hashCode();
        }
        return hashCode;
    }

    public boolean isEmpty() {
        if (this.primary == emptySet && this.secondary == emptySet) {
            return true;
        }
        return this.primary.isEmpty() && this.secondary.isEmpty();
    }

    public static class BTypeId {
        public final PackageID packageID;
        public final String name;
        public final boolean publicId;

        public BTypeId(PackageID packageID, String name, boolean publicId) {
            this.packageID = packageID;
            this.name = name;
            this.publicId = publicId;
        }

        public int hashCode() {
            return this.packageID.hashCode() * 31 + this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BTypeId) {
                BTypeId that = (BTypeId)obj;
                return this.name.equals(that.name) && this.packageID.equals(that.packageID);
            }
            return false;
        }

        public String toString() {
            return "BTypeId { " + this.packageID.toString() + "/" + this.name + "}";
        }
    }
}

