/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.FieldBasedAccessNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.FieldKind;

public class BLangFieldBasedAccess
extends BLangAccessExpression
implements FieldBasedAccessNode {
    public BLangIdentifier field;
    public FieldKind fieldKind;
    public BVarSymbol varSymbol;
    public boolean isStoreOnCreation = false;

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public BLangIdentifier getFieldName() {
        return this.field;
    }

    @Override
    public boolean isOptionalFieldAccess() {
        return this.optionalFieldAccess;
    }

    public String toString() {
        return String.valueOf(this.expr) + "." + String.valueOf(this.field);
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.FIELD_BASED_ACCESS_EXPR;
    }

    public static class BLangNSPrefixedFieldBasedAccess
    extends BLangFieldBasedAccess {
        public BLangIdentifier nsPrefix;
        public BXMLNSSymbol nsSymbol;

        @Override
        public String toString() {
            return String.valueOf(this.expr) + "." + String.valueOf(this.nsPrefix) + ":" + String.valueOf(this.field);
        }
    }

    public static class BLangStructFunctionVarRef
    extends BLangFieldBasedAccess {
        public BLangStructFunctionVarRef(BLangExpression varRef, BVarSymbol varSymbol) {
            this.expr = varRef;
            this.symbol = varSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

