/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;

public class BLangObjectConstructorExpression
extends BLangExpression {
    public BLangClassDefinition classNode;
    public BLangTypeInit typeInit;
    public BLangType referenceType;
    public boolean isClient = false;

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.OBJECT_CTOR_EXPRESSION;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        if (this.isClient) {
            sb.append("client ");
        }
        sb.append("object ");
        if (this.referenceType != null && this.referenceType.type.name != null) {
            sb.append(this.referenceType.type.name.getValue());
        }
        sb.append(" {");
        sb.append(this.classNode.toString());
        sb.append("};\n");
        return sb.toString();
    }

    public void addTypeReference(TypeNode type) {
        if (this.referenceType == null) {
            this.referenceType = (BLangType)type;
            this.classNode.addTypeReference(type);
            return;
        }
        throw new RuntimeException("object-constructor-expr can only have one type-reference");
    }
}

