/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.Names;

public class ProjectDirs {
    private static PathMatcher sourceFileMatcher = FileSystems.getDefault().getPathMatcher("glob:*.bal");
    private static PathMatcher testFileMatcher = FileSystems.getDefault().getPathMatcher("glob:../src/*/tests/**.bal");
    private static PathMatcher testResourceFileMatcher = FileSystems.getDefault().getPathMatcher("glob:../src/*/tests/resources/**.bal");

    public static boolean isSourceFile(Path path) {
        return !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && sourceFileMatcher.matches(path);
    }

    public static Path getLastComp(Path path) {
        return path.getName(path.getNameCount() - 1);
    }

    public static BLangCompilerException getPackageNotFoundError(PackageID packageID) {
        if (packageID.isUnnamed) {
            return new BLangCompilerException("cannot find file '" + packageID + "'");
        }
        return new BLangCompilerException("cannot find module '" + packageID + "'");
    }

    public static BLangCompilerException getPackageNotFoundError(String sourcePackage) {
        if (sourcePackage.endsWith(".bal")) {
            return new BLangCompilerException("cannot find file '" + sourcePackage + "'");
        }
        return new BLangCompilerException("cannot find module '" + sourcePackage + "'");
    }

    public static boolean containsSourceFiles(Path pkgPath) throws BLangCompilerException {
        List<Object> sourceFiles = new ArrayList();
        try {
            sourceFiles = Files.find(pkgPath, Integer.MAX_VALUE, (path, attrs) -> path.toString().endsWith(".bal"), new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException iOException) {
        }
        catch (UncheckedIOException e) {
            if (e.getCause() instanceof AccessDeniedException) {
                throw new BLangCompilerException("permission denied for path " + pkgPath.toString() + ", cause: " + e.getMessage());
            }
            throw e;
        }
        return sourceFiles.size() > 0;
    }

    public static boolean isTestSource(Path sourcePath, Path sourceRoot, String pkg) {
        if (Names.DOT.value.equals(pkg)) {
            return false;
        }
        if (!ProjectDirs.isModuleExist(sourceRoot, pkg)) {
            return false;
        }
        Path pkgPath = sourceRoot.resolve(pkg);
        Path relativizePath = pkgPath.relativize(sourcePath);
        return testFileMatcher.matches(relativizePath) && !testResourceFileMatcher.matches(relativizePath);
    }

    public static boolean isProject(Path path) {
        return Files.exists(path.resolve("Ballerina.toml"), new LinkOption[0]);
    }

    public static Path findProjectRoot(Path projectDir) {
        Path path = projectDir.resolve("Ballerina.toml");
        if (Files.exists(path, new LinkOption[0])) {
            return projectDir;
        }
        Path parentsParent = projectDir.getParent();
        if (null != parentsParent) {
            return ProjectDirs.findProjectRoot(parentsParent);
        }
        return null;
    }

    public static boolean isModuleExist(Path projectPath, String moduleName) {
        Path modulePath = projectPath.resolve("src").resolve(moduleName);
        return Files.exists(modulePath, new LinkOption[0]);
    }
}

