/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.util;

import java.util.HashSet;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;

public class Flags {
    public static final long PUBLIC = 1L;
    public static final long NATIVE = 2L;
    public static final long FINAL = 4L;
    public static final long ATTACHED = 8L;
    public static final long DEPRECATED = 16L;
    public static final long READONLY = 32L;
    public static final long FUNCTION_FINAL = 64L;
    public static final long INTERFACE = 128L;
    public static final long REQUIRED = 256L;
    public static final long RECORD = 512L;
    public static final long PRIVATE = 1024L;
    public static final long ANONYMOUS = 2048L;
    public static final long OPTIONAL = 4096L;
    public static final long TESTABLE = 8192L;
    public static final long CONSTANT = 16384L;
    public static final long REMOTE = 32768L;
    public static final long CLIENT = 65536L;
    public static final long RESOURCE = 131072L;
    public static final long SERVICE = 262144L;
    public static final long LISTENER = 524288L;
    public static final long LAMBDA = 0x100000L;
    public static final long TYPE_PARAM = 0x200000L;
    public static final long LANG_LIB = 0x400000L;
    public static final long WORKER = 0x800000L;
    public static final long FORKED = 0x1000000L;
    public static final long TRANSACTIONAL = 0x2000000L;
    public static final long PARAMETERIZED = 0x4000000L;
    public static final long DISTINCT = 0x8000000L;
    public static final long CLASS = 0x10000000L;
    public static final long ISOLATED = 0x20000000L;
    public static final long ISOLATED_PARAM = 0x40000000L;
    public static final long CONFIGURABLE = 0x80000000L;

    public static int asMask(Set<Flag> flagSet) {
        int mask = 0;
        for (Flag flag : flagSet) {
            switch (flag) {
                case PUBLIC: {
                    mask = (int)((long)mask | 1L);
                    break;
                }
                case PRIVATE: {
                    mask = (int)((long)mask | 0x400L);
                    break;
                }
                case REMOTE: {
                    mask = (int)((long)mask | 0x8000L);
                    break;
                }
                case NATIVE: {
                    mask = (int)((long)mask | 2L);
                    break;
                }
                case FINAL: {
                    mask = (int)((long)mask | 4L);
                    break;
                }
                case ATTACHED: {
                    mask = (int)((long)mask | 8L);
                    break;
                }
                case READONLY: {
                    mask = (int)((long)mask | 0x20L);
                    break;
                }
                case FUNCTION_FINAL: {
                    mask = (int)((long)mask | 0x40L);
                    break;
                }
                case INTERFACE: {
                    mask = (int)((long)mask | 0x80L);
                    break;
                }
                case REQUIRED: {
                    mask = (int)((long)mask | 0x100L);
                    break;
                }
                case RECORD: {
                    mask = (int)((long)mask | 0x200L);
                    break;
                }
                case ANONYMOUS: {
                    mask = (int)((long)mask | 0x800L);
                    break;
                }
                case OPTIONAL: {
                    mask = (int)((long)mask | 0x1000L);
                    break;
                }
                case TESTABLE: {
                    mask = (int)((long)mask | 0x2000L);
                    break;
                }
                case CLIENT: {
                    mask = (int)((long)mask | 0x10000L);
                    break;
                }
                case RESOURCE: {
                    mask = (int)((long)mask | 0x20000L);
                    break;
                }
                case SERVICE: {
                    mask = (int)((long)mask | 0x40000L);
                    break;
                }
                case LISTENER: {
                    mask = (int)((long)mask | 0x80000L);
                    break;
                }
                case CONSTANT: {
                    mask = (int)((long)mask | 0x4000L);
                    break;
                }
                case LAMBDA: {
                    mask = (int)((long)mask | 0x100000L);
                    break;
                }
                case TYPE_PARAM: {
                    mask = (int)((long)mask | 0x200000L);
                    break;
                }
                case LANG_LIB: {
                    mask = (int)((long)mask | 0x400000L);
                    break;
                }
                case WORKER: {
                    mask = (int)((long)mask | 0x800000L);
                    break;
                }
                case FORKED: {
                    mask = (int)((long)mask | 0x1000000L);
                    break;
                }
                case TRANSACTIONAL: {
                    mask = (int)((long)mask | 0x2000000L);
                    break;
                }
                case DISTINCT: {
                    mask = (int)((long)mask | 0x8000000L);
                    break;
                }
                case CLASS: {
                    mask = (int)((long)mask | 0x10000000L);
                    break;
                }
                case ISOLATED: {
                    mask = (int)((long)mask | 0x20000000L);
                    break;
                }
                case CONFIGURABLE: {
                    mask = (int)((long)mask | 0x80000000L);
                }
            }
        }
        return mask;
    }

    public static Set<Flag> unMask(long mask) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        block29: for (Flag flag : Flag.values()) {
            long flagVal;
            switch (flag) {
                case PUBLIC: {
                    flagVal = 1L;
                    break;
                }
                case PRIVATE: {
                    flagVal = 1024L;
                    break;
                }
                case REMOTE: {
                    flagVal = 32768L;
                    break;
                }
                case NATIVE: {
                    flagVal = 2L;
                    break;
                }
                case FINAL: {
                    flagVal = 4L;
                    break;
                }
                case ATTACHED: {
                    flagVal = 8L;
                    break;
                }
                case READONLY: {
                    flagVal = 32L;
                    break;
                }
                case FUNCTION_FINAL: {
                    flagVal = 64L;
                    break;
                }
                case INTERFACE: {
                    flagVal = 128L;
                    break;
                }
                case REQUIRED: {
                    flagVal = 256L;
                    break;
                }
                case RECORD: {
                    flagVal = 512L;
                    break;
                }
                case ANONYMOUS: {
                    flagVal = 2048L;
                    break;
                }
                case OPTIONAL: {
                    flagVal = 4096L;
                    break;
                }
                case CLIENT: {
                    flagVal = 65536L;
                    break;
                }
                case RESOURCE: {
                    flagVal = 131072L;
                    break;
                }
                case SERVICE: {
                    flagVal = 262144L;
                    break;
                }
                case LISTENER: {
                    flagVal = 524288L;
                    break;
                }
                case CONSTANT: {
                    flagVal = 16384L;
                    break;
                }
                case LAMBDA: {
                    flagVal = 0x100000L;
                    break;
                }
                case TYPE_PARAM: {
                    flagVal = 0x200000L;
                    break;
                }
                case LANG_LIB: {
                    flagVal = 0x400000L;
                    break;
                }
                case FORKED: {
                    flagVal = 0x1000000L;
                    break;
                }
                case TRANSACTIONAL: {
                    flagVal = 0x2000000L;
                    break;
                }
                case DISTINCT: {
                    flagVal = 0x8000000L;
                    break;
                }
                case CLASS: {
                    flagVal = 0x10000000L;
                    break;
                }
                case ISOLATED: {
                    flagVal = 0x20000000L;
                    break;
                }
                case CONFIGURABLE: {
                    flagVal = 0x80000000L;
                    break;
                }
                default: {
                    continue block29;
                }
            }
            Flags.addIfFlagOn(flagSet, mask, flagVal, flag);
        }
        return flagSet;
    }

    public static long unset(long mask, long flag) {
        return mask & (flag ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static void addIfFlagOn(Set<Flag> flagSet, long mask, long flagVal, Flag flag) {
        if ((mask & flagVal) == flagVal) {
            flagSet.add(flag);
        }
    }
}

