/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jms;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class JmsTransactionalResource
extends XATransactionalResource {
    private XAConnectionFactory factory;
    private XAConnection conn;

    public JmsTransactionalResource(String name, XAConnectionFactory factory) {
        super(name);
        this.factory = factory;
        this.conn = null;
    }

    @Override
    protected synchronized XAResource refreshXAConnection() throws ResourceException {
        XAResource res = null;
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.conn = this.factory.createXAConnection();
            XASession session = this.conn.createXASession();
            res = session.getXAResource();
        }
        catch (JMSException jms) {
            throw new ResourceException("Error in getting XA resource", jms);
        }
        return res;
    }

    @Override
    public void close() throws ResourceException {
        super.close();
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (JMSException err) {
            throw new ResourceException(err.getMessage());
        }
    }
}

