/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class LangLibrary {
    private static final CompilerContext.Key<LangLibrary> LANG_LIB_KEY = new CompilerContext.Key();
    private static final String LANG_VALUE = "value";
    private final Map<String, Map<String, BInvokableSymbol>> langLibMethods;
    private final Map<String, List<FunctionSymbol>> wrappedLangLibMethods;
    private final SymbolFactory symbolFactory;

    private LangLibrary(CompilerContext context) {
        context.put(LANG_LIB_KEY, this);
        this.symbolFactory = SymbolFactory.getInstance(context);
        this.wrappedLangLibMethods = new HashMap<String, List<FunctionSymbol>>();
        this.langLibMethods = new HashMap<String, Map<String, BInvokableSymbol>>();
        SymbolTable symbolTable = SymbolTable.getInstance(context);
        for (Map.Entry<BPackageSymbol, SymbolEnv> entry : symbolTable.pkgEnvMap.entrySet()) {
            BPackageSymbol module = entry.getKey();
            PackageID moduleID = module.pkgID;
            if (!LangLibrary.isLangLibModule(moduleID)) continue;
            if (!LANG_VALUE.equals(moduleID.nameComps.get((int)1).value)) {
                LangLibrary.addLangLibMethods(moduleID.nameComps.get((int)1).value, module, this.langLibMethods);
                continue;
            }
            LangLibrary.populateLangValueLibrary(module, this.langLibMethods);
        }
    }

    public static LangLibrary getInstance(CompilerContext context) {
        LangLibrary langLib = context.get(LANG_LIB_KEY);
        if (langLib == null) {
            langLib = new LangLibrary(context);
        }
        return langLib;
    }

    public List<FunctionSymbol> getMethods(TypeDescKind typeDescKind) {
        String langLibName = this.getAssociatedLangLibName(typeDescKind);
        return this.getMethods(langLibName);
    }

    public List<FunctionSymbol> getMethods(TypeKind typeKind) {
        String langLibName = this.getAssociatedLangLibName(typeKind);
        return this.getMethods(langLibName);
    }

    private List<FunctionSymbol> getMethods(String langLibName) {
        if (this.wrappedLangLibMethods.containsKey(langLibName)) {
            return this.wrappedLangLibMethods.get(langLibName);
        }
        Map<String, BInvokableSymbol> methods = this.langLibMethods.get(langLibName);
        ArrayList<FunctionSymbol> wrappedMethods = new ArrayList<FunctionSymbol>();
        this.wrappedLangLibMethods.put(langLibName, wrappedMethods);
        this.populateMethodList(wrappedMethods, methods);
        if (!LANG_VALUE.equals(langLibName)) {
            this.populateMethodList(wrappedMethods, this.langLibMethods.get(LANG_VALUE));
        }
        return wrappedMethods;
    }

    private void populateMethodList(List<FunctionSymbol> list, Map<String, BInvokableSymbol> langLib) {
        for (Map.Entry<String, BInvokableSymbol> entry : langLib.entrySet()) {
            BallerinaFunctionSymbol method = this.symbolFactory.createFunctionSymbol(entry.getValue(), entry.getKey());
            list.add(method);
        }
    }

    private String getAssociatedLangLibName(TypeDescKind typeDescKind) {
        switch (typeDescKind) {
            case INT: 
            case BYTE: {
                return TypeDescKind.INT.getName();
            }
            case ARRAY: 
            case TUPLE: {
                return TypeDescKind.ARRAY.getName();
            }
            case RECORD: 
            case MAP: {
                return TypeDescKind.MAP.getName();
            }
            case FLOAT: 
            case DECIMAL: 
            case STRING: 
            case BOOLEAN: 
            case STREAM: 
            case OBJECT: 
            case ERROR: 
            case FUTURE: 
            case TYPEDESC: 
            case XML: 
            case TABLE: {
                return typeDescKind.getName();
            }
        }
        return LANG_VALUE;
    }

    private String getAssociatedLangLibName(TypeKind typeKind) {
        switch (typeKind) {
            case INT: 
            case BYTE: {
                return TypeKind.INT.typeName();
            }
            case ARRAY: 
            case TUPLE: {
                return TypeKind.ARRAY.typeName();
            }
            case RECORD: 
            case MAP: {
                return TypeKind.MAP.typeName();
            }
            case FLOAT: 
            case DECIMAL: 
            case STRING: 
            case BOOLEAN: 
            case STREAM: 
            case OBJECT: 
            case ERROR: 
            case FUTURE: 
            case TYPEDESC: 
            case XML: 
            case TABLE: {
                return typeKind.typeName();
            }
        }
        return LANG_VALUE;
    }

    private static void addLangLibMethods(String basicType, BPackageSymbol langLibModule, Map<String, Map<String, BInvokableSymbol>> langLibMethods) {
        HashMap<String, BInvokableSymbol> methods = new HashMap<String, BInvokableSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> nameScopeEntry : langLibModule.scope.entries.entrySet()) {
            BSymbol symbol = nameScopeEntry.getValue().symbol;
            if (symbol.kind != SymbolKind.FUNCTION) continue;
            BInvokableSymbol invSymbol = (BInvokableSymbol)symbol;
            if (!Symbols.isFlagOn(invSymbol.flags, 1L) || invSymbol.params.isEmpty() || basicType.compareToIgnoreCase(invSymbol.params.get((int)0).type.getKind().name()) != 0) continue;
            methods.put(invSymbol.name.value, invSymbol);
        }
        langLibMethods.put(basicType, methods);
    }

    private static void populateLangValueLibrary(BPackageSymbol langValue, Map<String, Map<String, BInvokableSymbol>> langLibMethods) {
        HashMap<String, BInvokableSymbol> methods = new HashMap<String, BInvokableSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> nameScopeEntry : langValue.scope.entries.entrySet()) {
            BSymbol symbol = nameScopeEntry.getValue().symbol;
            if (symbol.kind != SymbolKind.FUNCTION || !Symbols.isFlagOn(symbol.flags, 0x400000L)) continue;
            methods.put(symbol.name.value, (BInvokableSymbol)symbol);
        }
        langLibMethods.put(LANG_VALUE, methods);
    }

    private static boolean isLangLibModule(PackageID moduleID) {
        return Names.BALLERINA_ORG.equals(moduleID.orgName) && moduleID.nameComps.size() == 2 && Names.LANG.equals(moduleID.nameComps.get(0));
    }
}

