/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.symbols.BallerinaAnnotationSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaConstantSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaEnumSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaMethodSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaModule;
import io.ballerina.compiler.api.impl.symbols.BallerinaParameterSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeDefinitionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaVariableSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaWorkerSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaXMLNSSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class SymbolFactory {
    private static final CompilerContext.Key<SymbolFactory> SYMBOL_FACTORY_KEY = new CompilerContext.Key();
    private final CompilerContext context;
    private final TypesFactory typesFactory;

    private SymbolFactory(CompilerContext context) {
        context.put(SYMBOL_FACTORY_KEY, this);
        this.context = context;
        this.typesFactory = TypesFactory.getInstance(context);
    }

    public static SymbolFactory getInstance(CompilerContext context) {
        SymbolFactory symbolFactory = context.get(SYMBOL_FACTORY_KEY);
        if (symbolFactory == null) {
            symbolFactory = new SymbolFactory(context);
        }
        return symbolFactory;
    }

    public Symbol getBCompiledSymbol(BSymbol symbol, String name) {
        if (symbol == null) {
            throw new IllegalArgumentException("Symbol is 'null'");
        }
        if (symbol instanceof BVarSymbol) {
            if (symbol.kind == SymbolKind.FUNCTION) {
                if (Symbols.isFlagOn(symbol.flags, 8L)) {
                    return this.createMethodSymbol((BInvokableSymbol)symbol);
                }
                return this.createFunctionSymbol((BInvokableSymbol)symbol, name);
            }
            if (symbol.kind == SymbolKind.ERROR_CONSTRUCTOR) {
                return this.createTypeDefinition(symbol.type.tsymbol, name);
            }
            if (symbol instanceof BConstantSymbol) {
                return this.createConstantSymbol((BConstantSymbol)symbol, name);
            }
            if (symbol.type instanceof BFutureType && ((BFutureType)symbol.type).workerDerivative) {
                return this.createWorkerSymbol((BVarSymbol)symbol, name);
            }
            return this.createVariableSymbol((BVarSymbol)symbol, name);
        }
        if (symbol instanceof BTypeSymbol) {
            if (symbol.kind == SymbolKind.ANNOTATION) {
                return this.createAnnotationSymbol((BAnnotationSymbol)symbol);
            }
            if (symbol instanceof BPackageSymbol) {
                return this.createModuleSymbol((BPackageSymbol)symbol, name);
            }
            if (symbol instanceof BClassSymbol) {
                return this.createClassSymbol((BClassSymbol)symbol, name);
            }
            if (Symbols.isFlagOn(symbol.flags, 0x200000000L)) {
                return this.createEnumSymbol((BEnumSymbol)symbol, name);
            }
            return this.createTypeDefinition((BTypeSymbol)symbol, name);
        }
        if (symbol.kind == SymbolKind.XMLNS) {
            return this.createXMLNamespaceSymbol((BXMLNSSymbol)symbol);
        }
        throw new IllegalArgumentException("Unsupported symbol type: " + symbol.getClass().getName());
    }

    public BallerinaFunctionSymbol createFunctionSymbol(BInvokableSymbol invokableSymbol, String name) {
        PackageID pkgID = invokableSymbol.pkgID;
        BallerinaFunctionSymbol.FunctionSymbolBuilder builder = new BallerinaFunctionSymbol.FunctionSymbolBuilder(name, pkgID, invokableSymbol);
        boolean isResourceMethod = SymbolFactory.isFlagOn(invokableSymbol.flags, 131072L);
        boolean isRemoteMethod = SymbolFactory.isFlagOn(invokableSymbol.flags, 32768L);
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 1L) && !isResourceMethod && !isRemoteMethod) {
            builder.withQualifier(Qualifier.PUBLIC);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 1024L)) {
            builder.withQualifier(Qualifier.PRIVATE);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 0x20000000L)) {
            builder.withQualifier(Qualifier.ISOLATED);
        }
        if (isRemoteMethod) {
            builder.withQualifier(Qualifier.REMOTE);
        }
        if (isResourceMethod) {
            builder.withQualifier(Qualifier.RESOURCE);
        }
        if (SymbolFactory.isFlagOn(invokableSymbol.flags, 0x2000000L)) {
            builder.withQualifier(Qualifier.TRANSACTIONAL);
        }
        for (BLangAnnotationAttachment annAttachment : invokableSymbol.annAttachments) {
            if (annAttachment.annotationSymbol == null) continue;
            builder.withAnnotation(this.createAnnotationSymbol(annAttachment.annotationSymbol));
        }
        return builder.withTypeDescriptor((FunctionTypeSymbol)this.typesFactory.getTypeDescriptor(invokableSymbol.type)).build();
    }

    public BallerinaMethodSymbol createMethodSymbol(BInvokableSymbol invokableSymbol, String name) {
        TypeSymbol typeDescriptor = this.typesFactory.getTypeDescriptor(invokableSymbol.type);
        BallerinaFunctionSymbol functionSymbol = this.createFunctionSymbol(invokableSymbol, name);
        if (typeDescriptor.typeKind() == TypeDescKind.FUNCTION) {
            return new BallerinaMethodSymbol(functionSymbol);
        }
        throw new AssertionError((Object)"Invalid type descriptor found");
    }

    private BallerinaMethodSymbol createMethodSymbol(BInvokableSymbol invokableSymbol) {
        String name = this.getMethodName(invokableSymbol, (BObjectTypeSymbol)invokableSymbol.owner);
        return this.createMethodSymbol(invokableSymbol, name);
    }

    public BallerinaVariableSymbol createVariableSymbol(BVarSymbol symbol, String name) {
        PackageID pkgID = symbol.pkgID;
        BallerinaVariableSymbol.VariableSymbolBuilder symbolBuilder = new BallerinaVariableSymbol.VariableSymbolBuilder(name, pkgID, symbol);
        if (SymbolFactory.isFlagOn(symbol.flags, 4L) || SymbolFactory.isFlagOn(symbol.flags, 64L)) {
            symbolBuilder.withQualifier(Qualifier.FINAL);
        }
        if (SymbolFactory.isFlagOn(symbol.flags, 524288L)) {
            symbolBuilder.withQualifier(Qualifier.LISTENER);
        }
        if (SymbolFactory.isFlagOn(symbol.flags, 32L)) {
            symbolBuilder.withQualifier(Qualifier.READONLY);
        }
        if (SymbolFactory.isFlagOn(symbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : symbol.getAnnotations()) {
            symbolBuilder.withAnnotation(this.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        return symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(symbol.type)).build();
    }

    public BallerinaWorkerSymbol createWorkerSymbol(BVarSymbol symbol, String name) {
        BallerinaWorkerSymbol.WorkerSymbolBuilder builder = new BallerinaWorkerSymbol.WorkerSymbolBuilder(name, symbol.pkgID, symbol);
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : symbol.getAnnotations()) {
            builder.withAnnotation(this.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        return builder.withReturnType(this.typesFactory.getTypeDescriptor(((BFutureType)symbol.type).constraint)).build();
    }

    public ParameterSymbol createBallerinaParameter(BVarSymbol symbol, ParameterKind kind) {
        if (symbol == null) {
            return null;
        }
        String name = symbol.getName().getValue().isBlank() ? null : symbol.getName().getValue();
        TypeSymbol typeDescriptor = this.typesFactory.getTypeDescriptor(symbol.getType());
        ArrayList<Qualifier> qualifiers = new ArrayList<Qualifier>();
        if ((symbol.flags & 1L) == 1L) {
            qualifiers.add(Qualifier.PUBLIC);
        }
        ArrayList<AnnotationSymbol> annotSymbols = new ArrayList<AnnotationSymbol>();
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : symbol.getAnnotations()) {
            annotSymbols.add(this.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        return new BallerinaParameterSymbol(name, typeDescriptor, qualifiers, annotSymbols, kind);
    }

    public BallerinaTypeDefinitionSymbol createTypeDefinition(BTypeSymbol typeSymbol, String name) {
        BallerinaTypeDefinitionSymbol.TypeDefSymbolBuilder symbolBuilder = new BallerinaTypeDefinitionSymbol.TypeDefSymbolBuilder(name, typeSymbol.pkgID, typeSymbol);
        if (SymbolFactory.isFlagOn(typeSymbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        return symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(typeSymbol.type, true)).build();
    }

    public BallerinaEnumSymbol createEnumSymbol(BEnumSymbol enumSymbol, String name) {
        BallerinaEnumSymbol.EnumSymbolBuilder symbolBuilder = new BallerinaEnumSymbol.EnumSymbolBuilder(name, enumSymbol.pkgID, enumSymbol);
        if (SymbolFactory.isFlagOn(enumSymbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        ArrayList<ConstantSymbol> members = new ArrayList<ConstantSymbol>();
        for (BConstantSymbol bConstantSymbol : enumSymbol.members) {
            members.add(this.createConstantSymbol(bConstantSymbol, bConstantSymbol.name.value));
        }
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : enumSymbol.getAnnotations()) {
            symbolBuilder.withAnnotation(this.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        return symbolBuilder.withMembers(members).withTypeDescriptor(this.typesFactory.getTypeDescriptor(enumSymbol.type, true)).build();
    }

    public BallerinaClassSymbol createClassSymbol(BClassSymbol classSymbol, String name) {
        TypeSymbol type = this.typesFactory.getTypeDescriptor(classSymbol.type, true);
        return this.createClassSymbol(classSymbol, name, type);
    }

    public BallerinaClassSymbol createClassSymbol(BClassSymbol classSymbol, String name, TypeSymbol type) {
        BallerinaClassSymbol.ClassSymbolBuilder symbolBuilder = new BallerinaClassSymbol.ClassSymbolBuilder(this.context, name, classSymbol.pkgID, (BSymbol)classSymbol);
        if (SymbolFactory.isFlagOn(classSymbol.flags, 1L)) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        if (SymbolFactory.isFlagOn(classSymbol.flags, 0x8000000L)) {
            symbolBuilder.withQualifier(Qualifier.DISTINCT);
        }
        if (SymbolFactory.isFlagOn(classSymbol.flags, 262144L)) {
            symbolBuilder.withQualifier(Qualifier.SERVICE);
        }
        if (SymbolFactory.isFlagOn(classSymbol.flags, 65536L)) {
            symbolBuilder.withQualifier(Qualifier.CLIENT);
        }
        if (SymbolFactory.isFlagOn(classSymbol.flags, 32L)) {
            symbolBuilder.withQualifier(Qualifier.READONLY);
        }
        if (type.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            type = ((TypeReferenceTypeSymbol)type).typeDescriptor();
        }
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : classSymbol.getAnnotations()) {
            symbolBuilder.withAnnotation(this.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        return symbolBuilder.withTypeDescriptor((ObjectTypeSymbol)type).build();
    }

    public BallerinaConstantSymbol createConstantSymbol(BConstantSymbol constantSymbol, String name) {
        BallerinaConstantSymbol.ConstantSymbolBuilder symbolBuilder = new BallerinaConstantSymbol.ConstantSymbolBuilder(name, constantSymbol.pkgID, constantSymbol);
        symbolBuilder.withConstValue(constantSymbol.getConstValue()).withTypeDescriptor(this.typesFactory.getTypeDescriptor(constantSymbol.type)).withBroaderTypeDescriptor(this.typesFactory.getTypeDescriptor(constantSymbol.literalType));
        if ((constantSymbol.flags & 1L) == 1L) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : constantSymbol.getAnnotations()) {
            symbolBuilder.withAnnotation(this.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        return symbolBuilder.build();
    }

    public BallerinaAnnotationSymbol createAnnotationSymbol(BAnnotationSymbol symbol) {
        BallerinaAnnotationSymbol.AnnotationSymbolBuilder symbolBuilder = new BallerinaAnnotationSymbol.AnnotationSymbolBuilder(symbol.name.getValue(), symbol.pkgID, symbol);
        if ((symbol.flags & 1L) == 1L) {
            symbolBuilder.withQualifier(Qualifier.PUBLIC);
        }
        if (symbol.attachedType != null && symbol.attachedType.getType() != null) {
            symbolBuilder.withTypeDescriptor(this.typesFactory.getTypeDescriptor(symbol.attachedType.getType()));
        }
        for (org.ballerinalang.model.symbols.AnnotationSymbol annotationSymbol : symbol.getAnnotations()) {
            symbolBuilder.withAnnotation(this.createAnnotationSymbol((BAnnotationSymbol)annotationSymbol));
        }
        return symbolBuilder.build();
    }

    public BallerinaXMLNSSymbol createXMLNamespaceSymbol(BXMLNSSymbol symbol) {
        BallerinaXMLNSSymbol.XmlNSSymbolBuilder symbolBuilder = new BallerinaXMLNSSymbol.XmlNSSymbolBuilder(symbol.name.getValue(), symbol.pkgID, symbol);
        return symbolBuilder.build();
    }

    public BallerinaModule createModuleSymbol(BPackageSymbol symbol, String name) {
        return new BallerinaModule.ModuleSymbolBuilder(this.context, name, symbol.pkgID, symbol).build();
    }

    public static boolean isFlagOn(long mask, long flags) {
        return (mask & flags) == flags;
    }

    private String getMethodName(BInvokableSymbol method, BObjectTypeSymbol owner) {
        ArrayList<BAttachedFunction> methods = new ArrayList<BAttachedFunction>(owner.attachedFuncs);
        methods.add(owner.initializerFunc);
        for (BAttachedFunction mthd : methods) {
            if (method != mthd.symbol) continue;
            return mthd.funcName.value;
        }
        throw new IllegalStateException(String.format("Method symbol for '%s' not found in owner symbol '%s'", method.name, owner.name));
    }
}

